/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.Smolecule;

public class MoleculeIterators {
    private static int countLonePairs(Molecule mol) {
        int lonePairCount = 0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            lonePairCount += mol.getAtom(i).getAtno() == 130 ? 1 : 0;
        }
        return lonePairCount;
    }

    private static int countLonePairs(Smolecule mol) {
        int lonePairCount = 0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            lonePairCount += mol.getAtomType(i) == 130 ? 1 : 0;
        }
        return lonePairCount;
    }

    private static int countH(Smolecule mol) {
        int hCount = 0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            hCount += mol.getAtomType(i) == 1 ? 1 : 0;
        }
        return hCount;
    }

    public MoleculeAtomIterator getMoleculeAtomIterator() {
        return new MoleculeAtomIterator();
    }

    public MoleculeBondIterator getMoleculeBondIterator() {
        return new MoleculeBondIterator();
    }

    public SmoleculeAtomIterator getSmoleculeAtomIterator() {
        return new SmoleculeAtomIterator();
    }

    public SmoleculeBondIterator getSmoleculeBondIterator() {
        return new SmoleculeBondIterator();
    }

    public class SmoleculeBondIterator
    implements BondIteratorInterface {
        protected Smolecule smol = null;
        public float[] xCoords = null;
        public float[] yCoords = null;
        public float[] zCoords = null;
        protected boolean includeH = false;
        private int lonePairCount = 0;
        private int hCount = 0;
        protected int current = -1;
        protected int last = 0;
        private int neighbour = -1;
        private int atom1 = 0;
        private int atom2 = -1;

        public void setMolecule(Smolecule mol, boolean includeH) {
            this.smol = mol;
            this.includeH = includeH;
            this.init();
        }

        public void setMolecule(Smolecule mol) {
            this.smol = mol;
            this.init();
        }

        public void setXCoords(float[] xCoords) {
            this.xCoords = xCoords;
        }

        public void setYCoords(float[] yCoords) {
            this.yCoords = yCoords;
        }

        public void setZCoords(float[] zCoords) {
            this.zCoords = zCoords;
        }

        public void setIncludeH(boolean includeH) {
            this.includeH = includeH;
        }

        private void init() {
            this.current = -1;
            this.neighbour = -1;
            this.atom1 = 0;
            this.atom2 = -1;
            this.lonePairCount = MoleculeIterators.countLonePairs(this.smol);
            this.hCount = MoleculeIterators.countH(this.smol);
        }

        public boolean end() {
            return this.current == -1 || this.current == this.smol.getBondCount();
        }

        @Override
        public int getModelCount() {
            return 0;
        }

        @Override
        public void setModel(int modelSerialNumber) {
        }

        @Override
        public void reset() {
            this.init();
            if (this.smol.getBondCount() > 0) {
                this.findNext();
            }
        }

        @Override
        public boolean hasNext() {
            return !this.end();
        }

        @Override
        public void next() {
            this.findNext();
        }

        @Override
        public int getCount() {
            return this.includeH ? this.smol.getBondCount() : this.smol.getBondCount() - this.hCount - this.lonePairCount;
        }

        @Override
        public int getAtomType(int whichAtom) {
            return this.smol.getAtomType(whichAtom == 1 ? this.atom1 : this.atom2);
        }

        @Override
        public float getX(int whichAtom) {
            if (whichAtom == 0) {
                return !this.findNeighbour() ? Float.NaN : this.xCoords[this.neighbour];
            }
            return this.xCoords[whichAtom == 1 ? this.atom1 : this.atom2];
        }

        @Override
        public float getY(int whichAtom) {
            if (whichAtom == 0) {
                return !this.findNeighbour() ? Float.NaN : this.yCoords[this.neighbour];
            }
            return this.yCoords[whichAtom == 1 ? this.atom1 : this.atom2];
        }

        @Override
        public float getZ(int whichAtom) {
            if (whichAtom == 0) {
                return !this.findNeighbour() ? Float.NaN : this.zCoords[this.neighbour];
            }
            return this.zCoords[whichAtom == 1 ? this.atom1 : this.atom2];
        }

        @Override
        public int getBondType() {
            return this.smol.getBondType(this.atom1, this.atom2);
        }

        @Override
        public int getResidueType(int whichAtom) {
            return 0;
        }

        @Override
        public boolean sameResidue(int alphaCarbonAtomId, int whichAtom) {
            return false;
        }

        @Override
        public int getSecondaryStructureType(int whichAtom) {
            return 0;
        }

        @Override
        public int getAtomIndex(int whichAtom) {
            return whichAtom == 1 ? this.atom1 : this.atom2;
        }

        private boolean findNext() {
            this.neighbour = -1;
            this.current = -1;
            int ac = this.smol.getAtomCount();
            for (int i = this.atom1; i < ac; ++i) {
                for (int j = this.atom2 + 1; j < ac; ++j) {
                    if (i == j || !this.smol.areNeighbors(i, j)) continue;
                    ++this.current;
                    this.atom1 = i;
                    this.atom2 = j;
                    if (this.includeH) {
                        return true;
                    }
                    int at1 = this.smol.getAtomType(this.atom1);
                    int at2 = this.smol.getAtomType(this.atom2);
                    if (at1 == 1 || at2 == 1 || at1 == 130 || at2 == 130) continue;
                    return true;
                }
            }
            this.atom1 = 0;
            this.atom2 = -1;
            return false;
        }

        private boolean findNeighbour() {
            if (this.neighbour != -1) {
                return true;
            }
            this.neighbour = 0;
            while (this.neighbour < this.smol.getAtomCount()) {
                if (this.neighbour != this.atom1 && this.neighbour != this.atom2 && (this.smol.areNeighbors(this.atom1, this.neighbour) || this.smol.areNeighbors(this.atom2, this.neighbour))) {
                    return true;
                }
                ++this.neighbour;
            }
            this.neighbour = -1;
            return false;
        }
    }

    public class SmoleculeAtomIterator
    implements AtomIteratorInterface {
        Smolecule smol = null;
        public float[] xCoords = null;
        public float[] yCoords = null;
        public float[] zCoords = null;
        protected int currentAtom = -1;
        protected boolean includeH = true;
        private int lonePairCount = 0;
        private int hCount = 0;

        public void setMolecule(Smolecule smol) {
            this.smol = smol;
            this.lonePairCount = MoleculeIterators.countLonePairs(smol);
            this.hCount = MoleculeIterators.countH(smol);
        }

        public void setMolecule(Smolecule smol, boolean enumH) {
            this.smol = smol;
            this.includeH = enumH;
            this.lonePairCount = MoleculeIterators.countLonePairs(smol);
            this.hCount = MoleculeIterators.countH(smol);
        }

        public void setXCoords(float[] xCoords) {
            this.xCoords = xCoords;
        }

        public void setYCoords(float[] yCoords) {
            this.yCoords = yCoords;
        }

        public void setZCoords(float[] zCoords) {
            this.zCoords = zCoords;
        }

        public void setIncludeH(boolean includeH) {
            this.includeH = includeH;
        }

        @Override
        public int getModelCount() {
            return 0;
        }

        @Override
        public void setModel(int modelSerialNumber) {
        }

        @Override
        public void reset() {
            this.currentAtom = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.includeH) {
                return this.currentAtom < this.smol.getAtomCount();
            }
            for (int i = this.currentAtom; i < this.smol.getAtomCount(); ++i) {
                int a = this.smol.getAtomType(i);
                if (a == 1 || a == 130) continue;
                return true;
            }
            return false;
        }

        @Override
        public int next() {
            if (this.includeH) {
                return this.currentAtom++;
            }
            while (++this.currentAtom < this.smol.getAtomCount()) {
                int a = this.smol.getAtomType(this.currentAtom);
                if (a == 1 || a == 130) continue;
                return this.currentAtom;
            }
            return -1;
        }

        @Override
        public int current() {
            return this.currentAtom;
        }

        @Override
        public int getCount() {
            return this.includeH ? this.smol.getAtomCount() : this.smol.getAtomCount() - this.hCount - this.lonePairCount;
        }

        @Override
        public int getCurrentAtomId() {
            return this.currentAtom;
        }

        @Override
        public int getMaxIndex() {
            return this.smol.getAtomCount();
        }

        @Override
        public int getAtomType() {
            return this.smol.getAtomType(this.currentAtom);
        }

        @Override
        public int getNeighborCount() {
            return 0;
        }

        @Override
        public String getResidueAtomLabel() {
            return null;
        }

        @Override
        public boolean sameResidue(int atomId1, int atomId2) {
            return false;
        }

        @Override
        public int getSecondaryStructureType() {
            return 0;
        }

        @Override
        public void getCoords(float[] xyz) {
            xyz[0] = this.xCoords[this.currentAtom];
            xyz[1] = this.yCoords[this.currentAtom];
            xyz[2] = this.zCoords[this.currentAtom];
        }

        @Override
        public float getX() {
            return this.xCoords[this.currentAtom];
        }

        @Override
        public float getY() {
            return this.yCoords[this.currentAtom];
        }

        @Override
        public float getZ() {
            return this.zCoords[this.currentAtom];
        }
    }

    public class MoleculeBondIterator
    implements BondIteratorInterface {
        protected Molecule mol = null;
        protected boolean includeH = false;
        private int lonePairCount = 0;
        protected int current = -1;
        protected int next = -1;
        protected int last = 0;
        private int neighbour = -1;
        private int atom1 = -1;
        private int atom2 = -1;

        public void setMolecule(Molecule mol, boolean includeH) {
            this.mol = mol;
            this.includeH = includeH;
            this.init();
        }

        public void setMolecule(Molecule mol) {
            this.mol = mol;
            this.init();
        }

        public void setIncludeH(boolean includeH) {
            this.includeH = includeH;
        }

        @Override
        public int getModelCount() {
            return 1;
        }

        @Override
        public void setModel(int modelSerialNumber) {
        }

        public boolean empty() {
            return this.mol.getBondCount() == 0;
        }

        @Override
        public void reset() {
            this.init();
            this.findNext();
            this.current = this.next;
        }

        public boolean end() {
            return this.current == -1 || this.current == this.mol.getBondCount();
        }

        @Override
        public boolean hasNext() {
            return !this.end();
        }

        @Override
        public void next() {
            this.findNext();
            this.current = this.next;
        }

        @Override
        public int getCount() {
            return this.includeH ? this.mol.getBondCount() : this.mol.getBondCount() - this.mol.getExplicitHcount() - this.lonePairCount;
        }

        @Override
        public int getAtomType(int whichAtom) {
            return this.mol.getAtom(whichAtom == 1 ? this.atom1 : this.atom2).getAtno();
        }

        @Override
        public float getX(int whichAtom) {
            if (whichAtom == 0) {
                return !this.findNeighbour() ? Float.NaN : (float)this.mol.getAtom(this.neighbour).getX();
            }
            return (float)this.mol.getAtom(whichAtom == 1 ? this.atom1 : this.atom2).getX();
        }

        @Override
        public float getY(int whichAtom) {
            if (whichAtom == 0) {
                return !this.findNeighbour() ? Float.NaN : (float)this.mol.getAtom(this.neighbour).getY();
            }
            return (float)this.mol.getAtom(whichAtom == 1 ? this.atom1 : this.atom2).getY();
        }

        @Override
        public float getZ(int whichAtom) {
            if (whichAtom == 0) {
                return !this.findNeighbour() ? Float.NaN : (float)this.mol.getAtom(this.neighbour).getZ();
            }
            return (float)this.mol.getAtom(whichAtom == 1 ? this.atom1 : this.atom2).getZ();
        }

        @Override
        public int getBondType() {
            return this.mol.getBond(this.current).getType();
        }

        @Override
        public int getResidueType(int whichAtom) {
            return 0;
        }

        @Override
        public int getSecondaryStructureType(int whichAtom) {
            return 0;
        }

        @Override
        public boolean sameResidue(int alphaCarbonAtomId, int whichAtom) {
            return true;
        }

        @Override
        public int getAtomIndex(int whichAtom) {
            return whichAtom == 1 ? this.atom1 : this.atom2;
        }

        protected int getNeighborIndex() {
            this.findNeighbour();
            return this.neighbour;
        }

        private void init() {
            this.next = -1;
            this.current = -1;
            this.neighbour = -1;
            this.atom2 = -1;
            this.atom1 = -1;
            this.lonePairCount = MoleculeIterators.countLonePairs(this.mol);
        }

        private boolean findNext() {
            this.neighbour = -1;
            while (++this.next < this.mol.getBondCount()) {
                MolBond b = this.mol.getBond(this.next);
                MolAtom a1 = b.getAtom1();
                MolAtom a2 = b.getAtom2();
                this.atom1 = this.mol.indexOf(a1);
                this.atom2 = this.mol.indexOf(a2);
                if (this.includeH) {
                    return true;
                }
                int at1 = a1.getAtno();
                int at2 = a2.getAtno();
                if (at1 == 1 || at2 == 1 || at1 == 130 || at2 == 130) continue;
                return true;
            }
            this.atom1 = -1;
            this.atom2 = -1;
            this.current = -1;
            return false;
        }

        private boolean findNeighbour() {
            if (this.neighbour != -1) {
                return true;
            }
            this.neighbour = 0;
            while (this.neighbour < this.mol.getAtomCount()) {
                if (this.neighbour != this.atom1 && this.neighbour != this.atom2 && (this.mol.getAtom(this.atom1).isBoundTo(this.mol.getAtom(this.neighbour)) || this.mol.getAtom(this.atom2).isBoundTo(this.mol.getAtom(this.neighbour)))) {
                    return true;
                }
                ++this.neighbour;
            }
            this.neighbour = -1;
            return false;
        }
    }

    public class MoleculeAtomIterator
    implements AtomIteratorInterface {
        protected Molecule mol = null;
        protected int currentAtom = -1;
        protected boolean includeH = true;
        private int lonePairCount = 0;

        public void setMolecule(Molecule mol, boolean includeH) {
            this.mol = mol;
            this.includeH = includeH;
            this.currentAtom = 0;
            this.lonePairCount = MoleculeIterators.countLonePairs(mol);
        }

        public void setMolecule(Molecule mol) {
            this.mol = mol;
            this.currentAtom = 0;
            this.lonePairCount = MoleculeIterators.countLonePairs(mol);
        }

        public void setIncludeH(boolean includeH) {
            this.includeH = includeH;
        }

        @Override
        public int getModelCount() {
            return 1;
        }

        @Override
        public void setModel(int modelSerialNumber) {
        }

        @Override
        public void reset() {
            this.currentAtom = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.includeH) {
                return this.currentAtom < this.mol.getAtomCount();
            }
            for (int i = this.currentAtom; i < this.mol.getAtomCount(); ++i) {
                int a = this.mol.getAtom(i).getAtno();
                if (a == 1 || a == 130) continue;
                return true;
            }
            return false;
        }

        @Override
        public int next() {
            if (this.includeH) {
                return this.currentAtom++;
            }
            ++this.currentAtom;
            while (this.currentAtom < this.mol.getAtomCount()) {
                int a = this.mol.getAtom(this.currentAtom).getAtno();
                if (a != 1 && a != 130) {
                    return this.currentAtom;
                }
                ++this.currentAtom;
            }
            return -1;
        }

        @Override
        public int current() {
            return this.currentAtom;
        }

        @Override
        public int getCount() {
            return this.includeH ? this.mol.getAtomCount() : this.mol.getAtomCount() - this.mol.getExplicitHcount() - this.lonePairCount;
        }

        @Override
        public int getCurrentAtomId() {
            return this.currentAtom;
        }

        @Override
        public int getMaxIndex() {
            return this.mol.getAtomCount();
        }

        @Override
        public int getAtomType() {
            return this.mol.getAtom(this.currentAtom).getAtno();
        }

        @Override
        public int getNeighborCount() {
            return this.mol.getAtom(this.currentAtom).getBondCount();
        }

        @Override
        public String getResidueAtomLabel() {
            String l = this.mol.getAtom(this.currentAtom).getAliasstr();
            return l != null ? l : PeriodicSystem.getSymbol(this.mol.getAtom(this.currentAtom).getAtno());
        }

        @Override
        public int getSecondaryStructureType() {
            return 0;
        }

        @Override
        public boolean sameResidue(int atomId1, int atomId2) {
            return true;
        }

        @Override
        public void getCoords(float[] xyz) {
            MolAtom a = this.mol.getAtom(this.currentAtom);
            xyz[0] = (float)a.getX();
            xyz[1] = (float)a.getY();
            xyz[2] = (float)a.getZ();
        }

        @Override
        public float getX() {
            return (float)this.mol.getAtom(this.currentAtom).getX();
        }

        @Override
        public float getY() {
            return (float)this.mol.getAtom(this.currentAtom).getY();
        }

        @Override
        public float getZ() {
            return (float)this.mol.getAtom(this.currentAtom).getZ();
        }
    }

    public static interface BondIteratorInterface {
        public static final int ATOM1 = 1;
        public static final int ATOM2 = 2;
        public static final int NEIGHBOR = 0;

        public int getModelCount();

        public void setModel(int var1);

        public void reset();

        public boolean hasNext();

        public void next();

        public int getCount();

        public int getAtomType(int var1);

        public float getX(int var1);

        public float getY(int var1);

        public float getZ(int var1);

        public int getBondType();

        public int getResidueType(int var1);

        public boolean sameResidue(int var1, int var2);

        public int getSecondaryStructureType(int var1);

        public int getAtomIndex(int var1);
    }

    public static interface AtomPropertyInterface {
        public void setMolecule(Object var1);

        public int getType(int var1);

        public String getLabel(int var1);

        public float getCharge(int var1);

        public float getBFactor(int var1);

        public float getPartialAtomCharge(int var1) throws Exception;

        public int getResidueTypeId(int var1);

        public int getSecondaryStructureType(int var1);

        public float getX(int var1);

        public float getY(int var1);

        public float getZ(int var1);
    }

    public static interface AtomIteratorInterface {
        public static final int SECONDARY_NONE = 0;

        public int getModelCount();

        public void setModel(int var1);

        public void reset();

        public boolean hasNext();

        public int next();

        public int current();

        public int getCount();

        public int getCurrentAtomId();

        public int getMaxIndex();

        public int getAtomType();

        public int getNeighborCount();

        public String getResidueAtomLabel();

        public boolean sameResidue(int var1, int var2);

        public int getSecondaryStructureType();

        public void getCoords(float[] var1);

        public float getX();

        public float getY();

        public float getZ();
    }

    public static interface MoleculeInterface {
        public AtomIteratorInterface getAtomIterator(boolean var1);

        public AtomPropertyInterface getAtomProperty();

        public BondIteratorInterface getBondIterator(boolean var1);

        public int getAtomCount(boolean var1);

        public int getBondCount(boolean var1);
    }
}

