/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.DPoint3;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PageSettings
implements Externalizable {
    static final long serialVersionUID = -7674028514396457694L;
    private boolean enabled = false;
    private int selectedPage = 0;
    private int columnCount = 1;
    private int rowCount = 1;
    private double width = 26.308333333333334;
    private double height = -40.65833333333334;
    private double leftMargin = 4.2;
    private double rightMargin = 4.2;
    private double topMargin = -4.2;
    private double bottomMargin = -4.2;
    private DPoint3 upperLeftPoint = new DPoint3(-12.425, 10.091666666666667, 0.0);

    public Object clone() {
        PageSettings newPageSettings = new PageSettings();
        newPageSettings.enabled = this.enabled;
        newPageSettings.selectedPage = this.selectedPage;
        newPageSettings.columnCount = this.columnCount;
        newPageSettings.rowCount = this.rowCount;
        newPageSettings.width = this.width;
        newPageSettings.height = this.height;
        newPageSettings.leftMargin = this.leftMargin;
        newPageSettings.rightMargin = this.rightMargin;
        newPageSettings.topMargin = this.topMargin;
        newPageSettings.bottomMargin = this.bottomMargin;
        newPageSettings.upperLeftPoint = new DPoint3(this.upperLeftPoint.x, this.upperLeftPoint.y, this.upperLeftPoint.z);
        return newPageSettings;
    }

    public int getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(int selectedPage) {
        this.selectedPage = selectedPage;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public DPoint3 getUpperLeftPoint() {
        return this.upperLeftPoint;
    }

    public void setUpperLeftPoint(DPoint3 upperLeftPoint) {
        this.upperLeftPoint = upperLeftPoint;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public boolean isMultiPageEnabled() {
        return this.getColumnCount() > 0 && this.getRowCount() > 0 && this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBottomMargin(double bottom) {
        this.bottomMargin = bottom;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(double left) {
        this.leftMargin = left;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public void setRightMargin(double right) {
        this.rightMargin = right;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(double top) {
        this.topMargin = top;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.enabled = in.readBoolean();
        this.selectedPage = in.readInt();
        this.columnCount = in.readInt();
        this.rowCount = in.readInt();
        this.width = in.readDouble();
        this.height = in.readDouble();
        this.leftMargin = in.readDouble();
        this.rightMargin = in.readDouble();
        this.topMargin = in.readDouble();
        this.bottomMargin = in.readDouble();
        this.upperLeftPoint.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeInt(this.selectedPage);
        out.writeInt(this.columnCount);
        out.writeInt(this.rowCount);
        out.writeDouble(this.width);
        out.writeDouble(this.height);
        out.writeDouble(this.leftMargin);
        out.writeDouble(this.rightMargin);
        out.writeDouble(this.topMargin);
        out.writeDouble(this.bottomMargin);
        this.upperLeftPoint.writeExternal(out);
    }

    public void reset() {
        this.enabled = false;
        this.selectedPage = 0;
        this.columnCount = 1;
        this.rowCount = 1;
        this.width = 26.308333333333334;
        this.height = -40.65833333333334;
        this.leftMargin = 4.2;
        this.rightMargin = 4.2;
        this.topMargin = -4.2;
        this.bottomMargin = -4.2;
    }
}

