/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.BasicEnvironment;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class PeriodicSystem {
    public static final int H = 1;
    public static final int He = 2;
    public static final int Li = 3;
    public static final int Be = 4;
    public static final int B = 5;
    public static final int C = 6;
    public static final int N = 7;
    public static final int O = 8;
    public static final int F = 9;
    public static final int Ne = 10;
    public static final int Na = 11;
    public static final int Mg = 12;
    public static final int Al = 13;
    public static final int Si = 14;
    public static final int P = 15;
    public static final int S = 16;
    public static final int Cl = 17;
    public static final int Ar = 18;
    public static final int K = 19;
    public static final int Ca = 20;
    public static final int Sc = 21;
    public static final int Ti = 22;
    public static final int V = 23;
    public static final int Cr = 24;
    public static final int Mn = 25;
    public static final int Fe = 26;
    public static final int Co = 27;
    public static final int Ni = 28;
    public static final int Cu = 29;
    public static final int Zn = 30;
    public static final int Ga = 31;
    public static final int Ge = 32;
    public static final int As = 33;
    public static final int Se = 34;
    public static final int Br = 35;
    public static final int Kr = 36;
    public static final int Rb = 37;
    public static final int Sr = 38;
    public static final int Y = 39;
    public static final int Zr = 40;
    public static final int Nb = 41;
    public static final int Mo = 42;
    public static final int Tc = 43;
    public static final int Ru = 44;
    public static final int Rh = 45;
    public static final int Pd = 46;
    public static final int Ag = 47;
    public static final int Cd = 48;
    public static final int In = 49;
    public static final int Sn = 50;
    public static final int Sb = 51;
    public static final int Te = 52;
    public static final int I = 53;
    public static final int Xe = 54;
    public static final int Cs = 55;
    public static final int Ba = 56;
    public static final int La = 57;
    public static final int Ce = 58;
    public static final int Pr = 59;
    public static final int Nd = 60;
    public static final int Pm = 61;
    public static final int Sm = 62;
    public static final int Eu = 63;
    public static final int Gd = 64;
    public static final int Tb = 65;
    public static final int Dy = 66;
    public static final int Ho = 67;
    public static final int Er = 68;
    public static final int Tm = 69;
    public static final int Yb = 70;
    public static final int Lu = 71;
    public static final int Hf = 72;
    public static final int Ta = 73;
    public static final int W = 74;
    public static final int Re = 75;
    public static final int Os = 76;
    public static final int Ir = 77;
    public static final int Pt = 78;
    public static final int Au = 79;
    public static final int Hg = 80;
    public static final int Tl = 81;
    public static final int Pb = 82;
    public static final int Bi = 83;
    public static final int Po = 84;
    public static final int At = 85;
    public static final int Rn = 86;
    public static final int Fr = 87;
    public static final int Ra = 88;
    public static final int Ac = 89;
    public static final int Th = 90;
    public static final int Pa = 91;
    public static final int U = 92;
    public static final int Np = 93;
    public static final int Pu = 94;
    public static final int Am = 95;
    public static final int Cm = 96;
    public static final int Bk = 97;
    public static final int Cf = 98;
    public static final int Es = 99;
    public static final int Fm = 100;
    public static final int Md = 101;
    public static final int No = 102;
    public static final int Lr = 103;
    public static final int Rf = 104;
    public static final int Db = 105;
    public static final int Sg = 106;
    public static final int Bh = 107;
    public static final int Hs = 108;
    public static final int Mt = 109;
    public static final int Ds = 110;
    public static final int Rg = 111;
    private static final String ELEMENT_FILE = "/chemaxon/elements.zip";
    private static final String ISOTOPE_FILE = "/chemaxon/isotopes.data";
    private static final int ISOTOPE_FILE_HEADER = -87949311;
    private static String[] ELEMENT_NAME;
    private static String[] ELEMENT_SYMBOL;
    private static double[] ELEMENT_MASS;
    private static int[] ELEMENT_MASS_PRECISION;
    private static double[] ATOMIC_RADIUS;
    private static double[] COVALENT_RADIUS_SINGLE;
    private static double[] COVALENT_RADIUS_DOUBLE;
    private static double[] COVALENT_RADIUS_TRIPLE;
    private static double[] VANDERWAALS_RADIUS;
    private static int[] ATOMIC_NUMBER_1;
    private static int[] ATOMIC_NUMBER_2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readElements() {
        int e = 0;
        InputStream resource = BasicEnvironment.getResourceAsStream(PeriodicSystem.class, ELEMENT_FILE);
        ZipInputStream zipresource = new ZipInputStream(resource);
        try {
            zipresource.getNextEntry();
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipresource));
            try {
                int i;
                String line = reader.readLine();
                if (line == null) {
                    throw new FileNotFoundException();
                }
                int elements = Integer.parseInt(line.trim());
                reader.readLine();
                ELEMENT_NAME = new String[elements];
                ELEMENT_SYMBOL = new String[elements];
                ELEMENT_MASS = new double[elements];
                ELEMENT_MASS_PRECISION = new int[elements];
                ATOMIC_RADIUS = new double[elements];
                VANDERWAALS_RADIUS = new double[elements];
                COVALENT_RADIUS_SINGLE = new double[elements];
                COVALENT_RADIUS_DOUBLE = new double[elements];
                COVALENT_RADIUS_TRIPLE = new double[elements];
                for (i = 0; i < elements; ++i) {
                    line = reader.readLine();
                    if (line == null) {
                        throw new EOFException();
                    }
                    StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                    e = Integer.parseInt(tokenizer.nextToken()) - 1;
                    PeriodicSystem.ELEMENT_SYMBOL[e] = tokenizer.nextToken();
                    PeriodicSystem.ELEMENT_NAME[e] = tokenizer.nextToken();
                    String token = tokenizer.nextToken().trim();
                    PeriodicSystem.ELEMENT_MASS_PRECISION[e] = token.length() - token.indexOf(46) - 1;
                    PeriodicSystem.ELEMENT_MASS[e] = Double.valueOf(token);
                    PeriodicSystem.ATOMIC_RADIUS[e] = Double.valueOf(tokenizer.nextToken());
                    PeriodicSystem.VANDERWAALS_RADIUS[e] = Double.valueOf(tokenizer.nextToken());
                    PeriodicSystem.COVALENT_RADIUS_SINGLE[e] = Double.valueOf(tokenizer.nextToken());
                    PeriodicSystem.COVALENT_RADIUS_DOUBLE[e] = Double.valueOf(tokenizer.nextToken());
                    PeriodicSystem.COVALENT_RADIUS_TRIPLE[e] = Double.valueOf(tokenizer.nextToken());
                }
                ATOMIC_NUMBER_1 = new int[26];
                for (i = 0; i < ATOMIC_NUMBER_1.length; ++i) {
                    PeriodicSystem.ATOMIC_NUMBER_1[i] = -1;
                }
                ATOMIC_NUMBER_2 = new int[676];
                for (i = 0; i < ATOMIC_NUMBER_2.length; ++i) {
                    PeriodicSystem.ATOMIC_NUMBER_2[i] = -1;
                }
                for (int i2 = 0; i2 < ELEMENT_SYMBOL.length; ++i2) {
                    int c1 = ELEMENT_SYMBOL[i2].charAt(0) - 65;
                    if (ELEMENT_SYMBOL[i2].length() == 1) {
                        PeriodicSystem.ATOMIC_NUMBER_1[c1] = i2 + 1;
                    }
                    if (ELEMENT_SYMBOL[i2].length() != 2) continue;
                    PeriodicSystem.ATOMIC_NUMBER_2[c1 * 26 + PeriodicSystem.ELEMENT_SYMBOL[i2].charAt((int)1) - 97] = i2 + 1;
                }
                PeriodicSystem.ATOMIC_NUMBER_1[3] = 1;
                PeriodicSystem.ATOMIC_NUMBER_1[19] = 1;
            }
            finally {
                reader.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static int indexOfIsotope(int z, int m) {
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            for (int i = 0; i < IsotopeDataHolder.ISOTOPE_COUNT[z - 1]; ++i) {
                if (z + IsotopeDataHolder.ISOTOPE_NEUTRON[IsotopeDataHolder.ISOTOPE_POSITION[z - 1] + i] != m) continue;
                return IsotopeDataHolder.ISOTOPE_POSITION[z - 1] + i;
            }
        }
        return -1;
    }

    public static int getElementCount() {
        return ELEMENT_SYMBOL.length;
    }

    public static int getIsotopeCount() {
        return IsotopeDataHolder.ISOTOPE_NEUTRON.length;
    }

    public static int getIsotopeCount(int z) {
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            return IsotopeDataHolder.ISOTOPE_COUNT[z - 1];
        }
        return 0;
    }

    public static int getIsotope(int z, int i) {
        if (z > 0 && z <= PeriodicSystem.getElementCount() && i >= 0 && i < PeriodicSystem.getIsotopeCount(z)) {
            return z + IsotopeDataHolder.ISOTOPE_NEUTRON[IsotopeDataHolder.ISOTOPE_POSITION[z - 1] + i];
        }
        return 0;
    }

    public static String getName(int z) {
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            return ELEMENT_NAME[z - 1];
        }
        return "";
    }

    public static String getSymbol(int z) {
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            return ELEMENT_SYMBOL[z - 1];
        }
        return "";
    }

    public static double getMass(int z) {
        return PeriodicSystem.getMass(z, 0);
    }

    public static double getMass(int z, int m) {
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            if (m == 0) {
                return ELEMENT_MASS[z - 1];
            }
            int i = PeriodicSystem.indexOfIsotope(z, m);
            return i != -1 ? IsotopeDataHolder.ISOTOPE_MASS[PeriodicSystem.indexOfIsotope(z, m)] : 0.0;
        }
        return 0.0;
    }

    public static int getMassPrecision(int z) {
        return PeriodicSystem.getMassPrecision(z, 0);
    }

    public static int getMassPrecision(int z, int m) {
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            if (m == 0) {
                return ELEMENT_MASS_PRECISION[z - 1];
            }
            int i = PeriodicSystem.indexOfIsotope(z, m);
            return i != -1 ? IsotopeDataHolder.ISOTOPE_MASS_PRECISION[PeriodicSystem.indexOfIsotope(z, m)] : 0;
        }
        return 0;
    }

    public static double getAbundance(int z, int m) {
        int i = PeriodicSystem.indexOfIsotope(z, m);
        return i != -1 ? IsotopeDataHolder.ISOTOPE_ABUNDANCE[i] : 0.0;
    }

    public static int getMostFrequentNaturalIsotope(int z) {
        int i = -1;
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            i = IsotopeDataHolder.MOST_FREQUENT_NATURAL_ISOTOPE[z - 1];
        }
        return i != -1 ? z + IsotopeDataHolder.ISOTOPE_NEUTRON[i] : 0;
    }

    public static int getAtomicNumber(String symbol) {
        if (symbol == null || symbol.length() < 1 || symbol.length() > 2) {
            return -1;
        }
        int c1 = symbol.charAt(0);
        if (c1 > 64 && c1 < 91) {
            c1 -= 65;
        } else if (c1 > 96 && c1 < 123) {
            c1 -= 97;
        } else {
            return -1;
        }
        if (symbol.length() == 1) {
            return ATOMIC_NUMBER_1[c1];
        }
        int c2 = symbol.charAt(1);
        if (c2 > 64 && c2 < 91) {
            c2 -= 65;
        } else if (c2 > 96 && c2 < 123) {
            c2 -= 97;
        } else {
            return -1;
        }
        return ATOMIC_NUMBER_2[c1 * 26 + c2];
    }

    public static int findAtomicNumber(String symbol) throws IllegalArgumentException {
        int atno = PeriodicSystem.getAtomicNumber(symbol);
        if (atno < 0) {
            throw new IllegalArgumentException("Unknown chemical element: " + symbol);
        }
        return atno;
    }

    public static boolean isAtomicSymbol(String symbol) {
        return PeriodicSystem.getAtomicNumber(symbol) >= 0;
    }

    public static double getAtomicRadius(int z) {
        double result = 0.0;
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            result = ATOMIC_RADIUS[z - 1];
        }
        if (result != 0.0) {
            return result;
        }
        return 1.5;
    }

    public static double getCovalentRadius(int z) {
        return PeriodicSystem.getCovalentRadius(z, 1);
    }

    public static double getCovalentRadius(int z, int t) {
        double result = 0.0;
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            switch (t) {
                case 2: {
                    result = COVALENT_RADIUS_DOUBLE[z - 1];
                    break;
                }
                case 3: {
                    result = COVALENT_RADIUS_TRIPLE[z - 1];
                    break;
                }
                default: {
                    result = COVALENT_RADIUS_SINGLE[z - 1];
                }
            }
        }
        if (result != 0.0) {
            return result;
        }
        return 1.5;
    }

    public static double getVanDerWaalsRadius(int z) {
        double result = 0.0;
        if (z > 0 && z <= PeriodicSystem.getElementCount()) {
            result = VANDERWAALS_RADIUS[z - 1];
        }
        if (result != 0.0) {
            return result;
        }
        return 2.0;
    }

    public static int getColumn(int z) {
        switch (PeriodicSystem.getRow(z)) {
            case 1: {
                if (z == 1) {
                    return 1;
                }
                return 18;
            }
            case 2: {
                if (z >= 5) {
                    return z + 8;
                }
                return z - 2;
            }
            case 3: {
                if (z >= 13) {
                    return z;
                }
                return z - 10;
            }
            case 4: {
                return z - 18;
            }
            case 5: {
                return z - 36;
            }
            case 6: {
                if (z >= 71) {
                    return z - 68;
                }
                if (z >= 57) {
                    return 3;
                }
                return z - 54;
            }
            case 7: {
                if (z >= 103) {
                    return z - 100;
                }
                if (z >= 89) {
                    return 3;
                }
                return z - 86;
            }
        }
        return 0;
    }

    public static int getRow(int z) {
        if (z < 1 || z > PeriodicSystem.getElementCount()) {
            return 0;
        }
        if (z <= 2) {
            return 1;
        }
        if (z <= 10) {
            return 2;
        }
        if (z <= 18) {
            return 3;
        }
        if (z <= 36) {
            return 4;
        }
        if (z <= 54) {
            return 5;
        }
        if (z <= 86) {
            return 6;
        }
        if (z <= 118) {
            return 7;
        }
        return 0;
    }

    public static boolean isMetal(int z) {
        if (z > 109) {
            return false;
        }
        if (z > 86) {
            return true;
        }
        if (z > 84) {
            return false;
        }
        if (z > 54) {
            return true;
        }
        if (z > 51) {
            return false;
        }
        if (z > 36) {
            return true;
        }
        if (z > 32) {
            return false;
        }
        if (z > 18) {
            return true;
        }
        if (z > 13) {
            return false;
        }
        if (z > 10) {
            return true;
        }
        if (z > 4) {
            return false;
        }
        return z >= 3;
    }

    public static boolean isAlkaliMetal(int z) {
        if (z >= 6 && z <= 8) {
            return false;
        }
        return PeriodicSystem.getColumn(z) == 1 && z != 1;
    }

    public static boolean isAlkalineEarthMetal(int z) {
        if (z >= 6 && z <= 8) {
            return false;
        }
        return PeriodicSystem.getColumn(z) == 2;
    }

    public static boolean isOtherMetal(int z) {
        if (z >= 6 && z <= 8) {
            return false;
        }
        int row = PeriodicSystem.getRow(z);
        int col = PeriodicSystem.getColumn(z);
        if (row < 3) {
            return false;
        }
        if (col < 13 || col > 15) {
            return false;
        }
        if (row <= 4 && col == 13) {
            return true;
        }
        if (row == 5 && col != 15) {
            return true;
        }
        return row == 6;
    }

    public static boolean isTransitionMetal(int z) {
        if (z >= 6 && z <= 8) {
            return false;
        }
        int row = PeriodicSystem.getRow(z);
        int col = PeriodicSystem.getColumn(z);
        if (col <= 2 || col >= 13) {
            return false;
        }
        return row != 6 && row != 7 || col != 3;
    }

    public static boolean isLanthanideMetal(int z) {
        return z >= 57 && z <= 71;
    }

    public static boolean isActinideMetal(int z) {
        return z >= 89 && z <= 103;
    }

    public static boolean isMetalloid(int z) {
        return z == 5 || z == 14 || z == 32 || z == 33 || z == 51 || z == 52 || z == 84;
    }

    public static boolean isHalogen(int z) {
        return z == 9 || z == 17 || z == 35 || z == 53 || z == 85;
    }

    public static boolean isNobleGas(int z) {
        return PeriodicSystem.getColumn(z) == 18;
    }

    static {
        PeriodicSystem.readElements();
    }

    private static class IsotopeDataHolder {
        static double[] ISOTOPE_MASS;
        static int[] ISOTOPE_MASS_PRECISION;
        static int[] ISOTOPE_NEUTRON;
        static double[] ISOTOPE_ABUNDANCE;
        static int[] ISOTOPE_COUNT;
        static int[] ISOTOPE_POSITION;
        static int[] MOST_FREQUENT_NATURAL_ISOTOPE;

        private IsotopeDataHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void readIsotopes() {
            int elements = PeriodicSystem.getElementCount();
            int e = 0;
            InputStream resource = BasicEnvironment.getResourceAsStream(PeriodicSystem.class, PeriodicSystem.ISOTOPE_FILE);
            if (resource.markSupported()) {
                resource.mark(4);
            }
            try {
                InputStream gzin = null;
                try {
                    gzin = new GZIPInputStream(resource);
                }
                catch (IOException ex) {
                    if (resource.markSupported()) {
                        resource.reset();
                    } else {
                        resource = BasicEnvironment.getResourceAsStream(PeriodicSystem.class, PeriodicSystem.ISOTOPE_FILE);
                    }
                    gzin = resource;
                }
                DataInputStream in = new DataInputStream(gzin);
                try {
                    int i;
                    if (in.readInt() != -87949311) {
                        throw new IOException("Malformed isotopes.data file. You might need to recreate isotopes.data file, and/or clean the client side Java cache.");
                    }
                    int isotopes = in.readShort() & 0xFFFF;
                    ISOTOPE_MASS = new double[isotopes];
                    ISOTOPE_MASS_PRECISION = new int[isotopes];
                    ISOTOPE_NEUTRON = new int[isotopes];
                    ISOTOPE_ABUNDANCE = new double[isotopes];
                    ISOTOPE_COUNT = new int[elements];
                    ISOTOPE_POSITION = new int[elements];
                    MOST_FREQUENT_NATURAL_ISOTOPE = new int[elements];
                    for (i = 0; i < elements; ++i) {
                        IsotopeDataHolder.MOST_FREQUENT_NATURAL_ISOTOPE[i] = -1;
                    }
                    int atno = 0;
                    int neutrons = 0;
                    for (i = 0; i < isotopes; ++i) {
                        byte flags = in.readByte();
                        if ((flags & 1) != 0) {
                            ++atno;
                            neutrons = in.readByte() & 0xFF;
                        } else {
                            ++neutrons;
                        }
                        int imass = in.readInt();
                        double mass = (double)(atno + neutrons) + (double)imass / 2.0E9 - 0.125;
                        double abundance = 0.0;
                        if ((flags & 2) != 0) {
                            int iabundance = in.readInt();
                            abundance = (double)iabundance / 1.0E7;
                        }
                        if (ISOTOPE_COUNT[e = atno - 1] == 0) {
                            IsotopeDataHolder.ISOTOPE_POSITION[e] = i;
                        }
                        int n = e;
                        ISOTOPE_COUNT[n] = ISOTOPE_COUNT[n] + 1;
                        IsotopeDataHolder.ISOTOPE_NEUTRON[i] = neutrons;
                        IsotopeDataHolder.ISOTOPE_MASS_PRECISION[i] = flags >> 2 & 0xF;
                        IsotopeDataHolder.ISOTOPE_MASS[i] = mass;
                        IsotopeDataHolder.ISOTOPE_ABUNDANCE[i] = abundance;
                        if (ISOTOPE_ABUNDANCE[i] != 100.0) continue;
                        IsotopeDataHolder.MOST_FREQUENT_NATURAL_ISOTOPE[e] = i;
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        static {
            IsotopeDataHolder.readIsotopes();
        }
    }
}

