/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.core.util.BondTable;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MObjectContainer;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.RgroupContainer;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.SelectionRgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.gearch.MoleculeGraphGearch;
import chemaxon.struc.gearch.RgMoleculeGearch;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.sgroup.MulticenterSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RgMolecule
extends Molecule
implements RgMoleculeGraphIface,
MObjectContainer {
    private static final long serialVersionUID = -939153732283455787L;
    public static final int RG_ID_MASK = Short.MAX_VALUE;
    public static final int RG_ID2_FLAG = 32768;
    public static final int RG_ID2_OFF = 16;
    public static final int RG_ID2_MASK = 0x7FFF0000;
    public static final int RG_RESTH = Integer.MIN_VALUE;
    private static final int REACTION_COMPLETE = 1;
    private static final int SETROOT_CALLED = 2;
    private transient Molecule root = new Molecule(this, 32, 32);
    private transient RgroupContainer rgroupContainer = null;
    private transient int rgFlags = 0;

    public RgMolecule() {
        this.root.setLocation(this.getLocation());
    }

    public void setRoot(Molecule mol) {
        mol.superGraph = this.superGraph;
        mol.parentGraph = this;
        mol.setLocation(this.getLocation());
        this.resetCtab();
        this.removeSgroupsOf(this.root, 3);
        this.addSgroupsOf(mol);
        this.root = mol;
        this.rgFlags |= 2;
    }

    public Molecule getRoot() {
        this.root.setInputFormat(this.getInputFormat());
        return this.root;
    }

    @Override
    public final MoleculeGraph getRootG() {
        return this.getRoot();
    }

    @Override
    public int getRgroupCount() {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.getRgroupCount() : 0;
    }

    @Override
    public int getRgroupMemberCount(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRgroupMemberCount(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in RgMolecule, cannot get R-group member count for " + i);
    }

    public Molecule getRgroupMember(int i, int j) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return (Molecule)r.getRgroupMember(i, j);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in RgMolecule, cannot get R-group member " + i + ", " + j);
    }

    @Override
    public final MoleculeGraph getRgroupMemberG(int i, int j) {
        return this.getRgroupMember(i, j);
    }

    @Override
    public int getRgroupId(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRgroupId(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in RgMolecule, cannot get R# ID for " + i);
    }

    @Override
    public int findRgroupIndex(int rgid) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.findRgroupIndex(rgid) : -1;
    }

    public int addRgroup(int rl, Molecule m) {
        int i;
        m.superGraph = this.superGraph;
        m.parentGraph = this;
        m.setLocation(this.getLocation());
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            i = r.addRgroup(rl, m);
        } else {
            r = new RgroupContainer();
            i = r.addRgroup(rl, m);
            this.rgroupContainer = r;
        }
        this.addSgroupsOf(m);
        this.incGrinvCCOnly();
        return i;
    }

    public boolean hasRgroupContainedBy(Set set) {
        RgroupContainer r = this.rgroupContainer;
        return r != null && r.hasRgroupContainedBy(set);
    }

    public int unRgroupAtoms(Set set) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            Iterator<MoleculeGraph> it = r.removeRgroupsConsistingOf(set);
            int n = 0;
            while (it.hasNext()) {
                MoleculeGraph m = it.next();
                for (int i = 0; i < m.getAtomCount(); ++i) {
                    MolAtom a = m.getAtom(i);
                    set.remove(a);
                }
                this.root.fuse(m);
                ++n;
            }
            return n;
        }
        return 0;
    }

    public void replaceAtomsWithNewRgroup(SelectionMolecule sel, int rgid) {
        Molecule m = new Molecule();
        m.fuse((MoleculeGraph)sel.clone());
        this.moveSgroupsTo(m, sel);
        for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
            this.removeAtom(sel.getAtom(i));
        }
        MDocument doc = this.getDocument();
        if (doc != null) {
            for (int i = sel.getAtomCount() - 1; i >= 0; --i) {
                doc.replaceAtomInGraphicsObjects(sel.getAtom(i), m.getAtom(i));
            }
        }
        m.setAbsStereo(sel.isAbsStereo());
        sel.removeAll();
        MoleculeGraph[] frags = m.findFrags(Molecule.class, 1);
        for (int i = 0; i < frags.length; ++i) {
            this.addRgroup(rgid, (Molecule)frags[i]);
            sel.fuse(frags[i]);
        }
    }

    private void moveSgroupsTo(Molecule m, SelectionMolecule sel) {
        int i;
        int n = this.getSgroupCount();
        for (i = this.getSgroupCount() - 1; i >= 0; --i) {
            Sgroup sg = this.getSgroup(i);
            if (!sg.isSelected(sel)) continue;
            m.addSgroup(sg, true);
            this.removeSgroupFromList(sg);
            this.root.removeSgroupFromList(sg);
        }
        for (i = this.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = this.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                MoleculeGraph mg = this.getRgroupMemberG(i, j);
                if (!(mg instanceof Molecule)) continue;
                Molecule molecule = (Molecule)mg;
                for (int k = molecule.getSgroupCount() - 1; k >= 0; --k) {
                    Sgroup sg = molecule.getSgroup(k);
                    if (!sg.isSelected(sel)) continue;
                    m.addSgroup(sg, true);
                    molecule.removeSgroupFromList(sg);
                }
            }
        }
        for (i = sel.getAtomCount() - 1; i >= 0; --i) {
            for (int j = m.getSgroupCount() - 1; j >= 0; --j) {
                Sgroup sg = m.getSgroup(j);
                sg.replaceAtom(sel.getAtom(i), m.getAtom(i));
                if (!(sg instanceof MulticenterSgroup)) continue;
                ((MulticenterSgroup)sg).replaceMulticenterAtom(sel.getAtom(i), m.getAtom(i));
            }
        }
    }

    @Override
    public int getRlogic(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRlogic(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in RgMolecule, cannot get R-logic " + i);
    }

    public void setRlogic(int i, int f) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.setRlogic(i, f);
        } else {
            r = new RgroupContainer();
            r.setRlogic(i, f);
            this.rgroupContainer = r;
        }
    }

    @Override
    public String getRlogicRange(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRlogicRange(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in RgMolecule, cannot get R-logic range " + i);
    }

    public void setRlogicRange(int index, String range) throws IllegalArgumentException {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.setRlogicRange(index, range);
        } else {
            r = new RgroupContainer();
            r.setRlogicRange(index, range);
            this.rgroupContainer = r;
        }
    }

    public String checkRlogicRange(int index, String range) throws IllegalArgumentException {
        return RgroupContainer.checkRlogicRange(index, range);
    }

    @Override
    public void clearForImport(String fmt) {
        super.clearForImport(fmt);
        if ((this.rgFlags & 2) != 0) {
            this.root = new Molecule(this, 32, 32);
        }
        this.root.clearForImport(fmt);
        this.root.removeAll();
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.clear();
        }
        this.rgFlags = 0;
    }

    @Override
    public void setName(String s) {
        this.root.setName(s);
    }

    @Override
    public String getName() {
        return this.root.getName();
    }

    @Override
    public void setComment(String s) {
        this.root.setComment(s);
    }

    @Override
    public String getComment() {
        return this.root.getComment();
    }

    @Override
    public MPropertyContainer properties() {
        return this.root.properties();
    }

    @Override
    public void revalidateCoordDependentProps() {
        this.root.revalidateCoordDependentProps();
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            int n = this.getRgroupMemberCount(i);
            for (int j = 0; j < n; ++j) {
                Molecule m = this.getRgroupMember(i, j);
                m.revalidateCoordDependentProps();
            }
        }
    }

    @Override
    public void setInputFormat(String format2) {
        super.setInputFormat(format2);
        this.root.setInputFormat(format2);
    }

    @Override
    public MolAtom reuseAtom(int z, int i) {
        return this.root.reuseAtom(z, i);
    }

    @Override
    public void endReuse(int n) {
        this.root.endReuse(n);
    }

    @Override
    public int[][] getCtab() {
        return this.root.getCtab();
    }

    @Override
    public int[][] getBtab() {
        return this.getBondTable().getMatrixArray();
    }

    @Override
    public BondTable getBondTable() {
        return this.root.getBondTable();
    }

    @Override
    public int rgroupIdOf(MolAtom node) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.rgroupIdOf(node) : -1;
    }

    @Override
    public int rgroupIndexOf(MolAtom node) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.rgroupIndexOf(node) : -1;
    }

    @Override
    public long getRgroupMemberID(MolAtom node) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.getRgroupMemberID(node) : -1L;
    }

    @Override
    public int getRgroupIndex(long id) {
        return RgroupContainer.getRgroupIndex(id);
    }

    @Override
    public int getRgroupMemberIndex(long id) {
        return RgroupContainer.getRgroupMemberIndex(id);
    }

    @Override
    public void setDim(int d) {
        this.root.setDim(d);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.setDim(d);
        }
        this.setFlags(this.getFlags() & 0xFFFFFFFC | d & 3);
    }

    @Override
    public int getFlags() {
        return this.root.getFlags();
    }

    @Override
    protected void setFlags(int f) {
        this.root.setFlags(f);
    }

    @Override
    protected void setFlags(int f, int mask) {
        this.root.setFlags(f, mask);
    }

    public void setAbsStereo(boolean c, int i, int j) {
        if (0 <= i && i < this.getRgroupCount() && 0 <= j && j < this.getRgroupMemberCount(i)) {
            this.getRgroupMember(i, j).setAbsStereo(c);
        } else if (i == -1 && j == -1) {
            this.root.setAbsStereo(c);
        }
        if (c) {
            if (this.root.isAbsStereo()) {
                RgroupContainer r = this.rgroupContainer;
                if (r != null && !r.isAbsStereo()) {
                    return;
                }
                super.setAbsStereo(c);
            }
        } else {
            super.setAbsStereo(c);
        }
    }

    @Override
    public void setAbsStereo(boolean c) {
        super.setAbsStereo(c);
        this.root.setAbsStereo(c);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.setAbsStereo(c);
        }
    }

    @Override
    public int getAtomCount() {
        return this.root.getAtomCount();
    }

    @Override
    public int getAtomCount(int atomicNumber) {
        return this.root.getAtomCount(atomicNumber);
    }

    @Override
    public MolAtom getAtom(int i) {
        if (i < this.root.atomCount) {
            return this.root.getAtom(i);
        }
        return this.getGraphUnion().getAtom(i);
    }

    @Override
    public void setAtom(int iu, MolAtom node) {
        if (iu >= this.root.getAtomCount()) {
            int i = iu - this.root.getAtomCount();
            for (int j = 0; j < this.getRgroupCount(); ++j) {
                int n = this.getRgroupMemberCount(j);
                for (int k = 0; k < n; ++k) {
                    Molecule m = this.getRgroupMember(j, k);
                    int na = m.getAtomCount();
                    if (i < na) {
                        m.setAtom(i, node);
                        return;
                    }
                    i -= na;
                }
            }
            throw new ArrayIndexOutOfBoundsException("Invalid node index " + iu);
        }
        this.root.setAtom(iu, node);
    }

    @Override
    public void add(MolAtom node) {
        this.root.add(node);
    }

    @Override
    protected void insertNullAtoms(int i, int count) {
        this.root.insertNullAtoms(i, count);
    }

    @Override
    protected void insertNullBonds(int i, int count) {
        this.root.insertNullBonds(i, count);
    }

    @Override
    public int getBondCount() {
        return this.root.getBondCount();
    }

    @Override
    public MolBond getBond(int i) {
        if (i < this.root.getBondCount()) {
            return this.root.getBond(i);
        }
        return this.getGraphUnion().getBond(i);
    }

    @Override
    public void setBond(int iu, MolBond edge) {
        if (iu >= this.root.getBondCount()) {
            int i = iu - this.root.getBondCount();
            for (int j = 0; j < this.getRgroupCount(); ++j) {
                int n = this.getRgroupMemberCount(j);
                for (int k = 0; k < n; ++k) {
                    Molecule m = this.getRgroupMember(j, k);
                    int nb = m.getBondCount();
                    if (i < nb) {
                        m.setBond(i, edge);
                        return;
                    }
                    i -= nb;
                }
            }
            throw new ArrayIndexOutOfBoundsException("Invalid edge index " + iu);
        }
        this.root.setBond(iu, edge);
    }

    @Override
    public void replaceBond(MolBond olde, MolBond newe) {
        this.root.replaceBond(olde, newe);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.replaceBond(olde, newe);
        }
    }

    @Override
    public void add(MolBond edge) {
        this.root.add(edge);
    }

    @Override
    public int indexOf(MolAtom node) {
        int k = this.root.indexOf(node);
        if (k >= 0) {
            return k;
        }
        k = this.root.getAtomCount();
        MoleculeGraph p = node.getParent();
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            int n = this.getRgroupMemberCount(i);
            for (int j = 0; j < n; ++j) {
                Molecule m = this.getRgroupMember(i, j);
                if (p == m) {
                    int l = m.indexOf(node);
                    return l >= 0 ? k + l : -1;
                }
                k += m.getAtomCount();
            }
        }
        return -1;
    }

    @Override
    public int indexOf(MolBond edge) {
        int k = this.root.indexOf(edge);
        if (k >= 0) {
            return k;
        }
        k = this.root.getBondCount();
        MoleculeGraph p = edge.getParent();
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            int n = this.getRgroupMemberCount(i);
            for (int j = 0; j < n; ++j) {
                Molecule m = this.getRgroupMember(i, j);
                if (p == m) {
                    int l = m.indexOf(edge);
                    return l >= 0 ? k + l : -1;
                }
                k += m.getBondCount();
            }
        }
        return -1;
    }

    @Override
    public boolean contains(MolAtom node) {
        if (this.root.contains(node)) {
            return true;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null && r.contains(node);
    }

    @Override
    public boolean contains(MolBond edge) {
        if (this.root.contains(edge)) {
            return true;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null && r.contains(edge);
    }

    @Override
    public boolean isEmpty() {
        if (!this.root.isEmpty()) {
            return false;
        }
        return this.getRgroupCount() == 0;
    }

    @Override
    public boolean isQuery() {
        if (this.getRgroupCount() > 0) {
            return true;
        }
        return this.root.isQuery();
    }

    @Override
    public boolean isAtom() {
        return this.getRgroupCount() == 0 && this.root.isAtom();
    }

    @Override
    public boolean isBond() {
        return this.getRgroupCount() == 0 && this.root.isBond();
    }

    @Override
    public boolean isReaction() {
        return this.root.isReaction();
    }

    @Override
    public boolean canBeReactionComponent() {
        return false;
    }

    @Override
    public boolean hasAtomSet() {
        if (this.root.hasAtomSet()) {
            return true;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null && r.hasAtomSet();
    }

    @Override
    public boolean hasBondSet() {
        if (this.root.hasBondSet()) {
            return true;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null && r.hasBondSet();
    }

    @Override
    protected Molecule getMostSimplifiedMolecule() {
        if (this.getRgroupCount() == 0) {
            MDocument doc;
            Molecule rootMol = this.getRoot();
            rootMol.parentGraph = null;
            rootMol.superGraph = rootMol;
            rootMol.theDocument = doc = this.getDocument();
            if (doc != null) {
                MChemicalStruct mcs;
                int indexOfMChemicalStruct = doc.objects.indexOf(doc.mainMChemicalStruct);
                doc.mainMChemicalStruct = mcs = new MChemicalStruct(rootMol);
                doc.setObject(mcs, indexOfMChemicalStruct < 0 ? 0 : indexOfMChemicalStruct);
            }
            return rootMol;
        }
        return this;
    }

    @Override
    protected MDocument getDocumentForChild(MoleculeGraph g) {
        return g == this || g == this.getRoot() ? this.theDocument : null;
    }

    public RgMolecule addRgroupsTo(Molecule m) {
        if ((m = m.getSimplifiedMolecule()) instanceof RgMolecule) {
            return (RgMolecule)m;
        }
        RgMolecule rg = (RgMolecule)this.newInstance();
        rg.setRoot(m);
        RgroupContainer rgc0 = this.rgroupContainer;
        if (rgc0 != null) {
            RgroupContainer rgc = new RgroupContainer();
            rgc.rgroups = (ArrayList)rgc0.rgroups.clone();
            rgc.rlogic = new ArrayList<Integer>();
            rgc.rlogic.addAll(rgc0.rlogic);
            rgc.rranges = new ArrayList<String>();
            rgc.rranges.addAll(rgc0.rranges);
            rg.rgroupContainer = rgc;
        }
        return rg;
    }

    @Override
    public void removeAtom(MolAtom node, int cleanupFlags) {
        this.root.removeAtom(node, cleanupFlags);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeAtom(node, cleanupFlags, this);
        }
    }

    @Override
    public void removeAtom(int i, int cleanupFlags) {
        this.root.removeAtom(i, cleanupFlags);
    }

    @Override
    public void cleanupRemovedRgroupMember(MoleculeGraph m, int f) {
        if ((f & 0x18) != 0) {
            this.removeSgroupsOf((Molecule)m);
        }
    }

    @Override
    protected void removeBond(MolBond edge, int cleanupFlags) {
        this.root.removeBond(edge, cleanupFlags);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeBond(edge, cleanupFlags);
        }
    }

    @Override
    protected void removeBond(int i, int cleanupFlags) {
        this.root.removeBond(i, cleanupFlags);
    }

    @Override
    public void removeAllBonds() {
        this.root.removeAllBonds();
        this.root.resetCtab();
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeAllBonds();
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.root.removeAll();
        this.root.resetCtab();
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeAll();
            this.rgroupContainer = null;
        }
    }

    @Override
    protected boolean isRealAtomParent() {
        return false;
    }

    @Override
    public void regenBonds() {
        this.root.regenBonds();
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.regenBonds();
        }
    }

    @Override
    public void sortBondsAccordingTo(MolBond[] order) {
        this.root.sortBondsAccordingTo(order);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.sortBondsAccordingTo(order);
        }
    }

    @Override
    public void setLocation(DPoint3 p) {
        RgroupContainer r;
        super.setLocation(p);
        if (this.root != null) {
            this.root.setLocation(p);
        }
        if ((r = this.rgroupContainer) != null) {
            r.setLocation(p);
        }
    }

    @Override
    public void fuse(MoleculeGraph g, boolean check) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof RgMoleculeGraphIface) {
            RgroupContainer rgc = this.rgroupContainer;
            RgMoleculeGraphIface rgm = (RgMoleculeGraphIface)((Object)g);
            this.fuse0(rgm.getRootG(), check);
            for (int i = 0; i < rgm.getRgroupCount(); ++i) {
                int rgid = rgm.getRgroupId(i);
                for (int j = 0; j < rgm.getRgroupMemberCount(i); ++j) {
                    MoleculeGraph rg1 = rgm.getRgroupMemberG(i, j);
                    MoleculeGraph rg0 = null;
                    if (rgc != null) {
                        rg0 = rgc.findRgroupMemberFor(rg1, rgid);
                    }
                    if (rg0 != null) {
                        rg0.fuse0(rg1, check);
                        continue;
                    }
                    if (rg1 instanceof SelectionMolecule) {
                        Molecule m = new Molecule();
                        m.fuse(rg1, check);
                        rg1 = m;
                    }
                    this.addRgroup(rgid, (Molecule)rg1);
                    this.fixRgroup(rg1.getAtom(0), rgid);
                }
            }
        } else {
            super.fuse(g, check);
        }
    }

    @Override
    public void checkConsistency() {
        this.root.checkConsistency();
        int nr = this.getRgroupCount();
        for (int i = 0; i < nr; ++i) {
            int nrm = this.getRgroupMemberCount(i);
            for (int j = 0; j < nrm; ++j) {
                this.getRgroupMember(i, j).checkConsistency();
            }
        }
    }

    @Override
    protected void fuse0(MoleculeGraph graph, boolean check) {
        if (graph instanceof MoleculeGraph) {
            this.updateDim(graph);
        }
        MoleculeGraph[] frags = graph.findFrags(SelectionMolecule.class, 1);
        block0: for (int i = 0; i < frags.length; ++i) {
            Molecule g = this.whichStructureShouldContain(frags[i]);
            boolean toRoot = false;
            if (g == null) {
                g = this.root;
                toRoot = true;
            }
            if (g.contains(frags[i]) && g.getAtomCount() == frags[i].getAtomCount()) continue;
            g.fuse0(frags[i], check);
            if (!toRoot) {
                this.root.removeSgroupsOf(g, 3);
            }
            this.resetCtab();
            if (toRoot || g == this.root) {
                MoleculeGraph mg = this.root.getGraphUnion();
                for (int j = 0; j < mg.getAtomCount(); ++j) {
                    Molecule rg;
                    MolAtom a = mg.getAtom(j);
                    RgroupContainer r = this.rgroupContainer;
                    Molecule molecule = rg = r != null ? (Molecule)r.whichRgroupContains(a) : null;
                    if (rg == null) continue;
                    int rgid = r != null ? r.getRgroupId(rg) : -1;
                    this.fixRgroup(a, rgid);
                    continue block0;
                }
                continue;
            }
            RgroupContainer r = this.rgroupContainer;
            int rgid = r != null ? r.getRgroupId(g) : -1;
            int k = this.findRgroupIndex(rgid);
            int rl = i >= 0 ? this.getRlogic(k) : rgid;
            this.fixRgroup(g.getAtom(0), rl);
            if (toRoot) continue;
            for (int m = 0; m < this.getRgroupMemberCount(k); ++m) {
                if (!(r.getRgroupMember(k, m) instanceof Molecule)) continue;
                this.root.removeSgroupsOf((Molecule)r.getRgroupMember(k, m), 3);
            }
        }
        RxnMolecule rxmol = RxnMolecule.getReaction(graph);
        if (rxmol != null && !(this.root instanceof RxnMolecule)) {
            RxnMolecule m = RxnMolecule.createReaction(this.root, rxmol.getReactionArrow(), rxmol.getReactionArrowType());
            this.setRoot(m);
        }
        this.resetCtab();
    }

    @Override
    public void mergeAtoms(MolAtom that, MolAtom a) {
        Molecule m = this.whichStructureContains(that);
        Molecule ma = this.whichStructureContains(a);
        if (m == null) {
            m = ma;
        }
        if (m == null && (m = this.whichStructureShouldContain(that)) == null) {
            m = this.root;
        }
        int rl = -1;
        if (ma != m && ma != null && ma != this.root) {
            int rgid;
            RgroupContainer r = this.rgroupContainer;
            int n = rgid = r != null ? r.getRgroupId(ma) : -1;
            if (rgid >= 0) {
                int k = this.findRgroupIndex(rgid);
                rl = k >= 0 ? this.getRlogic(k) : rgid;
            }
        }
        m.mergeAtoms(that, a);
        if (that != a) {
            this.removeAtom(a);
        }
        if (rl >= 0) {
            this.fixRgroup(that, rl);
        }
    }

    @Override
    public void setSgroupParent(MolAtom a, Sgroup sg, boolean set) {
        Molecule m = this.whichStructureContains(a);
        if (m == null) {
            throw new IllegalArgumentException("Neither root, nor any R-group contains atom " + a);
        }
        Sgroup[] oldsgroups = m.getSgroupArray();
        m.setSgroupParent(a, sg, set);
        Sgroup[] newsgroups = m.getSgroupArray();
        for (int i = 0; i < oldsgroups.length; ++i) {
            Sgroup oldsg = oldsgroups[i];
            boolean found = false;
            for (int j = 0; j < newsgroups.length && !found; ++j) {
                if (oldsg != newsgroups[j]) continue;
                found = true;
            }
            if (found) continue;
            this.removeSgroupFromList(oldsg);
        }
    }

    @Override
    public void clonecopy(MoleculeGraph g) {
        if (g instanceof RgMolecule) {
            RgMolecule rmol = (RgMolecule)g;
            rmol.removeAllSgroups();
            super.clonecopyWithoutSgroups(rmol);
            if (this.root instanceof RxnMolecule && !(rmol.root instanceof RxnMolecule)) {
                rmol.setRoot(new RxnMolecule());
            }
            this.root.clonecopy(rmol.root);
            rmol.addSgroupClones(this, this.root, rmol.root);
            RgroupContainer rgc = this.rgroupContainer;
            if (rgc != null && rgc.getRgroupCount() != 0) {
                RgroupContainer rmolrgc = rmol.rgroupContainer;
                if (rmolrgc != null) {
                    rmolrgc.clear();
                } else {
                    rmol.rgroupContainer = rmolrgc = new RgroupContainer();
                }
                for (int i = 0; i < rgc.getRgroupCount(); ++i) {
                    List<MoleculeGraph> v = rgc.rgroups.get(i);
                    ArrayList<Molecule> gv = new ArrayList<Molecule>();
                    rmolrgc.rgroups.add(gv);
                    rmolrgc.rlogic.add(rgc.rlogic.get(i));
                    rmolrgc.rranges.add(rgc.getRlogicRange(i));
                    for (int j = 0; j < v.size(); ++j) {
                        Molecule m = (Molecule)v.get(j);
                        Molecule gm = m.cloneMolecule();
                        gm.superGraph = rmol.superGraph;
                        gm.parentGraph = rmol;
                        gv.add(gm);
                        rmol.addSgroupClones(this, m, gm);
                    }
                }
            } else {
                rmol.rgroupContainer = null;
            }
        } else {
            if (g instanceof RgMoleculeGraphIface) {
                throw new RuntimeException("RgMolecule.clonecopy to " + g.getClass() + " not implemented");
            }
            this.root.clonecopy(g);
        }
    }

    @Override
    public void clonecopy(int[] iatoms, MoleculeGraph g) {
        g.removeAll();
        if (!(g instanceof RgMolecule)) {
            throw new IllegalArgumentException("Cannot clonecopy RgMolecule into " + g.getClass());
        }
        RgMolecule m = (RgMolecule)g;
        super.clonecopyMoleculeGraphWithoutSgroups(null, new MolBond[0], 0, m);
        this.root.clonecopy(iatoms, m.root);
    }

    @Override
    public boolean isSelfReference(MProp p) {
        return super.isSelfReference(p) || p.getPropValue() == this.root;
    }

    @Override
    protected boolean fixSelfReferringProperty(MProp prop) {
        if (super.fixSelfReferringProperty(prop)) {
            return true;
        }
        MMoleculeProp newprop = new MMoleculeProp(this.root);
        this.propertyContainer.replace(prop, newprop);
        return true;
    }

    @Override
    public void clonelesscopy(MoleculeGraph g) {
        super.clonelesscopy(g);
        if (g instanceof RgMolecule) {
            RgMolecule rmol = (RgMolecule)g;
            if (this.root instanceof RxnMolecule && !(rmol.root instanceof RxnMolecule)) {
                rmol.setRoot(new RxnMolecule());
            }
            this.root.clonelesscopy(rmol.root);
            rmol.root.parentGraph = rmol;
            RgroupContainer rgc = this.rgroupContainer;
            if (rgc != null && rgc.getRgroupCount() != 0) {
                RgroupContainer rmolrgc = rmol.rgroupContainer;
                if (rmolrgc != null) {
                    rmolrgc.clear();
                } else {
                    rmol.rgroupContainer = rmolrgc = new RgroupContainer();
                }
                for (int i = 0; i < rgc.getRgroupCount(); ++i) {
                    List<MoleculeGraph> v = rgc.rgroups.get(i);
                    ArrayList<MoleculeGraph> gv = new ArrayList<MoleculeGraph>();
                    rmolrgc.rgroups.add(gv);
                    rmolrgc.rlogic.add(rgc.rlogic.get(i));
                    rmolrgc.rranges.add(rgc.getRlogicRange(i));
                    for (int j = 0; j < v.size(); ++j) {
                        MoleculeGraph m = v.get(j);
                        MoleculeGraph gm = m.newInstance();
                        m.clonelesscopy(gm);
                        gm.superGraph = rmol.superGraph;
                        gm.parentGraph = rmol;
                        gv.add(gm);
                    }
                }
            } else {
                rmol.rgroupContainer = null;
            }
        } else {
            this.root.clonelesscopy(g);
        }
    }

    @Override
    public Molecule cloneMolecule() {
        RgMolecule m = new RgMolecule();
        this.clonecopy(m);
        return m;
    }

    @Override
    public String getFormula() {
        return this.root.getFormula();
    }

    @Override
    public double getMass() {
        if (this.getRgroupCount() == 0) {
            return this.root.getMass();
        }
        return 0.0;
    }

    @Override
    public MoleculeGraph newInstance() {
        RgMolecule m = new RgMolecule();
        this.makeItSimilar(m);
        return m;
    }

    @Override
    public SelectionMolecule newSelectionMolecule() {
        return this.getRgroupCount() != 0 ? new SelectionRgMolecule() : new SelectionMolecule();
    }

    @Override
    protected void makeItSimilar(MoleculeGraph g) {
        super.makeItSimilar(g);
        if (g instanceof RgMolecule) {
            RgMolecule m = (RgMolecule)g;
            this.root.makeItSimilar(m.getRoot());
        }
    }

    private void fixRgroup(MolAtom node, int rl) {
        MoleculeGraph umol = this.getGraphUnion();
        int i = umol.indexOf(node);
        if (i >= 0) {
            int j;
            Molecule frag = new Molecule(this, Math.min(umol.getAtomCount(), 32), Math.min(umol.getBondCount(), 32));
            frag.setDim(this.getDim());
            umol.findFrag(i, 1, frag);
            long index = this.getRgroupMemberID(node);
            if (index >= 0L) {
                int rgindex = this.getRgroupIndex(index);
                int mindex = this.getRgroupMemberIndex(index);
                Molecule mol = this.getRgroupMember(rgindex, mindex);
                frag.setAbsStereo(mol.isAbsStereo());
            } else {
                frag.setAbsStereo(this.getRoot().isAbsStereo());
            }
            for (j = frag.getAtomCount() - 1; j >= 0; --j) {
                this.removeAtom(frag.getAtom(j), 0);
            }
            for (j = frag.getBondCount() - 1; j >= 0; --j) {
                this.removeBond(frag.getBond(j), 0);
            }
            this.reparentSgroups(frag);
            this.addRgroup(rl, frag);
        }
    }

    private Molecule whichStructureContains(MolAtom atom) {
        if (atom == null) {
            return null;
        }
        if (this.root.contains(atom)) {
            return this.root;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null ? (Molecule)r.whichRgroupContains(atom) : null;
    }

    private Molecule whichStructureContains(MolBond edge) {
        if (edge == null) {
            return null;
        }
        if (this.root.contains(edge)) {
            return this.root;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null ? (Molecule)r.whichRgroupContains(edge) : null;
    }

    private Molecule whichStructureShouldContain(MolAtom node) {
        Molecule g = this.whichStructureContains(node);
        if (g != null) {
            return g;
        }
        for (int i = node.getBondCount() - 1; i >= 0; --i) {
            MolAtom a = node.getLigand(i);
            g = this.whichStructureContains(a);
            if (g == null) continue;
            return g;
        }
        return null;
    }

    private Molecule whichStructureShouldContain(MoleculeGraph graph) {
        for (int i = 0; i < graph.getAtomCount(); ++i) {
            Molecule gi = this.whichStructureShouldContain(graph.getAtom(i));
            if (gi == this.root) continue;
            return gi;
        }
        return null;
    }

    public boolean isIncompleteReaction() {
        boolean res = false;
        Molecule mol = this.getRoot();
        if (mol instanceof RxnMolecule) {
            res = ((RxnMolecule)mol).isIncompleteReaction();
            this.rgFlags = res ? (this.rgFlags &= 0xFFFFFFFE) : (this.rgFlags |= 1);
        }
        return res;
    }

    @Override
    public void transform(CTransform3D t, boolean incg) {
        super.transform(t, incg);
        this.root.transform(t, incg);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.transform(t, incg);
        }
    }

    public static Molecule createMol(String fmt) {
        if (fmt == null) {
            return null;
        }
        Molecule mol = fmt.equals("rgf") || fmt.equals("csrgf") || fmt.equals("rdf") || fmt.equals("csrdf") || fmt.equals("smiles") || fmt.startsWith("smiles:") || fmt.equals("smarts") || fmt.startsWith("smarts:") || fmt.equals("mol:V3") || fmt.equals("rxn:V3") ? new RgMolecule() : (fmt.equals("rxn") || fmt.equals("csrxn") ? new RxnMolecule() : new Molecule());
        ((Molecule)mol).setInputFormat(fmt);
        return mol;
    }

    @Override
    public MoleculeGraph getGraphUnion() {
        return this.getRgroupCount() != 0 ? this.getGraphUnionAsSelection() : this.root.getGraphUnion();
    }

    @Override
    protected final int getSubGraphCount() {
        int n = this.root.getSubGraphCount();
        int nr = this.getRgroupCount();
        for (int i = 0; i < nr; ++i) {
            int nrm = this.getRgroupMemberCount(i);
            for (int j = 0; j < nrm; ++j) {
                n += this.getRgroupMember(i, j).getSubGraphCount();
            }
        }
        return n;
    }

    @Override
    protected final void getSubGraphs(MoleculeGraph[] arr, int off) {
        this.root.getSubGraphs(arr, off);
        int nr = this.getRgroupCount();
        off += this.root.getSubGraphCount();
        for (int i = 0; i < nr; ++i) {
            int nrm = this.getRgroupMemberCount(i);
            for (int j = 0; j < nrm; ++j) {
                Molecule m = this.getRgroupMember(i, j);
                m.getSubGraphs(arr, off);
                off += m.getSubGraphCount();
            }
        }
    }

    @Override
    protected void fillSelectionMolecule(SelectionMolecule s) {
        this.root.fillSelectionMolecule(s);
        int n = this.getRgroupCount();
        for (int k = 0; k < n; ++k) {
            int m = this.getRgroupMemberCount(k);
            for (int l = 0; l < m; ++l) {
                Molecule r = this.getRgroupMember(k, l);
                r.fillSelectionMolecule(s);
            }
        }
    }

    @Override
    public int getLonePairCount(int i) {
        int na = this.root.getAtomCount();
        if (i < na) {
            return this.root.getLonePairCount(i);
        }
        int ng = this.getRgroupCount();
        for (int k = 0; k < ng; ++k) {
            int m = this.getRgroupMemberCount(k);
            for (int l = 0; l < m; ++l) {
                Molecule r = this.getRgroupMember(k, l);
                int nl = r.getAtomCount();
                int nextna = na + nl;
                if (i < nextna) {
                    return r.getLonePairCount(i - na);
                }
                na = nextna;
            }
        }
        throw new ArrayIndexOutOfBoundsException("atom index " + i + " greater than or equals to the total number of atoms (" + na + ")");
    }

    @Override
    public void aromatize(int method) {
        this.aromatize(method, true);
    }

    @Override
    public void aromatize(int method, boolean checkAmbiguity) {
        this.getRoot().aromatize(method);
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            for (int j = 0; j < this.getRgroupMemberCount(i); ++j) {
                this.getRgroupMember(i, j).aromatize(method, checkAmbiguity);
            }
        }
    }

    @Override
    protected void checkSgroupConsistency() {
        this.root.checkSgroupConsistency();
        int nr = this.getRgroupCount();
        for (int i = 0; i < nr; ++i) {
            int nrm = this.getRgroupMemberCount(i);
            for (int j = 0; j < nrm; ++j) {
                Molecule m = this.getRgroupMember(i, j);
                m.checkSgroupConsistency();
            }
        }
    }

    @Override
    public String toString() {
        int nr;
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append('[');
        boolean empty = true;
        int na = this.getRootG().getAtomCount();
        int nb = this.getRootG().getBondCount();
        if (na != 0) {
            if (na == 1 && nb == 0) {
                sb.append(this.getRootG().getAtom(0).getSymbol());
                sb.append(",");
            } else {
                sb.append(na);
                sb.append("a,");
            }
            empty = false;
        }
        if (nb != 0) {
            sb.append(nb);
            sb.append("b,");
            empty = false;
        }
        if ((nr = this.getRgroupCount()) <= 3) {
            for (int i = 0; i < nr; ++i) {
                int id = this.getRgroupId(i);
                sb.append('R');
                sb.append(id);
                sb.append(',');
                empty = false;
            }
        } else {
            sb.append(nr);
            sb.append("R,");
            empty = false;
        }
        if (!empty) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    protected void sumConservedQuantities(MolAtom a, int[] atoms, int sign) {
        int ri;
        int atno = a.getAtno();
        if (atno == 134 && (ri = this.findRgroupIndex(a.getRgroup())) >= 0) {
            Molecule m = this.getRgroupMember(ri, 0);
            for (int j = m.getAtomCount() - 1; j >= 0; --j) {
                MolAtom aa = m.getAtom(j);
                m.sumConservedQuantities(aa, atoms, sign);
            }
        } else {
            super.sumConservedQuantities(a, atoms, sign);
        }
    }

    @Override
    protected MoleculeGraphGearch createGearch() {
        return new RgMoleculeGearch(this);
    }

    public int getMaxAttachmentPointOrder(int rgroupID) {
        int order = 0;
        for (int i = this.getRgroupCount() - 1; i >= 0; --i) {
            if (this.getRgroupId(i) != rgroupID) continue;
            int graphOrder = 0;
            for (int j = this.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                graphOrder = this.getRgroupMemberG(i, j).getMaxRgroupAttachmentPointOrder();
                if (graphOrder <= 0 || order >= graphOrder && order != 0) continue;
                order = graphOrder;
            }
        }
        return order;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(2);
        oos.writeObject(this.getRoot());
        int n = this.getRgroupCount();
        oos.writeInt(n);
        for (int i = 0; i < n; ++i) {
            int nm = this.getRgroupMemberCount(i);
            oos.writeInt(nm);
            for (int j = 0; j < nm; ++j) {
                Molecule m = this.getRgroupMember(i, j);
                oos.writeObject(m);
            }
            int f = this.getRlogic(i);
            int rg = f & Short.MAX_VALUE;
            boolean thenR = (f & 0x8000) != 0;
            int rg2 = (f & 0x7FFF0000) >> 16;
            boolean restH = (f & Integer.MIN_VALUE) != 0;
            oos.writeShort(rg);
            oos.writeShort(rg2);
            oos.writeByte((restH ? 1 : 0) | (thenR ? 2 : 0));
            String range = this.getRlogicRange(i);
            oos.writeObject(range);
        }
        oos.writeInt(this.rgFlags);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 2) {
            throw new IOException("Cannot deserialize RgMolecule with future version (" + version + ")");
        }
        this.root = (Molecule)ois.readObject();
        int n = ois.readInt();
        if (n != 0) {
            this.rgroupContainer = new RgroupContainer();
            for (int i = 0; i < n; ++i) {
                ArrayList<Molecule> v = new ArrayList<Molecule>();
                this.rgroupContainer.rgroups.add(v);
                int nm = ois.readInt();
                for (int j = 0; j < nm; ++j) {
                    Molecule m = (Molecule)ois.readObject();
                    v.add(m);
                }
                short rg = ois.readShort();
                short rg2 = ois.readShort();
                byte bits = ois.readByte();
                int f = rg & Short.MAX_VALUE | rg2 << 16 & 0x7FFF0000;
                if ((bits & 1) != 0) {
                    f |= Integer.MIN_VALUE;
                }
                if ((bits & 2) != 0 || version < 2 && rg2 > 0) {
                    f |= 0x8000;
                }
                this.rgroupContainer.rlogic.add(new Integer(f));
                String range = (String)ois.readObject();
                this.rgroupContainer.rranges.add(range);
            }
        }
        this.rgFlags = ois.readInt();
        if (version == 0) {
            long reactionCompleteGrinvCC = ois.readLong();
        }
    }

    @Override
    public void clearObjects() {
        if (this.root instanceof MObjectContainer) {
            this.root.clearObjects();
        }
        for (int i = this.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = this.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                MoleculeGraph mg = this.getRgroupMemberG(i, j);
                if (!mg.isMolecule()) continue;
                ((Molecule)mg).clearObjects();
            }
        }
    }

    @Override
    public int getObjectCount() {
        int count = 0;
        if (this.root instanceof MObjectContainer) {
            count += this.root.getObjectCount();
        }
        for (int i = this.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = this.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                MoleculeGraph mg = this.getRgroupMemberG(i, j);
                if (!mg.isMolecule()) continue;
                count += ((Molecule)mg).getObjectCount();
            }
        }
        return count;
    }

    @Override
    public void removeObject(MObject mo) {
        if (this.root instanceof MObjectContainer) {
            this.root.removeObject(mo);
        }
        for (int i = this.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = this.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                MoleculeGraph mg = this.getRgroupMemberG(i, j);
                if (!mg.isMolecule()) continue;
                ((Molecule)mg).removeObject(mo);
            }
        }
    }

    @Override
    public void selectAllObjects(boolean s) {
        if (this.root instanceof MObjectContainer) {
            this.root.selectAllObjects(s);
        }
        for (int i = this.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = this.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                MoleculeGraph mg = this.getRgroupMemberG(i, j);
                if (!mg.isMolecule()) continue;
                ((Molecule)mg).selectAllObjects(s);
            }
        }
    }

    @Override
    public List<MObject> getAllObjects() {
        ArrayList<MObject> list = new ArrayList<MObject>();
        list.addAll(this.root.getAllObjects());
        for (int i = this.getRgroupCount() - 1; i >= 0; --i) {
            for (int j = this.getRgroupMemberCount(i) - 1; j >= 0; --j) {
                MoleculeGraph mg = this.getRgroupMemberG(i, j);
                if (!mg.isMolecule()) continue;
                list.addAll(((Molecule)mg).getAllObjects());
            }
        }
        return list;
    }

    @Override
    public int getParity(int i) {
        int ac = this.root.getAtomCount();
        if (i < ac) {
            return this.root.getParity(i);
        }
        for (int j = 0; j < this.getRgroupCount(); ++j) {
            for (int k = 0; k < this.getRgroupMemberCount(j); ++k) {
                Molecule rg = this.getRgroupMember(j, k);
                if (i >= (ac += rg.getAtomCount())) continue;
                int idx = i - ac + rg.getAtomCount();
                return rg.getParity(idx);
            }
        }
        return 0;
    }

    @Override
    public int getLocalParity(int i) {
        int ac = this.root.getAtomCount();
        if (i < ac) {
            return this.root.getLocalParity(i);
        }
        for (int j = 0; j < this.getRgroupCount(); ++j) {
            for (int k = 0; k < this.getRgroupMemberCount(j); ++k) {
                Molecule rg = this.getRgroupMember(j, k);
                if (i >= (ac += rg.getAtomCount())) continue;
                int idx = i - ac + rg.getAtomCount();
                return rg.getLocalParity(idx);
            }
        }
        return 0;
    }

    @Override
    public boolean stereoClean() {
        boolean success = this.root.stereoClean();
        for (int j = 0; j < this.getRgroupCount(); ++j) {
            for (int k = 0; k < this.getRgroupMemberCount(j); ++k) {
                Molecule rg = this.getRgroupMember(j, k);
                success &= rg.stereoClean();
            }
        }
        return success;
    }
}

