/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMoleculeGraphIface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

class RgroupContainer {
    public static final int RG_ID_MASK = Short.MAX_VALUE;
    public static final int RG_ID2_FLAG = 32768;
    public static final int RG_ID2_OFF = 16;
    public static final int RG_ID2_MASK = 0x7FFF0000;
    public static final int RG_RESTH = Integer.MIN_VALUE;
    transient ArrayList<List<MoleculeGraph>> rgroups = new ArrayList();
    transient List<Integer> rlogic = new ArrayList<Integer>();
    transient List<String> rranges = new ArrayList<String>();

    RgroupContainer() {
    }

    public int getRgroupCount() {
        return this.rgroups.size();
    }

    public int getRgroupMemberCount(int i) {
        return ((Collection)this.rgroups.get(i)).size();
    }

    public MoleculeGraph getRgroupMember(int i, int j) {
        return this.rgroups.get(i).get(j);
    }

    public int getRgroupId(int i) {
        return this.rlogic.get(i) & Short.MAX_VALUE;
    }

    public int findRgroupIndex(int rgid) {
        int n = this.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            int r = this.getRgroupId(i);
            if (r != rgid) continue;
            return i;
        }
        return -1;
    }

    public int addRgroup(int rl, MoleculeGraph m) {
        int i;
        List<MoleculeGraph> v = null;
        int rgid = rl & Short.MAX_VALUE;
        for (i = 0; i < this.getRgroupCount(); ++i) {
            int r = this.getRgroupId(i);
            if (r == rgid) {
                v = this.rgroups.get(i);
                break;
            }
            if (r <= rgid) continue;
            v = new ArrayList();
            this.rgroups.add(i, v);
            this.rlogic.add(i, new Integer(rl));
            this.rranges.add(i, new String(">0"));
            break;
        }
        if (v == null) {
            v = new ArrayList<MoleculeGraph>();
            this.rgroups.add(v);
            this.rlogic.add(new Integer(rl));
            this.rranges.add(new String(">0"));
        }
        v.add(m);
        return i;
    }

    void removeRgroup(int i) {
        this.rgroups.remove(i);
        this.rlogic.remove(i);
        this.rranges.remove(i);
    }

    public int getRlogic(int i) {
        return this.rlogic.get(i);
    }

    public void setRlogic(int i, int f) {
        this.rlogic.set(i, new Integer(f));
    }

    public String getRlogicRange(int i) {
        return this.rranges.get(i);
    }

    public void setRlogicRange(int index, String range) throws IllegalArgumentException {
        String aRange = RgroupContainer.checkRlogicRange(index, range);
        this.rranges.set(index, aRange);
    }

    static String checkRlogicRange(int index, String range) throws IllegalArgumentException {
        boolean first = true;
        StringBuffer sbuf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(range, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.length() == 0) continue;
            if (!first) {
                sbuf.append(',');
            }
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if ("<>-0123456789".indexOf(c) >= 0) continue;
                throw new IllegalArgumentException("Bad occurence range \"" + range + "\"," + " character \"" + String.valueOf(c) + "\" is not one of > < - 0 1 2 3 4 5 6 7 8 9 ,");
            }
            if (s.startsWith("-") || s.endsWith("-")) {
                throw new IllegalArgumentException("Bad occurence range \"" + range + "\"," + " \"-\" can only appear between" + " two positive integers");
            }
            if (s.startsWith(">") || s.startsWith("<")) {
                int x = -1;
                try {
                    x = Integer.parseInt(s.substring(1));
                }
                catch (NumberFormatException ex) {
                    x = -1;
                }
                if (x < 0) {
                    throw new IllegalArgumentException("Bad occurence range \"" + range + "\", positive integer expected" + " after " + s.substring(0, 1));
                }
            }
            sbuf.append(s);
            first = false;
        }
        return sbuf.toString();
    }

    void clear() {
        this.rgroups.clear();
        this.rlogic.clear();
        this.rranges.clear();
    }

    public int rgroupIdOf(MolAtom node) {
        int i = this.rgroupIndexOf(node);
        return i >= 0 ? this.getRgroupId(i) : -1;
    }

    public int rgroupIndexOf(MolAtom node) {
        ArrayList<List<MoleculeGraph>> r = this.rgroups;
        for (int j = r.size() - 1; j >= 0; --j) {
            List v = (List)r.get(j);
            for (int k = v.size() - 1; k >= 0; --k) {
                MoleculeGraph m = (MoleculeGraph)v.get(k);
                if (!m.contains(node)) continue;
                return j;
            }
        }
        return -1;
    }

    public long getRgroupMemberID(MolAtom node) {
        ArrayList<List<MoleculeGraph>> r = this.rgroups;
        if (r != null) {
            for (int j = r.size() - 1; j >= 0; --j) {
                List v = (List)r.get(j);
                for (int k = v.size() - 1; k >= 0; --k) {
                    MoleculeGraph m = (MoleculeGraph)v.get(k);
                    if (m == null || !m.contains(node)) continue;
                    return (long)j << 32 | (long)k;
                }
            }
        }
        return -1L;
    }

    static int getRgroupIndex(long id) {
        return id != -1L ? (int)(id >> 32 & 0xFFFFFFFFFFFFFFFFL) : -1;
    }

    static int getRgroupMemberIndex(long id) {
        return id != -1L ? (int)(id & 0xFFFFFFFFFFFFFFFFL) : -1;
    }

    void setDim(int d) {
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            for (int j = 0; j < this.getRgroupMemberCount(i); ++j) {
                this.getRgroupMember(i, j).setDim(d);
            }
        }
    }

    public boolean isAbsStereo() {
        for (int k = 0; k < this.getRgroupCount(); ++k) {
            for (int l = 0; l < this.getRgroupMemberCount(k); ++l) {
                if (this.getRgroupMember(k, l).isAbsStereo()) continue;
                return false;
            }
        }
        return true;
    }

    public void setAbsStereo(boolean c) {
        int n = this.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            int m = this.getRgroupMemberCount(i);
            for (int j = 0; j < m; ++j) {
                this.getRgroupMember(i, j).setAbsStereo(c);
            }
        }
    }

    public boolean contains(MolAtom node) {
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            for (int j = 0; j < this.getRgroupMemberCount(i); ++j) {
                MoleculeGraph m = this.getRgroupMember(i, j);
                if (!m.contains(node)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(MolBond edge) {
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            for (int j = 0; j < this.getRgroupMemberCount(i); ++j) {
                MoleculeGraph m = this.getRgroupMember(i, j);
                if (!m.contains(edge)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAtomSet() {
        int n = this.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            int m = this.getRgroupMemberCount(i);
            for (int j = 0; j < m; ++j) {
                MoleculeGraph r = this.getRgroupMember(i, j);
                if (!r.hasAtomSet()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasBondSet() {
        int n = this.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            int m = this.getRgroupMemberCount(i);
            for (int j = 0; j < m; ++j) {
                MoleculeGraph r = this.getRgroupMember(i, j);
                if (!r.hasBondSet()) continue;
                return true;
            }
        }
        return false;
    }

    void removeBond(MolBond edge, int cleanupFlags) {
        ArrayList<List<MoleculeGraph>> r = this.rgroups;
        for (int j = r.size() - 1; j >= 0; --j) {
            List<MoleculeGraph> v = this.rgroups.get(j);
            for (int k = 0; k < v.size(); ++k) {
                MoleculeGraph m = v.get(k);
                m.removeBond(edge, cleanupFlags);
            }
        }
    }

    void removeAllBonds() {
        for (int i = 0; i < this.rgroups.size(); ++i) {
            List<MoleculeGraph> v = this.rgroups.get(i);
            for (int j = 0; j < v.size(); ++j) {
                MoleculeGraph m = v.get(j);
                m.removeAllBonds();
                m.resetCtab();
            }
        }
    }

    void removeAll() {
        for (int i = 0; i < this.rgroups.size(); ++i) {
            List<MoleculeGraph> v = this.rgroups.get(i);
            for (int j = 0; j < v.size(); ++j) {
                MoleculeGraph m = v.get(j);
                m.removeAll();
                m.resetCtab();
            }
            v.clear();
        }
        this.clear();
    }

    void replaceBond(MolBond olde, MolBond newe) {
        ArrayList<List<MoleculeGraph>> r = this.rgroups;
        for (int j = r.size() - 1; j >= 0; --j) {
            List<MoleculeGraph> v = this.rgroups.get(j);
            for (int k = 0; k < v.size(); ++k) {
                MoleculeGraph m = v.get(k);
                m.replaceBond(olde, newe);
            }
        }
    }

    void regenBonds() {
        for (int i = 0; i < this.rgroups.size(); ++i) {
            List<MoleculeGraph> v = this.rgroups.get(i);
            for (int j = 0; j < v.size(); ++j) {
                MoleculeGraph m = v.get(j);
                m.regenBonds();
            }
        }
    }

    void sortBondsAccordingTo(MolBond[] order) {
        for (int i = 0; i < this.rgroups.size(); ++i) {
            List<MoleculeGraph> v = this.rgroups.get(i);
            for (int j = 0; j < v.size(); ++j) {
                MoleculeGraph m = v.get(j);
                m.sortBondsAccordingTo(order);
            }
        }
    }

    public void setLocation(DPoint3 p) {
        for (int i = 0; i < this.rgroups.size(); ++i) {
            List<MoleculeGraph> v = this.rgroups.get(i);
            for (int j = 0; j < v.size(); ++j) {
                MoleculeGraph m = v.get(j);
                if (!(m instanceof Molecule)) continue;
                m.setLocation(p);
            }
        }
    }

    MoleculeGraph whichRgroupContains(MolAtom node) {
        for (int k = 0; k < this.getRgroupCount(); ++k) {
            for (int l = 0; l < this.getRgroupMemberCount(k); ++l) {
                MoleculeGraph r = this.getRgroupMember(k, l);
                if (!r.contains(node)) continue;
                return r;
            }
        }
        return null;
    }

    MoleculeGraph whichRgroupContains(MolBond edge) {
        for (int k = 0; k < this.getRgroupCount(); ++k) {
            for (int l = 0; l < this.getRgroupMemberCount(k); ++l) {
                MoleculeGraph r = this.getRgroupMember(k, l);
                if (!r.contains(edge)) continue;
                return r;
            }
        }
        return null;
    }

    int getRgroupId(MoleculeGraph g) {
        int n = this.getRgroupCount();
        for (int i = 0; i < n; ++i) {
            List<MoleculeGraph> v = this.rgroups.get(i);
            for (int j = 0; j < v.size(); ++j) {
                if (v.get(j) != g) continue;
                return this.getRgroupId(i);
            }
        }
        return -1;
    }

    MoleculeGraph findRgroupMemberFor(MoleculeGraph m, int rgid) {
        int i = this.findRgroupIndex(rgid);
        if (i >= 0) {
            for (int j = 0; j < this.getRgroupMemberCount(i); ++j) {
                MoleculeGraph rg = this.getRgroupMember(i, j);
                for (int k = 0; k < m.getAtomCount(); ++k) {
                    if (!rg.contains(m.getAtom(k))) continue;
                    return rg;
                }
            }
        }
        return null;
    }

    boolean hasRgroupContainedBy(Set<?> set) {
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            List<MoleculeGraph> list = this.rgroups.get(i);
            for (int j = list.size() - 1; j >= 0; --j) {
                MoleculeGraph rg = list.get(j);
                boolean found = rg.getAtomCount() > 0;
                for (int k = 0; k < rg.getAtomCount() && found; ++k) {
                    if (set.contains(rg.getAtom(k))) continue;
                    found = false;
                }
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    Iterator<MoleculeGraph> removeRgroupsConsistingOf(Set<?> set) {
        ArrayList<MoleculeGraph> result = new ArrayList<MoleculeGraph>();
        for (int i = 0; i < this.getRgroupCount(); ++i) {
            List<MoleculeGraph> list = this.rgroups.get(i);
            Iterator<MoleculeGraph> mit = list.iterator();
            while (mit.hasNext()) {
                MoleculeGraph rg = mit.next();
                boolean found = rg.getAtomCount() > 0;
                for (int k = 0; k < rg.getAtomCount() && found; ++k) {
                    if (set.contains(rg.getAtom(k))) continue;
                    found = false;
                }
                if (!found) continue;
                result.add(rg);
                mit.remove();
            }
        }
        return result.iterator();
    }

    void removeAtom(MolAtom node, int cleanupFlags, RgMoleculeGraphIface rgmol) {
        for (int j = this.rgroups.size() - 1; j >= 0; --j) {
            List<MoleculeGraph> v = this.rgroups.get(j);
            for (int k = v.size() - 1; k >= 0; --k) {
                MoleculeGraph m = v.get(k);
                m.removeAtom(node, cleanupFlags);
                if (m.getAtomCount() != 0 || k >= v.size() || m != v.get(k)) continue;
                v.remove(k);
                rgmol.cleanupRemovedRgroupMember(m, cleanupFlags);
            }
            if (v.size() != 0 || j >= this.rgroups.size() || v != this.rgroups.get(j)) continue;
            this.removeRgroup(j);
        }
    }

    void transform(CTransform3D t, boolean incg) {
        for (int i = 0; i < this.rgroups.size(); ++i) {
            List<MoleculeGraph> v = this.rgroups.get(i);
            for (int j = 0; j < v.size(); ++j) {
                MoleculeGraph g = v.get(j);
                g.transform(t, incg);
            }
        }
    }
}

