/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.core.util.BondTable;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MObjectContainer;
import chemaxon.struc.MPoint;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.gearch.MoleculeGraphGearch;
import chemaxon.struc.gearch.RxnMoleculeGearch;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.prop.MDoubleProp;
import chemaxon.struc.prop.MIntegerProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RxnMolecule
extends Molecule
implements MObjectContainer {
    private static final long serialVersionUID = -2863036104564183121L;
    private static final String[] ARROW_TYPE_NAMES = new String[]{"DEFAULT", "RESONANCE", "RETROSYNTHETIC", "EQUILIBRIUM"};
    private static final double MIN_X_DIST = 4.62;
    private static final double MIN_Y_DIST = 1.54;
    public static final int TYPE_COUNT = 3;
    public static final int REACTANTS = 0;
    public static final int PRODUCTS = 1;
    public static final int AGENTS = 2;
    public static final int RGROUPED = 4;
    public static final int TYPE_MASK = 3;
    public static final int REGULAR_SINGLE = 0;
    public static final int TWO_HEADED_SINGLE = 1;
    public static final int REGULAR_DOUBLE = 2;
    public static final int TWO_HEADED_DOUBLE = 3;
    public static final int RESONANCE = 1;
    public static final int RETROSYNTHETIC = 2;
    public static final int EQUILIBRIUM = 3;
    private transient List<Molecule>[] strucVectors = null;
    private transient Map<MRArrow, RxnMolecule> msLogic = null;
    private transient DPoint3 reactantsEdgePoint = new DPoint3(0.0, 0.0, 0.0);
    private transient DPoint3 productsEdgePoint = new DPoint3(0.0, 0.0, 0.0);
    private transient long reactionEdgePointsGrinvCC = -1L;
    private transient long reactionCompleteGrinvCC = -1L;
    private transient boolean reactionComplete = false;
    private transient DPoint3[][] componentCenters = null;
    private transient ArrayList<MoleculeGraph> mergedComponents = null;
    private transient MRArrow arrow;

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < 3; ++i) {
            if (this.getComponentCount(i) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isBond() {
        return false;
    }

    @Override
    public boolean isReaction() {
        return true;
    }

    @Override
    public boolean canBeReactionComponent() {
        return false;
    }

    @Override
    public String getFormula() {
        StringBuffer sb = new StringBuffer();
        this.appendFormula(sb, 0);
        sb.append("->");
        if (this.getComponentCount(2) != 0) {
            this.appendFormula(sb, 2);
            sb.append("->");
        }
        this.appendFormula(sb, 1);
        return sb.toString();
    }

    @Override
    public double getMass() {
        double m = 0.0;
        for (int i = 0; i < this.getReactantCount(); ++i) {
            Molecule r = this.getReactant(i);
            m += r.getMass();
        }
        return m;
    }

    private void appendFormula(StringBuffer sb, int type) {
        for (int i = 0; i < this.getComponentCount(type); ++i) {
            if (i > 0) {
                sb.append('+');
            }
            Molecule g = this.getComponent(type, i);
            sb.append(g.getFormula());
        }
    }

    public static RxnMolecule getReaction(MoleculeGraph g) {
        if (g != null && g instanceof Molecule) {
            MoleculeGraph m = g;
            if (m instanceof RgMoleculeGraphIface) {
                m = ((RgMoleculeGraphIface)((Object)g)).getRootG();
            }
            if (m instanceof RxnMolecule) {
                return (RxnMolecule)m;
            }
        }
        return null;
    }

    public int getReactantCount() {
        return this.getComponentCount(0);
    }

    public int getProductCount() {
        return this.getComponentCount(1);
    }

    public int getAgentCount() {
        return this.getComponentCount(2);
    }

    public int getComponentCount(int type) {
        List<Molecule> w;
        List<Molecule>[] v = this.strucVectors;
        if (v != null && (w = v[type & 3]) != null) {
            return w.size();
        }
        return 0;
    }

    public Molecule getReactant(int i) {
        return this.getComponent(0, i);
    }

    public Molecule[] getReactants() {
        Molecule[] reactants = new Molecule[this.getReactantCount()];
        for (int i = 0; i < this.getReactantCount(); ++i) {
            reactants[i] = this.getReactant(i);
        }
        return reactants;
    }

    public Molecule getProduct(int i) {
        return this.getComponent(1, i);
    }

    public Molecule[] getProducts() {
        Molecule[] products = new Molecule[this.getProductCount()];
        for (int i = 0; i < this.getProductCount(); ++i) {
            products[i] = this.getProduct(i);
        }
        return products;
    }

    public Molecule getAgent(int i) {
        return this.getComponent(2, i);
    }

    public Molecule[] getAgents() {
        Molecule[] agents = new Molecule[this.getAgentCount()];
        for (int i = 0; i < this.getAgentCount(); ++i) {
            agents[i] = this.getAgent(i);
        }
        return agents;
    }

    public long getComponentID(Molecule m) {
        for (int type = 0; type < 3; ++type) {
            for (int i = 0; i < this.getComponentCount(type); ++i) {
                Molecule c = this.getComponent(type, i);
                if (m != c) continue;
                return (long)type | (long)i << 32;
            }
        }
        return -1L;
    }

    public long getComponentID(MolAtom a) {
        for (int type = 0; type < 3; ++type) {
            for (int i = 0; i < this.getComponentCount(type); ++i) {
                Molecule m = this.getComponent(type, i);
                if (!m.contains(a)) continue;
                return (long)type | (long)i << 32;
            }
        }
        return -1L;
    }

    public long getComponentID(MolBond b) {
        for (int type = 0; type < 3; ++type) {
            for (int i = 0; i < this.getComponentCount(type); ++i) {
                Molecule m = this.getComponent(type, i);
                if (!m.contains(b)) continue;
                return (long)type | (long)i << 32;
            }
        }
        return -1L;
    }

    public int getComponentType(long id) {
        return id != -1L ? (int)(id & 3L) : -1;
    }

    public int getComponentFlags(long id) {
        return id != -1L ? (int)(id & 0xFFFFFFFFFFFFFFFFL) : -1;
    }

    public int getComponentIndex(long id) {
        return id != -1L ? (int)(id >> 32 & 0xFFFFFFFFFFFFFFFFL) : -1;
    }

    public Molecule getComponent(long id) {
        return this.getComponent(this.getComponentFlags(id), this.getComponentIndex(id));
    }

    public Molecule getComponent(int flags, int i) {
        MoleculeGraph p;
        Molecule m = this.strucVectors[flags & 3].get(i);
        if ((flags & 4) != 0 && (p = this.getParent()) instanceof RgMolecule && ((RgMolecule)p).getRgroupCount() > 0) {
            Molecule r = (Molecule)m.newInstance();
            m.clonelesscopy(r);
            RgMolecule mm = ((RgMolecule)p).addRgroupsTo(r);
            ((Molecule)mm).setInputFormat(m.getInputFormat());
            return mm;
        }
        return m;
    }

    public boolean isMergedComponent(MoleculeGraph m) {
        return this.mergedComponents != null && this.mergedComponents.contains(m);
    }

    public DPoint3 getCenter(int type, int i) {
        if (this.componentCenters == null || this.grinvCC != this.reactionEdgePointsGrinvCC) {
            this.recalcReactionEdgePoints();
        }
        return new DPoint3(this.componentCenters[type & 3][i]);
    }

    @Override
    public void revalidateCoordDependentProps() {
        super.revalidateCoordDependentProps();
        for (int type = 0; type < 3; ++type) {
            for (int i = 0; i < this.getComponentCount(type); ++i) {
                Molecule m = this.getComponent(type, i);
                m.revalidateCoordDependentProps();
            }
        }
    }

    private DPoint3[] getReactionArrow0() {
        DPoint3[] arw = new DPoint3[2];
        if (this.arrow != null) {
            arw[0] = new DPoint3(this.arrow.getPoint(0).getLocation());
            arw[1] = new DPoint3(this.arrow.getPoint(1).getLocation());
        } else if (!this.isEmpty()) {
            arw[0] = this.getReactantsBond();
            arw[1] = this.getProductsBond();
            this.arrow = new MRArrow(new MPoint(arw[0]), new MPoint(arw[1]));
        } else {
            return null;
        }
        return arw;
    }

    private void setReactionArrow0(DPoint3[] arw) {
        if (this.arrow == null) {
            this.arrow = new MRArrow(new MPoint(arw[0]), new MPoint(arw[1]));
        } else {
            MPoint[] points = new MPoint[]{new MPoint(arw[0]), new MPoint(arw[1])};
            this.arrow.setPoints(points);
        }
    }

    public void setReactionArrow0() {
        this.arrow = new MRArrow(new MPoint(this.getReactantsBond()), new MPoint(this.getProductsBond()));
    }

    private void rebuildStructures0() {
        if (this.arrow == null) {
            return;
        }
        if (this.parentGraph != null) {
            ++this.parentGraph.grinvCC;
        }
        if (this.strucVectors == null) {
            return;
        }
        int nr = this.getReactantCount();
        int np = this.getProductCount();
        int na = this.getAgentCount();
        int m = nr + np;
        int n = m + na;
        ArrayList<Molecule> structures = new ArrayList<Molecule>(n);
        for (int i = 0; i < n; ++i) {
            if (i < nr) {
                structures.add(this.strucVectors[0].get(i));
                continue;
            }
            if (i < m) {
                structures.add(this.strucVectors[1].get(i - nr));
                continue;
            }
            structures.add(this.strucVectors[2].get(i - m));
        }
        this.strucVectors[0] = new ArrayList<Molecule>();
        this.strucVectors[1] = new ArrayList<Molecule>();
        this.strucVectors[2] = new ArrayList<Molecule>();
        ArrayList[] dists = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
        for (int i = 0; i < n; ++i) {
            int type;
            Molecule structure = (Molecule)structures.get(i);
            DPoint3 p = structure.calcCenter();
            DPoint3[] arrowPoints = new DPoint3[]{this.arrow.getPoint(0).getLocation(), this.arrow.getPoint(1).getLocation()};
            double u = RxnMolecule.determineArrowDistance(p.x, p.y, p.z, arrowPoints);
            int n2 = u <= 0.0 ? 0 : (type = u < 1.0 ? 2 : 1);
            if (structure.getFragCount(2) > 1) {
                MoleculeGraph[] frags = structure.findFrags(Molecule.class, 2);
                Molecule newStructure = new Molecule();
                for (int j = 0; j < frags.length; ++j) {
                    int frag_type;
                    DPoint3 q = ((Molecule)frags[j]).calcCenter();
                    double v = RxnMolecule.determineArrowDistance(q.x, q.y, q.z, arrowPoints);
                    int n3 = v <= 0.0 ? 0 : (frag_type = v < 1.0 ? 2 : 1);
                    if (frag_type != type) {
                        dists[frag_type].add(new Double(v));
                        this.addComponent((Molecule)frags[j], frag_type);
                        continue;
                    }
                    newStructure.fuse0(frags[j], true);
                }
                structure = newStructure;
                p = structure.calcCenter();
                u = RxnMolecule.determineArrowDistance(p.x, p.y, p.z, arrowPoints);
            }
            if (structure.isEmpty()) continue;
            dists[type].add(new Double(u));
            this.addComponent(structure, type);
        }
        for (int j = 0; j < 3; ++j) {
            if (this.strucVectors[j].isEmpty()) {
                this.strucVectors[j] = null;
                continue;
            }
            double[] dists_array = new double[dists[j].size()];
            for (int k = 0; k < dists[j].size(); ++k) {
                dists_array[k] = (Double)dists[j].get(k);
            }
            RxnMolecule.sortStructures(this.strucVectors[j], dists_array);
        }
        this.componentCenters = null;
        ++this.grinvCC;
    }

    private void rebuildStructures0(DPoint3[] arw, int art) {
        this.setReactionArrow0(arw);
        this.setReactionArrowType(art);
        this.rebuildStructures0();
    }

    public int getReactionArrowType() {
        if (this.arrow == null) {
            return 0;
        }
        return this.arrow.getType();
    }

    public String getReactionArrowTypeName() {
        return ARROW_TYPE_NAMES[this.getReactionArrowType()];
    }

    public void setReactionArrowType(int type) {
        if (this.arrow == null) {
            this.arrow = new MRArrow();
        }
        this.arrow.setType(type);
    }

    public void setReactionArrowType(String name) {
        for (int i = 0; i < ARROW_TYPE_NAMES.length; ++i) {
            if (!ARROW_TYPE_NAMES[i].equalsIgnoreCase(name)) continue;
            if (this.arrow == null) {
                this.arrow = new MRArrow();
            }
            this.arrow.setType(i);
            return;
        }
        throw new IllegalArgumentException("Invalid arrow type name: " + name);
    }

    public DPoint3[] getReactionArrow() {
        return this.getReactionArrow0();
    }

    public MRArrow getReactionArrow(boolean generate) {
        return generate ? this.getItsArrow() : this.arrow;
    }

    public void setReactionArrow(DPoint3[] arw) {
        this.setReactionArrow0(arw);
    }

    public void setReactionArrow() {
        this.setReactionArrow0();
    }

    public void setReactionArrow(MRArrow arrow) {
        this.arrow = arrow;
        if (this.arrow == null) {
            this.setReactionArrow0();
        }
    }

    public void removeReactionArrow() {
        this.arrow = null;
    }

    public void setMSLogic(Map<MRArrow, RxnMolecule> ms) {
        this.msLogic = ms;
    }

    public Map<MRArrow, RxnMolecule> getMSLogic() {
        return this.msLogic;
    }

    public void recalcReactionArrow() {
        ++this.grinvCC;
        DPoint3[] arrowPoints = new DPoint3[]{this.getReactantsBond(), this.getProductsBond()};
        this.setReactionArrowEndPoints(arrowPoints);
    }

    public void rebuildStructures() {
        if (this.isSingleStepReaction()) {
            this.rebuildStructures0();
        }
    }

    public void rebuildStructures(DPoint3[] arw, int art) {
    }

    private Molecule whichComponentContains(MolAtom node, int type) {
        if (node == null) {
            return null;
        }
        for (int i = this.getComponentCount(type) - 1; i >= 0; --i) {
            Molecule m = this.getComponent(type, i);
            if (!m.contains(node)) continue;
            return m;
        }
        return null;
    }

    private Molecule whichComponentContains(MolAtom node) {
        if (this.isSingleStepReaction()) {
            if (node == null || this.strucVectors == null) {
                return null;
            }
            for (int i = 0; i < this.strucVectors.length; ++i) {
                Molecule g = this.whichComponentContains(node, i);
                if (g == null) continue;
                return g;
            }
            return null;
        }
        Molecule containingOne = null;
        List<Molecule> allFrags = this.getAllFragments();
        Iterator<Molecule> fIter = allFrags.iterator();
        while (fIter.hasNext() && containingOne == null) {
            Molecule frag = fIter.next();
            if (!frag.contains(node)) continue;
            containingOne = frag;
        }
        return containingOne;
    }

    private Molecule whichComponentContains(MoleculeGraph molGraph, int type) {
        MolAtom selAtom = molGraph.getAtom(0);
        Molecule selComponent = this.whichComponentContains(selAtom, type);
        if (selComponent.contains(molGraph)) {
            return selComponent;
        }
        return null;
    }

    private Molecule whichComponentShouldContain(MolAtom node, int type) {
        if (node != null) {
            Molecule g = this.whichComponentContains(node, type);
            if (g != null) {
                return g;
            }
            for (int i = node.getBondCount() - 1; i >= 0; --i) {
                MolAtom a = node.getLigand(i);
                g = this.whichComponentContains(a, type);
                if (g == null) continue;
                return g;
            }
        }
        return null;
    }

    private Molecule whichComponentShouldContain(MolAtom node) {
        if (node == null || this.strucVectors == null) {
            return null;
        }
        for (int i = 0; i < this.strucVectors.length; ++i) {
            Molecule g = this.whichComponentShouldContain(node, i);
            if (g == null) continue;
            return g;
        }
        return null;
    }

    private Molecule whichComponentShouldContain(MoleculeGraph g, int type) {
        if (g != null) {
            for (int i = 0; i < g.getAtomCount(); ++i) {
                Molecule gi = this.whichComponentShouldContain(g.getAtom(i), type);
                if (gi == null) continue;
                return gi;
            }
        }
        return null;
    }

    private Molecule whichComponentShouldContain(MoleculeGraph g) {
        if (g == null || this.strucVectors == null) {
            return null;
        }
        for (int i = 0; i < this.strucVectors.length; ++i) {
            Molecule m = this.whichComponentShouldContain(g, i);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    private DPoint3 calcCenter(int type) {
        if (this.strucVectors == null) {
            return null;
        }
        List<Molecule> v = this.strucVectors[type];
        if (v == null || v.size() == 0) {
            return null;
        }
        DPoint3 p = new DPoint3(0.0, 0.0, 0.0);
        int n = 0;
        for (int j = v.size() - 1; j >= 0; --j) {
            Molecule m = v.get(j);
            for (int k = m.getAtomCount() - 1; k >= 0; --k) {
                MolAtom a = m.getAtom(k);
                p.x += a.getX();
                p.y += a.getY();
                p.z += a.getZ();
                ++n;
            }
        }
        p.x /= (double)n;
        p.y /= (double)n;
        p.z /= (double)n;
        return p;
    }

    private double calcSize(int type, boolean alongX) {
        if (this.strucVectors == null) {
            return 0.0;
        }
        double min = 0.0;
        double max = 0.0;
        List<Molecule> v = this.strucVectors[type];
        if (v != null) {
            int n = 0;
            for (int j = v.size() - 1; j >= 0; --j) {
                Molecule m = v.get(j);
                for (int k = m.getAtomCount() - 1; k >= 0; --k) {
                    double xy;
                    MolAtom a = m.getAtom(k);
                    double d = xy = alongX ? a.getX() : a.getY();
                    if (n == 0) {
                        min = xy;
                        max = xy;
                        ++n;
                    }
                    if (xy > max) {
                        max = xy;
                    }
                    if (!(xy < min)) continue;
                    min = xy;
                }
            }
        }
        return max - min;
    }

    private double calcXSize(int type) {
        return this.calcSize(type, true);
    }

    private double calcYSize(int type) {
        return this.calcSize(type, false);
    }

    private double defval(int type, double sign) {
        double res = 0.0;
        if (type == 1) {
            res = 1.0;
        } else if (type == 2 && sign == 1.0) {
            res = 1.0;
        }
        return res;
    }

    private double calcUMaxOrMin(DPoint3 o1, DPoint3 o2, int type, double sign) {
        if (this.strucVectors == null) {
            return this.defval(type, sign);
        }
        List<Molecule> v = this.strucVectors[type];
        if (v == null || v.size() == 0) {
            return this.defval(type, sign);
        }
        double dx = o2.x - o1.x;
        double dy = o2.y - o1.y;
        double dz = o2.z - o1.z;
        double d = dx * dx + dy * dy + dz * dz;
        if (d == 0.0) {
            return 0.0;
        }
        double fx = dx / d;
        double fy = dy / d;
        double fz = dz / d;
        double umax = 0.0;
        int n = 0;
        for (int j = v.size() - 1; j >= 0; --j) {
            Molecule m = v.get(j);
            for (int k = m.getAtomCount() - 1; k >= 0; --k) {
                MolAtom a = m.getAtom(k);
                double u = sign * (fx * (a.getX() - o1.x) + fy * (a.getY() - o1.y) + fz * (a.getZ() - o1.z));
                if (n == 0 || u > umax) {
                    umax = u;
                }
                ++n;
            }
        }
        return umax *= sign;
    }

    private void recalcReactionEdgePoints() {
        double dx = 0.0;
        double dy = 0.0;
        double u1 = 0.0;
        double u2 = 1.0;
        DPoint3 o1 = this.calcCenter(0);
        DPoint3 o2 = this.calcCenter(1);
        DPoint3 o3 = this.calcCenter(2);
        if (o1 == null && o2 == null) {
            if (o3 == null) {
                o1 = new DPoint3(-4.62, 0.0, 0.0);
                o2 = new DPoint3(4.62, 0.0, 0.0);
            } else {
                dx = 0.7 * this.calcXSize(2);
                dy = 0.7 * this.calcYSize(2);
                if (dx < 4.62) {
                    dx = 4.62;
                }
                if (dy < 1.54) {
                    dy = 1.54;
                }
                o1 = new DPoint3(o3.x - dx, o3.y - dy, o3.z);
                o2 = new DPoint3(o3.x + dx, o3.y - dy, o3.z);
            }
        } else if (o1 == null) {
            if (o3 == null) {
                dx = this.calcXSize(1);
                if (dx < 4.62) {
                    dx = 4.62;
                }
            } else {
                dx = o2.x - o3.x;
            }
            o1 = new DPoint3(o2.x - 2.0 * dx, o2.y, o2.z);
        } else if (o2 == null) {
            if (o3 == null) {
                dx = this.calcXSize(0);
                if (dx < 4.62) {
                    dx = 4.62;
                }
            } else {
                dx = o3.x - o1.x;
            }
            o2 = new DPoint3(o1.x + 2.0 * dx, o1.y, o1.z);
        }
        double urmax = this.calcUMaxOrMin(o1, o2, 0, 1.0);
        double upmin = this.calcUMaxOrMin(o1, o2, 1, -1.0);
        double uamin = this.calcUMaxOrMin(o1, o2, 2, -1.0);
        double uamax = this.calcUMaxOrMin(o1, o2, 2, 1.0);
        if (upmin < urmax) {
            double min = urmax;
            double max = upmin;
            upmin = min;
            urmax = max;
        }
        if (o3 == null) {
            u1 = 0.75 * urmax + 0.25 * upmin;
            u2 = 0.25 * urmax + 0.75 * upmin;
        } else {
            u1 = 0.5 * (urmax + uamin);
            u2 = 0.5 * (uamax + upmin);
        }
        this.reactantsEdgePoint.x = o1.x + (o2.x - o1.x) * u1;
        this.reactantsEdgePoint.y = o1.y + (o2.y - o1.y) * u1;
        this.reactantsEdgePoint.z = o1.z + (o2.z - o1.z) * u1;
        this.productsEdgePoint.x = o1.x + (o2.x - o1.x) * u2;
        this.productsEdgePoint.y = o1.y + (o2.y - o1.y) * u2;
        this.productsEdgePoint.z = o1.z + (o2.z - o1.z) * u2;
        this.recalcComponentCenters();
        this.reactionEdgePointsGrinvCC = this.grinvCC;
    }

    private void recalcComponentCenters() {
        this.componentCenters = new DPoint3[3][];
        for (int i = 0; i < this.componentCenters.length; ++i) {
            int n = this.getComponentCount(i);
            DPoint3[] centers = new DPoint3[n];
            this.componentCenters[i] = centers;
            for (int j = 0; j < centers.length; ++j) {
                centers[j] = this.getComponent(i, j).calcCenter();
            }
        }
    }

    private DPoint3 getReactantsBond() {
        if (this.grinvCC != this.reactionEdgePointsGrinvCC) {
            this.recalcReactionEdgePoints();
        }
        return new DPoint3(this.reactantsEdgePoint);
    }

    private DPoint3 getProductsBond() {
        if (this.grinvCC != this.reactionEdgePointsGrinvCC) {
            this.recalcReactionEdgePoints();
        }
        return new DPoint3(this.productsEdgePoint);
    }

    public static double determineArrowDistance(double x, double y, double z, DPoint3[] ar) {
        if (ar == null) {
            return 0.0;
        }
        double dx = ar[1].x - ar[0].x;
        double dy = ar[1].y - ar[0].y;
        double dz = ar[1].z - ar[0].z;
        double d = dx * dx + dy * dy + dz * dz;
        if (d == 0.0) {
            return 0.0;
        }
        double ex = dx / d;
        double ey = dy / d;
        double ez = dz / d;
        return ex * (x - ar[0].x) + ey * (y - ar[0].y) + ez * (z - ar[0].z);
    }

    public static int determineType(double x, double y, double z, DPoint3[] ar) {
        double u = RxnMolecule.determineArrowDistance(x, y, z, ar);
        if (u <= 0.0) {
            return 0;
        }
        if (u < 1.0) {
            return 2;
        }
        return 1;
    }

    public int determineType(double x, double y, double z) {
        DPoint3[] ar = this.getReactionArrow();
        return RxnMolecule.determineType(x, y, z, ar);
    }

    private int determineType(Molecule g) {
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> v = this.strucVectors[i];
                if (v == null) continue;
                for (int j = v.size() - 1; j >= 0; --j) {
                    if (v.get(j) != g) continue;
                    return i;
                }
            }
        }
        DPoint3 p = g.calcCenter();
        return this.determineType(p.x, p.y, p.z);
    }

    public int getType(MoleculeGraph selection) {
        if (selection == null || selection.getAtomCount() == 0) {
            return -1;
        }
        int type = this.getComponentType(this.getComponentID(selection.getAtom(0)));
        for (int i = 1; i < selection.getAtomCount(); ++i) {
            if (this.getComponentType(this.getComponentID(selection.getAtom(i))) == type) continue;
            return -1;
        }
        return type;
    }

    private void addComponent(Molecule m, DPoint3[] arw) throws IllegalArgumentException {
        DPoint3 p = m.calcCenter();
        int type = RxnMolecule.determineType(p.x, p.y, p.z, arw);
        this.addComponent(m, type);
    }

    public void addComponent(Molecule m, int type) throws IllegalArgumentException {
        this.addComponent(m, type, false);
    }

    public void addComponent(Molecule m, int type, boolean beNew) throws IllegalArgumentException {
        int i;
        Molecule g;
        List<Molecule> v;
        if (!m.canBeReactionComponent()) {
            throw new IllegalArgumentException("Addition of " + m + " to a reaction is illegal.");
        }
        m.superGraph = this.superGraph;
        m.parentGraph = this;
        m.setLocation(this.getLocation());
        if (this.strucVectors == null) {
            this.strucVectors = new ArrayList[3];
        }
        if ((v = this.strucVectors[type]) == null) {
            this.strucVectors[type] = v = new ArrayList<Molecule>();
        }
        if ((g = this.whichComponentShouldContain(m, type)) != null) {
            if (beNew) {
                g = null;
            }
            for (i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> vv = this.strucVectors[i];
                if (vv == null) continue;
                for (int j = vv.size() - 1; j >= 0; --j) {
                    int k;
                    MoleculeGraph gg = vv.get(j);
                    if (gg == g) continue;
                    for (k = m.getBondCount() - 1; k >= 0; --k) {
                        MolBond edge = m.getBond(k);
                        gg.removeBond(edge, 0);
                    }
                    for (k = m.getAtomCount() - 1; k >= 0; --k) {
                        MolAtom node = m.getAtom(k);
                        gg.removeAtom(node, 0);
                    }
                    if (gg.getFragCount(2) <= 1 && this.isMergedComponent(gg)) {
                        this.mergedComponents.remove(gg);
                    }
                    if (!gg.isEmpty() || j >= vv.size() || gg != vv.get(j)) continue;
                    vv.remove(j);
                }
            }
        }
        if (g == null) {
            i = m.getAtomCount() - 1;
            while (i >= 0) {
                MolAtom node = m.getAtom(i);
                node.parentGraph = m;
                node.index = i--;
            }
            for (i = m.getBondCount() - 1; i >= 0; --i) {
                MolBond edge = m.getBond(i);
                edge.setParent(m);
                edge.setIndex(i);
            }
            v.add(m);
        } else {
            g.fuse(m);
        }
        this.addSgroupsOf(m);
        if (m.isAbsStereo()) {
            super.setAbsStereo(true);
        }
        this.resetCtab();
    }

    public Molecule removeComponent(int flags, int i) {
        Molecule m = this.getComponent(flags, i);
        this.strucVectors[flags & 3].remove(i);
        if (this.mergedComponents != null) {
            this.mergedComponents.remove(m);
        }
        m.parentGraph = null;
        for (int j = m.getAtomCount() - 1; j >= 0; --j) {
            this.removeAtom(m.getAtom(j));
        }
        return m;
    }

    public void mergeComponentParts(MoleculeGraph m, int type, boolean isMergeStored) throws IllegalArgumentException {
        Molecule selComponent = this.whichComponentContains(m, type);
        if (selComponent != null) {
            return;
        }
        SelectionMolecule extendedSelection = new SelectionMolecule();
        MoleculeGraph umol = this.getGraphUnion();
        MolAtom[] atoms = m.getAtomArray();
        for (int i = 0; i < atoms.length; ++i) {
            umol.findFrag(umol.indexOf(atoms[i]), 2, extendedSelection);
        }
        Molecule newComponent = new Molecule();
        extendedSelection.addAtomsAndBondsTo(newComponent);
        this.addComponent(newComponent, type, true);
        if (isMergeStored) {
            if (this.mergedComponents == null) {
                this.mergedComponents = new ArrayList();
            }
            if (!this.mergedComponents.contains(newComponent)) {
                this.mergedComponents.add(newComponent);
            }
        }
    }

    public void splitComponentParts(MoleculeGraph m, int type) throws IllegalArgumentException {
        if (m.getAtomCount() != 0) {
            Molecule[] components;
            MoleculeGraph mcopy = new MoleculeGraph();
            m.clonelesscopy(mcopy);
            Molecule molToSplit = new Molecule();
            mcopy.addAtomsAndBondsTo(molToSplit);
            for (Molecule component : components = (Molecule[])molToSplit.findFrags(Molecule.class, 2)) {
                this.addComponent(component, type, true);
            }
        }
    }

    @Override
    public void clearForImport(String fmt) {
        super.clearForImport(fmt);
        if (this.strucVectors != null) {
            for (int t = 0; t < this.strucVectors.length; ++t) {
                List<Molecule> v = this.strucVectors[t];
                if (v == null) continue;
                v.clear();
            }
        }
        this.reactantsEdgePoint.x = 0.0;
        this.reactantsEdgePoint.y = 0.0;
        this.reactantsEdgePoint.z = 0.0;
        this.productsEdgePoint.x = 0.0;
        this.productsEdgePoint.y = 0.0;
        this.productsEdgePoint.z = 0.0;
        this.componentCenters = null;
        this.reactionEdgePointsGrinvCC = -1L;
        this.reactionCompleteGrinvCC = -1L;
        this.arrow = null;
    }

    @Override
    public void setDim(int d) {
        this.setFlags(this.getFlags() & 0xFFFFFFFC | d & 3);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                this.getComponent(i, j).setDim(d);
            }
        }
    }

    @Override
    public void setAbsStereo(boolean c) {
        super.setAbsStereo(c);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                this.getComponent(i, j).setAbsStereo(c);
            }
        }
    }

    @Override
    public int getAtomCount() {
        return this.getGraphUnion().getAtomCount();
    }

    @Override
    public int getAtomCount(int atomicNumber) {
        return this.getGraphUnion().getAtomCount(atomicNumber);
    }

    @Override
    public MolAtom getAtom(int i) {
        return this.getGraphUnion().getAtom(i);
    }

    @Override
    public void setAtom(int iu, MolAtom node) {
        int i = iu;
        for (int j = 0; j < 3; ++j) {
            int n = this.getComponentCount(j);
            for (int k = 0; k < n; ++k) {
                Molecule m = this.getComponent(j, k);
                int na = m.getAtomCount();
                if (i < na) {
                    m.setAtom(i, node);
                    return;
                }
                i -= na;
            }
        }
        throw new ArrayIndexOutOfBoundsException("Invalid node index " + iu);
    }

    @Override
    public int[][] getCtab() {
        return this.getGraphUnion().getCtab();
    }

    @Override
    public int[][] getBtab() {
        return this.getBondTable().getMatrixArray();
    }

    @Override
    public BondTable getBondTable() {
        return this.getGraphUnion().getBondTable();
    }

    @Override
    public int[][] createCHtab() {
        return this.getGraphUnion().createCHtab();
    }

    @Override
    public int[][] createBHtab() {
        return this.getGraphUnion().createBHtab();
    }

    @Override
    public boolean contains(MolAtom node) {
        for (int i = 0; i < 3; ++i) {
            int n = this.getComponentCount(i);
            for (int j = 0; j < n; ++j) {
                Molecule m = this.getComponent(i, j);
                if (!m.contains(node)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(MolBond edge) {
        for (int i = 0; i < 3; ++i) {
            int n = this.getComponentCount(i);
            for (int j = 0; j < n; ++j) {
                Molecule m = this.getComponent(i, j);
                if (!m.contains(edge)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasAtomSet() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                if (!this.getComponent(i, j).hasAtomSet()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasBondSet() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                if (!this.getComponent(i, j).hasBondSet()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int indexOf(MolAtom node) {
        int k = 0;
        MoleculeGraph p = node.getParent();
        for (int i = 0; i < 3; ++i) {
            int n = this.getComponentCount(i);
            for (int j = 0; j < n; ++j) {
                Molecule m = this.getComponent(i, j);
                if (m == p) {
                    int l = m.indexOf(node);
                    return l >= 0 ? k + l : -1;
                }
                k += m.getAtomCount();
            }
        }
        return -1;
    }

    @Override
    public int indexOf(MolBond edge) {
        int k = 0;
        MoleculeGraph p = edge.getParent();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                Molecule m = this.getComponent(i, j);
                if (m == p) {
                    int l = m.indexOf(edge);
                    return l >= 0 ? k + l : -1;
                }
                k += m.getBondCount();
            }
        }
        return -1;
    }

    @Override
    public void add(MolAtom a) {
        Molecule g = this.whichComponentShouldContain(a);
        if (g == null) {
            g = new Molecule(this, 32, 32);
            int type = this.determineType(a.getX(), a.getY(), a.getZ());
            this.addComponent(g, type);
        }
        g.add(a);
    }

    @Override
    public int getBondCount() {
        return this.getGraphUnion().getBondCount();
    }

    @Override
    public MolBond getBond(int i) {
        return this.getGraphUnion().getBond(i);
    }

    @Override
    public void setBond(int iu, MolBond edge) {
        int i = iu;
        for (int j = 0; j < 3; ++j) {
            int n = this.getComponentCount(j);
            for (int k = 0; k < n; ++k) {
                Molecule m = this.getComponent(j, k);
                int nb = m.getBondCount();
                if (i < nb) {
                    m.setBond(i, edge);
                    return;
                }
                i -= nb;
            }
        }
        throw new ArrayIndexOutOfBoundsException("Invalid edge index " + iu);
    }

    @Override
    public void replaceBond(MolBond olde, MolBond newe) {
        for (int j = 0; j < 3; ++j) {
            int n = this.getComponentCount(j);
            for (int k = 0; k < n; ++k) {
                Molecule m = this.getComponent(j, k);
                m.replaceBond(olde, newe);
            }
        }
    }

    @Override
    public void add(MolBond e) {
        MolAtom a1 = e.getAtom1();
        MolAtom a2 = e.getAtom2();
        Molecule g1 = this.whichComponentContains(a1);
        Molecule g2 = this.whichComponentContains(a2);
        if (g1 != null && g2 != null && g1 != g2) {
            g1.fuse0(g2, true);
            g1.add(e);
            if (this.strucVectors != null) {
                for (int i = 0; i < this.strucVectors.length; ++i) {
                    if (this.strucVectors[i] == null) continue;
                    this.strucVectors[i].remove(g2);
                    if (this.mergedComponents == null) continue;
                    this.mergedComponents.remove(g2);
                }
            }
        } else {
            Molecule g;
            Molecule molecule = g = g1 != null ? g1 : g2;
            if (g != null) {
                g.add(e);
            }
        }
    }

    public Molecule simplifyIncompleteReactionToMolecule() {
        Molecule m = null;
        int ntot = 0;
        for (int i = 0; i < 3; ++i) {
            int n = this.getComponentCount(i);
            if (n == 1) {
                m = this.getComponent(i, 0);
            }
            ntot += n;
        }
        return ntot == 1 ? m : this;
    }

    @Override
    public void removeAtom(MolAtom node, int cleanupFlags) {
        if (this.strucVectors != null) {
            for (int j = 0; j < this.strucVectors.length; ++j) {
                List<Molecule> v = this.strucVectors[j];
                if (v == null) continue;
                for (int k = v.size() - 1; k >= 0; --k) {
                    MoleculeGraph m = v.get(k);
                    m.removeAtom(node, cleanupFlags);
                    if (k >= v.size() || m != v.get(k)) {
                        this.resetCtab();
                        return;
                    }
                    if ((cleanupFlags & 0x20) != 0) {
                        if (m.getAtomCount() == 0 && m.properties().size() == 0) {
                            v.remove(k);
                            if (this.mergedComponents != null) {
                                this.mergedComponents.remove(m);
                            }
                        }
                    } else if (m.isEmpty()) {
                        v.remove(k);
                        if (this.mergedComponents != null) {
                            this.mergedComponents.remove(m);
                        }
                    }
                    this.resetCtab();
                }
            }
        }
    }

    @Override
    public void removeAtom(int iu, int cleanupFlags) {
        int i = iu;
        for (int j = 0; j < 3; ++j) {
            int n = this.getComponentCount(j);
            List<Molecule> v = this.strucVectors[j];
            for (int k = 0; k < n; ++k) {
                Molecule m = this.getComponent(j, k);
                int na = m.getAtomCount();
                if (i < na) {
                    m.removeAtom(i, cleanupFlags);
                    if (k >= v.size() || m != v.get(k)) {
                        this.resetCtab();
                        return;
                    }
                    if ((cleanupFlags & 0x20) != 0) {
                        if (m.getAtomCount() == 0 && m.properties().size() == 0) {
                            v.remove(k);
                            if (this.mergedComponents != null) {
                                this.mergedComponents.remove(m);
                            }
                        }
                    } else if (m.isEmpty()) {
                        v.remove(k);
                        if (this.mergedComponents != null) {
                            this.mergedComponents.remove(m);
                        }
                    }
                    this.resetCtab();
                    return;
                }
                i -= na;
            }
        }
        throw new ArrayIndexOutOfBoundsException("Invalid node index " + iu);
    }

    @Override
    protected void removeBond(MolBond edge, int cleanupFlags) {
        if (this.strucVectors != null) {
            for (int j = 0; j < this.strucVectors.length; ++j) {
                List<Molecule> v = this.strucVectors[j];
                if (v == null) continue;
                for (int k = 0; k < v.size(); ++k) {
                    MoleculeGraph m = v.get(k);
                    m.removeBond(edge, cleanupFlags);
                    this.resetCtab();
                }
            }
        }
    }

    @Override
    protected void removeBond(int iu, int cleanupFlags) {
        int i = iu;
        for (int j = 0; j < 3; ++j) {
            int n = this.getComponentCount(j);
            for (int k = 0; k < n; ++k) {
                Molecule m = this.getComponent(j, k);
                int nb = m.getBondCount();
                if (i < nb) {
                    m.removeBond(i, cleanupFlags);
                    this.resetCtab();
                    return;
                }
                i -= nb;
            }
        }
        throw new ArrayIndexOutOfBoundsException("Invalid edge index " + iu);
    }

    @Override
    public void removeAllBonds() {
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> v = this.strucVectors[i];
                if (v == null) continue;
                for (int j = 0; j < v.size(); ++j) {
                    MoleculeGraph m = v.get(j);
                    m.removeAllBonds();
                }
            }
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> v = this.strucVectors[i];
                if (v == null) continue;
                for (int j = 0; j < v.size(); ++j) {
                    MoleculeGraph m = v.get(j);
                    m.removeAll();
                }
                v.clear();
            }
        }
        if (!this.isSingleStepReaction()) {
            ArrayList<RxnMolecule> allSteps = this.getReactionSteps();
            Iterator<RxnMolecule> sIter = allSteps.iterator();
            while (sIter.hasNext()) {
                sIter.next().removeAll();
            }
            this.msLogic.clear();
            this.msLogic = null;
        }
    }

    @Override
    protected boolean isRealAtomParent() {
        return false;
    }

    @Override
    public void regenBonds() {
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> v = this.strucVectors[i];
                if (v == null) continue;
                for (int j = 0; j < v.size(); ++j) {
                    MoleculeGraph m = v.get(j);
                    m.regenBonds();
                }
            }
        }
    }

    @Override
    public void sortBondsAccordingTo(MolBond[] order) {
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> v = this.strucVectors[i];
                if (v == null) continue;
                for (int j = 0; j < v.size(); ++j) {
                    MoleculeGraph m = v.get(j);
                    m.sortBondsAccordingTo(order);
                }
            }
        }
    }

    @Override
    public void setLocation(DPoint3 p) {
        super.setLocation(p);
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> v = this.strucVectors[i];
                if (v == null) continue;
                for (int j = 0; j < v.size(); ++j) {
                    Molecule m = v.get(j);
                    m.setLocation(p);
                }
            }
        }
    }

    @Override
    public void mergeAtoms(MolAtom that, MolAtom node) {
        Molecule g = this.whichComponentContains(that);
        if (g == null) {
            g = this.whichComponentContains(node);
        }
        g.mergeAtoms(that, node);
        if (this.isSingleStepReaction()) {
            if (that != node) {
                this.removeAtom(node);
                int type = this.determineType(g);
                SelectionMolecule umol = new SelectionMolecule();
                this.fillSelectionMolecule(umol);
                this.fixComponent(that, type);
                g = this.whichComponentContains(that);
                for (int i = 0; i < umol.getBondCount(); ++i) {
                    MolBond b = umol.getBond(i);
                    MolAtom a1 = b.getAtom1();
                    MolAtom a2 = b.getAtom2();
                    if (!g.contains(a1) && !g.contains(a2) || g.contains(b)) continue;
                    g.add(b);
                }
                this.fixOrder(type);
            }
        } else {
            this.updateComponentRoles();
        }
    }

    @Override
    public void fuse(MoleculeGraph graph, boolean check) {
        MoleculeGraph m = graph.getGraphUnion();
        this.fuse0(m, check);
    }

    @Override
    protected void fuse0(MoleculeGraph graph, boolean check) {
        if (graph.isEmpty()) {
            return;
        }
        if (graph instanceof MoleculeGraph) {
            this.updateDim(graph);
        }
        int type = -1;
        Molecule g = this.whichComponentShouldContain(graph);
        if (g == null) {
            if (this.isSingleStepReaction()) {
                List<Molecule> v;
                g = new Molecule(this, graph.getAtomCount(), graph.getBondCount());
                DPoint3 p = graph.calcCenter();
                type = this.determineType(p.x, p.y, p.z);
                g.fuse0(graph, check);
                if (this.strucVectors == null) {
                    this.strucVectors = new ArrayList[3];
                }
                if ((v = this.strucVectors[type]) == null) {
                    this.strucVectors[type] = v = new ArrayList<Molecule>();
                }
                v.add(g);
                ++this.grinvCC;
            }
        } else {
            g.fuse0(graph, check);
            type = this.determineType(g);
            this.fixComponent(g.getAtom(0), type);
        }
        if (this.isSingleStepReaction()) {
            this.fixOrder(type);
        }
        if (graph instanceof Molecule) {
            this.addSgroupsOf((Molecule)graph);
        }
    }

    @Override
    public void setSgroupParent(MolAtom a, Sgroup sg, boolean set) {
        Molecule m = this.whichComponentContains(a);
        if (m == null) {
            throw new IllegalArgumentException("Neither reactants, nor products or agents contain atom " + a);
        }
        m.setSgroupParent(a, sg, set);
    }

    @Override
    public void clonecopy(MoleculeGraph g) {
        if (g instanceof RxnMolecule) {
            RxnMolecule rmol = (RxnMolecule)g;
            super.clonecopyWithoutSgroups(rmol);
            rmol.removeAllSgroups();
            rmol.reactantsEdgePoint = new DPoint3(this.reactantsEdgePoint);
            rmol.productsEdgePoint = new DPoint3(this.productsEdgePoint);
            rmol.reactionEdgePointsGrinvCC = this.reactionEdgePointsGrinvCC;
            rmol.reactionCompleteGrinvCC = this.reactionCompleteGrinvCC;
            rmol.componentCenters = null;
            if (rmol.mergedComponents != null) {
                rmol.mergedComponents.clear();
            }
            if (!this.isSingleStepReaction()) {
                rmol.msLogic = new HashMap<MRArrow, RxnMolecule>();
                List<Molecule> allFrags = this.getAllFragments();
                ArrayList<Molecule> cloneFrags = new ArrayList<Molecule>();
                for (Molecule f : allFrags) {
                    cloneFrags.add((Molecule)f.clone());
                }
                for (MRArrow itsKey : this.msLogic.keySet()) {
                    MRArrow cloneKey;
                    RxnMolecule target = this.msLogic.get(itsKey);
                    RxnMolecule cloneRxn = new RxnMolecule();
                    for (Molecule f : allFrags) {
                        long fID = target.getComponentID(f);
                        int type = target.getComponentType(fID);
                        if (type < 0) continue;
                        int cloneIdx = allFrags.indexOf(f);
                        Molecule cFrag = (Molecule)cloneFrags.get(cloneIdx);
                        cloneRxn.addComponent(cFrag, type);
                        if (!this.isMergedComponent(f)) continue;
                        if (cloneRxn.mergedComponents == null) {
                            cloneRxn.mergedComponents = new ArrayList();
                        }
                        cloneRxn.mergedComponents.add(cFrag);
                    }
                    if (target.arrow == null) {
                        cloneRxn.setReactionArrow0();
                        cloneKey = cloneRxn.arrow;
                    } else {
                        cloneKey = cloneRxn.arrow = (MRArrow)target.arrow.clone();
                    }
                    int type = target.getReactionArrowType();
                    cloneRxn.setReactionArrowType(type);
                    rmol.msLogic.put(cloneKey, cloneRxn);
                }
                rmol.updateComponentRoles();
            } else {
                rmol.msLogic = null;
                if (this.arrow == null) {
                    rmol.arrow = null;
                } else {
                    rmol.arrow = (MRArrow)this.arrow.clone();
                    rmol.arrow.setType(this.arrow.getType());
                }
            }
            if (this.isSingleStepReaction()) {
                if (this.strucVectors == null) {
                    rmol.strucVectors = null;
                    return;
                }
                rmol.strucVectors = new ArrayList[3];
                for (int i = 0; i < this.strucVectors.length; ++i) {
                    List<Molecule> v = this.strucVectors[i];
                    if (v == null) {
                        rmol.strucVectors[i] = null;
                        continue;
                    }
                    List<Molecule> gv = rmol.strucVectors[i];
                    if (gv == null) {
                        rmol.strucVectors[i] = gv = new ArrayList<Molecule>();
                    } else {
                        gv.clear();
                    }
                    for (int j = 0; j < v.size(); ++j) {
                        Molecule m = v.get(j);
                        Molecule gm = m.cloneMolecule();
                        gm.superGraph = rmol.superGraph;
                        gm.parentGraph = rmol;
                        gv.add(gm);
                        rmol.addSgroupClones(this, m, gm);
                        if (!this.isMergedComponent(m)) continue;
                        if (rmol.mergedComponents == null) {
                            rmol.mergedComponents = new ArrayList();
                        }
                        rmol.mergedComponents.add(gm);
                    }
                }
            }
        } else {
            super.clonecopy(g);
        }
    }

    @Override
    public void clonecopy(int[] iatoms, MoleculeGraph g) {
        if (!(g instanceof RxnMolecule)) {
            throw new IllegalArgumentException("Cannot clonecopy RxnMolecule into " + g.getClass());
        }
        RxnMolecule rmol = (RxnMolecule)g;
        super.clonecopyMoleculeGraphWithoutSgroups(null, new MolBond[0], 0, rmol);
    }

    public List<Molecule> getAllFragments() {
        ArrayList<Molecule> frags = new ArrayList<Molecule>();
        if (this.isSingleStepReaction()) {
            Molecule mFrag;
            int i;
            for (i = 0; i < this.getProductCount(); ++i) {
                mFrag = this.getProduct(i);
                if (frags.contains(mFrag)) continue;
                frags.add(mFrag);
            }
            for (i = 0; i < this.getReactantCount(); ++i) {
                mFrag = this.getReactant(i);
                if (frags.contains(mFrag)) continue;
                frags.add(mFrag);
            }
            for (i = 0; i < this.getAgentCount(); ++i) {
                mFrag = this.getAgent(i);
                if (frags.contains(mFrag)) continue;
                frags.add(mFrag);
            }
        } else {
            ArrayList<RxnMolecule> steps = this.getReactionSteps();
            for (RxnMolecule sstep : steps) {
                List<Molecule> stepFrags = sstep.getAllFragments();
                for (Molecule mFrag : stepFrags) {
                    if (frags.contains(mFrag)) continue;
                    frags.add(mFrag);
                }
            }
        }
        return frags;
    }

    @Override
    public void clonelesscopy(MoleculeGraph g) {
        super.clonelesscopy(g);
        if (g instanceof RxnMolecule) {
            RxnMolecule rmol = (RxnMolecule)g;
            rmol.reactantsEdgePoint = new DPoint3(this.reactantsEdgePoint);
            rmol.productsEdgePoint = new DPoint3(this.productsEdgePoint);
            rmol.reactionEdgePointsGrinvCC = this.reactionEdgePointsGrinvCC;
            rmol.reactionCompleteGrinvCC = this.reactionCompleteGrinvCC;
            rmol.componentCenters = null;
            if (rmol.mergedComponents != null) {
                rmol.mergedComponents.clear();
            }
            if (rmol.arrow == null) {
                rmol.arrow = new MRArrow();
            }
            rmol.arrow.setType(this.arrow.getType());
            if (this.strucVectors == null) {
                rmol.strucVectors = null;
                return;
            }
            if (rmol.strucVectors == null) {
                rmol.strucVectors = new ArrayList[3];
            }
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> v = this.strucVectors[i];
                if (v == null) {
                    rmol.strucVectors[i] = null;
                    continue;
                }
                List<Molecule> gv = rmol.strucVectors[i];
                if (gv == null) {
                    rmol.strucVectors[i] = gv = new ArrayList<Molecule>();
                } else {
                    gv.clear();
                }
                for (int j = 0; j < v.size(); ++j) {
                    Molecule m = v.get(j);
                    Molecule gm = (Molecule)m.newInstance();
                    m.clonelesscopy(gm);
                    if (this.isMergedComponent(m)) {
                        if (rmol.mergedComponents == null) {
                            rmol.mergedComponents = new ArrayList();
                        }
                        rmol.mergedComponents.add(gm);
                    }
                    gm.superGraph = rmol.superGraph;
                    gm.parentGraph = rmol;
                    gv.add(gm);
                }
            }
        }
    }

    @Override
    public Molecule cloneMolecule() {
        RxnMolecule m = new RxnMolecule();
        this.clonecopy(m);
        return m;
    }

    @Override
    public MoleculeGraph newInstance() {
        RxnMolecule m = new RxnMolecule();
        this.makeItSimilar(m);
        return m;
    }

    @Override
    protected void makeItSimilar(MoleculeGraph g) {
        super.makeItSimilar(g);
        if (g instanceof RxnMolecule) {
            RxnMolecule m = (RxnMolecule)g;
            m.setReactionArrow(this.getReactionArrow());
        }
    }

    private boolean fixComponent(MolAtom node, int type) {
        boolean fixed = false;
        Molecule mol = this.whichComponentContains(node);
        int nrAtomsInMol = mol.getAtomCount();
        if (mol != null) {
            for (int i = this.strucVectors[type].size() - 1; i >= 0; --i) {
                Molecule component = this.strucVectors[type].get(i);
                for (int j = 0; j < nrAtomsInMol; ++j) {
                    if (component == mol || !component.contains(mol.getAtom(j))) continue;
                    mol.fuse0(component, true);
                    if (this.isMergedComponent(component)) {
                        this.mergedComponents.remove(component);
                        if (!this.isMergedComponent(mol)) {
                            this.mergedComponents.add(mol);
                        }
                    }
                    this.strucVectors[type].remove(component);
                }
            }
            fixed = true;
        }
        return fixed;
    }

    public void splitAllDisconnectedComponents() {
        for (int i = 0; i < 3; ++i) {
            if (this.strucVectors[i] == null) continue;
            for (int j = 0; j < this.strucVectors[i].size(); ++j) {
                this.splitDisconnectedComponent(i, j);
            }
        }
    }

    public void splitDisconnectedComponent(long id) {
        this.splitDisconnectedComponent(this.getComponentType(id), this.getComponentIndex(id));
    }

    public void splitDisconnectedComponent(int type, int index) {
        if (this.isSingleStepReaction()) {
            Molecule[] components;
            if (this.strucVectors == null || this.strucVectors[type] == null) {
                return;
            }
            Molecule m = this.getComponent(type, index);
            if (m.getFragCount(2) == 1 || this.isMergedComponent(m)) {
                return;
            }
            this.removeComponent(type, index);
            for (Molecule component : components = (Molecule[])m.findFrags(Molecule.class, 2)) {
                this.addComponent(component, type);
            }
            this.fixOrder(type);
        } else {
            ArrayList<RxnMolecule> steps = this.getReactionSteps();
            ArrayList<RxnMolecule> containingSteps = new ArrayList<RxnMolecule>();
            Molecule m = this.getComponent(type, index);
            if (m.getFragCount(2) > 1) {
                for (RxnMolecule sstep : steps) {
                    if (!sstep.contains(m)) continue;
                    containingSteps.add(sstep);
                }
                MoleculeGraph[] frags = m.findFrags(m.getClass(), 2);
                for (RxnMolecule sstep : containingSteps) {
                    long mID = sstep.getComponentID(m);
                    int subType = sstep.getComponentType(mID);
                    int idx = sstep.getComponentIndex(mID);
                    sstep.removeComponent(subType, idx);
                    for (int i = 0; i < frags.length; ++i) {
                        sstep.addComponent((Molecule)frags[i], subType);
                    }
                    sstep.fixOrder(subType);
                }
            }
            this.updateComponentRoles();
        }
    }

    private void fixOrder(int type) {
        if (this.strucVectors == null || this.strucVectors[type] == null) {
            return;
        }
        DPoint3[] arrowPoints = this.getReactionArrow0();
        List<Molecule> v = this.strucVectors[type];
        int n = v.size();
        double[] m = new double[n];
        for (int i = 0; i < n; ++i) {
            Molecule structure = v.get(i);
            DPoint3 p = structure.calcCenter();
            m[i] = RxnMolecule.determineArrowDistance(p.x, p.y, p.z, arrowPoints);
        }
        RxnMolecule.sortStructures(v, m);
    }

    private static void sortStructures(List<Molecule> v, double[] m) {
        int n = v.size();
        for (int i = 1; i < n; ++i) {
            int j;
            Molecule structure = v.get(i);
            double u = m[i];
            int t = 0;
            for (j = i - 1; j >= 0; --j) {
                if (!(u > m[j])) continue;
                t = j + 1;
                break;
            }
            for (j = i; j > t; --j) {
                v.set(j, v.get(j - 1));
                m[j] = m[j - 1];
            }
            v.set(t, structure);
            m[t] = u;
        }
    }

    @Override
    public void transform(CTransform3D t, boolean incg) {
        super.transform(t, incg);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                Molecule m = this.getComponent(i, j);
                ((MoleculeGraph)m).transform(t, incg);
            }
        }
        this.transformReactionArrow(t);
    }

    protected void transformReactionArrow(CTransform3D t) {
        t.transform(this.reactantsEdgePoint);
        t.transform(this.productsEdgePoint);
        this.componentCenters = null;
        if (this.arrow != null) {
            this.arrow.transform(t, 0, null);
        }
    }

    private void addMolecule(Molecule mol, DPoint3[] arw) {
        MoleculeGraph[] frags = mol.findFrags(mol.getClass(), 2);
        for (int i = 0; i < frags.length; ++i) {
            Molecule frag = (Molecule)frags[i];
            this.addComponent(frag, arw);
        }
        if (this.arrow == null) {
            this.setReactionArrow(arw);
        }
        this.rebuildStructures0(arw, this.arrow.getType());
    }

    private void setReactionProperties(MoleculeGraph mol) {
        for (String key : mol.properties().getKeys()) {
            this.properties().set(key, mol.properties().get(key));
        }
    }

    public static RxnMolecule createReaction(Molecule mol, DPoint3[] arw, int art) {
        RxnMolecule rxmol = new RxnMolecule();
        rxmol.setReactionProperties(mol);
        rxmol.setReactionArrow0(arw);
        rxmol.setReactionArrowType(art);
        rxmol.addMolecule(mol, arw);
        return rxmol;
    }

    public static RxnMolecule createReaction(MoleculeGraph mol, DPoint3[] arw) {
        RxnMolecule rxmol = new RxnMolecule();
        rxmol.setReactionProperties(mol);
        rxmol.addMolecule((Molecule)mol, arw);
        return rxmol;
    }

    @Override
    public MoleculeGraph getGraphUnion() {
        return this.getGraphUnionAsSelection();
    }

    @Override
    protected final int getSubGraphCount() {
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                Molecule m = this.getComponent(i, j);
                n += m.getSubGraphCount();
            }
        }
        return n;
    }

    @Override
    protected final void getSubGraphs(MoleculeGraph[] arr, int off) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                Molecule m = this.getComponent(i, j);
                m.getSubGraphs(arr, off);
                off += m.getSubGraphCount();
            }
        }
    }

    @Override
    protected void fillSelectionMolecule(SelectionMolecule s) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.getComponentCount(i); ++j) {
                Molecule m = this.getComponent(i, j);
                m.fillSelectionMolecule(s);
            }
        }
    }

    public int getStructureCount(int type) {
        return this.getComponentCount(type);
    }

    public Molecule getStructure(int flags, int i) {
        return this.getComponent(flags, i);
    }

    public void addStructure(Molecule m, int type) {
        this.addComponent(m, type);
    }

    public void addStructure(Molecule m, int type, boolean beNew) {
        this.addComponent(m, type, beNew);
    }

    public Molecule removeStructure(int flags, int i) {
        return this.removeComponent(flags, i);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append('[');
        sb.append(this.getStructureCount(0));
        sb.append('>');
        int agents = this.getStructureCount(2);
        if (agents != 0) {
            sb.append(agents);
        }
        sb.append('>');
        sb.append(this.getStructureCount(1));
        sb.append(']');
        return sb.toString();
    }

    public boolean isIncompleteReaction() {
        if (this.grinvCC != this.reactionCompleteGrinvCC) {
            int i;
            MoleculeGraph parent = this.getParent();
            if (parent == null) {
                parent = new MoleculeGraph(null, 0, 0);
            }
            int[] atoms = new int[130];
            for (i = 0; i < 2; ++i) {
                int sign = 2 * i - 1;
                int n = this.getComponentCount(i);
                for (int j = 0; j < n; ++j) {
                    Molecule m = this.getComponent(i, j);
                    for (int k = m.getAtomCount() - 1; k >= 0; --k) {
                        MolAtom a = m.getAtom(k);
                        parent.sumConservedQuantities(a, atoms, sign);
                    }
                }
            }
            atoms[0] = atoms[0] + atoms[2];
            atoms[3] = atoms[3] + atoms[2];
            atoms[2] = 0;
            this.reactionComplete = true;
            for (i = 0; i < atoms.length; ++i) {
                if (atoms[i] == 0) continue;
                this.reactionComplete = false;
                break;
            }
            this.reactionCompleteGrinvCC = this.grinvCC;
        }
        return !this.reactionComplete;
    }

    public MRArrow getItsArrow() {
        if (this.arrow == null) {
            this.setReactionArrow0();
        }
        return this.arrow;
    }

    public MPropertyContainer getArrowAsProperty() {
        MPropertyContainer ap = new MPropertyContainer();
        if (this.arrow == null) {
            this.setReactionArrow();
        }
        MIntegerProp aType = new MIntegerProp(this.arrow.getType());
        ap.set("arrowType", aType);
        MPoint[] points = this.getItsArrow().getPoints();
        DPoint3 start = points[0].getLocation();
        MDoubleProp x1 = new MDoubleProp(start.x);
        ap.set("x1", x1);
        MDoubleProp y1 = new MDoubleProp(start.y);
        ap.set("y1", y1);
        DPoint3 end = points[1].getLocation();
        MDoubleProp x2 = new MDoubleProp(end.x);
        ap.set("x2", x2);
        MDoubleProp y2 = new MDoubleProp(end.y);
        ap.set("y2", y2);
        if (this.getDim() == 3) {
            MDoubleProp z1 = new MDoubleProp(start.z);
            ap.set("z1", z1);
            MDoubleProp z2 = new MDoubleProp(end.z);
            ap.set("z2", z2);
        }
        return ap;
    }

    public void setReactionArrowEndPoints(DPoint3[] points) {
        if (this.arrow == null) {
            this.arrow = new MRArrow(new MPoint(points[0]), new MPoint(points[1]));
        } else {
            MPoint[] aPoints = new MPoint[]{new MPoint(points[0]), new MPoint(points[1])};
            this.arrow.setPoints(aPoints);
        }
    }

    public void removeEmptyComponents() {
        if (this.strucVectors != null) {
            for (int i = 0; i < 3; ++i) {
                List<Molecule> cmpList = this.strucVectors[i];
                ArrayList<Molecule> toBeRemoved = new ArrayList<Molecule>();
                if (cmpList != null) {
                    for (int j = 0; j < cmpList.size(); ++j) {
                        Molecule mol = cmpList.get(j);
                        if (mol.getAtomCount() != 0) continue;
                        toBeRemoved.add(mol);
                    }
                }
                for (Molecule m : toBeRemoved) {
                    long cmpID = this.getComponentID(m);
                    int flags = this.getComponentFlags(cmpID);
                    int idx = this.getComponentIndex(cmpID);
                    this.removeComponent(flags, idx);
                }
            }
        }
    }

    @Override
    protected void checkSgroupConsistency() {
        for (int type = 0; type < 3; ++type) {
            for (int i = 0; i < this.getComponentCount(type); ++i) {
                Molecule c = this.getComponent(type, i);
                c.checkSgroupConsistency();
            }
        }
    }

    @Override
    protected MoleculeGraphGearch createGearch() {
        return new RxnMoleculeGearch(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
        if (this.strucVectors == null) {
            oos.writeInt(0);
            oos.writeInt(0);
            oos.writeInt(0);
        } else {
            this.writeStrucVector(oos, 0);
            this.writeStrucVector(oos, 1);
            this.writeStrucVector(oos, 2);
        }
        oos.writeDouble(this.reactantsEdgePoint.x);
        oos.writeDouble(this.reactantsEdgePoint.y);
        oos.writeDouble(this.reactantsEdgePoint.z);
        oos.writeDouble(this.productsEdgePoint.x);
        oos.writeDouble(this.productsEdgePoint.y);
        oos.writeDouble(this.productsEdgePoint.z);
        oos.writeLong(this.reactionEdgePointsGrinvCC);
        if (this.arrow == null) {
            oos.writeByte(0);
        } else {
            oos.writeByte(1);
            for (int i = 0; i < 2; ++i) {
                oos.writeDouble(this.arrow.getPoint((int)i).getLocation().x);
                oos.writeDouble(this.arrow.getPoint((int)i).getLocation().y);
                oos.writeDouble(this.arrow.getPoint((int)i).getLocation().z);
            }
        }
        int b = this.reactionComplete ? 1 : 0;
        oos.writeByte(b);
        oos.writeLong(this.reactionCompleteGrinvCC);
        if (this.arrow == null) {
            oos.writeInt(-1);
        } else {
            oos.writeInt(this.arrow.getType());
        }
    }

    private void writeStrucVector(ObjectOutputStream oos, int type) throws IOException {
        List<Molecule> v = this.strucVectors[type];
        if (v == null) {
            oos.writeInt(0);
        } else {
            oos.writeInt(v.size());
            for (int j = 0; j < v.size(); ++j) {
                oos.writeObject(v.get(j));
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 1) {
            throw new IOException("Cannot deserialize reaction with future version (" + version + ")");
        }
        this.readStrucVector(ois, 0);
        this.readStrucVector(ois, 1);
        this.readStrucVector(ois, 2);
        double x = ois.readDouble();
        double y = ois.readDouble();
        double z = ois.readDouble();
        this.reactantsEdgePoint = new DPoint3(x, y, z);
        x = ois.readDouble();
        y = ois.readDouble();
        z = ois.readDouble();
        this.productsEdgePoint = new DPoint3(x, y, z);
        this.reactionEdgePointsGrinvCC = ois.readLong();
        byte control = ois.readByte();
        if ((control & 1) == 1) {
            DPoint3[] arrowPoints = new DPoint3[2];
            for (int i = 0; i < 2; ++i) {
                x = ois.readDouble();
                y = ois.readDouble();
                z = ois.readDouble();
                arrowPoints[i] = new DPoint3(x, y, z);
            }
            this.setReactionArrow(arrowPoints);
        }
        if (version > 0) {
            byte b = ois.readByte();
            this.reactionComplete = (b & 1) != 0;
            this.reactionCompleteGrinvCC = ois.readLong();
            int type = ois.readInt();
            if (type != -1) {
                this.setReactionArrowType(type);
            }
        }
    }

    private void readStrucVector(ObjectInputStream ois, int type) throws IOException, ClassNotFoundException {
        int n = ois.readInt();
        if (n != 0) {
            if (this.strucVectors == null) {
                this.strucVectors = new List[3];
            }
            this.strucVectors[type] = new ArrayList<Molecule>();
            for (int j = 0; j < n; ++j) {
                this.strucVectors[type].add((Molecule)ois.readObject());
            }
        }
    }

    public void addReactionStep(ArrayList reactants, ArrayList products, ArrayList agents, MRArrow arrow, int arrowType) {
        if (this.msLogic == null) {
            this.msLogic = new HashMap<MRArrow, RxnMolecule>();
        }
        RxnMolecule newStep = new RxnMolecule();
        for (int type = 0; type < 3; ++type) {
            ArrayList collection = null;
            switch (type) {
                case 0: {
                    collection = reactants;
                    break;
                }
                case 1: {
                    collection = products;
                    break;
                }
                case 2: {
                    collection = agents;
                }
            }
            if (collection == null) continue;
            for (Molecule cmp : collection) {
                newStep.addComponent(cmp, type);
            }
        }
        newStep.setReactionArrow(arrow);
        this.msLogic.put(arrow, newStep);
    }

    public boolean isSingleStepReaction() {
        return true;
    }

    public void updateComponentRoles() {
        if (!this.isSingleStepReaction()) {
            for (MRArrow key : this.msLogic.keySet()) {
                RxnMolecule subRxn = this.msLogic.get(key);
                for (int type = 0; type < 3; ++type) {
                    for (int cc = 0; cc < subRxn.getComponentCount(type); ++cc) {
                        Molecule m = subRxn.getComponent(type, cc);
                        long cID = this.getComponentID(m);
                        if (cID < 0L) {
                            this.addComponent(m, type);
                            continue;
                        }
                        int oldType = this.getComponentType(cID);
                        if (oldType == type) continue;
                        int cIdx = this.getComponentIndex(cID);
                        this.removeComponent(oldType, cIdx);
                        this.addComponent(m, 2);
                    }
                }
            }
            this.simplifyMsLogic();
        }
    }

    private void simplifyMsLogic() {
        if (this.msLogic.size() == 1) {
            RxnMolecule rxn = this.msLogic.values().iterator().next();
            this.setReactionArrow(rxn.arrow);
            this.setReactionArrowType(rxn.getReactionArrowType());
            this.msLogic.clear();
            this.msLogic = null;
        }
    }

    public ArrayList<RxnMolecule> getReactionSteps() {
        ArrayList<RxnMolecule> rs = null;
        if (!this.isSingleStepReaction()) {
            rs = new ArrayList<RxnMolecule>();
            Collection<RxnMolecule> c = this.msLogic.values();
            Iterator<RxnMolecule> iter = c.iterator();
            while (iter.hasNext()) {
                rs.add(iter.next());
            }
        }
        return rs;
    }

    public List<MRArrow> getReactionArrowList() {
        ArrayList<MRArrow> ral = new ArrayList<MRArrow>();
        if (this.isSingleStepReaction()) {
            if (this.arrow != null) {
                ral.add(this.arrow);
            }
        } else if (!this.isSingleStepReaction()) {
            Iterator<MRArrow> arrows = this.msLogic.keySet().iterator();
            while (arrows.hasNext()) {
                ral.add(arrows.next());
            }
        }
        return ral;
    }

    public Molecule simplifyToMolecule() {
        Molecule mol = new Molecule();
        if (this.strucVectors == null) {
            return mol;
        }
        for (int i = 0; i < this.strucVectors.length; ++i) {
            if (this.strucVectors[i] == null) continue;
            for (int j = 0; j < this.strucVectors[i].size(); ++j) {
                int k;
                Molecule m = this.strucVectors[i].get(j);
                for (k = m.getBondCount() - 1; k >= 0; --k) {
                    MolBond edge = m.getBond(k);
                    mol.add(edge);
                }
                for (k = m.getAtomCount() - 1; k >= 0; --k) {
                    MolAtom node = m.getAtom(k);
                    mol.add(node);
                }
            }
            this.strucVectors[i] = null;
        }
        for (String key : this.properties().getKeys()) {
            mol.properties().set(key, this.properties().get(key));
        }
        return mol;
    }

    @Override
    public void clearObjects() {
        if (this.isSingleStepReaction()) {
            this.arrow = null;
        } else {
            this.arrow = null;
            this.msLogic = null;
        }
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> vv = this.strucVectors[i];
                if (vv == null) continue;
                for (int j = vv.size() - 1; j >= 0; --j) {
                    vv.get(j).clearObjects();
                }
            }
        }
    }

    @Override
    public void removeObject(MObject o) {
        if (this.isSingleStepReaction()) {
            if (o == this.arrow) {
                this.arrow = null;
            }
        } else {
            this.msLogic.remove(o);
            this.simplifyMsLogic();
        }
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> vv = this.strucVectors[i];
                if (vv == null) continue;
                for (int j = vv.size() - 1; j >= 0; --j) {
                    vv.get(j).removeObject(o);
                }
            }
        }
    }

    @Override
    public int getObjectCount() {
        int count;
        int n = count = this.arrow != null ? 1 : 0;
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> vv = this.strucVectors[i];
                if (vv == null) continue;
                for (int j = vv.size() - 1; j >= 0; --j) {
                    count += vv.get(j).getObjectCount();
                }
            }
        }
        return count;
    }

    @Override
    public void selectAllObjects(boolean s) {
        if (this.arrow != null) {
            this.arrow.setSelected(s);
        }
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> vv = this.strucVectors[i];
                if (vv == null) continue;
                for (int j = vv.size() - 1; j >= 0; --j) {
                    vv.get(j).selectAllObjects(s);
                }
            }
        }
    }

    @Override
    public List<MObject> getAllObjects() {
        ArrayList<MObject> list = new ArrayList<MObject>();
        if (this.arrow != null) {
            list.add(this.arrow);
        }
        if (this.strucVectors != null) {
            for (int i = 0; i < this.strucVectors.length; ++i) {
                List<Molecule> vv = this.strucVectors[i];
                if (vv == null) continue;
                for (int j = vv.size() - 1; j >= 0; --j) {
                    list.addAll(vv.get(j).getAllObjects());
                }
            }
        }
        return list;
    }

    @Override
    public int getParity(int i) {
        int ac = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < this.getComponentCount(j); ++k) {
                Molecule m = this.getComponent(j, k);
                if (i >= (ac += m.getAtomCount())) continue;
                int idx = i - ac + m.getAtomCount();
                return m.getParity(idx);
            }
        }
        return 0;
    }

    @Override
    public int getLocalParity(int i) {
        int ac = 0;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < this.getComponentCount(j); ++k) {
                Molecule m = this.getComponent(j, k);
                if (i >= (ac += m.getAtomCount())) continue;
                int idx = i - ac + m.getAtomCount();
                return m.getLocalParity(idx);
            }
        }
        return 0;
    }

    @Override
    public boolean stereoClean() {
        boolean success = true;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < this.getComponentCount(j); ++k) {
                Molecule m = this.getComponent(j, k);
                success &= m.stereoClean();
            }
        }
        return success;
    }
}

