/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.core.util.BondTable;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.RgroupContainer;
import chemaxon.struc.SelectionMolecule;
import java.util.ArrayList;
import java.util.List;

public class SelectionRgMolecule
extends SelectionMolecule
implements RgMoleculeGraphIface {
    public static final int RG_ID_MASK = Short.MAX_VALUE;
    private transient SelectionMolecule root = new SelectionMolecule();
    private transient RgroupContainer rgroupContainer = null;

    public SelectionRgMolecule() {
        this.root.parentGraph = this;
    }

    @Override
    public MoleculeGraph getRootG() {
        return this.root;
    }

    @Override
    public int getRgroupCount() {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.getRgroupCount() : 0;
    }

    @Override
    public int getRgroupMemberCount(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRgroupMemberCount(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in SelectionRgMolecule, cannot get R-group member count for " + i);
    }

    @Override
    public MoleculeGraph getRgroupMemberG(int i, int j) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRgroupMember(i, j);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in SelectionRgMolecule, cannot get R-group member " + i + ", " + j);
    }

    @Override
    public int getRgroupId(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRgroupId(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in SelectionRgMolecule, cannot get R# ID for " + i);
    }

    @Override
    public int findRgroupIndex(int rgid) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.findRgroupIndex(rgid) : -1;
    }

    @Override
    public int getRlogic(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRlogic(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in SelectionRgMolecule, cannot get R-logic " + i);
    }

    @Override
    public String getRlogicRange(int i) {
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            return r.getRlogicRange(i);
        }
        throw new ArrayIndexOutOfBoundsException("No R-groups in SelectionRgMolecule, cannot get R-logic range " + i);
    }

    @Override
    public int rgroupIdOf(MolAtom node) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.rgroupIdOf(node) : -1;
    }

    @Override
    public int rgroupIndexOf(MolAtom node) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.rgroupIndexOf(node) : -1;
    }

    @Override
    public long getRgroupMemberID(MolAtom node) {
        RgroupContainer r = this.rgroupContainer;
        return r != null ? r.getRgroupMemberID(node) : -1L;
    }

    @Override
    public int getRgroupIndex(long id) {
        return RgroupContainer.getRgroupIndex(id);
    }

    @Override
    public int getRgroupMemberIndex(long id) {
        return RgroupContainer.getRgroupMemberIndex(id);
    }

    @Override
    public int[][] getCtab() {
        return this.root.getCtab();
    }

    @Override
    public int[][] getBtab() {
        return this.getBondTable().getMatrixArray();
    }

    @Override
    public BondTable getBondTable() {
        return this.root.getBondTable();
    }

    @Override
    public int getAtomCount() {
        return this.root.getAtomCount();
    }

    @Override
    public MolAtom getAtom(int i) {
        return this.root.getAtom(i);
    }

    @Override
    public void setAtom(int i, MolAtom node) {
        this.root.setAtom(i, node);
    }

    @Override
    public void add(MolAtom node) {
        this.root.add(node);
    }

    @Override
    protected void insertNullAtoms(int i, int count) {
        this.root.insertNullAtoms(i, count);
    }

    @Override
    protected void insertNullBonds(int i, int count) {
        this.root.insertNullBonds(i, count);
    }

    @Override
    public int getBondCount() {
        return this.root.getBondCount();
    }

    @Override
    public MolBond getBond(int i) {
        return this.root.getBond(i);
    }

    @Override
    public void setBond(int i, MolBond edge) {
        this.root.setBond(i, edge);
    }

    @Override
    public void add(MolBond edge) {
        this.root.add(edge);
    }

    @Override
    public int indexOf(MolAtom node) {
        return this.root.indexOf(node);
    }

    @Override
    public int indexOf(MolBond edge) {
        return this.root.indexOf(edge);
    }

    @Override
    public boolean contains(MolAtom node) {
        if (this.root.contains(node)) {
            return true;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null && r.contains(node);
    }

    @Override
    public boolean contains(MolBond edge) {
        if (this.root.contains(edge)) {
            return true;
        }
        RgroupContainer r = this.rgroupContainer;
        return r != null && r.contains(edge);
    }

    @Override
    public boolean isEmpty() {
        if (!this.root.isEmpty()) {
            return false;
        }
        return this.getRgroupCount() == 0;
    }

    @Override
    public void removeAtom(MolAtom node, int cleanupFlags) {
        this.root.removeAtom(node, cleanupFlags);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeAtom(node, cleanupFlags, this);
        }
    }

    @Override
    public void removeAtom(int i, int cleanupFlags) {
        this.root.removeAtom(i, cleanupFlags);
    }

    @Override
    public void cleanupRemovedRgroupMember(MoleculeGraph m, int f) {
    }

    @Override
    protected void removeBond(MolBond edge, int cleanupFlags) {
        this.root.removeBond(edge, cleanupFlags);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeBond(edge, cleanupFlags);
        }
    }

    @Override
    protected void removeBond(int i, int cleanupFlags) {
        this.root.removeBond(i, cleanupFlags);
    }

    @Override
    public void removeAllBonds() {
        this.root.removeAllBonds();
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeAllBonds();
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.root.removeAll();
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.removeAll();
            this.rgroupContainer = null;
        }
    }

    public int addRgroup(int rl, SelectionMolecule m) {
        int i;
        m.superGraph = this.superGraph;
        m.parentGraph = this;
        m.setLocation(this.getLocation());
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            i = r.addRgroup(rl, m);
        } else {
            r = new RgroupContainer();
            i = r.addRgroup(rl, m);
            this.rgroupContainer = r;
        }
        return i;
    }

    @Override
    protected void fuse0(MoleculeGraph g, boolean check) {
        this.root.fuse0(g, check);
    }

    @Override
    public void fuse(MoleculeGraph g, boolean check) {
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof RgMoleculeGraphIface) {
            RgroupContainer rgc = this.rgroupContainer;
            RgMoleculeGraphIface rgm = (RgMoleculeGraphIface)((Object)g);
            this.fuse0(rgm.getRootG(), check);
            for (int i = 0; i < rgm.getRgroupCount(); ++i) {
                int rgid = rgm.getRgroupId(i);
                for (int j = 0; j < rgm.getRgroupMemberCount(i); ++j) {
                    MoleculeGraph rg1 = rgm.getRgroupMemberG(i, j);
                    MoleculeGraph rg0 = null;
                    if (rgc != null) {
                        rg0 = rgc.findRgroupMemberFor(rg1, rgid);
                    }
                    if (rg0 != null) {
                        rg0.fuse0(rg1, check);
                        continue;
                    }
                    SelectionMolecule m = new SelectionMolecule();
                    m.fuse(rg1, check);
                    this.addRgroup(rgid, m);
                }
            }
        } else {
            super.fuse(g, check);
        }
    }

    @Override
    public void transform(CTransform3D t, boolean incg) {
        super.transform(t, incg);
        this.root.transform(t, incg);
        RgroupContainer r = this.rgroupContainer;
        if (r != null) {
            r.transform(t, incg);
        }
    }

    @Override
    public MoleculeGraph getGraphUnion() {
        if (this.getRgroupCount() != 0) {
            SelectionMolecule m = new SelectionMolecule();
            this.fillSelectionMolecule(m);
            return m;
        }
        return this.root.getGraphUnion();
    }

    protected void fillSelectionMolecule(SelectionMolecule s) {
        this.root.addAtomsAndBondsTo(s);
        int n = this.getRgroupCount();
        for (int k = 0; k < n; ++k) {
            int m = this.getRgroupMemberCount(k);
            for (int l = 0; l < m; ++l) {
                MoleculeGraph r = this.getRgroupMemberG(k, l);
                r.addAtomsAndBondsTo(s);
            }
        }
    }

    @Override
    public String toString() {
        int nr;
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append('[');
        boolean empty = true;
        int na = this.getRootG().getAtomCount();
        int nb = this.getRootG().getAtomCount();
        if (na != 0) {
            if (na == 1 && nb == 0) {
                sb.append(this.getRootG().getAtom(0).getSymbol());
                sb.append(",");
            } else {
                sb.append(na);
                sb.append("a,");
            }
            empty = false;
        }
        if (nb != 0) {
            sb.append(nb);
            sb.append("b,");
            empty = false;
        }
        if ((nr = this.getRgroupCount()) <= 3) {
            for (int i = 0; i < nr; ++i) {
                int id = this.getRgroupId(i);
                sb.append('R');
                sb.append(id);
                sb.append(',');
                empty = false;
            }
        } else {
            sb.append(nr);
            sb.append("R,");
            empty = false;
        }
        if (!empty) {
            sb.setLength(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void clonelesscopy(MoleculeGraph graph) {
        throw new RuntimeException("SelectionRgMolecule.clonelesscopy not implemented");
    }

    @Override
    public void clonecopy(MoleculeGraph g) {
        super.clonecopy(g);
        if (g instanceof SelectionRgMolecule) {
            SelectionRgMolecule rmol = (SelectionRgMolecule)g;
            this.root.clonecopy(rmol.root);
            RgroupContainer rgc = this.rgroupContainer;
            if (rgc != null && rgc.getRgroupCount() != 0) {
                RgroupContainer rmolrgc = rmol.rgroupContainer;
                if (rmolrgc != null) {
                    rmolrgc.clear();
                } else {
                    rmol.rgroupContainer = rmolrgc = new RgroupContainer();
                }
                for (int i = 0; i < rgc.getRgroupCount(); ++i) {
                    List<MoleculeGraph> v = rgc.rgroups.get(i);
                    ArrayList<SelectionMolecule> gv = new ArrayList<SelectionMolecule>();
                    rmolrgc.rgroups.add(gv);
                    rmolrgc.rlogic.add(rgc.rlogic.get(i));
                    rmolrgc.rranges.add(rgc.getRlogicRange(i));
                    for (int j = 0; j < v.size(); ++j) {
                        SelectionMolecule m = (SelectionMolecule)v.get(j);
                        SelectionMolecule gm = new SelectionMolecule();
                        m.clonecopy(gm);
                        gm.superGraph = rmol.superGraph;
                        gm.parentGraph = rmol;
                        gv.add(gm);
                    }
                }
            } else {
                rmol.rgroupContainer = null;
            }
        } else {
            throw new RuntimeException("SelectionRgMolecule.clonecopy to " + g.getClass() + " not implemented");
        }
    }

    @Override
    public Object clone() {
        SelectionRgMolecule g = new SelectionRgMolecule();
        this.clonecopy(g);
        return g;
    }
}

