/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.struc.Gearch;
import chemaxon.struc.Incomplecule;

public interface Smolecule
extends Incomplecule {
    public static final int A_BOND = 1;
    public static final int A_CHARGE = 2;
    public static final int A_RADICAL = 4;
    public static final int A_HYBRIDIZATION = 8;
    public static final int A_MASSNO = 16;
    public static final int A_IMPLH = 32;
    public static final int A_EXPLH = 64;
    public static final int A_VALENCE = 128;
    public static final int A_ATOMMAP = 256;
    public static final int A_RGROUP = 512;
    public static final int A_PARITY = 1024;
    public static final int A_CHIRALITY = 2048;
    public static final int A_ASTEREO = 3072;
    public static final int A_ALL = 4095;
    public static final int RGROUP_MAX = Short.MAX_VALUE;

    public int getArrayFlags();

    public int getAtomType(int var1);

    public int getCharge(int var1);

    public int getRadical(int var1);

    public int getMassno(int var1);

    public int getHybridizationState(int var1);

    public int getQPropAsInt(int var1, String var2);

    public boolean inAtomList(int var1, int var2);

    public int getImplicitHcount(int var1);

    public int getImplicitHcount();

    public int getExplicitHcount(int var1);

    public int getHcount(int var1);

    public int getValence(int var1);

    public int getAtomMap(int var1);

    public int getRgroupId(int var1);

    public int getParity(int var1);

    public int getChirality(int var1);

    public int getAtomStereo(int var1);

    public int getNeighborCount(int var1);

    public int getNeighbor(int var1, int var2);

    public boolean areNeighbors(int var1, int var2);

    public int getAtom1(int var1);

    public int getAtom2(int var1);

    public Gearch gearch();

    public int getBondIndex(int var1, int var2);

    public int getBondType(int var1);

    public int getBondType(int var1, int var2);

    public int getBondFlags(int var1);
}

