/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.struc.Gearch;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.Smolecule;
import chemaxon.struc.WSmolecule;
import chemaxon.struc.gearch.SmoleculeGearch;
import java.io.Serializable;
import java.util.Arrays;

public class StaticMolecule
implements WSmolecule,
Serializable {
    public static final int MAX_ATOM_COUNT = 255;
    public static final byte BOND_SINGLE = 1;
    public static final byte BOND_DOUBLE = 2;
    public static final byte BOND_TRIPLE = 3;
    public static final byte BOND_NORMALIZED = 4;
    public static final String[] QUERY_PROPERTY_NAME = new String[]{"v", "H"};
    private boolean ringPerception = false;
    private String name;
    private int arrayFlags;
    private int atomCount;
    private short[] connectionTable;
    private byte[] neighborCount;
    private short[][] nodeEdgeList;
    private int bondCount;
    private short[] atomType;
    private short[] bondAtom1;
    private short[] bondAtom2;
    private int[] bondFlags;
    private int[] extendedAtomType;
    private byte[][] atomLists;
    private byte[] hybridization;
    private byte[] atomStereo;
    private byte[] implicitHcount;
    private byte[] explicitHcount;
    private byte[] valence;
    private byte[][] queryProperty;
    private byte[] radical;
    private byte[] charge;
    private byte[] massno;
    private short[] atomMap;
    private short[] rgroupId;
    private String[] sgroupId;
    private SmoleculeGearch gearch;
    private static ThreadLocal bc = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new BondClassifier();
        }
    };

    private static BondClassifier getBondClassifier() {
        return (BondClassifier)bc.get();
    }

    public StaticMolecule() {
        this.allocate(0, 0, 4095);
    }

    public StaticMolecule(int atomCount, int bondCount, int arrays) {
        this.allocate(atomCount, bondCount, arrays);
    }

    public StaticMolecule(Molecule m) {
        this.name = m.getName();
        int mcaCpount = this.multicenterAtomCount(m);
        this.allocate(m.getAtomCount() - mcaCpount, m.getBondCount(), 4095);
        this.init(m);
    }

    public StaticMolecule(Molecule m, boolean perceiveRings) {
        this.name = m.getName();
        int mcaCpount = this.multicenterAtomCount(m);
        this.allocate(m.getAtomCount() - mcaCpount, m.getBondCount(), 4095);
        this.ringPerception = perceiveRings;
        this.init(m);
    }

    @Override
    public WSmolecule newInstance(int na, int nb, int arrays) {
        return new StaticMolecule(na, nb, arrays);
    }

    @Override
    public void addAtom(Smolecule smol, int k) {
        int v;
        int rgid;
        int amap;
        int explh;
        int implh;
        int val;
        int i = this.atomCount;
        this.addAtom(smol.getAtomType(k));
        int aflags = this.arrayFlags;
        if ((aflags & 2) != 0 && (val = smol.getCharge(k)) != 0) {
            if (this.charge == null) {
                this.charge = new byte[this.atomType.length];
            }
            this.charge[i] = (byte)val;
        }
        if ((aflags & 4) != 0 && (val = smol.getRadical(k)) != 0) {
            if (this.radical == null) {
                this.radical = new byte[this.atomType.length];
            }
            this.radical[i] = (byte)val;
        }
        if ((aflags & 8) != 0 && (val = smol.getHybridizationState(k)) != 0) {
            if (this.hybridization == null) {
                this.hybridization = new byte[this.atomType.length];
            }
            this.hybridization[i] = (byte)val;
        }
        if ((aflags & 0x10) != 0 && (val = smol.getMassno(k)) != 0) {
            if (this.massno == null) {
                this.massno = new byte[this.atomType.length];
            }
            this.massno[i] = (byte)val;
        }
        if ((aflags & 0x20) != 0 && (implh = smol.getImplicitHcount(k)) != 0) {
            if (this.implicitHcount == null) {
                this.implicitHcount = new byte[this.atomType.length];
            }
            this.implicitHcount[i] = (byte)implh;
        }
        if ((aflags & 0x40) != 0 && (explh = smol.getExplicitHcount(k)) != 0) {
            if (this.explicitHcount == null) {
                this.explicitHcount = new byte[this.atomType.length];
            }
            this.explicitHcount[i] = (byte)explh;
        }
        if ((aflags & 0x100) != 0 && (amap = smol.getAtomMap(k)) != 0) {
            if (this.atomMap == null) {
                this.atomMap = new short[this.atomType.length];
            }
            this.atomMap[i] = (short)amap;
        }
        if ((aflags & 0x80) != 0 && (val = smol.getValence(k)) != 0) {
            if (this.valence == null) {
                this.valence = new byte[this.atomType.length];
            }
            this.valence[i] = (byte)val;
        }
        if ((aflags & 0x200) != 0 && (rgid = smol.getRgroupId(k)) != 0) {
            if (this.rgroupId == null) {
                this.rgroupId = new short[this.atomType.length];
            }
            this.rgroupId[i] = (short)rgid;
        }
        if ((aflags & 0x400) != 0) {
            v = smol.getParity(k);
            if (v != 0) {
                if (this.atomStereo == null) {
                    this.atomStereo = new byte[this.atomType.length];
                }
                this.atomStereo[i] = (byte)v;
            } else if (this.atomStereo != null) {
                this.atomStereo[i] = 0;
            }
        }
        if ((aflags & 0x800) != 0) {
            v = smol.getChirality(k);
            if (v != 0) {
                if (this.atomStereo == null) {
                    this.atomStereo = new byte[this.atomType.length];
                }
                int n = i;
                this.atomStereo[n] = (byte)(this.atomStereo[n] | (byte)v);
            } else if (this.atomStereo != null) {
                int n = i;
                this.atomStereo[n] = (byte)(this.atomStereo[n] & 0xFFFFFFE7);
            }
        }
    }

    @Override
    public void addAtom(int atomicNumber) {
        this.ensureCapacity(this.atomCount + 1, this.bondCount);
        this.atomType[this.atomCount++] = (short)atomicNumber;
        this.resetCC();
    }

    @Override
    public void removeAtom(int i) {
        int a1;
        int j;
        int na = this.atomCount;
        for (j = this.getNeighborCount(i) - 1; j >= 0; --j) {
            int k = this.getNeighbor(i, j);
            short bi = this.connectionTable[this.index(i, k)];
            this.removeBond(bi - 1);
        }
        for (a1 = 1; a1 < na; ++a1) {
            if (a1 == i) continue;
            int aa1 = a1 < i ? a1 : a1 - 1;
            for (int a2 = 0; a2 < a1; ++a2) {
                int aa2;
                int kk;
                int k;
                if (a2 == i || (k = a1 * (a1 - 1) / 2 + a2) == (kk = aa1 * (aa1 - 1) / 2 + (aa2 = a2 < i ? a2 : a2 - 1))) continue;
                this.connectionTable[kk] = this.connectionTable[k];
                this.connectionTable[k] = 0;
            }
        }
        StaticMolecule.remove(this.atomType, i, na, 0);
        StaticMolecule.remove(this.neighborCount, i, na, 0);
        StaticMolecule.remove(this.nodeEdgeList, i, na);
        for (a1 = 0; a1 < na - 1; ++a1) {
            int n = this.neighborCount[a1];
            short[] neighbors = this.nodeEdgeList[a1];
            for (int j2 = 0; j2 < n; ++j2) {
                if (neighbors[j2] <= i) continue;
                int n2 = j2;
                neighbors[n2] = (short)(neighbors[n2] - 1);
            }
        }
        if (this.bondAtom1 != null) {
            for (j = 0; j < this.bondCount; ++j) {
                if (this.bondAtom1[j] > i) {
                    int n = j;
                    this.bondAtom1[n] = (short)(this.bondAtom1[n] - 1);
                }
                if (this.bondAtom2[j] <= i) continue;
                int n = j;
                this.bondAtom2[n] = (short)(this.bondAtom2[n] - 1);
            }
        }
        StaticMolecule.remove(this.extendedAtomType, i, na, 0);
        StaticMolecule.remove(this.atomLists, i, na);
        StaticMolecule.remove(this.hybridization, i, na, 0);
        StaticMolecule.remove(this.implicitHcount, i, na, 0);
        StaticMolecule.remove(this.explicitHcount, i, na, 0);
        StaticMolecule.remove(this.valence, i, na, 0);
        if (this.queryProperty != null) {
            for (j = 0; j < this.queryProperty.length; ++j) {
                StaticMolecule.remove(this.queryProperty[j], i, na, 0);
            }
        }
        StaticMolecule.remove(this.radical, i, na, 0);
        StaticMolecule.remove(this.charge, i, na, 0);
        StaticMolecule.remove(this.massno, i, na, 0);
        StaticMolecule.remove(this.atomMap, i, na, 0);
        StaticMolecule.remove(this.rgroupId, i, na, 0);
        StaticMolecule.remove(this.atomStereo, i, na, 0);
        StaticMolecule.remove(this.sgroupId, i, na);
        --this.atomCount;
        this.resetCC();
    }

    @Override
    public void addBond(int atom1, int atom2, int type) {
        short a1 = (short)atom1;
        short a2 = (short)atom2;
        this.ensureCapacity(this.atomCount, this.bondCount + 1);
        this.bondAtom1[this.bondCount] = a1;
        this.bondAtom2[this.bondCount] = a2;
        this.connectionTable[this.index((int)a1, (int)a2)] = (short)(this.bondCount + 1);
        this.addNeighbour(a1, a2);
        this.addNeighbour(a2, a1);
        this.bondFlags[this.bondCount] = type;
        if (this.explicitHcount != null) {
            if (this.atomType[atom1] == 1) {
                int n = atom2;
                this.explicitHcount[n] = (byte)(this.explicitHcount[n] + 1);
            }
            if (this.atomType[atom2] == 1) {
                int n = atom1;
                this.explicitHcount[n] = (byte)(this.explicitHcount[n] + 1);
            }
        }
        ++this.bondCount;
        this.resetCC();
    }

    @Override
    public void removeBond(int i) {
        int nb = this.bondCount;
        short a1 = this.bondAtom1[i];
        short a2 = this.bondAtom2[i];
        for (int j = i + 1; j < nb; ++j) {
            int k;
            short aa1 = this.bondAtom1[j];
            short aa2 = this.bondAtom2[j];
            int n = k = this.index(aa1, aa2);
            this.connectionTable[n] = (short)(this.connectionTable[n] - 1);
        }
        StaticMolecule.remove(this.bondAtom1, i, nb, 0);
        StaticMolecule.remove(this.bondAtom2, i, nb, 0);
        this.connectionTable[this.index((int)a1, (int)a2)] = 0;
        StaticMolecule.remove(this.bondFlags, i, nb, 0);
        this.removeNeighbor(a1, a2);
        this.removeNeighbor(a2, a1);
        if (this.explicitHcount != null) {
            if (this.atomType[a1] == 1) {
                short s = a2;
                this.explicitHcount[s] = (byte)(this.explicitHcount[s] - 1);
            }
            if (this.atomType[a2] == 1) {
                short s = a1;
                this.explicitHcount[s] = (byte)(this.explicitHcount[s] - 1);
            }
        }
        --this.bondCount;
        this.resetCC();
    }

    private void addNeighbour(short atom1, short atom2) {
        byte n = this.neighborCount[atom1];
        short[] old = this.nodeEdgeList[atom1];
        if (n == this.nodeEdgeList[atom1].length) {
            this.nodeEdgeList[atom1] = new short[n + 1];
            System.arraycopy(old, 0, this.nodeEdgeList[atom1], 0, n);
        }
        this.nodeEdgeList[atom1][n] = atom2;
        short s = atom1;
        this.neighborCount[s] = (byte)(this.neighborCount[s] + 1);
    }

    private void removeNeighbor(int a1, int a2) {
        int n = this.neighborCount[a1];
        short[] list = this.nodeEdgeList[a1];
        int k = 0;
        for (int j = 0; j < n; ++j) {
            short a = list[j];
            if (a == a2) continue;
            list[k++] = a;
        }
        this.neighborCount[a1] = (byte)k;
    }

    public Molecule toMolecule() {
        Molecule m = new Molecule(null, this.atomCount, this.bondCount);
        MolAtom[] ma = this.addAtoms(m);
        if (this.atomMap != null) {
            for (int i = 0; i < this.atomCount; ++i) {
                if (this.atomMap[i] <= 0) continue;
                ma[i].setAtomMap(this.atomMap[i]);
            }
        }
        this.addBonds(m, ma);
        return m;
    }

    public Molecule toMolecule(int[] rgAtoms) {
        if (rgAtoms == null) {
            return this.toMolecule();
        }
        Molecule m = new Molecule(null, this.atomCount + rgAtoms.length, this.bondCount);
        MolAtom[] ma = this.addAtoms(m);
        this.addBonds(m, ma);
        for (int i = 0; i < rgAtoms.length; ++i) {
            MolAtom a = new MolAtom(134);
            a.setRgroup(i + 1);
            m.add(a);
            m.add(new MolBond(ma[rgAtoms[i]], a, 1));
        }
        return m;
    }

    public Molecule toColoredMolecule(int[] bondIndexes) {
        Molecule m = new Molecule(null, this.atomCount, this.bondCount);
        MolAtom[] ma = this.addAtoms(m);
        for (int bond = 0; bond < this.bondCount; ++bond) {
            short i = this.bondAtom1[bond];
            short j = this.bondAtom2[bond];
            MolBond b = new MolBond(ma[i], ma[j], this.getBondFlags(bond));
            m.add(b);
            if (!this.bondInArray(i, j, bondIndexes)) continue;
            b.setSetSeq(2);
            b.getAtom1().setSetSeq(2);
            b.getAtom2().setSetSeq(2);
        }
        return m;
    }

    private MolAtom[] addAtoms(Molecule m) {
        MolAtom[] ma = new MolAtom[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            ma[i] = new MolAtom(this.getAtomType(i));
            m.add(ma[i]);
        }
        return ma;
    }

    private void addBonds(Molecule m, MolAtom[] ma) {
        for (int bond = 0; bond < this.bondCount; ++bond) {
            short i = this.bondAtom1[bond];
            short j = this.bondAtom2[bond];
            m.add(new MolBond(ma[i], ma[j], this.getBondFlags(bond)));
        }
    }

    private boolean bondInArray(int atom1, int atom2, int[] bondIndexes) {
        for (int i = 0; i < bondIndexes.length; ++i) {
            int ba1 = this.getAtom1(bondIndexes[i]);
            int ba2 = this.getAtom2(bondIndexes[i]);
            if ((ba1 != atom1 || ba2 != atom2) && (ba1 != atom2 || ba2 != atom1)) continue;
            return true;
        }
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAtomType(int atom, byte type) {
        this.atomType[atom] = type;
    }

    @Override
    public final void setAtomMap(int atom, int map) {
        this.atomMap = this.setProperty(this.atomMap, atom, map);
    }

    public void setPerceiveRingBonds(boolean ringPerception) {
        this.ringPerception = ringPerception;
    }

    public void generateExtendedAtomType(boolean withHydrogens) {
        this.extendedAtomType = new int[this.atomType.length];
        for (int i = 0; i < this.extendedAtomType.length; ++i) {
            this.extendedAtomType[i] = this.extendedAtomType(i, withHydrogens);
        }
    }

    private int extendedAtomType(int atomIndex, boolean withHydrogens) {
        int CCount = 0;
        int NCount = 0;
        int OCount = 0;
        int Hcount = 0;
        int otherCount = 0;
        int neighCount = this.neighborCount[atomIndex];
        short[] neighs = this.nodeEdgeList[atomIndex];
        block6: for (int i = 0; i < neighCount; ++i) {
            switch (this.atomType[neighs[i]]) {
                case 1: {
                    if (!withHydrogens) continue block6;
                    ++Hcount;
                    continue block6;
                }
                case 6: {
                    ++CCount;
                    continue block6;
                }
                case 7: {
                    ++NCount;
                    continue block6;
                }
                case 8: {
                    ++OCount;
                    continue block6;
                }
                default: {
                    ++otherCount;
                }
            }
        }
        int eta = this.atomType[atomIndex];
        eta = (eta << 8) + CCount;
        eta = (eta << 2) + NCount;
        eta = (eta << 2) + OCount;
        eta = (eta << 2) + Hcount;
        eta = (eta << 2) + otherCount;
        return eta;
    }

    public void clearAtomMap(int atomIndex) {
        this.atomMap[atomIndex] = 0;
    }

    @Override
    public final int getAtomMap(int atom) {
        return this.atomMap == null ? 0 : this.atomMap[atom];
    }

    @Override
    public void reset(int aflags) {
        int flagsToClear = this.arrayFlags & ~aflags;
        this.name = null;
        Arrays.fill(this.neighborCount, 0, this.atomCount, (byte)0);
        for (int i = 0; i < this.bondCount; ++i) {
            short a1 = this.bondAtom1[i];
            short a2 = this.bondAtom2[i];
            this.connectionTable[this.index((int)a1, (int)a2)] = 0;
        }
        if ((flagsToClear & 2) != 0) {
            this.charge = this.clearProperty(this.charge);
        }
        if ((flagsToClear & 4) != 0) {
            this.radical = this.clearProperty(this.radical);
        }
        if ((flagsToClear & 8) != 0) {
            this.hybridization = this.clearProperty(this.hybridization);
        }
        if ((flagsToClear & 0x10) != 0) {
            this.massno = this.clearProperty(this.massno);
        }
        if ((flagsToClear & 0x20) != 0) {
            this.implicitHcount = this.clearProperty(this.implicitHcount);
        }
        if ((flagsToClear & 0x40) != 0) {
            this.explicitHcount = this.clearProperty(this.explicitHcount);
        }
        if ((flagsToClear & 0x100) != 0) {
            this.atomMap = this.clearProperty(this.atomMap);
        }
        if ((flagsToClear & 0x200) != 0) {
            this.rgroupId = this.clearProperty(this.rgroupId);
        }
        if ((flagsToClear & 0xC00) != 0) {
            this.atomStereo = this.clearProperty(this.atomStereo);
        }
        this.atomCount = 0;
        this.bondCount = 0;
        this.arrayFlags = aflags;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getAtomCount() {
        return this.atomCount;
    }

    @Override
    public final int getBondCount() {
        return this.bondCount;
    }

    @Override
    public final int getNeighborCount(int atom) {
        return this.neighborCount[atom];
    }

    @Override
    public final int getNeighbor(int atom, int neighborIndex) {
        return this.nodeEdgeList[atom][neighborIndex];
    }

    @Override
    public final boolean areNeighbors(int atom1, int atom2) {
        return this.connectionTable[this.index(atom1, atom2)] != 0;
    }

    @Override
    public final int getAtom1(int bondIndex) {
        return this.bondAtom1[bondIndex];
    }

    @Override
    public final int getAtom2(int bondIndex) {
        return this.bondAtom2[bondIndex];
    }

    @Override
    public int getArrayFlags() {
        return this.arrayFlags;
    }

    @Override
    public final int getAtomType(int atom) {
        return this.atomType[atom];
    }

    @Override
    public final Gearch gearch() {
        if (this.gearch == null) {
            this.regenGearch();
        }
        return this.gearch;
    }

    public final int getExtendedAtomType(int atomIndex) {
        return this.extendedAtomType[atomIndex];
    }

    public boolean matchingExtendedAtomType(int atomIndex, int extendedTypeOfOtherAtom) {
        int eta1 = this.extendedAtomType[atomIndex];
        int eta2 = extendedTypeOfOtherAtom;
        return eta1 == eta2;
    }

    @Override
    public final int getBondType(int i) {
        return this.bondFlags[i] & 0xF;
    }

    @Override
    public final int getBondFlags(int i) {
        return this.bondFlags[i];
    }

    @Override
    public final boolean inAtomList(int atom, int atno) {
        byte[] l = this.atomLists[atom];
        for (int i = 0; i < l.length; ++i) {
            if (l[i] != atno) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void setImplicitHcount(int atom, int h) {
        if (this.implicitHcount == null) {
            this.implicitHcount = new byte[this.atomType.length];
        }
        this.implicitHcount[atom] = (byte)h;
    }

    @Override
    public final int getImplicitHcount(int atom) {
        return this.implicitHcount != null ? this.implicitHcount[atom] : 0;
    }

    @Override
    public final int getImplicitHcount() {
        int ihc = 0;
        if (this.implicitHcount != null) {
            for (int a = 0; a < this.implicitHcount.length; ++a) {
                ihc += this.implicitHcount[a];
            }
        }
        return ihc;
    }

    @Override
    public final int getExplicitHcount(int atom) {
        return this.explicitHcount != null ? this.explicitHcount[atom] : 0;
    }

    @Override
    public final int getHcount(int atom) {
        return this.getExplicitHcount(atom) + this.getImplicitHcount(atom);
    }

    @Override
    public final int getValence(int atom) {
        return this.valence != null ? this.valence[atom] : 0;
    }

    @Override
    public final void setValence(int atom, int v) {
        this.valence = this.setProperty(this.valence, atom, v);
    }

    @Override
    public final int getHybridizationState(int atom) {
        return this.hybridization != null ? this.hybridization[atom] : 0;
    }

    @Override
    public void setHybridizationState(int atom, int hs) {
        this.hybridization[atom] = (byte)hs;
    }

    @Override
    public final int getCharge(int atom) {
        return this.charge == null ? 0 : this.charge[atom];
    }

    @Override
    public final void setCharge(int atom, int chg) {
        this.charge = this.setProperty(this.charge, atom, chg);
    }

    @Override
    public final int getMassno(int atom) {
        return this.massno == null ? 0 : this.massno[atom];
    }

    @Override
    public final void setMassno(int atom, int m) {
        this.massno = this.setProperty(this.massno, atom, m);
    }

    @Override
    public final int getRadical(int atom) {
        return this.radical == null ? 0 : this.radical[atom];
    }

    @Override
    public final void setRadical(int atom, int rad) {
        this.radical = this.setProperty(this.radical, atom, rad);
    }

    @Override
    public final int getBondIndex(int atom1, int atom2) {
        if (atom1 == atom2) {
            return -1;
        }
        return this.connectionTable[this.index(atom1, atom2)] - 1;
    }

    @Override
    public final int getBondType(int atom1, int atom2) {
        if (atom1 == atom2) {
            throw new IllegalArgumentException("no a" + atom1 + "-a" + atom2 + " bond");
        }
        short bi = this.connectionTable[this.index(atom1, atom2)];
        if (bi != 0) {
            return this.bondFlags[bi - 1] & 0xF;
        }
        throw new IllegalArgumentException("no a" + atom1 + "-a" + atom2 + " bond");
    }

    public final boolean isRingBond(int atom1, int atom2) {
        short bi = this.connectionTable[this.index(atom1, atom2)];
        return bi != 0 && (this.bondFlags[bi - 1] & 0x400) != 0;
    }

    @Override
    public int getQPropAsInt(int k, String name) {
        return this.queryProperty != null ? this.queryProperty[this.queryPropertyIndex(name)][k] : 0;
    }

    @Override
    public final int getRgroupId(int atom) {
        return this.rgroupId == null ? 0 : this.rgroupId[atom];
    }

    @Override
    public final void setRgroupId(int atom, int rgid) {
        this.rgroupId = this.setProperty(this.rgroupId, atom, rgid + 1);
    }

    @Override
    public final int getParity(int atom) {
        return this.atomStereo == null ? 0 : this.atomStereo[atom] & 7;
    }

    @Override
    public final int getChirality(int atom) {
        return this.atomStereo == null ? 0 : this.atomStereo[atom] & 0x18;
    }

    @Override
    public final int getAtomStereo(int atom) {
        return this.atomStereo == null ? 0 : this.atomStereo[atom];
    }

    @Override
    public void setAtomStereo(int atom, int stereo) {
        this.atomStereo = this.setProperty(this.atomStereo, atom, stereo);
    }

    public String getSGroupId(int atom) {
        return this.sgroupId == null ? null : this.sgroupId[atom];
    }

    private int queryPropertyIndex(String qpName) {
        for (int i = 0; i < QUERY_PROPERTY_NAME.length; ++i) {
            if (!QUERY_PROPERTY_NAME[i].equals(qpName)) continue;
            return i;
        }
        return -1;
    }

    private void init(Molecule m) {
        int aflags = this.arrayFlags;
        this.atomCount = 0;
        this.bondCount = 0;
        if ((aflags & 8) != 0) {
            m.calcHybridization();
        }
        if (this.ringPerception) {
            StaticMolecule.getBondClassifier().classify(m);
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            int v;
            MolAtom a = m.getAtom(i);
            int atno = a.getAtno();
            short ai = (short)this.atomCount;
            if (atno == 137) continue;
            this.addAtom(atno);
            if (atno == 128 || atno == 129) {
                this.atomLists[ai] = new byte[a.getList().length];
                for (int j = 0; j < a.getList().length; ++j) {
                    this.atomLists[ai][j] = (byte)a.getList()[j];
                }
            }
            if (atno == 134 || atno == 135) {
                this.copyRSG(m, ai);
            }
            if ((aflags & 0x100) != 0 && a.getAtomMap() > 0) {
                this.atomMap = this.setProperty(this.atomMap, (int)ai, a.getAtomMap());
            }
            if ((aflags & 8) != 0) {
                this.hybridization[ai] = (byte)a.getHybridizationState();
            }
            if ((aflags & 0x20) != 0) {
                this.implicitHcount[ai] = (byte)a.getImplicitHcount();
            }
            if ((aflags & 0x40) != 0) {
                this.explicitHcount[ai] = (byte)a.getExplicitHcount();
            }
            if ((aflags & 0x10) != 0) {
                this.massno = this.setProperty(this.massno, (int)ai, a.getMassno());
            }
            if ((aflags & 2) != 0) {
                this.charge = this.setProperty(this.charge, (int)ai, a.getCharge());
            }
            if ((aflags & 4) != 0) {
                this.radical = this.setProperty(this.radical, (int)ai, a.getRadical());
            }
            if ((aflags & 0x80) != 0) {
                this.valence = this.setProperty(this.valence, (int)ai, a.getValence());
            }
            if ((aflags & 0x400) != 0 && (v = m.getParity(i)) != 0) {
                if (this.atomStereo == null) {
                    this.atomStereo = new byte[this.atomType.length];
                }
                this.atomStereo[i] = (byte)v;
            }
            if ((aflags & 0x800) != 0 && (v = m.getChirality(i)) != 0) {
                if (this.atomStereo == null) {
                    this.atomStereo = new byte[this.atomType.length];
                }
                int n = i;
                this.atomStereo[n] = (byte)(this.atomStereo[n] | (byte)v);
            }
            this.queryProperty[this.queryPropertyIndex((String)"H")][ai] = (byte)a.getQPropAsInt("H");
            this.queryProperty[this.queryPropertyIndex((String)"v")][ai] = (byte)a.getValenceProp();
            if ((aflags & 1) == 0) continue;
            int nb = a.getBondCount();
            this.neighborCount[ai] = (byte)nb;
            this.nodeEdgeList[ai] = new short[nb];
            for (int j = 0; j < nb; ++j) {
                short aj;
                MolBond b = a.getBond(j);
                MolAtom a2 = b.getOtherAtom(a);
                if (a2.getAtno() == 137) continue;
                this.nodeEdgeList[ai][j] = aj = (short)m.indexOf(a2);
                if (ai <= aj) continue;
                int f = b.getFlags();
                if (this.ringPerception && StaticMolecule.getBondClassifier().isRingBond(aj, ai)) {
                    f |= 0x400;
                }
                this.connectionTable[this.index((int)aj, (int)ai)] = (short)(this.bondCount + 1);
                this.ensureCapacity(this.atomCount, this.bondCount + 1);
                this.bondAtom1[this.bondCount] = aj;
                this.bondAtom2[this.bondCount] = ai;
                this.bondFlags[this.bondCount] = f;
                ++this.bondCount;
            }
        }
        this.resetCC();
    }

    private void resetCC() {
        this.gearch = null;
    }

    private byte[] setProperty(byte[] propArray, int atomIndex, int propValue) {
        if (propValue == 0) {
            if (propArray != null) {
                propArray[atomIndex] = 0;
            }
            return propArray;
        }
        if (propArray == null) {
            propArray = new byte[this.nodeEdgeList.length];
        }
        propArray[atomIndex] = (byte)propValue;
        return propArray;
    }

    private short[] setProperty(short[] propArray, int atomIndex, int propValue) {
        if (propValue == 0) {
            if (propArray != null) {
                propArray[atomIndex] = 0;
            }
            return propArray;
        }
        if (propArray == null) {
            propArray = new short[this.nodeEdgeList.length];
        }
        propArray[atomIndex] = (short)propValue;
        return propArray;
    }

    private byte[] clearProperty(byte[] arr) {
        if (arr != null) {
            Arrays.fill(arr, 0, this.atomCount, (byte)0);
            return arr;
        }
        return new byte[this.atomType.length];
    }

    private short[] clearProperty(short[] arr) {
        if (arr != null) {
            Arrays.fill(arr, 0, this.atomCount, (short)0);
            return arr;
        }
        return new short[this.atomType.length];
    }

    private void copyRSG(Molecule m, int atomIndex) {
        MolAtom a = m.getAtom(atomIndex);
        int at = a.getAtno();
        if (at == 134) {
            if (this.rgroupId == null) {
                this.rgroupId = new short[m.getAtomCount()];
            }
            this.rgroupId[atomIndex] = (short)a.getRgroup();
        } else if (at == 135) {
            if (this.sgroupId == null) {
                this.sgroupId = new String[m.getAtomCount()];
            }
            this.sgroupId[atomIndex] = a.getSymbol();
        }
    }

    private int index(int i, int j) {
        return i > j ? i * (i - 1) / 2 + j : j * (j - 1) / 2 + i;
    }

    private int multicenterAtomCount(Molecule m) {
        int mcac = 0;
        for (int i = 0; i < m.getAtomCount(); ++i) {
            mcac += m.getAtom(i).getAtno() == 137 ? 1 : 0;
        }
        return mcac;
    }

    private void allocate(int capacity, int bcapacity, int aflags) {
        this.arrayFlags = aflags;
        this.atomCount = 0;
        this.bondCount = 0;
        this.connectionTable = new short[capacity * (capacity - 1) / 2];
        this.neighborCount = new byte[capacity];
        this.nodeEdgeList = new short[capacity][4];
        this.atomType = new short[capacity];
        this.atomLists = new byte[capacity][];
        this.implicitHcount = (aflags & 0x20) != 0 ? new byte[capacity] : null;
        this.explicitHcount = (aflags & 0x40) != 0 ? new byte[capacity] : null;
        this.hybridization = (aflags & 8) != 0 ? new byte[capacity] : null;
        this.valence = (aflags & 0x80) != 0 ? new byte[capacity] : null;
        this.queryProperty = new byte[QUERY_PROPERTY_NAME.length][capacity];
        if ((aflags & 1) != 0) {
            this.bondAtom1 = new short[bcapacity];
            this.bondAtom2 = new short[bcapacity];
            this.bondFlags = new int[bcapacity];
        } else {
            this.bondAtom1 = null;
            this.bondAtom2 = null;
            this.bondFlags = null;
        }
    }

    private void ensureCapacity(int na, int nb) {
        int n2;
        if (na > this.atomType.length) {
            n2 = 2 * na;
            this.connectionTable = StaticMolecule.grow(this.connectionTable, n2 * (n2 - 1) / 2);
            this.neighborCount = StaticMolecule.grow(this.neighborCount, n2);
            this.nodeEdgeList = StaticMolecule.grow(this.nodeEdgeList, n2, 4);
            this.atomType = StaticMolecule.grow(this.atomType, n2);
            this.atomLists = StaticMolecule.grow(this.atomLists, n2);
            this.implicitHcount = StaticMolecule.grow(this.implicitHcount, n2);
            this.explicitHcount = StaticMolecule.grow(this.explicitHcount, n2);
            this.hybridization = StaticMolecule.grow(this.hybridization, n2);
            this.valence = StaticMolecule.grow(this.valence, n2);
            this.queryProperty = StaticMolecule.grow2(this.queryProperty, n2);
            this.extendedAtomType = StaticMolecule.grow(this.extendedAtomType, n2);
            this.radical = StaticMolecule.grow(this.radical, n2);
            this.charge = StaticMolecule.grow(this.charge, n2);
            this.massno = StaticMolecule.grow(this.massno, n2);
            this.atomMap = StaticMolecule.grow(this.atomMap, n2);
            this.rgroupId = StaticMolecule.grow(this.rgroupId, n2);
            this.atomStereo = StaticMolecule.grow(this.atomStereo, n2);
            this.sgroupId = StaticMolecule.grow(this.sgroupId, n2);
        }
        if (this.bondFlags != null && nb > this.bondFlags.length) {
            n2 = 2 * nb;
            this.bondAtom1 = StaticMolecule.grow(this.bondAtom1, n2);
            this.bondAtom2 = StaticMolecule.grow(this.bondAtom2, n2);
            this.bondFlags = StaticMolecule.grow(this.bondFlags, n2);
        }
    }

    @Override
    public MPropertyContainer properties() {
        return null;
    }

    public void dump() {
        int j;
        int i;
        System.out.println("name = " + this.name);
        int ac = this.atomCount;
        for (i = 0; i < ac; ++i) {
            for (j = 0; j < ac; ++j) {
                if (i == j) {
                    System.out.print("0 ");
                    continue;
                }
                System.out.print(this.connectionTable[this.index(i, j)] + " ");
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("bondCount = " + this.bondCount);
        for (i = 0; i < ac; ++i) {
            for (j = 0; j < this.neighborCount[i]; ++j) {
                System.out.print(this.nodeEdgeList[i][j] + ", ");
            }
            System.out.println();
        }
        System.out.println();
        for (i = 0; i < ac; ++i) {
            System.out.print(this.atomType[i] + ", ");
        }
    }

    private static int[] grow(int[] arr, int newcapacity) {
        if (arr != null) {
            int[] newarr = new int[newcapacity];
            System.arraycopy(arr, 0, newarr, 0, arr.length);
            return newarr;
        }
        return null;
    }

    private static short[] grow(short[] arr, int newcapacity) {
        if (arr != null) {
            short[] newarr = new short[newcapacity];
            System.arraycopy(arr, 0, newarr, 0, arr.length);
            return newarr;
        }
        return null;
    }

    private static byte[] grow(byte[] arr, int newcapacity) {
        if (arr != null) {
            byte[] newarr = new byte[newcapacity];
            System.arraycopy(arr, 0, newarr, 0, arr.length);
            return newarr;
        }
        return null;
    }

    private static String[] grow(String[] arr, int newcapacity) {
        if (arr != null) {
            String[] newarr = new String[newcapacity];
            System.arraycopy(arr, 0, newarr, 0, arr.length);
            return newarr;
        }
        return null;
    }

    private static short[][] grow(short[][] arr, int newcapacity, int dim) {
        if (arr != null) {
            int i;
            short[][] newarr = new short[newcapacity][];
            for (i = 0; i < arr.length; ++i) {
                if (arr[i] == null) continue;
                int n = arr[i].length;
                newarr[i] = new short[n];
                System.arraycopy(arr[i], 0, newarr[i], 0, n);
            }
            if (dim >= 0) {
                for (i = arr.length; i < newcapacity; ++i) {
                    newarr[i] = new short[dim];
                }
            }
            return newarr;
        }
        return null;
    }

    private static byte[][] grow(byte[][] arr, int newcapacity) {
        if (arr != null) {
            byte[][] newarr = new byte[newcapacity][];
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i] == null) continue;
                int n = arr[i].length;
                newarr[i] = new byte[n];
                System.arraycopy(arr[i], 0, newarr[i], 0, n);
            }
            return newarr;
        }
        return null;
    }

    private static byte[][] grow2(byte[][] arr, int newcapacity) {
        if (arr != null) {
            byte[][] newarr = new byte[arr.length][newcapacity];
            for (int i = 0; i < arr.length; ++i) {
                System.arraycopy(arr[i], 0, newarr[i], 0, arr[i].length);
            }
            return newarr;
        }
        return null;
    }

    private static void remove(int[] arr, int i, int size, int def) {
        if (arr != null) {
            System.arraycopy(arr, i + 1, arr, i, size - i - 1);
            arr[size - 1] = def;
        }
    }

    private static void remove(short[] arr, int i, int size, int def) {
        if (arr != null) {
            System.arraycopy(arr, i + 1, arr, i, size - i - 1);
            arr[size - 1] = (short)def;
        }
    }

    private static void remove(short[][] arr, int i, int size) {
        if (arr != null) {
            System.arraycopy(arr, i + 1, arr, i, size - i - 1);
            arr[size - 1] = null;
        }
    }

    private static void remove(byte[] arr, int i, int size, int def) {
        if (arr != null) {
            System.arraycopy(arr, i + 1, arr, i, size - i - 1);
            arr[size - 1] = (byte)def;
        }
    }

    private static void remove(byte[][] arr, int i, int size) {
        if (arr != null) {
            System.arraycopy(arr, i + 1, arr, i, size - i - 1);
            arr[size - 1] = null;
        }
    }

    private static void remove(String[] arr, int i, int size) {
        if (arr != null) {
            System.arraycopy(arr, i + 1, arr, i, size - i - 1);
            arr[size - 1] = null;
        }
    }

    protected void regenGearch() {
        this.gearch = new SmoleculeGearch(this);
    }
}

