/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc;

import chemaxon.common.util.ArrayTools;

public class StereoActivePart {
    private int stereoActiveAtomIndex = -1;
    private int[] ligandAtomIndexes = null;

    public StereoActivePart(int stereoActiveIndex, int[] ligandIndexes) {
        this.stereoActiveAtomIndex = stereoActiveIndex;
        this.ligandAtomIndexes = ligandIndexes;
    }

    public int getStereoActiveAtom() {
        return this.stereoActiveAtomIndex;
    }

    public int[] getLigands() {
        return this.ligandAtomIndexes;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof StereoActivePart)) {
            return false;
        }
        StereoActivePart other = (StereoActivePart)object;
        return this.stereoActiveAtomIndex == other.stereoActiveAtomIndex && ArrayTools.equalsArrays(other.ligandAtomIndexes, this.ligandAtomIndexes);
    }

    public boolean equalsTo(Object o, int[] map) {
        if (o == null || !(o instanceof StereoActivePart)) {
            return false;
        }
        StereoActivePart other = (StereoActivePart)o;
        if (map[this.stereoActiveAtomIndex] != other.stereoActiveAtomIndex) {
            return false;
        }
        if (this.ligandAtomIndexes.length != other.ligandAtomIndexes.length) {
            return false;
        }
        int[] mappedLigands = new int[this.ligandAtomIndexes.length];
        for (int i = 0; i < this.ligandAtomIndexes.length; ++i) {
            mappedLigands[i] = map[this.ligandAtomIndexes[i]];
        }
        return ArrayTools.equalsArrays(other.ligandAtomIndexes, mappedLigands);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.stereoActiveAtomIndex);
        sb.append("{");
        for (int i : this.ligandAtomIndexes) {
            sb.append(i);
            sb.append(",");
        }
        if (this.ligandAtomIndexes.length > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int result = 17 * this.stereoActiveAtomIndex;
        for (int i : this.ligandAtomIndexes) {
            result += i;
        }
        return result;
    }
}

