/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.gearch;

import chemaxon.common.util.IntVector;
import chemaxon.struc.Smolecule;
import java.util.HashMap;

public final class ConnectedComponents {
    private int[] connCompIds;
    private int numConnComps;
    private IntVector connCompSizes;

    private static void findConnections(Smolecule mol, int[] x) {
        for (int j = mol.getBondCount() - 1; j >= 0; --j) {
            int i2;
            int i1 = mol.getAtom1(j);
            if (x[i1] < 0 || x[i2 = mol.getAtom2(j)] < 0) continue;
            while (x[i1] != i1) {
                i1 = x[i1];
            }
            while (x[i2] != i2) {
                i2 = x[i2];
            }
            if (i1 > i2) {
                x[i1] = i2;
                continue;
            }
            x[i2] = i1;
        }
    }

    private void setComponentIds(Smolecule mol) {
        int i;
        int[] x = new int[mol.getAtomCount()];
        for (int i2 = 0; i2 < x.length; ++i2) {
            x[i2] = i2;
        }
        ConnectedComponents.findConnections(mol, x);
        HashMap<Integer, Integer> idmap = new HashMap<Integer, Integer>();
        this.connCompSizes = new IntVector();
        int m = 0;
        for (i = 0; i < x.length; ++i) {
            int t = i;
            while (x[t] != t) {
                t = x[t];
            }
            Integer id = (Integer)idmap.get(t);
            if (id == null) {
                id = m;
                idmap.put(t, m);
                assert (this.connCompSizes.size() == m);
                this.connCompSizes.add(1);
                ++m;
            } else {
                this.connCompSizes.set(id, this.connCompSizes.get(id) + 1);
            }
            x[i] = t;
        }
        for (i = 0; i < x.length; ++i) {
            x[i] = (Integer)idmap.get(x[i]);
        }
        this.connCompIds = x;
        this.numConnComps = this.connCompSizes.size();
    }

    public ConnectedComponents(Smolecule mol) {
        this.setComponentIds(mol);
    }

    public ConnectedComponents(ConnectedComponents other) {
        this.connCompIds = new int[other.connCompIds.length];
        System.arraycopy(other.connCompIds, 0, this.connCompIds, 0, other.connCompIds.length);
        this.connCompSizes = new IntVector(other.connCompSizes.toArray());
        this.numConnComps = other.numConnComps;
    }

    public int getCC(int i) {
        return this.connCompIds[i];
    }

    int[] getCCArray() {
        return this.connCompIds;
    }

    public int count() {
        return this.numConnComps;
    }

    public int getSize(int id) {
        return this.connCompSizes.get(id);
    }

    int mergeFrags(int id1, int id2) {
        int oldID = Math.max(id1, id2);
        int newID = Math.min(id1, id2);
        int[] ids = this.connCompIds;
        for (int j = 0; j < ids.length; ++j) {
            if (ids[j] == oldID) {
                ids[j] = newID;
                continue;
            }
            if (ids[j] <= oldID) continue;
            int n = j;
            ids[n] = ids[n] - 1;
        }
        --this.numConnComps;
        int size1 = this.connCompSizes.get(id1);
        int size2 = this.connCompSizes.get(id2);
        this.connCompSizes.remove(oldID);
        this.connCompSizes.set(newID, new Integer(size1 + size2));
        return newID;
    }
}

