/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.gearch;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.gearch.MoleculeGraphGearch;
import chemaxon.struc.sgroup.MulticenterSgroup;

public class MoleculeGearch
extends MoleculeGraphGearch {
    Molecule molecule;

    public MoleculeGearch(Molecule m) {
        super(m);
        this.molecule = m;
    }

    public MoleculeGearch(MoleculeGearch other, Molecule m, boolean hasxbond) {
        super(other, m, hasxbond);
        this.molecule = m;
    }

    @Override
    public MoleculeGraphGearch cloneMoleculeGraphGearch(MoleculeGraph m, boolean hasxbond) {
        if (m instanceof Molecule) {
            return new MoleculeGearch(this, (Molecule)m, hasxbond);
        }
        return super.cloneMoleculeGraphGearch(m, hasxbond);
    }

    @Override
    public void mergeFrags(int fragmentationType) {
        switch (fragmentationType) {
            case 1: {
                this.mergeFragsKeepingMulticenters();
                break;
            }
            case 2: {
                this.mergeFragsKeepingSgroups();
            }
        }
    }

    private void mergeFragsKeepingSgroups() {
        for (int k = 0; k < this.molecule.getSgroupCount(); ++k) {
            int mcIndex;
            MolAtom mc;
            Sgroup sg = this.molecule.getSgroup(k);
            int atomIndex = -1;
            for (int i = 0; i < sg.getAtomCount() && atomIndex == -1; ++i) {
                int index;
                MolAtom atom = sg.getAtom(i);
                if (atom == null || (index = this.molecule.indexOf(atom)) < 0 || index >= this.molecule.getAtomCount()) continue;
                atomIndex = index;
            }
            if (atomIndex == -1) continue;
            for (int j = i; j < sg.getAtomCount(); ++j) {
                int index;
                MolAtom atom = sg.getAtom(j);
                if (atom == null || (index = this.molecule.indexOf(atom)) < 0 || index >= this.molecule.getAtomCount()) continue;
                this.mergeFrags(atomIndex, index, 2);
            }
            if (sg.getType() != 14 || (mc = ((MulticenterSgroup)sg).getCentralAtom()) == null || (mcIndex = this.molecule.indexOf(mc)) < 0 || mcIndex >= this.molecule.getAtomCount()) continue;
            this.mergeFrags(atomIndex, mcIndex, 2);
        }
    }

    private void mergeFragsKeepingMulticenters() {
        for (int k = 0; k < this.molecule.getSgroupCount(); ++k) {
            int mcIndex;
            MolAtom mc;
            Sgroup sg = this.molecule.getSgroup(k);
            if (sg.getType() != 14 || (mc = ((MulticenterSgroup)sg).getCentralAtom()) == null || (mcIndex = this.molecule.indexOf(mc)) < 0 || mcIndex >= this.molecule.getAtomCount()) continue;
            for (int i = 0; i < sg.getAtomCount(); ++i) {
                int atIndex;
                MolAtom atom = sg.getAtom(i);
                if (atom == null || (atIndex = this.molecule.indexOf(atom)) < 0 || atIndex >= this.molecule.getAtomCount()) continue;
                this.mergeFrags(atIndex, mcIndex, 1);
            }
        }
    }
}

