/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.gearch;

import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.gearch.MoleculeGraphGearch;
import chemaxon.struc.sgroup.MulticenterSgroup;

public class SelectionMoleculeGearch
extends MoleculeGraphGearch {
    private MoleculeGraph molecule;

    public SelectionMoleculeGearch(MoleculeGraph m) {
        super(m);
        this.molecule = m;
    }

    public SelectionMoleculeGearch(SelectionMoleculeGearch other, MoleculeGraph m, boolean hasxbond) {
        super(other, m, hasxbond);
        this.molecule = m;
    }

    @Override
    public MoleculeGraphGearch cloneMoleculeGraphGearch(MoleculeGraph m, boolean hasxbond) {
        if (m instanceof SelectionMolecule) {
            return new SelectionMoleculeGearch(this, m, hasxbond);
        }
        return super.cloneMoleculeGraphGearch(m, hasxbond);
    }

    @Override
    public void mergeFrags(int fragmentationType) {
        switch (fragmentationType) {
            case 1: {
                this.mergeFragsKeepingMulticenters();
                break;
            }
            case 2: {
                this.mergeFragsKeepingSgroups();
            }
        }
    }

    private void mergeFragsKeepingMulticenters() {
        for (int k = 0; k < this.molecule.getAtomCount(); ++k) {
            MulticenterSgroup sg;
            MolAtom mc = this.molecule.getAtom(k);
            if (mc.getAtno() != 137 || !(mc.getParent() instanceof Molecule) || (sg = ((Molecule)mc.getParent()).findContainingMulticenterSgroup(mc)) == null || sg.getType() != 14) continue;
            for (int i = 0; i < sg.getAtomCount(); ++i) {
                int atomIndex = this.molecule.indexOf(sg.getAtom(i));
                this.mergeFrags(k, atomIndex, 1);
            }
        }
    }

    private void mergeFragsKeepingSgroups() {
        for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
            Sgroup[] sgroups;
            MolAtom atom = this.molecule.getAtom(i);
            if (!(atom.getParent() instanceof Molecule)) continue;
            Molecule parentMolecule = (Molecule)atom.getParent();
            for (Sgroup sg : sgroups = parentMolecule.findAllSgroupContaining(atom)) {
                this.mergeFragsInSameSgroup(i, sg);
            }
        }
    }

    private void mergeFragsInSameSgroup(int selectedAtomIndex, Sgroup sgroup) {
        assert (sgroup != null);
        Sgroup largestSgroup = sgroup;
        while (largestSgroup.getParentSgroup() != null) {
            largestSgroup = largestSgroup.getParentSgroup();
        }
        for (int i = 0; i < largestSgroup.getAtomCount(); ++i) {
            MolAtom mc;
            int sgroupAtomIndex = this.molecule.indexOf(largestSgroup.getAtom(i));
            if (sgroupAtomIndex != selectedAtomIndex) {
                this.mergeFrags(selectedAtomIndex, sgroupAtomIndex, 2);
            }
            if (largestSgroup.getType() != 14 || (mc = ((MulticenterSgroup)largestSgroup).getCentralAtom()) == null) continue;
            int mcIndex = this.molecule.indexOf(mc);
            this.mergeFrags(selectedAtomIndex, mcIndex, 2);
        }
    }

    @Override
    protected boolean isGrinvCCValid() {
        return false;
    }
}

