/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.gearch;

import chemaxon.core.calculations.SSSR;
import chemaxon.struc.Gearch;
import chemaxon.struc.Smolecule;
import chemaxon.struc.WSmolecule;
import chemaxon.struc.gearch.ConnectedComponents;

public class SmoleculeGearch
implements Gearch {
    private Smolecule smolecule;
    protected ConnectedComponents[] connComps = new ConnectedComponents[3];
    protected transient int[][] sssr = null;
    protected transient int[][] cssr = null;
    protected transient int[] sssrl2idx = null;
    protected transient int[][] sssr2idx = null;
    protected transient SSSR sssrModule = null;
    protected transient long[] sssrBondSetInLong = null;

    public SmoleculeGearch(Smolecule m) {
        this.setSmolecule(m);
    }

    public SmoleculeGearch(SmoleculeGearch other, Smolecule m, boolean hasxbond) {
        int ni;
        int n;
        this.setSmolecule(m);
        for (int i = 0; i < this.connComps.length; ++i) {
            ConnectedComponents cc = other.connComps[i];
            this.connComps[i] = cc != null ? new ConnectedComponents(cc) : null;
        }
        if (other.sssr != null && !hasxbond) {
            n = other.sssr.length;
            this.sssr = new int[n][];
            for (int i = 0; i < n; ++i) {
                ni = other.sssr[i].length;
                this.sssr[i] = new int[ni];
                System.arraycopy(other.sssr[i], 0, this.sssr[i], 0, ni);
            }
        }
        if (other.cssr != null && !hasxbond) {
            n = other.cssr.length;
            this.cssr = new int[n][];
            for (int i = 0; i < n; ++i) {
                ni = other.cssr[i].length;
                this.cssr[i] = new int[ni];
                System.arraycopy(other.cssr[i], 0, this.cssr[i], 0, ni);
            }
        }
        if (this.sssrl2idx != null && !hasxbond) {
            n = other.sssrl2idx.length;
            this.sssrl2idx = new int[n];
            System.arraycopy(other.sssrl2idx, 0, this.sssrl2idx, 0, n);
        }
        if (this.sssr2idx != null && !hasxbond) {
            n = other.sssr2idx.length;
            this.sssr2idx = new int[n][];
            for (int i = 0; i < n; ++i) {
                ni = other.sssr2idx[i].length;
                this.sssr2idx[i] = new int[ni];
                System.arraycopy(other.sssr2idx[i], 0, this.sssr2idx[i], 0, ni);
            }
        }
    }

    private void initConnComps(int opts) {
        if (this.connComps[opts] == null) {
            this.regenFragIds(opts);
        }
    }

    @Override
    public final int fragCount(int opts) {
        this.initConnComps(opts);
        return this.connComps[opts].count();
    }

    @Override
    public final int fragId(int opts, int k) {
        this.initConnComps(opts);
        return this.connComps[opts].getCC(k);
    }

    @Override
    public int fragSize(int opts, int id) {
        this.initConnComps(opts);
        return this.connComps[opts].getSize(id);
    }

    protected void regenFragIds(int opts) {
        this.connComps[opts] = new ConnectedComponents(this.getSmolecule());
        if (opts != 0 && this.connComps[opts].count() > 1) {
            this.mergeFrags(opts);
        }
    }

    public void mergeFrags(int fragmentationType) {
    }

    @Override
    public int getGrinv(int[] gi, int opts) {
        throw new RuntimeException("getGrinv is not implemented");
    }

    @Override
    public final int[] getFragIds(int opts) {
        if (this.connComps[opts] == null) {
            this.regenFragIds(opts);
        }
        return this.connComps[opts].getCCArray();
    }

    @Override
    public final Smolecule[] findFrags(int opts, WSmolecule proto, int aflags) {
        return SmoleculeGearch.findFrags(this, this.getSmolecule(), opts, proto, aflags);
    }

    static Smolecule[] findFrags(Gearch gearch, Smolecule smolecule, int opts, WSmolecule proto, int aflags) {
        int na = smolecule.getAtomCount();
        Smolecule[] frags = new WSmolecule[gearch.fragCount(opts)];
        for (int i = 0; i < frags.length; ++i) {
            int nfa = gearch.fragSize(opts, i);
            frags[i] = proto.newInstance(nfa, nfa, aflags);
        }
        int[] amap = new int[na];
        for (int atom = 0; atom < na; ++atom) {
            int fragatom;
            int fragId = gearch.fragId(opts, atom);
            Smolecule frag = frags[fragId];
            amap[atom] = fragatom = frag.getAtomCount();
            frag.addAtom(smolecule, atom);
            if ((aflags & 1) == 0) continue;
            int nb = smolecule.getNeighborCount(atom);
            for (int i = 0; i < nb; ++i) {
                int neighbor = smolecule.getNeighbor(atom, i);
                if (neighbor >= atom || gearch.fragId(opts, neighbor) != fragId) continue;
                int bondType = smolecule.getBondType(atom, neighbor);
                frag.addBond(amap[atom], amap[neighbor], bondType);
            }
        }
        return frags;
    }

    @Override
    public final int getSSSRCount() {
        if (this.sssr == null) {
            this.regenSSSR();
        }
        return this.sssr.length;
    }

    @Override
    public final int getSSSRAtomCount(int ring) {
        if (this.sssr == null) {
            this.regenSSSR();
        }
        return this.sssr[ring].length;
    }

    @Override
    public final int getSSSRAtom(int ring, int i) {
        if (this.sssr == null) {
            this.regenSSSR();
        }
        return this.sssr[ring][i];
    }

    protected synchronized void regenSSSR() {
        if (this.sssrModule == null) {
            this.sssrModule = new SSSR();
        }
        this.sssrModule.setGraph(this.getSmolecule());
        this.sssrModule.startRingSearch(false);
        this.sssr = this.sssrModule.getRings();
    }

    public void resetGrinv() {
        this.sssr = null;
        this.cssr = null;
        this.sssrl2idx = null;
        this.sssr2idx = null;
        this.sssrBondSetInLong = null;
    }

    private Smolecule getSmolecule() {
        return this.smolecule;
    }

    private void setSmolecule(Smolecule smolecule) {
        this.smolecule = smolecule;
    }
}

