/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRectanglePoint;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

public class MBracket
extends MRectangle {
    private static final long serialVersionUID = -5775562691065011181L;
    public static final int T_ROUND = 0;
    public static final int T_SQUARE = 1;
    public static final int T_BRACES = 2;
    public static final int T_CHEVRONS = 3;
    private int bracketType = 0;
    private int bracketOrientation = 5;
    public static final int T_SINGLE = 4;
    public static final int T_DOUBLE = 5;

    public MBracket() {
        this(new MPoint(0.0, 0.0, 0.0), new MPoint(0.0, 0.0, 0.0), null);
    }

    public MBracket(MPoint p1, MPoint p2) {
        this(p1, p2, null);
    }

    public MBracket(MPoint p1, MPoint p2, Color c) {
        super(p1, p2, c, null);
    }

    protected MBracket(MBracket r) {
        super(r);
        this.bracketType = r.bracketType;
        this.bracketOrientation = r.bracketOrientation;
    }

    @Override
    public boolean hasBackground() {
        return false;
    }

    public void copyProperties(MBracket l) {
        super.copyProperties(l);
        l.bracketType = this.bracketType;
        l.bracketOrientation = this.bracketOrientation;
    }

    public int getType() {
        return this.bracketType;
    }

    public void setType(int t) {
        this.bracketType = t;
    }

    @Override
    public Object clone() {
        return new MBracket(this);
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        super.transform(t, opts, trot);
        if (t.determinant() < 0.0 || t.determinant2D() < 0.0) {
            this.reverse();
        }
    }

    @Override
    public void addAttributeKeys(List<String> l) {
        super.addAttributeKeys(l);
        l.add("type");
        l.add("orientation");
    }

    @Override
    public String getAttribute(String s) {
        if (s.equalsIgnoreCase("type")) {
            int t = this.bracketType;
            if (t == 0) {
                return "ROUND";
            }
            if (t == 1) {
                return "SQUARE";
            }
            if (t == 2) {
                return "BRACES";
            }
            if (t == 3) {
                return "CHEVRONS";
            }
            throw new RuntimeException("invalid bracket type value " + t);
        }
        if (s.equalsIgnoreCase("orientation")) {
            if (this.bracketOrientation == 5) {
                return "DOUBLE";
            }
            if (this.bracketOrientation == 4) {
                return "SINGLE";
            }
            throw new RuntimeException("invalid orientation type value ");
        }
        return super.getAttribute(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(String s, String v) {
        if (s.equalsIgnoreCase("type")) {
            int t;
            if (v.equals("ROUND")) {
                t = 0;
            } else if (v.equals("SQUARE")) {
                t = 1;
            } else if (v.equals("BRACES")) {
                t = 2;
            } else {
                if (!v.equals("CHEVRONS")) throw new IllegalArgumentException("unknown bracket type " + v);
                t = 3;
            }
            this.bracketType = t;
            return;
        } else if (s.equalsIgnoreCase("orientation")) {
            if (v.equals("DOUBLE")) {
                this.bracketOrientation = 5;
                return;
            } else {
                if (!v.equals("SINGLE")) throw new IllegalArgumentException("unknown orientation type " + v);
                this.bracketOrientation = 4;
            }
            return;
        } else {
            super.setAttribute(s, v);
        }
    }

    public int getBracketOrientation() {
        return this.bracketOrientation;
    }

    public void setBracketOrientation(int bracketOrientation) {
        this.bracketOrientation = bracketOrientation;
    }

    public boolean enclosesPoint(double x, double y) {
        DPoint3 p0 = this.getPoint(0).getLocation();
        DPoint3 p1 = this.getPoint(1).getLocation();
        DPoint3 p2 = this.getPoint(2).getLocation();
        DPoint3 p3 = this.getPoint(3).getLocation();
        Line2D.Double line1 = new Line2D.Double(p0.x, p0.y, p1.x, p1.y);
        Line2D.Double line2 = new Line2D.Double(p1.x, p1.y, p2.x, p2.y);
        Line2D.Double line3 = new Line2D.Double(p3.x, p3.y, p2.x, p2.y);
        Line2D.Double line4 = new Line2D.Double(p0.x, p0.y, p3.x, p3.y);
        double l1 = p0.distance(p1);
        double l2 = p2.distance(p1);
        double d1 = line1.ptLineDist(x, y);
        double d2 = line2.ptLineDist(x, y);
        double d3 = line3.ptLineDist(x, y);
        double d4 = line4.ptLineDist(x, y);
        return d1 <= l2 && d3 <= l2 && d2 <= l1 && d4 <= l1;
    }

    public int getVisiblePointRefCount() {
        return this.bracketOrientation == 4 ? 2 : 6;
    }

    public MPoint getVisiblePointRef(int index, CTransform3D trot) {
        double z;
        double y;
        double x;
        Cloneable p;
        int i = index;
        if (this.bracketOrientation == 4) {
            if (index == 0) {
                i = 0;
            } else if (index == 1) {
                i = 3;
            }
        }
        if (i < 4) {
            p = super.getPointRef(i, trot).getLocation(null);
            x = ((DPoint3)p).x;
            y = ((DPoint3)p).y;
            z = ((DPoint3)p).z;
        } else {
            int k = i == 4 ? 0 : 1;
            int l = i == 4 ? 3 : 2;
            DPoint3 p1 = super.getPointRef(k, trot).getLocation(null);
            DPoint3 p2 = super.getPointRef(l, trot).getLocation(null);
            x = (p1.x + p2.x) / 2.0;
            y = (p1.y + p2.y) / 2.0;
            z = (p1.z + p2.z) / 2.0;
        }
        p = new MRectanglePoint(this, i, x, y, z);
        if (this.internalPointAddCount != 0 && this.internalPointPos == i) {
            ((MObject)p).setSelected(true);
        }
        return p;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(1);
        oos.writeShort((short)this.bracketType);
        oos.writeShort((short)this.bracketOrientation);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 1) {
            throw new IOException("Cannot deserialize bracket object with future version (" + version + ")");
        }
        this.bracketType = ois.readShort();
        if (version > 0) {
            this.bracketOrientation = ois.readShort();
        }
    }
}

