/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.graphics.MChemicalStruct;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MMoleculeMovie
extends MObject {
    private static final long serialVersionUID = 6476041884742537582L;
    private transient int currentFrameIndex;
    private transient Molecule[] molecules;

    public MMoleculeMovie(Molecule[] mols) {
        super(null, null, null);
        this.currentFrameIndex = 0;
        if (mols == null || mols.length == 0) {
            this.molecules = new Molecule[1];
            this.molecules[0] = new Molecule();
        } else {
            int n = mols.length;
            this.molecules = new Molecule[n];
            System.arraycopy(mols, 0, this.molecules, 0, n);
        }
    }

    protected MMoleculeMovie(MMoleculeMovie mma) {
        super(mma);
        this.currentFrameIndex = mma.currentFrameIndex;
        int n = mma.molecules.length;
        this.molecules = new Molecule[n];
        for (int i = 0; i < n; ++i) {
            this.molecules[i] = (Molecule)mma.molecules[i].clone();
        }
    }

    public int getMoleculeCount() {
        return this.molecules.length;
    }

    public Molecule getMolecule(int i) {
        return this.molecules[i];
    }

    public Molecule[] getMolecules() {
        Molecule[] m = new Molecule[this.molecules.length];
        System.arraycopy(this.molecules, 0, m, 0, m.length);
        return m;
    }

    public int getCurrentFrameIndex() {
        return this.currentFrameIndex;
    }

    public void setCurrentFrameIndex(int i) {
        this.currentFrameIndex = i;
    }

    public Molecule getCurrentMolecule() {
        return this.molecules[this.currentFrameIndex];
    }

    @Override
    public Object clone() {
        return new MMoleculeMovie(this);
    }

    @Override
    public boolean isEmpty() {
        return this.molecules.length == 1 && this.molecules[0].isEmpty();
    }

    @Override
    public int getPointCount() {
        return this.molecules[this.currentFrameIndex].getAtomCount();
    }

    @Override
    public MPoint getPoint(int i) {
        Molecule m = this.molecules[this.currentFrameIndex];
        return new MPoint(m.getAtom(i).getLocation());
    }

    @Override
    public boolean containsAtom(MolAtom a) {
        for (int i = 0; i < this.molecules.length; ++i) {
            if (!this.molecules[i].contains(a)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        for (int i = 0; i < this.molecules.length; ++i) {
            this.molecules[i].transform(t);
        }
    }

    @Override
    public void calcCenter(DPoint3 p, CTransform3D t) {
        DPoint3 q = new DPoint3(0.0, 0.0, 0.0);
        int n = this.molecules.length;
        for (int i = 0; i < n; ++i) {
            this.molecules[i].calcCenter(q);
            p.x += q.x;
            p.y += q.y;
            p.z += q.z;
        }
        p.x /= (double)n;
        p.y /= (double)n;
        p.z /= (double)n;
        if (t != null) {
            t.transform(p);
        }
    }

    @Override
    public double distanceFrom(double x, double y, CTransform3D t) {
        return MChemicalStruct.distanceFrom(this.molecules[this.currentFrameIndex], x, y, t);
    }

    @Override
    public void setSelected(boolean s) {
        super.setSelected(s);
        for (int i = 0; i < this.molecules.length; ++i) {
            MChemicalStruct.setSelected(this.molecules[i], s);
        }
    }

    public boolean hasSelection() {
        for (int i = 0; i < this.molecules.length; ++i) {
            if (!MChemicalStruct.hasSelection(this.molecules[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unselectContents() {
        for (int i = 0; i < this.molecules.length; ++i) {
            MChemicalStruct.setSelected(this.molecules[i], false);
        }
    }

    @Override
    public void removeAtom(MolAtom atom) {
        for (int j = 0; j < this.getMoleculeCount(); ++j) {
            this.getMolecule(j).removeAtom(atom);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeInt(this.molecules.length);
        for (int i = 0; i < this.molecules.length; ++i) {
            oos.writeObject(this.molecules[i]);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize molecule animation with future version (" + version + ")");
        }
        int n = ois.readInt();
        this.molecules = new Molecule[n];
        for (int i = 0; i < n; ++i) {
            this.molecules[i] = (Molecule)ois.readObject();
        }
    }
}

