/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MPoint;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.graphics.MTextDocument;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

public class MNameTextBox
extends MTextBox {
    private static final long serialVersionUID = 6302424343157644471L;
    private transient long grinv = -1L;
    private transient boolean autoResize = true;
    private transient boolean autoAlign = true;
    private transient double preferredWidth = 10.0;

    protected MNameTextBox(MNameTextBox t) {
        super(t);
        this.grinv = t.grinv;
        this.autoResize = t.autoResize;
        this.autoAlign = t.autoAlign;
        this.preferredWidth = t.preferredWidth;
    }

    public MNameTextBox() {
        this.grinv = -1L;
    }

    @Override
    public Object clone() {
        return new MNameTextBox(this);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public double calcWidth(Graphics2D g, double scale) {
        if (g == null) {
            return this.preferredWidth;
        }
        double w = 0.4;
        MTextDocument text = this.getTextDocument();
        for (int i = 0; i < text.getSectionCount(); ++i) {
            MTextDocument.Section s = text.getSection(i);
            FontMetrics fm = s.getFontMetrics(g, text.getDefaultFont());
            w += fm.getStringBounds(s.getString(), g).getWidth() / (this.getFontScale() * 1.54);
        }
        if (w < this.preferredWidth) {
            return w;
        }
        return this.preferredWidth;
    }

    @Override
    public void setCurrentWidth(double w) {
        this.currentWidth = w * 1.05;
    }

    @Override
    public void setAutoHeight(boolean v) {
        this.autoHeight = v;
    }

    @Override
    public void setText(String s) {
        MTextDocument textDoc = this.getTextDocument();
        MTextAttributes simpleAttr = MTextAttributes.DEFAULT;
        MTextAttributes superscriptAttr = new MTextAttributes(simpleAttr.getSet(), 1, simpleAttr.getForeground(), simpleAttr.getBaseFont(), 0.7, simpleAttr.getDx(), 0.6);
        textDoc.remove(0, textDoc.length());
        int fromIndex = 0;
        int begin = 0;
        int end = 0;
        while (fromIndex < s.length() && begin != -1 && end != -1) {
            begin = s.indexOf("^{", fromIndex);
            if (begin == -1) continue;
            end = s.indexOf("}", begin);
            textDoc.append(s.substring(fromIndex, begin), simpleAttr);
            if (end != -1 && begin < end) {
                textDoc.append(s.substring(begin + 2, end), superscriptAttr);
            }
            if (end == -1) continue;
            fromIndex = end + 1;
        }
        if (begin == -1) {
            textDoc.append(s.substring(fromIndex, s.length()), simpleAttr);
        }
    }

    public long getGrinv() {
        return this.grinv;
    }

    public void setGrinv(long grinv) {
        this.grinv = grinv;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public boolean isAutoAlign() {
        return this.autoAlign;
    }

    public void setAutoAlign(boolean autoAlign) {
        this.autoAlign = autoAlign;
    }

    public double getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(double preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    @Override
    public void transform(CTransform3D t, int opts, CTransform3D trot) {
        DPoint3 p = null;
        if (this.autoAlign && this.getPointCount() > 0) {
            p = this.getPoint(0).getLocation();
        }
        super.transform(t, opts, trot);
        if (this.autoAlign && this.getPointCount() > 0 && p != null && !p.equals(this.getPoint(0).getLocation())) {
            this.autoAlign = false;
        }
    }

    @Override
    public void setPoints(MPoint[] p) {
        MPoint[] ref = null;
        if (this.autoResize) {
            ref = this.getPoints();
        }
        super.setPoints(p);
        if (this.autoResize) {
            for (int i = this.getPointCount() - 1; i >= 0; --i) {
                if (ref == null || ref[i].getLocation().equals(this.getPoint(i).getLocation())) continue;
                this.autoResize = false;
            }
        }
    }

    @Override
    public void addAttributeKeys(List<String> l) {
        super.addAttributeKeys(l);
        l.add("autoResize");
        l.add("autoAlign");
        l.add("preferredWidth");
    }

    @Override
    public String getAttribute(String s) {
        String v = super.getAttribute(s);
        if (v != null) {
            return v;
        }
        if (s.equalsIgnoreCase("autoResize")) {
            return this.autoResize ? "true" : "false";
        }
        if (s.equalsIgnoreCase("autoAlign")) {
            return this.autoAlign ? "true" : "false";
        }
        if (s.equalsIgnoreCase("preferredWidth")) {
            return String.valueOf(this.preferredWidth);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(String s, String v) {
        if (s.equalsIgnoreCase("autoResize")) {
            if (v.equalsIgnoreCase("true")) {
                this.autoResize = true;
                return;
            } else {
                if (!v.equalsIgnoreCase("false")) throw new IllegalArgumentException("invalid autoResize attribute " + v);
                this.autoResize = false;
            }
            return;
        } else if (s.equalsIgnoreCase("autoAlign")) {
            if (v.equalsIgnoreCase("true")) {
                this.autoAlign = true;
                return;
            } else {
                if (!v.equalsIgnoreCase("false")) throw new IllegalArgumentException("invalid autoAlign attribute " + v);
                this.autoAlign = false;
            }
            return;
        } else if (s.equalsIgnoreCase("preferredWidth")) {
            this.preferredWidth = Double.valueOf(v);
            return;
        } else {
            super.setAttribute(s, v);
        }
    }

    @Override
    public String getPreBreakingChars() {
        return "[{(";
    }

    @Override
    public String getBreakingChars() {
        return " \t-]}),";
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeByte(0);
        oos.writeLong(this.grinv);
        oos.writeBoolean(this.autoResize);
        oos.writeBoolean(this.autoAlign);
        oos.writeDouble(this.preferredWidth);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize text object with future version (" + version + ")");
        }
        this.grinv = ois.readLong();
        this.autoResize = ois.readBoolean();
        this.autoAlign = ois.readBoolean();
        this.preferredWidth = ois.readDouble();
    }
}

