/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.graphics;

import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MTextAttributes;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class MTextDocument
implements Externalizable,
MTextAttributes.MFontCreator {
    private static final long serialVersionUID = 6305880304790247656L;
    private static final int MAX_SECTIONS = 32766;
    private static final MFont FONT_DEFAULT = new MFont("SansSerif", 0, 10.0);
    private static final int FONT_DEFAULT_SIZE = 10;
    private MFont defaultFont;
    private int docLength;
    private String docText;
    private Section[] sections;
    private short[] charIndexToSectionIndex;
    private double[] sectionShiftY;

    public MTextDocument() {
        this("");
    }

    public MTextDocument(String s) {
        this.setPlainText(s);
        this.defaultFont = FONT_DEFAULT;
    }

    public MTextDocument(MTextDocument d) {
        this.docLength = d.docLength;
        this.docText = d.docText;
        this.defaultFont = d.defaultFont;
        this.sections = new Section[d.sections.length];
        System.arraycopy(d.sections, 0, this.sections, 0, this.sections.length);
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i] = new Section(d.sections[i]);
        }
        this.charIndexToSectionIndex = new short[d.charIndexToSectionIndex.length];
        System.arraycopy(d.charIndexToSectionIndex, 0, this.charIndexToSectionIndex, 0, this.charIndexToSectionIndex.length);
        this.sectionShiftY = new double[d.sectionShiftY.length];
        System.arraycopy(d.sectionShiftY, 0, this.sectionShiftY, 0, this.sectionShiftY.length);
    }

    public final String getPlainText() {
        if (this.docText == null) {
            StringBuffer sb = new StringBuffer();
            for (int k = 0; k < this.sections.length; ++k) {
                sb.append(this.sections[k].getString());
            }
            this.docText = sb.toString();
        }
        return this.docText;
    }

    public void setPlainText(String s) {
        this.docText = s;
        this.sections = new Section[1];
        this.sections[0] = new Section(0, s);
        this.charIndexToSectionIndex = new short[s.length()];
        for (int i = 0; i < this.charIndexToSectionIndex.length; ++i) {
            this.charIndexToSectionIndex[i] = 0;
        }
        this.sectionShiftY = new double[1];
        this.docLength = s.length();
    }

    public final int length() {
        return this.docLength;
    }

    public final char charAt(int i) {
        short k = this.charIndexToSectionIndex[i];
        String s = this.sections[k].getString();
        return s.charAt(i - this.sections[k].getPosition());
    }

    public boolean endsWith(char c) {
        return this.docLength != 0 && this.charAt(this.docLength - 1) == c;
    }

    public final String substring(int start) {
        if (start == this.length()) {
            return "";
        }
        short startk = this.charIndexToSectionIndex[start];
        int i0 = this.sections[startk].getPosition();
        StringBuffer sb = new StringBuffer();
        sb.append(this.sections[startk].substring(start - i0));
        for (int k = startk + 1; k < this.sections.length; ++k) {
            sb.append(this.sections[k].getString());
        }
        return sb.toString();
    }

    public final String substring(int start, int end) {
        if (start < this.length()) {
            int startk = this.getSectionIndexOfCharAt(start);
            int endk = this.getSectionIndexOfCharAt(end);
            int i0 = this.getSectionPos(startk);
            int i1 = this.getSectionPos(endk);
            StringBuffer sb = new StringBuffer();
            if (startk == endk) {
                String s = this.sections[startk].getString();
                sb.append(s.substring(start - i0, end - i0));
            } else if (startk == endk - 1 && i1 == 0) {
                String s = this.sections[startk].getString();
                sb.append(s.substring(start - i0));
            } else if (endk > startk) {
                String s = this.sections[startk].getString();
                sb.append(s.substring(start - i0));
                for (int k = startk + 1; k < endk; ++k) {
                    sb.append(this.sections[k].getString());
                }
                if (endk < this.sections.length) {
                    s = this.sections[endk].getString();
                    sb.append(s.substring(0, end - this.sections[endk].getPosition()));
                }
            }
            return sb.toString();
        }
        if (start == this.length() && end == start) {
            return "";
        }
        throw new ArrayIndexOutOfBoundsException("invalid substring(" + start + ", " + end + ") call, text length is " + this.length());
    }

    public final void remove(int start, int len) {
        int end = start + len;
        int startk = this.getSectionIndexOfCharAt(start);
        int endk = this.getSectionIndexOfCharAt(start + len);
        int i1 = start - this.getSectionPos(startk);
        int i2 = end - this.getSectionPos(endk);
        if (startk == endk) {
            this.deleteSubstringFromSection(startk, i1, i2);
        } else if (startk == endk - 1 && i2 == 0) {
            if (i1 == 0) {
                this.deleteSections(startk, startk + 1);
                this.joinSectionsIfPossible(startk - 1);
            } else {
                this.deleteSubstringFromSection(startk, i1, this.getSection(startk).length());
            }
        } else {
            int k0 = startk;
            this.deleteSubstringFromSection(endk, 0, i2);
            if (i1 == 0) {
                this.deleteSections(k0, endk);
                --k0;
            } else {
                this.deleteSections(k0 + 1, endk);
                this.deleteSubstringFromSection(k0, i1, this.getSection(k0).length());
            }
            this.joinSectionsIfPossible(k0);
        }
        if (this.sections.length == 0) {
            this.setPlainText("");
        }
        this.docText = null;
    }

    public final void append(String s, MTextAttributes attr) {
        if (s.length() != 0) {
            int k = this.sections.length - 1;
            Section last = this.sections[k];
            if (last.length() == 0 || attr == null || last.getAttributes().equalsNext(attr)) {
                if (last.length() == 0 && attr != null) {
                    last.setAttributes(attr);
                }
                this.replaceSectionContent(k, last.getString() + s);
                this.docText = null;
            } else {
                this.addSection(s, attr);
            }
        }
    }

    public final void insert(int i, String s, MTextAttributes attr) {
        if (s.length() == 0) {
            return;
        }
        if (i == this.length()) {
            this.append(s, attr);
        } else {
            int k = this.getSectionIndexOfCharAt(i);
            int i1 = i - this.getSectionPos(k);
            Section sec = this.getSection(k);
            MTextAttributes secattr = sec.getAttributes();
            String s1 = sec.substring(0, i1);
            String s2 = sec.substring(i1);
            if (attr == null || i1 == 0 && secattr.equals(attr) || i1 != 0 && secattr.equalsNext(attr)) {
                this.replaceSectionContent(k, s1 + s + s2);
            } else if (k == this.sections.length - 1) {
                if (i1 != 0) {
                    this.replaceSectionContent(k, s1);
                    this.addSection(s, attr);
                } else {
                    this.replaceSectionContent(k, s);
                    sec.setAttributes(attr);
                    this.joinSectionsIfPossible(k - 1);
                }
                if (s2.length() != 0) {
                    this.addSection(s2, secattr);
                }
            } else if (i1 != 0) {
                byte prevsubl;
                byte subl;
                this.replaceSectionContent(k, s1);
                this.insertSection(k + 1, s, attr);
                if (s2.length() != 0) {
                    this.insertSection(k + 2, s2, secattr.createNext());
                }
                if ((subl = attr.getSubLevel()) == -(prevsubl = secattr.getSubLevel())) {
                    this.invertScript(k + 2, prevsubl);
                    this.joinSectionsIfPossible(k + 1);
                }
            } else {
                byte prevsubl;
                byte subl;
                this.replaceSectionContent(k, s);
                sec.setAttributes(attr);
                if (s2.length() != 0) {
                    this.insertSection(k + 1, s2, secattr);
                }
                if ((subl = attr.getSubLevel()) == -(prevsubl = secattr.getSubLevel())) {
                    this.invertScript(k + 1, prevsubl);
                    this.joinSectionsIfPossible(k);
                }
                this.joinSectionsIfPossible(k - 1);
            }
            this.docText = null;
        }
    }

    private void invertScript(int k, int origsubl) {
        int subl = -origsubl;
        int end = this.findScriptLastSectionIndex(k, origsubl);
        for (int kk = k; kk <= end; ++kk) {
            Section seckk = this.getSection(kk);
            MTextAttributes aa = seckk.getAttributes();
            if (aa.getSubLevel() != origsubl) continue;
            aa = new MTextAttributes(aa.getSet(), subl, aa.getForeground(), aa.getBaseFont(), aa.getScale(), aa.getDx(), aa.getDy());
            seckk.setAttributes(aa);
        }
    }

    public final void replace(int start, int len, String s) {
        if (s.length() == 0) {
            this.remove(start, len);
        } else {
            int end = start + len;
            int startk = this.getSectionIndexOfCharAt(start);
            int endk = this.getSectionIndexOfCharAt(end);
            int i1 = start - this.getSectionPos(startk);
            int i2 = end - this.getSectionPos(endk);
            Section sec = this.getSection(startk);
            String s1 = sec.substring(0, i1);
            if (startk == endk) {
                String s2 = sec.substring(i2);
                this.replaceSectionContent(startk, s1 + s + s2);
            } else if (startk == endk - 1 && i2 == 0) {
                this.replaceSectionContent(startk, s1 + s);
            } else {
                this.deleteSubstringFromSection(endk, 0, i2);
                this.deleteSections(startk + 1, endk);
                this.replaceSectionContent(startk, s1 + s);
                this.joinSectionsIfPossible(startk);
            }
            this.docText = null;
        }
    }

    public final MTextAttributes getAttributes(int start, int len, int set0) {
        int startk = this.getSectionIndexOfCharAt(start);
        int endk = this.getSectionIndexOfCharAt(start + len);
        if (start + len == this.docLength || endk < this.getSectionCount() && this.getSection(endk).getPosition() == start + len) {
            --endk;
        }
        MTextAttributes attr0 = this.getSection(startk).getAttributes();
        attr0 = attr0.getCompatibleAttributes(attr0, this.defaultFont, this, set0);
        for (int k = startk + 1; k <= endk; ++k) {
            MTextAttributes attr = this.getSection(k).getAttributes();
            attr0 = attr0.getCompatibleAttributes(attr, this.defaultFont, this, set0);
            set0 = attr0.getSet();
        }
        return attr0;
    }

    public final boolean isFontDefaultInRange(int start, int len) {
        int startk = this.getSectionIndexOfCharAt(start);
        int endk = this.getSectionIndexOfCharAt(start + len);
        if (start + len == this.docLength || endk < this.getSectionCount() && this.getSection(endk).getPosition() == start + len) {
            --endk;
        }
        for (int k = startk; k <= endk; ++k) {
            MTextAttributes attr = this.getSection(k).getAttributes();
            if (attr.isFontDefault(this.getDefaultFont())) continue;
            return false;
        }
        return true;
    }

    public final boolean isFontRegularInRange(int start, int len) {
        int startk = this.getSectionIndexOfCharAt(start);
        int endk = this.getSectionIndexOfCharAt(start + len);
        if (start + len == this.docLength || endk < this.getSectionCount() && this.getSection(endk).getPosition() == start + len) {
            --endk;
        }
        for (int k = startk; k <= endk; ++k) {
            MTextAttributes attr = this.getSection(k).getAttributes();
            if (attr.isFontRegular()) continue;
            return false;
        }
        return true;
    }

    public final void setAttributes(int start, int len, MTextAttributes attr) {
        if (len == 0) {
            return;
        }
        MTextAttributes origAttr = this.getAttributes(start, len, 0);
        int startk = this.getSectionIndexOfCharAt(start);
        int endk = this.getSectionIndexOfCharAt(start + len);
        Section sec = this.getSection(startk);
        MTextAttributes secattr = sec.getAttributes();
        int i0 = sec.getPosition();
        if (!secattr.isCompatible(attr, origAttr, this.defaultFont)) {
            MTextAttributes newattr = secattr.createCompatible(attr, origAttr, this.defaultFont, this);
            if (startk == endk) {
                if (i0 == start) {
                    this.splitSection(startk, start + len - i0);
                    this.getSection(startk).attributes = newattr;
                    return;
                }
                this.splitSection(startk, start - i0);
                this.splitSection(startk + 1, len);
                if ((attr.getSet() & 0x200) == 0) {
                    newattr = newattr.createNext();
                }
                this.getSection(startk + 1).attributes = newattr;
                this.updateShiftY();
                return;
            }
            if (i0 == start) {
                sec.attributes = newattr;
            } else {
                this.splitSection(startk, start - i0);
                if ((attr.getSet() & 0x200) == 0) {
                    newattr = newattr.createNext();
                }
                this.getSection(startk + 1).attributes = newattr;
                ++startk;
                ++endk;
            }
        }
        MTextAttributes attrnext = attr.createNext();
        for (int k = startk + 1; k < endk; ++k) {
            sec = this.getSection(k);
            secattr = sec.getAttributes();
            if (secattr.isCompatible(attr, origAttr, this.defaultFont)) continue;
            sec.attributes = secattr.createCompatible(attrnext, origAttr, this.defaultFont, this);
        }
        if (endk < this.getSectionCount() && (i0 = (sec = this.getSection(endk)).getPosition()) < start + len) {
            secattr = sec.getAttributes();
            this.splitSection(endk, start + len - i0);
            MTextAttributes newattr = secattr.createCompatible(attrnext, origAttr, this.defaultFont, this);
            this.getSection(endk).attributes = newattr.createNext();
        }
        this.joinSectionsIfPossible(startk, endk);
        this.updateShiftY();
    }

    public final Portion getPortion(int start, int end) {
        return new Portion(start, end);
    }

    public MFont getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(MFont f) {
        this.defaultFont = f;
        for (int i = 0; i < this.getSectionCount(); ++i) {
            MFont fnt;
            Section sec = this.getSection(i);
            MTextAttributes a = sec.getAttributes();
            MFont basefnt = a.getBaseFont();
            if (basefnt == null || (fnt = this.getAttrFont(a)).equals(basefnt)) continue;
            sec.setAttributes(new MTextAttributes(a.getSet(), a.getSubLevel(), a.getForeground(), fnt, a.getScale(), a.getDx(), a.getDy()));
        }
    }

    public final int getSectionCount() {
        return this.sections.length;
    }

    public final int getSectionIndexOfCharAt(int i) {
        if (i == this.length()) {
            return i != 0 ? this.getSectionCount() : 0;
        }
        return this.charIndexToSectionIndex[i];
    }

    public final Section getSection(int k) {
        return this.sections[k];
    }

    public final double getSectionShiftY(int k) {
        return this.sectionShiftY[k];
    }

    public final int findScriptLastSectionIndex(int k, int subl) {
        MTextAttributes attr;
        byte l;
        --k;
        while (((l = (attr = this.getSection(++k).getAttributes()).getSubLevel()) == subl || Math.abs(l) > Math.abs(subl)) && k < this.getSectionCount() - 1) {
        }
        if (l == subl || Math.abs(l) > Math.abs(subl)) {
            return k;
        }
        return k - 1;
    }

    public final int getScriptCount(int i1, int subl) {
        byte l;
        MTextAttributes attr;
        int k0;
        int k1;
        if (i1 == this.charIndexToSectionIndex.length) {
            k0 = k1 = this.getSectionCount() - 1;
            attr = this.getSection(k1).getAttributes();
            l = attr.getSubLevel();
        } else {
            k0 = k1 = this.charIndexToSectionIndex[i1];
            attr = this.getSection(k1).getAttributes();
            l = attr.getSubLevel();
            if (k1 >= 0 && Math.abs(l) < Math.abs(subl) && k0 > 0) {
                --k0;
            }
        }
        if (Math.abs(l) < Math.abs(subl)) {
            Section sec = this.getSection(k1);
            int secpos = sec.getPosition();
            if (i1 == secpos) {
                byte ll;
                if (k1 > 0 && Math.abs(ll = this.getSection(k1 - 1).getAttributes().getSubLevel()) < Math.abs(subl)) {
                    return 0;
                }
            } else {
                return 0;
            }
        }
        while (k0 >= 0 && Math.abs(l = (attr = this.getSection(k0).getAttributes()).getSubLevel()) >= Math.abs(subl)) {
            --k0;
        }
        int n = 0;
        for (int k = k0 + 1; k < this.getSectionCount(); ++k) {
            attr = this.getSection(k).getAttributes();
            l = attr.getSubLevel();
            if (l == subl) {
                ++n;
                k = this.findScriptLastSectionIndex(k, l);
                continue;
            }
            if (Math.abs(l) < Math.abs(subl)) break;
        }
        return n;
    }

    public MFont getAttrFont(MTextAttributes attr) {
        MFont deffnt = this.defaultFont;
        if (attr == null) {
            return deffnt;
        }
        int set = attr.getSet();
        MFont basefnt = attr.getBaseFont();
        if (basefnt == null) {
            return deffnt;
        }
        if ((set & 4) != 0) {
            return basefnt;
        }
        String name = ((set & 8) != 0 ? basefnt : deffnt).getFamily();
        double size = ((set & 0x10) != 0 ? basefnt : deffnt).getSizeDouble();
        int style = 0;
        if (((set & 0x20) != 0 ? basefnt : deffnt).isBold()) {
            style |= 1;
        }
        if (((set & 0x40) != 0 ? basefnt : deffnt).isItalic()) {
            style |= 2;
        }
        return this.reuseFont(name, style, size);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.defaultFont != FONT_DEFAULT) {
            sb.append("{D font=");
            sb.append(this.defaultFont.getFamily());
            sb.append(",size=");
            double size = this.defaultFont.getSizeDouble();
            sb.append(MFont.sizeToString(size));
            if (this.defaultFont.isBold()) {
                sb.append(",bold");
            }
            if (this.defaultFont.isItalic()) {
                sb.append(",italic");
            }
            sb.append("}");
        }
        MTextAttributes prevattr = null;
        for (int k = 0; k < this.sections.length; ++k) {
            Section sec = this.sections[k];
            MTextAttributes secattr = sec.getAttributes();
            if (prevattr == null && !secattr.isDefault() || prevattr != null && !secattr.equals(prevattr)) {
                sb.append(secattr.encode(this.defaultFont, prevattr));
            }
            String str = sec.getString();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '\\') {
                    sb.append("\\\\");
                    continue;
                }
                if (c == '{') {
                    sb.append("\\{");
                    continue;
                }
                if (c != (c & 0x7F)) {
                    sb.append("\\u");
                    String s = "000" + Integer.toString(c, 16);
                    sb.append(s.substring(s.length() - 4));
                    continue;
                }
                sb.append(c);
            }
            prevattr = secattr;
        }
        return sb.toString();
    }

    public void readFromString(String str) throws IllegalArgumentException {
        this.setPlainText("");
        StringBuffer sb = new StringBuffer();
        MTextAttributes secattr = MTextAttributes.DEFAULT;
        int i = 0;
        this.defaultFont = FONT_DEFAULT;
        if (str.startsWith("{D ")) {
            int j = str.indexOf(125);
            StringTokenizer st = new StringTokenizer(str.substring(3, j), ",");
            String fontfamily = null;
            double size = 0.0;
            int style = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("font=")) {
                    fontfamily = s.substring(5);
                    continue;
                }
                if (s.startsWith("size=")) {
                    try {
                        size = Double.valueOf(s.substring(5));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Cannot read font size: " + s);
                    }
                }
                if (s.equals("bold")) {
                    style |= 1;
                    continue;
                }
                if (!s.equals("italic")) continue;
                style |= 2;
            }
            if (fontfamily != null || size != 0.0 || style != 0) {
                if (fontfamily == null) {
                    fontfamily = FONT_DEFAULT.getFamily();
                }
                if (size == 0.0) {
                    size = FONT_DEFAULT.getSizeDouble();
                }
                this.defaultFont = new MFont(fontfamily, style, size);
            }
            i = j + 1;
        }
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                if ((c = str.charAt(++i)) == 'u') {
                    String s = str.substring(i + 1, i + 5);
                    try {
                        int hex = Integer.parseInt(s, 16);
                        c = (char)hex;
                        i += 4;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Unicode escape is in bad format: \"" + s + "\"");
                    }
                }
                sb.append(c);
            } else if (c == '{') {
                if (sb.length() != 0) {
                    if (this.sections.length == 32766) {
                        throw new IllegalArgumentException("Cannot add more than 32766 sections");
                    }
                    this.addSection(sb.toString(), secattr);
                    sb.setLength(0);
                }
                int j = str.indexOf(125, i + 1);
                secattr = secattr.decode(str.substring(i, j + 1), this.defaultFont, this);
                i = j;
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (sb.length() != 0) {
            if (this.sections.length == 32766) {
                throw new IllegalArgumentException("Cannot add more than 32766 sections");
            }
            this.addSection(sb.toString(), secattr);
        }
    }

    @Override
    public MFont reuseFont(String name, int style, double size) {
        for (int k = 0; k < this.sections.length; ++k) {
            MFont f = this.sections[k].getAttributes().getBaseFont();
            if (f == null || f.getStyle() != style || f.getSizeDouble() != size || !f.getFamily().equals(name)) continue;
            return f;
        }
        return new MFont(name, style, size);
    }

    public void updateSubLevel(double[] sublevX, double x, int k) {
        Section sec = this.getSection(k);
        Section prevsec = k > 0 ? this.getSection(k - 1) : null;
        byte l = sec.getAttributes().getSubLevel();
        if (prevsec != null) {
            byte prevl = prevsec.getAttributes().getSubLevel();
            double prevx = sublevX[Math.abs(prevl)];
            for (int i = Math.abs(prevl) + 1; i < Math.abs(l); ++i) {
                sublevX[i] = prevx;
            }
        }
        sublevX[Math.abs((int)l)] = x;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String str = (String)in.readObject();
        try {
            this.readFromString(str);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String s = this.toString();
        out.writeObject(s);
    }

    private final int getSectionPos(int k) {
        return k == this.getSectionCount() ? this.length() : this.sections[k].getPosition();
    }

    private void deleteSections(int startk, int endk) {
        int dnsecs = endk - startk;
        if (dnsecs > 0) {
            int starti = this.getSectionPos(startk);
            int endi = this.getSectionPos(endk);
            int dnchars = endi - starti;
            Section[] newsections = new Section[this.sections.length - dnsecs];
            System.arraycopy(this.sections, 0, newsections, 0, startk);
            System.arraycopy(this.sections, endk, newsections, startk, newsections.length - startk);
            for (int k = startk; k < newsections.length; ++k) {
                newsections[k].position -= dnchars;
            }
            this.sections = newsections;
            short[] tmpcs = new short[this.charIndexToSectionIndex.length - dnchars];
            System.arraycopy(this.charIndexToSectionIndex, 0, tmpcs, 0, starti);
            for (int i = starti; i < tmpcs.length; ++i) {
                tmpcs[i] = (short)(this.charIndexToSectionIndex[i + dnchars] - dnsecs);
            }
            this.charIndexToSectionIndex = tmpcs;
            this.docLength -= dnchars;
            this.docText = null;
            this.updateShiftY();
        }
    }

    private void replaceSectionContent(int k, String s) {
        if (s.length() == 0) {
            this.deleteSections(k, k + 1);
            if (this.sections.length == 0) {
                this.setPlainText("");
            }
        } else {
            Section sec = this.sections[k];
            int i0 = sec.getPosition();
            String olds = sec.getString();
            int dnchars = s.length() - olds.length();
            sec.text = s;
            short[] tmpcs = new short[this.charIndexToSectionIndex.length + dnchars];
            int i1 = i0 + Math.min(s.length(), olds.length());
            System.arraycopy(this.charIndexToSectionIndex, 0, tmpcs, 0, i1);
            System.arraycopy(this.charIndexToSectionIndex, i0 + olds.length(), tmpcs, i0 + s.length(), tmpcs.length - i0 - s.length());
            if (s.length() > olds.length()) {
                for (int j = olds.length(); j < s.length(); ++j) {
                    tmpcs[i0 + j] = (short)k;
                }
            }
            this.charIndexToSectionIndex = tmpcs;
            ++k;
            while (k < this.sections.length) {
                this.sections[k++].position += dnchars;
            }
            this.docLength += dnchars;
        }
    }

    private void deleteSubstringFromSection(int k, int start, int end) {
        if (k == this.sections.length && start == 0 && start == end) {
            return;
        }
        Section sec = this.sections[k];
        String s = sec.getString();
        int i0 = sec.getPosition();
        int starti = i0 + start;
        int endi = i0 + end;
        int dnchars = end - start;
        sec.text = s.substring(0, start) + s.substring(end);
        short[] tmpcs = new short[this.charIndexToSectionIndex.length - dnchars];
        System.arraycopy(this.charIndexToSectionIndex, 0, tmpcs, 0, starti);
        System.arraycopy(this.charIndexToSectionIndex, endi, tmpcs, starti, tmpcs.length - starti);
        this.charIndexToSectionIndex = tmpcs;
        ++k;
        while (k < this.sections.length) {
            this.sections[k++].position -= dnchars;
        }
        this.docLength -= dnchars;
    }

    private void joinSectionsIfPossible(int startk, int endk) {
        for (int k = endk - 1; k >= startk - 1; --k) {
            this.joinSectionsIfPossible(k);
        }
    }

    private void joinSectionsIfPossible(int k0) {
        if (k0 < 0 || k0 >= this.sections.length - 1) {
            return;
        }
        Section sec = this.sections[k0];
        Section next = this.sections[k0 + 1];
        if (sec.getAttributes().equalsNext(next.getAttributes())) {
            int n1 = sec.text.length();
            int n2 = next.text.length();
            int i0 = this.getSectionPos(k0) + n1;
            sec.text = sec.text + next.text;
            Section[] newsections = new Section[this.sections.length - 1];
            System.arraycopy(this.sections, 0, newsections, 0, k0 + 1);
            System.arraycopy(this.sections, k0 + 2, newsections, k0 + 1, newsections.length - k0 - 1);
            this.sections = newsections;
            int i = i0;
            while (i < this.charIndexToSectionIndex.length) {
                int n = i++;
                this.charIndexToSectionIndex[n] = (short)(this.charIndexToSectionIndex[n] - 1);
            }
            this.updateShiftY();
        }
    }

    private void splitSection(int k0, int i0) {
        Section sec = this.sections[k0];
        int secpos = sec.getPosition();
        MTextAttributes secattr = sec.getAttributes();
        Section[] newsections = new Section[this.sections.length + 1];
        System.arraycopy(this.sections, 0, newsections, 0, k0);
        System.arraycopy(this.sections, k0 + 1, newsections, k0 + 2, newsections.length - k0 - 2);
        newsections[k0] = new Section(secpos, sec.substring(0, i0), secattr);
        secattr = secattr.createNext();
        newsections[k0 + 1] = new Section(secpos + i0, sec.substring(i0), secattr);
        this.sections = newsections;
        int i = secpos + i0;
        while (i < this.charIndexToSectionIndex.length) {
            int n = i++;
            this.charIndexToSectionIndex[n] = (short)(this.charIndexToSectionIndex[n] + 1);
        }
        this.updateShiftY();
    }

    private void addSection(String s, MTextAttributes attr) {
        int k = this.sections.length - 1;
        int dnchars = s.length();
        if (this.sections[k].length() == 0) {
            Section sec = this.sections[k];
            sec.text = s;
            sec.setAttributes(attr);
        } else {
            Section[] tmp = new Section[this.sections.length + 1];
            System.arraycopy(this.sections, 0, tmp, 0, this.sections.length);
            this.sections = tmp;
            this.sections[++k] = new Section(this.docLength, s, attr);
        }
        short[] tmpcs = new short[this.charIndexToSectionIndex.length + dnchars];
        System.arraycopy(this.charIndexToSectionIndex, 0, tmpcs, 0, this.charIndexToSectionIndex.length);
        for (int i = this.charIndexToSectionIndex.length; i < tmpcs.length; ++i) {
            tmpcs[i] = (short)k;
        }
        this.charIndexToSectionIndex = tmpcs;
        this.docLength += dnchars;
        this.docText = null;
        this.updateShiftY();
    }

    private void insertSection(int k0, String s, MTextAttributes attr) {
        int i;
        Section old = this.sections[k0];
        int pos = old.getPosition();
        int dnchars = s.length();
        Section[] tmp = new Section[this.sections.length + 1];
        System.arraycopy(this.sections, 0, tmp, 0, k0);
        System.arraycopy(this.sections, k0, tmp, k0 + 1, tmp.length - k0 - 1);
        tmp[k0] = new Section(pos, s, attr);
        for (int k = k0 + 1; k < tmp.length; ++k) {
            tmp[k].position += dnchars;
        }
        this.sections = tmp;
        short[] tmpcs = new short[this.charIndexToSectionIndex.length + dnchars];
        System.arraycopy(this.charIndexToSectionIndex, 0, tmpcs, 0, pos);
        for (i = pos; i < pos + dnchars; ++i) {
            tmpcs[i] = (short)k0;
        }
        for (i = pos + dnchars; i < tmpcs.length; ++i) {
            tmpcs[i] = (short)(this.charIndexToSectionIndex[i - dnchars] + 1);
        }
        this.charIndexToSectionIndex = tmpcs;
        this.docLength += dnchars;
        this.docText = null;
        this.updateShiftY();
    }

    private void updateShiftY() {
        if (this.sectionShiftY.length != this.sections.length) {
            this.sectionShiftY = new double[this.sections.length];
        }
        double[] sumdy = new double[256];
        int[] lastpos = new int[256];
        for (int i = 0; i < lastpos.length; ++i) {
            lastpos[i] = -1;
        }
        byte prevsubl = 0;
        int k = 0;
        while (k < this.sections.length) {
            Section sec = this.sections[k];
            MTextAttributes attr = sec.getAttributes();
            MFont mft = attr.getBaseFont();
            if (mft == null) {
                mft = this.defaultFont;
            }
            byte subl = attr.getSubLevel();
            int i = subl & 0xFF;
            double ftsz = mft.getSizeDouble() * attr.getScale();
            double dy = attr.getDy() * ftsz;
            if (Math.abs(subl) > Math.abs(prevsubl)) {
                sumdy[i] = sumdy[prevsubl & 0xFF] + dy;
            } else if (subl != 0 && subl == -prevsubl) {
                int abspl = subl > 0 ? subl - 1 : -subl - 1;
                int parentl = lastpos[abspl] > lastpos[-abspl & 0xFF] ? abspl : -abspl;
                sumdy[i] = sumdy[parentl & 0xFF] + dy;
            } else {
                int n = i;
                sumdy[n] = sumdy[n] + dy;
            }
            this.sectionShiftY[k] = sumdy[i];
            prevsubl = subl;
            lastpos[subl & 0xFF] = k++;
        }
    }

    public class Portion {
        private int startPosition;
        private int endPosition;

        public final int getStartPos() {
            return this.startPosition;
        }

        public final int getEndPos() {
            return this.endPosition;
        }

        public final int length() {
            return this.endPosition - this.startPosition;
        }

        public final double portionWidth(Graphics g, MFont dmfont, FontMetrics fm0) {
            return this.portionXAdvance(g, dmfont, fm0, false);
        }

        public final double portionXAdvance(Graphics g, MFont dmf, FontMetrics fm0) {
            return this.portionXAdvance(g, dmf, fm0, true);
        }

        public final double portionXAdvance(Graphics g, MFont dmfont, FontMetrics fm0, boolean lastxadv) {
            if (this.startPosition == this.endPosition && this.startPosition == MTextDocument.this.docLength) {
                return 0.0;
            }
            double[] sublevX = new double[256];
            int startk = MTextDocument.this.getSectionIndexOfCharAt(this.startPosition);
            int endk = MTextDocument.this.getSectionIndexOfCharAt(this.endPosition);
            int i0 = this.startPosition - MTextDocument.this.getSectionPos(startk);
            if (startk == endk) {
                int i1 = this.endPosition - MTextDocument.this.getSectionPos(endk);
                Section sec = MTextDocument.this.getSection(startk);
                String s = sec.substring(i0, i1);
                double w = sec.doubleStringWidth(s, dmfont, fm0, g);
                return w + sec.getAttributes().getDx();
            }
            Section sec = MTextDocument.this.getSection(startk);
            MTextAttributes secattr = sec.getAttributes();
            String s = sec.substring(i0);
            byte sublev = secattr.getSubLevel();
            double w = sec.doubleStringWidth(s, dmfont, fm0, g);
            MTextDocument.this.updateSubLevel(sublevX, w, startk);
            for (int k = startk + 1; k < endk; ++k) {
                sec = MTextDocument.this.getSection(k);
                secattr = sec.getAttributes();
                byte newsublev = secattr.getSubLevel();
                if (newsublev != 0 && newsublev == -sublev) {
                    w = sublevX[Math.abs(sublev) - 1];
                }
                sublev = newsublev;
                s = sec.getString();
                w += sec.doubleStringWidth(s, dmfont, fm0, g);
                MTextDocument.this.updateSubLevel(sublevX, w += sec.getAttributes().getDx(), k);
            }
            if (endk < MTextDocument.this.getSectionCount()) {
                sec = MTextDocument.this.getSection(endk);
                secattr = sec.getAttributes();
                i0 = this.endPosition - MTextDocument.this.getSectionPos(endk);
                byte newsublev = secattr.getSubLevel();
                if (newsublev != 0 && newsublev == -sublev && (i0 != 0 || lastxadv)) {
                    w = sublevX[Math.abs(sublev) - 1];
                }
                sublev = newsublev;
                if (i0 != 0 || lastxadv) {
                    s = sec.substring(0, i0);
                    w += sec.doubleStringWidth(s, dmfont, fm0, g);
                    MTextDocument.this.updateSubLevel(sublevX, w += sec.getAttributes().getDx(), endk);
                }
            }
            return w;
        }

        public final double getEndDx() {
            int endi;
            int endk = MTextDocument.this.getSectionIndexOfCharAt(this.endPosition);
            if (endk < MTextDocument.this.getSectionCount() && this.endPosition == (endi = MTextDocument.this.getSectionPos(endk))) {
                Section sec = MTextDocument.this.getSection(endk);
                return sec.getAttributes().getDx();
            }
            return 0.0;
        }

        public final double getAscent(Graphics g, FontMetrics fm0) {
            if (this.startPosition == this.endPosition && this.startPosition == MTextDocument.this.docLength) {
                return fm0.getAscent();
            }
            int startk = MTextDocument.this.getSectionIndexOfCharAt(this.startPosition);
            int endk = MTextDocument.this.getSectionIndexOfCharAt(this.endPosition);
            Section sec = MTextDocument.this.getSection(startk);
            FontMetrics fm = this.getFontMetrics(startk, g, fm0);
            MTextAttributes secattr = sec.getAttributes();
            double dy = MTextDocument.this.sectionShiftY[startk];
            double maxascent = (double)fm.getAscent() + dy;
            if (startk < endk) {
                int endi;
                double ascent;
                for (int k = startk + 1; k < endk; ++k) {
                    sec = MTextDocument.this.getSection(k);
                    fm = this.getFontMetrics(k, g, fm0);
                    secattr = sec.getAttributes();
                    dy = MTextDocument.this.sectionShiftY[k];
                    ascent = (double)fm.getAscent() + dy;
                    if (!(ascent > maxascent)) continue;
                    maxascent = ascent;
                }
                if (endk < MTextDocument.this.getSectionCount() && this.endPosition > (endi = MTextDocument.this.getSectionPos(endk))) {
                    fm = this.getFontMetrics(endk, g, fm0);
                    secattr = MTextDocument.this.getSection(endk).getAttributes();
                    dy = MTextDocument.this.sectionShiftY[endk];
                    ascent = (double)fm.getAscent() + dy;
                    if (ascent > maxascent) {
                        maxascent = ascent;
                    }
                }
            }
            return maxascent;
        }

        public final double getDescent(Graphics g, FontMetrics fm0) {
            if (this.startPosition == this.endPosition && this.startPosition == MTextDocument.this.docLength) {
                return fm0.getDescent();
            }
            int startk = MTextDocument.this.getSectionIndexOfCharAt(this.startPosition);
            int endk = MTextDocument.this.getSectionIndexOfCharAt(this.endPosition);
            Section sec = MTextDocument.this.getSection(startk);
            FontMetrics fm = this.getFontMetrics(startk, g, fm0);
            MTextAttributes secattr = sec.getAttributes();
            double dy = MTextDocument.this.sectionShiftY[startk];
            double maxdescent = (double)fm.getDescent() - dy;
            if (startk < endk) {
                int endi;
                double descent;
                for (int k = startk + 1; k < endk; ++k) {
                    sec = MTextDocument.this.getSection(k);
                    fm = this.getFontMetrics(k, g, fm0);
                    secattr = sec.getAttributes();
                    dy = MTextDocument.this.sectionShiftY[k];
                    descent = (double)fm.getDescent() - dy;
                    if (!(descent > maxdescent)) continue;
                    maxdescent = descent;
                }
                if (endk < MTextDocument.this.getSectionCount() && this.endPosition > (endi = MTextDocument.this.getSectionPos(endk))) {
                    fm = this.getFontMetrics(endk, g, fm0);
                    secattr = MTextDocument.this.getSection(endk).getAttributes();
                    dy = MTextDocument.this.sectionShiftY[endk];
                    descent = (double)fm.getDescent() - dy;
                    if (descent > maxdescent) {
                        maxdescent = descent;
                    }
                }
            }
            return maxdescent;
        }

        public final Portion getPortion(int start, int end) {
            return new Portion(this.startPosition + start, this.startPosition + end);
        }

        public final String getPlainText() {
            return MTextDocument.this.substring(this.startPosition, this.endPosition);
        }

        public final String toString() {
            int start = this.getStartPos();
            int end = this.getEndPos();
            StringBuffer sb = new StringBuffer("MTextDocument$Portion[");
            if (end == start + 1) {
                sb.append(start);
            } else if (end > start + 1) {
                sb.append(start);
                sb.append("..");
                sb.append(end - 1);
            }
            sb.append(']');
            return sb.toString();
        }

        public boolean endsWith(char c) {
            return this.endPosition > this.startPosition && MTextDocument.this.charAt(this.endPosition - 1) == c;
        }

        private Portion(int start, int end) {
            this.startPosition = start;
            this.endPosition = end;
        }

        private FontMetrics getFontMetrics(int k, Graphics g, FontMetrics fm0) {
            FontMetrics fm = MTextDocument.this.getSection(k).getFontMetrics(g, MTextDocument.this.getDefaultFont());
            return fm != null ? fm : fm0;
        }
    }

    public static class Section {
        private int position;
        private String text;
        private MTextAttributes attributes;
        private FontMetrics fontMetrics;

        public Section(int pos, String s) {
            this(pos, s, null);
        }

        public Section(int pos, String s, MTextAttributes attr) {
            this.position = pos;
            this.text = s;
            this.fontMetrics = null;
            this.attributes = attr != null ? attr : MTextAttributes.DEFAULT;
        }

        public Section(Section sec) {
            this.position = sec.position;
            this.text = sec.text;
            this.fontMetrics = sec.fontMetrics;
            this.attributes = sec.attributes;
        }

        public int getPosition() {
            return this.position;
        }

        public String getString() {
            return this.text;
        }

        public String substring(int start) {
            return this.text.substring(start);
        }

        public String substring(int start, int end) {
            return this.text.substring(start, end);
        }

        public int length() {
            return this.text.length();
        }

        public MTextAttributes getAttributes() {
            return this.attributes;
        }

        public FontMetrics getFontMetrics(Graphics g, MFont deffnt) {
            if (g != null) {
                FontMetrics fm;
                MTextAttributes attr = this.getAttributes();
                MFont mft = attr.getBaseFont();
                if (mft == null) {
                    mft = deffnt;
                }
                Font ft = mft.getScaledAWTFont(Float.valueOf((float)attr.getScale()));
                this.fontMetrics = fm = g.getFontMetrics(ft);
                return fm;
            }
            return this.fontMetrics;
        }

        public double doubleStringWidth(String s, MFont dmf, FontMetrics fm, Graphics g) {
            try {
                this.fontMetrics = this.fontMetrics == null && g != null ? this.getFontMetrics(g, dmf) : (this.fontMetrics == null ? fm : this.fontMetrics);
                Method m = FontMetrics.class.getMethod("getStringBounds", String.class, Graphics.class);
                Object o = m.invoke((Object)this.fontMetrics, s, g);
                return ((Rectangle2D)o).getWidth();
            }
            catch (Exception ex) {
                return fm.stringWidth(s);
            }
        }

        private void setAttributes(MTextAttributes p) {
            this.attributes = p;
            this.fontMetrics = null;
        }
    }
}

