/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MBooleanProp
extends MProp {
    private static final long serialVersionUID = -5366978422380739811L;
    private transient boolean booleanValue;

    public MBooleanProp(boolean v) {
        this.booleanValue = v;
    }

    public MBooleanProp(String s) {
        if (s == null) {
            throw new NullPointerException("MBooleanProp cannot be created with null argument");
        }
        this.booleanValue = Boolean.valueOf(s);
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public Object getPropValue() {
        return new Boolean(this.booleanValue);
    }

    public final boolean booleanValue() {
        return this.booleanValue;
    }

    @Override
    public String getPropType() {
        return "boolean";
    }

    @Override
    public String getPropXSDType() {
        return "boolean";
    }

    @Override
    public MProp cloneProp() {
        return new MBooleanProp(this.booleanValue);
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.booleanValue = in.readBoolean();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.booleanValue);
    }

    public boolean equals(Object o) {
        MBooleanProp p;
        return o instanceof MBooleanProp && (p = (MBooleanProp)o).booleanValue() == this.booleanValue();
    }

    @Override
    public String toString() {
        return Boolean.toString(this.booleanValue);
    }
}

