/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.common.util.Base64Util;
import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class MByteArrayProp
extends MProp {
    private static final long serialVersionUID = -4046371792715339701L;
    private transient byte[] byteValues;

    public MByteArrayProp(byte[] x) {
        int n = x.length;
        this.byteValues = new byte[n];
        System.arraycopy(x, 0, this.byteValues, 0, n);
    }

    public MByteArrayProp(String sval, int size, int c) throws IllegalArgumentException {
        try {
            this.byteValues = Base64Util.decode(sval);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public int getPropArraySize() {
        return this.byteValues.length;
    }

    @Override
    public String convertToString(String fmt, int flags) throws MolExportException {
        try {
            MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
            return handler.convertToString(this, fmt);
        }
        catch (IllegalArgumentException e) {
            throw new MolExportException(e);
        }
    }

    @Override
    public Object getPropValue() {
        return this.byteValues;
    }

    public final byte[] getByteArray() {
        return this.byteValues;
    }

    @Override
    public String getPropType() {
        return "byte";
    }

    @Override
    public String getPropXSDType() {
        return "byte";
    }

    @Override
    public MProp cloneProp() {
        return new MByteArrayProp(this.byteValues);
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        byte[] x = new byte[n];
        for (int i = 0; i < n; ++i) {
            x[i] = in.readByte();
        }
        this.byteValues = x;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        byte[] x = this.byteValues;
        out.writeInt(x.length);
        for (int i = 0; i < x.length; ++i) {
            out.writeByte(x[i]);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MByteArrayProp) {
            MByteArrayProp p = (MByteArrayProp)o;
            if (Arrays.equals(this.getByteArray(), p.getByteArray())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        try {
            return Base64Util.encode(this.byteValues);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

