/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MDoubleProp
extends MProp {
    private static final long serialVersionUID = -1221776439131689653L;
    private transient double doubleValue;

    public MDoubleProp(double x) {
        this.doubleValue = x;
    }

    public MDoubleProp(String sval) throws IllegalArgumentException {
        try {
            this.doubleValue = Double.valueOf(sval.trim());
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public Object getPropValue() {
        return new Double(this.doubleValue);
    }

    public final double doubleValue() {
        return this.doubleValue;
    }

    @Override
    public String getPropType() {
        return "double";
    }

    @Override
    public String getPropXSDType() {
        return "double";
    }

    @Override
    public MProp cloneProp() {
        return new MDoubleProp(this.doubleValue());
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.doubleValue = in.readDouble();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.doubleValue());
    }

    public boolean equals(Object o) {
        MDoubleProp p;
        return o instanceof MDoubleProp && this.doubleValue == (p = (MDoubleProp)o).doubleValue();
    }

    @Override
    public String toString() {
        return Double.toString(this.doubleValue);
    }
}

