/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import chemaxon.struc.graphics.MFont;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MFontProp
extends MProp {
    private transient MFont fontValue;
    static final long serialVersionUID = 2369581307328116455L;

    public MFontProp(Font f) {
        if (f == null) {
            throw new NullPointerException("MFontProp cannot be created with null argument.");
        }
        this.fontValue = new MFont(f);
    }

    public MFontProp(String fntStr) {
        this.fontValue = new MFont(fntStr);
    }

    public MFontProp(MFont mfp) {
        this.fontValue = new MFont(mfp);
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    public MFont getFont() {
        return this.fontValue;
    }

    @Override
    public Object getPropValue() {
        return this.fontValue.getString();
    }

    @Override
    public String getPropType() {
        return "mfont";
    }

    @Override
    public String getPropXSDType() {
        return "mfont";
    }

    @Override
    public MProp cloneProp() {
        return new MFontProp(this.fontValue);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String fontStr = in.readUTF();
        this.fontValue = new MFont(fontStr);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.convertToString(null, 0));
    }

    public boolean equals(Object o) {
        MFontProp p;
        return o instanceof MFontProp && this.fontValue.equals((p = (MFontProp)o).getFont());
    }

    @Override
    public String toString() {
        return this.fontValue.getString();
    }
}

