/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MProp;
import chemaxon.struc.MTransformable;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MHCoords3DProp
extends MProp
implements MTransformable {
    private static final long serialVersionUID = 6646271128663088908L;
    private transient HashMap<Integer, DPoint3[]> coordMap = new HashMap();

    public MHCoords3DProp(Map<MolAtom, DPoint3[]> map, MoleculeGraph m) {
        for (MolAtom key : map.keySet()) {
            DPoint3[] val = map.get(key);
            this.coordMap.put(new Integer(m.indexOf(key)), val);
        }
        this.setCoordDependent(m.getGrinvCC());
    }

    public MHCoords3DProp(Map<Integer, DPoint3[]> map, long grinvCC) {
        for (Integer key : map.keySet()) {
            DPoint3[] val = map.get(key);
            this.coordMap.put(key, val);
        }
        this.setCoordDependent(grinvCC);
    }

    public MHCoords3DProp(String sval) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(sval, " \t\r\n");
        try {
            while (st.hasMoreTokens()) {
                int k = Integer.parseInt(st.nextToken());
                int n = Integer.parseInt(st.nextToken());
                DPoint3[] points = new DPoint3[n];
                for (int i = 0; i < n; ++i) {
                    double x = Double.parseDouble(st.nextToken());
                    double y = Double.parseDouble(st.nextToken());
                    double z = Double.parseDouble(st.nextToken());
                    points[i] = new DPoint3(x, y, z);
                }
                this.coordMap.put(new Integer(k), points);
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.setCoordDependent(0L);
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public Object getPropValue() {
        return this.coordMap.clone();
    }

    public final Map<MolAtom, DPoint3[]> getMap(MoleculeGraph m) {
        Iterator<Integer> it = this.coordMap.keySet().iterator();
        HashMap<MolAtom, DPoint3[]> map = new HashMap<MolAtom, DPoint3[]>();
        while (it.hasNext()) {
            Integer o;
            Integer k = o = it.next();
            MolAtom a = m.getAtom(k);
            map.put(a, this.coordMap.get(k));
        }
        return map;
    }

    public final DPoint3[] getPoints(int k) {
        return this.coordMap.get(new Integer(k));
    }

    @Override
    public String getPropType() {
        return "MHCoords3D";
    }

    @Override
    public String getPropXSDType() {
        return "ENTITY";
    }

    @Override
    public MProp cloneProp() {
        return new MHCoords3DProp(this.coordMap, this.getGrinvCC());
    }

    public Object clone() {
        return this.cloneProp();
    }

    @Override
    public void transform(CTransform3D t) {
        for (DPoint3[] points : this.coordMap.values()) {
            for (int i = 0; i < points.length; ++i) {
                t.transform(points[i]);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.coordMap = new HashMap();
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            int k = in.readInt();
            int npoints = in.readInt();
            DPoint3[] p = new DPoint3[npoints];
            for (int j = 0; j < npoints; ++j) {
                double x = in.readDouble();
                double y = in.readDouble();
                double z = in.readDouble();
                p[j] = new DPoint3(x, y, z);
            }
            this.coordMap.put(new Integer(k), p);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Set<Integer> keySet = this.coordMap.keySet();
        Iterator<Integer> it = keySet.iterator();
        out.writeInt(keySet.size());
        while (it.hasNext()) {
            Integer k = it.next();
            DPoint3[] p = this.coordMap.get(k);
            out.writeInt(k);
            out.writeInt(p.length);
            for (int i = 0; i < p.length; ++i) {
                out.writeDouble(p[i].x);
                out.writeDouble(p[i].y);
                out.writeDouble(p[i].z);
            }
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MHCoords3DProp) {
            MHCoords3DProp p = (MHCoords3DProp)o;
            Iterator<Integer> it1 = this.coordMap.keySet().iterator();
            Iterator<Integer> it2 = p.coordMap.keySet().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Integer k2;
                DPoint3[] points2;
                Integer k1 = it1.next();
                DPoint3[] points1 = this.coordMap.get(k1);
                if (points1.length != (points2 = p.coordMap.get(k2 = it2.next())).length) {
                    return false;
                }
                for (int i = 0; i < points1.length; ++i) {
                    DPoint3 dPoint1 = points1[i];
                    DPoint3 dPoint2 = points2[i];
                    if (dPoint1.equals(dPoint2)) continue;
                    return false;
                }
            }
            return !it1.hasNext() && !it2.hasNext();
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Integer> it = this.coordMap.keySet().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Integer k = it.next();
            DPoint3[] points = this.coordMap.get(k);
            if (first) {
                sb.append('\n');
            }
            sb.append(k);
            sb.append(' ');
            sb.append(points.length);
            for (int i = 0; i < points.length; ++i) {
                sb.append(' ');
                sb.append(points[i].x);
                sb.append(' ');
                sb.append(points[i].y);
                sb.append(' ');
                sb.append(points[i].z);
            }
            first = true;
        }
        return sb.toString();
    }
}

