/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import chemaxon.struc.prop.MCollectionProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MHashProp
extends MCollectionProp {
    private static final long serialVersionUID = 5457649877894058447L;
    private transient ArrayList<String> propKeys;
    private transient HashMap<String, MProp> propHash;

    public MHashProp() {
        this.propKeys = new ArrayList();
        this.propHash = new HashMap();
    }

    protected MHashProp(MHashProp other, Set xprops) {
        this.propKeys = (ArrayList)other.propKeys.clone();
        this.propHash = new HashMap();
        for (int i = 0; i < other.size(); ++i) {
            String key = other.getKey(i);
            MProp p = other.get(i);
            if (!(p == null || xprops != null && xprops.contains(p))) {
                p = p instanceof MCollectionProp ? ((MCollectionProp)p).cloneCollectionProp(xprops) : p.cloneProp();
            }
            this.propHash.put(key.toLowerCase(), p);
        }
    }

    @Override
    public int getPropArraySize() {
        return this.propKeys.size();
    }

    @Override
    public String convertToString(String fmt, int flags) throws MolExportException {
        try {
            MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
            return handler.convertToString(this, fmt, flags);
        }
        catch (IllegalArgumentException e) {
            throw new MolExportException(e);
        }
    }

    @Override
    public Object getPropValue() {
        return this.propHash;
    }

    public final Map<String, MProp> getMap() {
        return this.propHash;
    }

    public final int size() {
        return this.propKeys.size();
    }

    public final String getKey(int i) {
        return this.propKeys.get(i);
    }

    public final MProp get(int i) {
        String key = this.propKeys.get(i);
        return this.get(key);
    }

    public final MProp get(String key) {
        return this.propHash.get(key.toLowerCase());
    }

    public final void put(String key, MProp v) {
        int n = this.propHash.size();
        if (v == null) {
            this.propHash.remove(key.toLowerCase());
            if (this.propHash.size() != n) {
                for (int i = 0; i < this.propKeys.size(); ++i) {
                    String s = this.propKeys.get(i);
                    if (!s.equalsIgnoreCase(key)) continue;
                    this.propKeys.remove(i);
                    break;
                }
            }
        } else {
            this.propHash.put(key.toLowerCase(), v);
            if (this.propHash.size() != n) {
                this.propKeys.add(key);
            }
        }
    }

    @Override
    public Iterator unorderedIterator() {
        return this.propHash.entrySet().iterator();
    }

    @Override
    public void replace(MProp oldp, MProp newp) {
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getKey(i);
            MProp p = this.get(i);
            if (p == oldp) {
                if (newp != null) {
                    this.propHash.put(key.toLowerCase(), newp);
                    continue;
                }
                this.propKeys.remove(i);
                this.propHash.remove(key.toLowerCase());
                --i;
                continue;
            }
            if (!(p instanceof MCollectionProp)) continue;
            ((MCollectionProp)p).replace(oldp, newp);
        }
    }

    @Override
    public String getPropType() {
        return "MHashProp";
    }

    @Override
    public final MCollectionProp cloneCollectionProp(Set xprops) {
        return new MHashProp(this, xprops);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        this.propHash = new HashMap();
        for (int i = 0; i < n; ++i) {
            String key = in.readUTF();
            MProp p = (MProp)in.readObject();
            this.propHash.put(key.toLowerCase(), p);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int n = this.size();
        out.writeInt(n);
        for (int i = 0; i < n; ++i) {
            String key = this.getKey(i);
            MProp p = this.get(i);
            out.writeUTF(key);
            out.writeObject(p);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MHashProp) {
            MHashProp p = (MHashProp)o;
            if (this.propKeys.equals(p.propKeys) && this.propHash.equals(p.propHash)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            String key = this.getKey(i);
            MProp p = this.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("[");
            sb.append(key);
            sb.append("=");
            sb.append(p.toString());
            sb.append("]");
        }
        return sb.toString();
    }
}

