/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MIntegerProp
extends MProp {
    private static final long serialVersionUID = -7179550727198941747L;
    private transient int intValue;

    public MIntegerProp(int x) {
        this.intValue = x;
    }

    public MIntegerProp(String sval) throws IllegalArgumentException {
        try {
            this.intValue = Integer.parseInt(sval.trim());
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public Object getPropValue() {
        return new Integer(this.intValue);
    }

    public final int intValue() {
        return this.intValue;
    }

    @Override
    public String getPropType() {
        return "integer";
    }

    @Override
    public String getPropXSDType() {
        return "integer";
    }

    @Override
    public MProp cloneProp() {
        return new MIntegerProp(this.intValue());
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.intValue = in.readInt();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.intValue());
    }

    public boolean equals(Object o) {
        if (o instanceof MIntegerProp) {
            MIntegerProp p = (MIntegerProp)o;
            if (this.intValue == p.intValue) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return Integer.toString(this.intValue);
    }
}

