/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import chemaxon.struc.prop.MCollectionProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MListProp
extends MCollectionProp {
    private static final long serialVersionUID = 5360371881677476960L;
    private transient ArrayList<MProp> propList;

    public MListProp() {
        this.propList = new ArrayList();
    }

    protected MListProp(MListProp other, Set xprops) {
        int n = other.propList.size();
        this.propList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            MProp p = other.propList.get(i);
            if (!(p == null || xprops != null && xprops.contains(p))) {
                p = p instanceof MCollectionProp ? ((MCollectionProp)p).cloneCollectionProp(xprops) : p.cloneProp();
            }
            this.propList.add(p);
        }
    }

    @Override
    public int getPropArraySize() {
        return this.propList.size();
    }

    @Override
    public String convertToString(String fmt, int flags) throws MolExportException {
        try {
            MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
            return handler.convertToString(this, fmt, flags);
        }
        catch (IllegalArgumentException e) {
            throw new MolExportException(e);
        }
    }

    @Override
    public Object getPropValue() {
        return this.propList;
    }

    public final List<MProp> getList() {
        return this.propList;
    }

    public final int size() {
        return this.propList.size();
    }

    public final MProp get(int i) {
        return this.propList.get(i);
    }

    public final void set(int i, MProp p) {
        this.propList.set(i, p);
    }

    public final void remove(int i) {
        this.propList.remove(i);
    }

    public final void add(MProp p) {
        this.propList.add(p);
    }

    @Override
    public Iterator<MProp> unorderedIterator() {
        return this.propList.iterator();
    }

    @Override
    public void replace(MProp oldp, MProp newp) {
        for (int i = 0; i < this.size(); ++i) {
            MProp p = this.get(i);
            if (p == oldp) {
                if (newp != null) {
                    this.propList.set(i, newp);
                    continue;
                }
                this.propList.remove(i);
                --i;
                continue;
            }
            if (!(p instanceof MCollectionProp)) continue;
            ((MCollectionProp)p).replace(oldp, newp);
        }
    }

    @Override
    public String getPropType() {
        return "MListProp";
    }

    @Override
    public MCollectionProp cloneCollectionProp(Set xprops) {
        return new MListProp(this, xprops);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        ArrayList<MProp> x = new ArrayList<MProp>(n);
        for (int i = 0; i < n; ++i) {
            MProp p = (MProp)in.readObject();
            x.add(p);
        }
        this.propList = x;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ArrayList<MProp> x = this.propList;
        out.writeInt(x.size());
        for (int i = 0; i < x.size(); ++i) {
            MProp p = x.get(i);
            out.writeObject(p);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MListProp) {
            MListProp p = (MListProp)o;
            if (this.propList.equals(p.propList)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.propList.size(); ++i) {
            MProp p = this.propList.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("[");
            if (p != null) {
                sb.append(p.toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

