/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MMoleculeProp
extends MProp {
    private static final long serialVersionUID = -7687559780023024273L;
    private transient Molecule molecule;

    public MMoleculeProp(Molecule m) {
        if (m == null) {
            throw new NullPointerException("MMoleculeProp cannot be created with null argument");
        }
        this.molecule = m;
    }

    public MMoleculeProp(String sval) throws IOException {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        this.molecule = handler.parseMolecule(sval);
    }

    @Override
    public String convertToString(String fmt, int flags) throws MolExportException {
        try {
            MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
            return handler.convertToString(this, fmt, flags);
        }
        catch (IllegalArgumentException e) {
            throw new MolExportException(e);
        }
    }

    @Override
    public Object getPropValue() {
        return this.molecule;
    }

    public Molecule getMolecule() {
        return this.molecule;
    }

    @Override
    public String getPropType() {
        return "Molecule";
    }

    @Override
    public String getPropXSDType() {
        return "ENTITY";
    }

    @Override
    public MProp cloneProp() {
        Molecule m = this.getMolecule();
        if (m != null) {
            MDocument doc = m.getDocument();
            m = doc != null ? doc.cloneMainMolecule() : m.cloneMolecule();
        }
        return new MMoleculeProp(m);
    }

    public Object clone() {
        return this.cloneProp();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        String sval = in.readUTF();
        this.molecule = handler.parseMolecule(sval);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.convertToString("mrv", 0));
    }

    public boolean equals(Object o) {
        if (o instanceof MMoleculeProp) {
            MMoleculeProp p = (MMoleculeProp)o;
            if (this.molecule.equals(p.molecule)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Number of atoms: " + this.molecule.getAtomCount() + "\n");
        sb.append("Number of bonds: " + this.molecule.getBondCount() + "\n");
        return sb.toString();
    }
}

