/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.prop;

import chemaxon.core.spi.MPropHandlerIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.MProp;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MStringProp
extends MProp {
    private static final long serialVersionUID = 1373831606368751112L;
    private transient String stringValue;

    public MStringProp(String s) {
        if (s == null) {
            throw new NullPointerException("MStringProp cannot be created with null argument");
        }
        this.stringValue = s;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    @Override
    public String convertToString(String fmt, int flags) {
        MPropHandlerIface handler = (MPropHandlerIface)MarvinModule.load("chemaxon.marvin.io.MPropHandlerUtil");
        return handler.convertToString(this, fmt);
    }

    @Override
    public Object getPropValue() {
        return this.stringValue;
    }

    @Override
    public String getPropType() {
        return "string";
    }

    @Override
    public String getPropXSDType() {
        return "string";
    }

    @Override
    public MProp cloneProp() {
        return new MStringProp(this.stringValue);
    }

    public Object clone() {
        return this.cloneProp();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        String s = this.stringValue;
        if (s != null && s.length() > 16) {
            s = s.substring(0, 13) + "...";
        }
        sb.append("[\"");
        sb.append(s);
        sb.append("\"]");
        return sb.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.stringValue = in.readUTF();
        if (this.stringValue == null) {
            throw new NullPointerException("MStringProp cannot deserialize null string");
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.stringValue);
    }

    public boolean equals(Object o) {
        if (o instanceof MStringProp) {
            MStringProp p = (MStringProp)o;
            if (this.stringValue.equals(p.stringValue)) {
                return true;
            }
        }
        return false;
    }
}

