/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.struc.sgroup;

import chemaxon.core.util.GeomUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class RepeatingUnitSgroup
extends Sgroup {
    private static final long serialVersionUID = -3209611525734625009L;
    private transient boolean flipped = false;
    private transient MolBond[] headCrossingBonds = null;
    private transient MolBond[] tailCrossingBonds = null;

    public RepeatingUnitSgroup(Molecule parent, int type) {
        super(parent, type);
    }

    public RepeatingUnitSgroup(Molecule parent, String connectivity, int type) {
        super(parent, type);
        if (connectivity.startsWith("ht")) {
            this.setConnectivity(2);
        } else if (connectivity.startsWith("hh")) {
            this.setConnectivity(1);
        } else if (connectivity.startsWith("eu")) {
            this.setConnectivity(0);
        }
        if (connectivity.endsWith("f")) {
            this.setFlipped(true);
        }
    }

    protected RepeatingUnitSgroup(RepeatingUnitSgroup sg, Molecule m, Sgroup psg, int[] atomIndexMap) {
        super(sg, m, psg, atomIndexMap);
        this.flipped = sg.flipped;
        if (sg.getParentMolecule() != null && this.getParentMolecule() != null) {
            int k;
            MolBond b;
            int i;
            if (sg.headCrossingBonds != null) {
                this.headCrossingBonds = new MolBond[sg.headCrossingBonds.length];
                for (i = 0; i < sg.headCrossingBonds.length; ++i) {
                    b = sg.headCrossingBonds[i];
                    k = sg.getParentMolecule().indexOf(b);
                    if (k == -1) {
                        this.headCrossingBonds = null;
                        break;
                    }
                    this.headCrossingBonds[i] = this.getParentMolecule().getBond(k);
                }
            }
            if (sg.tailCrossingBonds != null) {
                this.tailCrossingBonds = new MolBond[sg.tailCrossingBonds.length];
                for (i = 0; i < sg.tailCrossingBonds.length; ++i) {
                    b = sg.tailCrossingBonds[i];
                    k = sg.getParentMolecule().indexOf(b);
                    if (k == -1) {
                        this.tailCrossingBonds = null;
                        break;
                    }
                    this.tailCrossingBonds[i] = this.getParentMolecule().getBond(k);
                }
            }
        }
    }

    protected RepeatingUnitSgroup(RepeatingUnitSgroup sg, Molecule m, Sgroup psg) {
        this(sg, m, psg, null);
    }

    @Override
    protected Sgroup cloneSgroup(Molecule m, Sgroup psg, int[] atomIndexMap) {
        return new RepeatingUnitSgroup(this, m, psg, atomIndexMap);
    }

    @Override
    public String getSuperscript() {
        String s = this.getConnectivity() == 1 ? new String("hh") : (this.getConnectivity() == 2 ? new String("ht") : (this.getConnectivity() == 0 ? new String("eu") : new String("")));
        if (this.isFlipped()) {
            s = s.concat(",f");
        }
        return s;
    }

    public static boolean isAcceptableSru(String s) {
        String label = s.trim();
        boolean simpleSruLabel = false;
        if (label.length() == 1) {
            simpleSruLabel = label.charAt(0) >= 'a' && label.charAt(0) <= 'z' || label.charAt(0) >= 'A' && label.charAt(0) <= 'Z';
        }
        return simpleSruLabel;
    }

    public static boolean isAcceptablePolymerGraph(MoleculeGraph molGraph) {
        int crossingBondCount = 0;
        for (int i = 0; crossingBondCount < 2 && i < molGraph.getAtomCount(); ++i) {
            MolAtom a = molGraph.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                if (molGraph.contains(aa)) continue;
                ++crossingBondCount;
            }
        }
        return crossingBondCount != 1;
    }

    public static boolean isAcceptableRSRUGraph(MoleculeGraph molGraph) {
        ArrayList<MolBond> crossingBonds = new ArrayList<MolBond>();
        for (int i = 0; i < molGraph.getAtomCount(); ++i) {
            MolAtom a = molGraph.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                if (molGraph.contains(aa)) continue;
                crossingBonds.add(b);
            }
        }
        if (crossingBonds.size() == 4) {
            DPoint3[] corners = molGraph.getEnclosingCube();
            DPoint3 cornerBottomLeft = corners[0];
            DPoint3 cornerTopRight = corners[1];
            DPoint3 cornerBottomRight = new DPoint3(cornerTopRight.x, cornerBottomLeft.y, 0.0);
            DPoint3 cornerTopLeft = new DPoint3(cornerBottomLeft.x, cornerTopRight.y, 0.0);
            MolBond[] crossingBondsArray = new MolBond[crossingBonds.size()];
            crossingBonds.toArray(crossingBondsArray);
            MolBond[] head = GeomUtil.getCrossingBonds(crossingBondsArray, cornerBottomLeft, cornerTopLeft, true);
            MolBond[] tail = GeomUtil.getCrossingBonds(crossingBondsArray, cornerBottomRight, cornerTopRight, true);
            if (head.length == 2 && tail.length == 2) {
                return true;
            }
        }
        return crossingBonds.size() <= 2;
    }

    public void addStarAtoms() {
        if (RepeatingUnitSgroup.isAcceptableSru(this.getSubscript()) || this.sgroupType == 11 || this.sgroupType == 5 || this.sgroupType == 6 || this.sgroupType == 15 || this.sgroupType == 7) {
            int c = MolAtom.getAtomicNumber("C");
            for (int i = 0; i < this.getAtomCount(); ++i) {
                MolAtom a = this.getAtom(i);
                for (int j = a.getBondCount() - 1; j >= 0; --j) {
                    MolAtom a2 = a.getBond(j).getOtherAtom(a);
                    if (this.indexOf(a2) != -1 || a2.getBondCount() >= 2 || a2.getAtno() != c) continue;
                    a2.setAtno(133);
                    a2.valenceCheck();
                }
            }
        }
    }

    public void removeStarAtoms() {
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = this.getAtom(i);
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b = a.getBond(j);
                MolAtom other = b.getOtherAtom(a);
                if (other.getAtno() != 133) continue;
                other.setAtno(MolAtom.getAtomicNumber("C"));
            }
        }
    }

    public boolean isStarAtom(MolAtom atom) {
        for (int i = this.getAtomCount() - 1; i >= 0; --i) {
            MolAtom a = this.getAtom(i);
            for (int j = a.getBondCount() - 1; j >= 0; --j) {
                MolBond b = a.getBond(j);
                MolAtom other = b.getOtherAtom(a);
                if (other.getAtno() != 133 || other != atom) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public MolBond[] findCrossingBonds() {
        ArrayList<MolBond> vb = new ArrayList<MolBond>();
        for (int i = 0; i < this.sgroupGraph.getAtomCount(); ++i) {
            MolAtom a = this.sgroupGraph.getAtom(i);
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b = a.getBond(j);
                MolAtom aa = b.getOtherAtom(a);
                if (this.sgroupGraph.contains(aa)) continue;
                if (aa instanceof SgroupAtom) {
                    SuperatomSgroup sg = ((SgroupAtom)aa).getSgroup();
                    if (sg.isDescendantOf(this)) continue;
                    vb.add(b);
                    continue;
                }
                vb.add(b);
            }
        }
        MolBond[] crossingBonds = new MolBond[vb.size()];
        vb.toArray(crossingBonds);
        return crossingBonds;
    }

    public void mergeBrackets(MolBond b1, MolBond b2) {
        if (this.headCrossingBonds == null) {
            this.headCrossingBonds = new MolBond[2];
            this.headCrossingBonds[0] = b1;
            this.headCrossingBonds[1] = b2;
        } else if (this.tailCrossingBonds == null) {
            this.tailCrossingBonds = new MolBond[2];
            this.tailCrossingBonds[0] = b1;
            this.tailCrossingBonds[1] = b2;
        }
    }

    private MolBond calcConnectingCrossingBond(boolean flip) {
        MolBond connectingCrossingBond = null;
        if (this.tailCrossingBonds == null || this.headCrossingBonds == null) {
            return null;
        }
        switch (this.getConnectivity()) {
            case 1: {
                connectingCrossingBond = flip ? this.headCrossingBonds[1] : this.headCrossingBonds[0];
                break;
            }
            case 2: {
                DPoint3 c = new DPoint3();
                DPoint3 p0 = this.indexOf(this.headCrossingBonds[0].getAtom1()) < 0 ? this.headCrossingBonds[0].getAtom1().getLocation() : this.headCrossingBonds[0].getAtom2().getLocation();
                DPoint3 p1 = this.indexOf(this.headCrossingBonds[1].getAtom1()) < 0 ? this.headCrossingBonds[1].getAtom1().getLocation() : this.headCrossingBonds[1].getAtom2().getLocation();
                DPoint3 p2 = this.indexOf(this.tailCrossingBonds[0].getAtom1()) < 0 ? this.tailCrossingBonds[0].getAtom1().getLocation() : this.tailCrossingBonds[0].getAtom2().getLocation();
                DPoint3 p3 = this.indexOf(this.tailCrossingBonds[1].getAtom1()) < 0 ? this.tailCrossingBonds[1].getAtom1().getLocation() : this.tailCrossingBonds[1].getAtom2().getLocation();
                c.x = (p0.x + p1.x + p2.x + p3.x) / 4.0;
                c.y = (p0.y + p1.y + p2.y + p3.y) / 4.0;
                c.z = (p0.z + p1.z + p2.z + p3.z) / 4.0;
                int nearest = GeomUtil.calculateAngle(p0, p2, c) < GeomUtil.calculateAngle(p0, p3, c) ? 0 : 1;
                int furthest = nearest == 1 ? 0 : 1;
                connectingCrossingBond = flip ? this.tailCrossingBonds[furthest] : this.tailCrossingBonds[nearest];
                break;
            }
            case 0: {
                break;
            }
        }
        return connectingCrossingBond;
    }

    public boolean isCrossingBond(MolBond b) {
        boolean isCrossing = false;
        if (this.headCrossingBonds != null) {
            isCrossing |= this.headCrossingBonds[0] == b || this.headCrossingBonds[1] == b;
        }
        if (this.tailCrossingBonds != null) {
            isCrossing |= this.tailCrossingBonds[0] == b || this.tailCrossingBonds[1] == b;
        }
        return isCrossing;
    }

    public MolBond getOtherCrossingBond(MolBond b) {
        if (this.headCrossingBonds != null) {
            if (this.headCrossingBonds[0] == b) {
                return this.headCrossingBonds[1];
            }
            if (this.headCrossingBonds[1] == b) {
                return this.headCrossingBonds[0];
            }
        }
        if (this.tailCrossingBonds != null) {
            if (this.tailCrossingBonds[0] == b) {
                return this.tailCrossingBonds[1];
            }
            if (this.tailCrossingBonds[1] == b) {
                return this.tailCrossingBonds[0];
            }
        }
        return null;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    public MolBond[] getBondConnectionInfo() {
        MolBond connectingCrossingBond = this.calcConnectingCrossingBond(this.flipped);
        if (this.headCrossingBonds != null && this.tailCrossingBonds != null && connectingCrossingBond != null) {
            MolBond[] cb = new MolBond[]{this.headCrossingBonds[0], this.headCrossingBonds[1], connectingCrossingBond};
            return cb;
        }
        return null;
    }

    public MolBond[] getBondCorrespondence() {
        MolBond[] cb = null;
        MolBond connectingCrossingBond = this.calcConnectingCrossingBond(this.flipped);
        if (this.headCrossingBonds != null && this.tailCrossingBonds != null && connectingCrossingBond != null) {
            if (this.getConnectivity() == 1) {
                cb = new MolBond[]{this.headCrossingBonds[0], this.flipped ? this.headCrossingBonds[1] : this.headCrossingBonds[0], this.headCrossingBonds[1], this.flipped ? this.headCrossingBonds[0] : this.headCrossingBonds[1]};
            } else if (this.getConnectivity() == 2) {
                cb = new MolBond[]{this.headCrossingBonds[0], connectingCrossingBond, this.headCrossingBonds[1], connectingCrossingBond == this.tailCrossingBonds[0] ? this.tailCrossingBonds[1] : this.tailCrossingBonds[0]};
            }
        }
        return cb;
    }

    public void setBondCorrespondence(MolBond[] b) {
        if (b.length == 4) {
            MolBond connectingCrossingBond = null;
            if (this.headCrossingBonds == null) {
                this.headCrossingBonds = new MolBond[2];
                this.headCrossingBonds[0] = b[0];
                this.headCrossingBonds[1] = b[2];
                connectingCrossingBond = b[1];
                this.tailCrossingBonds = new MolBond[2];
                this.tailCrossingBonds[0] = b[1];
                this.tailCrossingBonds[1] = b[3];
            } else if (this.headCrossingBonds[0] == b[0] && this.headCrossingBonds[1] == b[2]) {
                this.tailCrossingBonds = new MolBond[2];
                this.tailCrossingBonds[0] = b[1];
                this.tailCrossingBonds[1] = b[3];
                connectingCrossingBond = b[1];
            } else if (this.headCrossingBonds[0] == b[1] && this.headCrossingBonds[1] == b[3]) {
                this.tailCrossingBonds = new MolBond[2];
                this.tailCrossingBonds[0] = b[0];
                this.tailCrossingBonds[1] = b[2];
                connectingCrossingBond = b[0];
            }
            if (!this.equalsTail(this.headCrossingBonds)) {
                this.setConnectivity(2);
            }
            boolean bl = this.flipped = this.calcConnectingCrossingBond(true) == connectingCrossingBond;
            if (this.equalsTail(this.headCrossingBonds)) {
                this.tailCrossingBonds = null;
            }
        }
    }

    public boolean equalsTail(MolBond[] bonds) {
        if (this.tailCrossingBonds == null && bonds == null) {
            return true;
        }
        if (this.tailCrossingBonds == null || bonds == null) {
            return false;
        }
        if (this.tailCrossingBonds.length == 2 && bonds.length == 2) {
            return this.tailCrossingBonds[0] == bonds[0] && this.tailCrossingBonds[1] == bonds[1] || this.tailCrossingBonds[0] == bonds[1] && this.tailCrossingBonds[1] == bonds[0];
        }
        return false;
    }

    public boolean equalsHead(MolBond[] bonds) {
        if (this.headCrossingBonds == null && bonds == null) {
            return true;
        }
        if (this.headCrossingBonds == null || bonds == null) {
            return false;
        }
        if (this.headCrossingBonds.length == 2 && bonds.length == 2) {
            return this.headCrossingBonds[0] == bonds[0] && this.headCrossingBonds[1] == bonds[1] || this.headCrossingBonds[0] == bonds[1] && this.headCrossingBonds[1] == bonds[0];
        }
        return false;
    }

    public void addCrossingBonds(List<MolBond> crsList, List<MolBond> list) {
        if (list == null) {
            return;
        }
        if (crsList == null) {
            if (list.size() == 4) {
                // empty if block
            }
            return;
        }
        if (crsList.size() == 3) {
            if (this.headCrossingBonds == null) {
                this.headCrossingBonds = new MolBond[2];
            }
            this.headCrossingBonds[0] = crsList.get(0);
            this.headCrossingBonds[1] = crsList.get(1);
            if (list.size() == 4) {
                int j;
                if (this.tailCrossingBonds == null) {
                    this.tailCrossingBonds = new MolBond[2];
                }
                int n = list.size();
                for (j = 0; j < n; ++j) {
                    if (this.headCrossingBonds[0] == list.get(j) || this.headCrossingBonds[1] == list.get(j)) continue;
                    this.tailCrossingBonds[0] = list.get(j);
                    break;
                }
                for (j = 0; j < n; ++j) {
                    if (this.headCrossingBonds[0] == list.get(j) || this.headCrossingBonds[1] == list.get(j) || this.tailCrossingBonds[0] == list.get(j)) continue;
                    this.tailCrossingBonds[1] = list.get(j);
                    break;
                }
                boolean bl = this.flipped = this.calcConnectingCrossingBond(true) == crsList.get(2);
                if (this.tailCrossingBonds[1] == null) {
                    // empty if block
                }
            }
        }
    }

    public MolBond[] getHeadCrossingBonds() {
        return this.headCrossingBonds;
    }

    public void setHeadCrossingBonds(MolBond[] b) {
        if (b == null || b.length == 2) {
            this.headCrossingBonds = b;
        }
    }

    public MolBond[] getTailCrossingBonds() {
        return this.tailCrossingBonds;
    }

    public void setTailCrossingBonds(MolBond[] tailCrossingBonds) {
        this.tailCrossingBonds = tailCrossingBonds;
    }

    public void swapHeadTail() {
        if (this.headCrossingBonds != null && this.tailCrossingBonds != null) {
            MolBond[] tmp = this.headCrossingBonds;
            this.headCrossingBonds = this.tailCrossingBonds;
            this.tailCrossingBonds = tmp;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int i;
        oos.writeByte(0);
        oos.writeBoolean(this.flipped);
        if (this.headCrossingBonds == null) {
            oos.writeInt(0);
        } else {
            oos.writeInt(this.headCrossingBonds.length);
            for (i = 0; i < this.headCrossingBonds.length; ++i) {
                oos.writeObject(this.headCrossingBonds[i]);
            }
        }
        if (this.tailCrossingBonds == null) {
            oos.writeInt(0);
        } else {
            oos.writeInt(this.tailCrossingBonds.length);
            for (i = 0; i < this.tailCrossingBonds.length; ++i) {
                oos.writeObject(this.tailCrossingBonds[i]);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int i;
        byte version = ois.readByte();
        if (version > 0) {
            throw new IOException("Cannot deserialize SRU Sgroup with future version (" + version + ")");
        }
        this.flipped = ois.readBoolean();
        int n = ois.readInt();
        if (n > 0) {
            this.headCrossingBonds = new MolBond[n];
            for (i = 0; i < n; ++i) {
                this.headCrossingBonds[i] = (MolBond)ois.readObject();
            }
        } else {
            this.headCrossingBonds = null;
        }
        if ((n = ois.readInt()) > 0) {
            this.tailCrossingBonds = new MolBond[n];
            for (i = 0; i < n; ++i) {
                this.tailCrossingBonds[i] = (MolBond)ois.readObject();
            }
        } else {
            this.tailCrossingBonds = null;
        }
    }

    public boolean containsLadderTypePolymer() {
        return this.headCrossingBonds != null && this.tailCrossingBonds != null;
    }
}

