/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.toxic;

import chemaxon.formats.MolExporter;
import chemaxon.metabolizer.Metabolizer;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.toxic.ToxicRiskCalculator;
import chemaxon.toxic.ToxicityUtilities;
import chemaxon.util.ChemaxonException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Toxic {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final String HELP_TEXT = "Toxicity file generator:" + lineSeparator + "Usage:" + lineSeparator + "toxic [imput molecules <smiles/file>] -t <toxicophore path> [-M <libraryPath>] [-n <levelCount>] [-o <outputFile>] [-p]" + lineSeparator + "-t toxicophore path" + lineSeparator + "-M biotransformation library path (metabolism will be used for substrates)" + lineSeparator + "-n metabolic level count" + lineSeparator + "-o output file path" + lineSeparator + "-p use metabolic parents too";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int i;
        InputStream inputStream = System.in;
        InputStream toxicStream = null;
        boolean useMetabolizer = false;
        boolean useMetabolicParents = false;
        String biotransformationPath = null;
        int levelCount = 0;
        PrintStream logStream = System.err;
        PrintWriter logWriter = new PrintWriter(logStream);
        OutputStream outputStream = System.out;
        if (args.length == 0) {
            Toxic.printHelp();
            return;
        }
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (!Toxic.isSwitchCorrect(args[i])) {
                Toxic.printHelp();
                return;
            }
            set.add(args[i]);
        }
        if (args.length > 0 && !Toxic.containsAllNeededSwitch(set)) {
            Toxic.printHelp();
            return;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) {
                File inputFile = new File(args[i]);
                if (inputFile.exists()) {
                    try {
                        inputStream = new FileInputStream(args[i]);
                        continue;
                    }
                    catch (IOException exception) {
                        System.err.println("Can't open input file, exiting.");
                        return;
                    }
                }
                inputStream = new ByteArrayInputStream(args[i].getBytes());
                continue;
            }
            if (args[i].equals("-t")) {
                try {
                    toxicStream = new FileInputStream(args[++i]);
                    continue;
                }
                catch (IOException exception) {
                    System.err.println("Can't open toxic library file, exiting.");
                    return;
                }
            }
            if (args[i].equals("-o")) {
                try {
                    outputStream = new FileOutputStream(args[++i]);
                    continue;
                }
                catch (IOException exception) {
                    System.err.println("Can't open output file, exiting.");
                    return;
                }
            }
            if (args[i].equals("-M")) {
                useMetabolizer = true;
                biotransformationPath = args[++i];
                continue;
            }
            if (args[i].equals("-n")) {
                levelCount = Integer.valueOf(args[++i]);
                continue;
            }
            if (!args[i].equals("-p")) continue;
            useMetabolicParents = true;
        }
        try {
            Toxic.calculate(inputStream, toxicStream, useMetabolizer, useMetabolicParents, biotransformationPath, levelCount, outputStream);
        }
        catch (MetabolizerException e) {
            logWriter.write("Some error has occured while trying to metabolize input molecule(s).\n");
            e.printStackTrace(logWriter);
        }
        catch (IOException e) {
            logWriter.write("Some error has occured while trying to read input molecule(s).\n");
            e.printStackTrace(logWriter);
        }
        catch (ChemaxonException chemaxonException) {
            logWriter.write("Some error has occured while trying to calculate toxicity risk, exiting\n");
            chemaxonException.printStackTrace(logWriter);
        }
        finally {
            try {
                ((OutputStream)logStream).flush();
                ((OutputStream)logStream).close();
                ((OutputStream)outputStream).flush();
                ((OutputStream)outputStream).close();
                inputStream.close();
                toxicStream.close();
            }
            catch (IOException exception) {}
        }
    }

    private static void calculate(InputStream inputStream, InputStream toxicStream, boolean useMetabolizer, boolean useMetabolicParents, String biotransformationPath, int levelCount, OutputStream outputStream) throws MetabolizerException, IOException, ChemaxonException {
        if (!useMetabolizer) {
            Toxic.calculateToxicity(inputStream, toxicStream, outputStream, biotransformationPath, useMetabolicParents, levelCount);
        } else {
            float tolerance = 0.1f;
            RxnMolecule[] rxns = ToxicityUtilities.readReactions(biotransformationPath);
            Metabolizer metabolizer = new Metabolizer(levelCount, rxns, true);
            metabolizer.setMetabolicPathwayTolerance(tolerance);
            File metabolizedInputFile = ToxicityUtilities.createMetabolizedInputFile(inputStream, tolerance, metabolizer);
            inputStream = ToxicityUtilities.createMetabolizedToxicStream(useMetabolicParents, metabolizedInputFile);
            Toxic.calculateToxicity(inputStream, toxicStream, outputStream, biotransformationPath, useMetabolicParents, levelCount);
        }
    }

    private static void calculateToxicity(InputStream inputStream, InputStream toxicStream, OutputStream outputStream, String biotransformationPath, boolean useMetabolicParents, int levelCount) throws IOException, ChemaxonException {
        ToxicRiskCalculator calculator = new ToxicRiskCalculator();
        List<Molecule> toxicMolecules = calculator.calculateToxicRiskList(toxicStream, inputStream);
        MolExporter exporter = new MolExporter(outputStream, "mrv");
        for (Molecule molecule : toxicMolecules) {
            exporter.write(molecule);
        }
        exporter.close();
        inputStream.close();
        outputStream.flush();
        outputStream.close();
    }

    private static boolean containsAllNeededSwitch(Set set) {
        return set.contains("-t");
    }

    private static boolean isSwitchCorrect(String switchString) {
        return switchString.equals("-t") || switchString.equals("-o") || switchString.equals("-M") || switchString.equals("-n") || switchString.equals("-p");
    }

    private static void printHelp() {
        System.out.println(HELP_TEXT);
    }
}

