/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.toxic;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.metabolizer.Metabolizer;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.metabolizer.MetabolizerUtilities;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ToxicityUtilities {
    public static File createMetabolizedInputFile(InputStream inputStream, float tolerance, Metabolizer metabolizer) throws IOException, FileNotFoundException, MolFormatException, MetabolizerException {
        Molecule tempMol;
        File metabolizedInputFile = File.createTempFile("toxic", "meta");
        FileOutputStream metabolizedOutputStream = new FileOutputStream(metabolizedInputFile);
        MolExporter exporter = new MolExporter(metabolizedOutputStream, "mrv");
        MolImporter importer = new MolImporter(inputStream);
        MetabolizerUtilities utilities = new MetabolizerUtilities();
        while ((tempMol = importer.read()) != null) {
            metabolizer.setSubstrates(new Molecule[]{tempMol});
            utilities.generateMajorMetabolites(metabolizer, exporter, "mrv", "product", tolerance);
        }
        importer.close();
        exporter.close();
        metabolizedOutputStream.flush();
        metabolizedOutputStream.close();
        return metabolizedInputFile;
    }

    public static InputStream createMetabolizedToxicStream(boolean useMetabolicParents, File metabolizedToxicFile) throws FileNotFoundException, IOException, MolFormatException, MolExportException {
        FileInputStream toxicStream;
        if (!useMetabolicParents) {
            toxicStream = new FileInputStream(metabolizedToxicFile);
        } else {
            Molecule tempMol;
            MolImporter importer = new MolImporter(new FileInputStream(metabolizedToxicFile));
            File metabolizedOutputWithParentsFile = File.createTempFile("toxic", "meta");
            FileOutputStream metabolizedOutputStreamWithParents = new FileOutputStream(metabolizedOutputWithParentsFile);
            MolExporter exporter = new MolExporter(metabolizedOutputStreamWithParents, "mrv");
            while ((tempMol = importer.read()) != null) {
                String parentsString = tempMol.getProperty("PARENTS");
                if (parentsString != null) {
                    Molecule parentMol;
                    ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(parentsString.getBytes());
                    MolImporter parentImporter = new MolImporter(arrayInputStream);
                    while ((parentMol = parentImporter.read()) != null) {
                        exporter.write(parentMol);
                    }
                    importer.close();
                }
                exporter.write(tempMol);
            }
            exporter.close();
            metabolizedOutputStreamWithParents.flush();
            ((OutputStream)metabolizedOutputStreamWithParents).close();
            toxicStream = new FileInputStream(metabolizedOutputWithParentsFile);
        }
        return toxicStream;
    }

    public static RxnMolecule[] readReactions(String biotransformationPath) throws IOException, MolFormatException {
        Molecule tempMol;
        MolImporter importer = new MolImporter(biotransformationPath);
        ArrayList<RxnMolecule> reactions = new ArrayList<RxnMolecule>();
        while ((tempMol = importer.read()) != null) {
            if (!tempMol.isReaction()) continue;
            reactions.add((RxnMolecule)tempMol);
        }
        RxnMolecule[] rxns = reactions.toArray(new RxnMolecule[reactions.size()]);
        return rxns;
    }
}

