/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.toxic;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.fragmenter.MoleculeFragmenter;
import chemaxon.metabolizer.Metabolizer;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.toxic.ToxicityUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ToxicophoreGenerator {
    private static final String COMMAND_INCREASE = "increase";
    private static final String COMMAND_REMOVE = "remove";
    public static final String TOXIC_PERCENTAGE = "TOXIC_PERCENTAGE";
    public static final String TOXIC_PARENTS = "TOXIC_PARENTS";
    public static final String SMILES_OUTPUT_FORMAT = "smiles:qTTOXIC_PERCENTAGE";
    private boolean cleaveAromaticBonds = false;
    private int minOccurence = 1;
    private String biotransformationPath = null;
    private int levelCount;
    private float tolerance;
    private boolean useMetabolicParents = false;
    private Map<String, List<Molecule>> parentMap = new HashMap<String, List<Molecule>>();

    public List generateToxicophores(InputStream toxicStream, InputStream excludeStream) {
        if (this.biotransformationPath != null) {
            try {
                RxnMolecule[] rxns = ToxicityUtilities.readReactions(this.biotransformationPath);
                Metabolizer metabolizer = new Metabolizer(this.levelCount, rxns, true);
                metabolizer.setMetabolicPathwayTolerance(this.tolerance);
                File metabolizedToxicFile = ToxicityUtilities.createMetabolizedInputFile(toxicStream, this.tolerance, metabolizer);
                toxicStream = ToxicityUtilities.createMetabolizedToxicStream(this.useMetabolicParents, metabolizedToxicFile);
                if (excludeStream != null) {
                    File metabolizedExcludeFile = ToxicityUtilities.createMetabolizedInputFile(excludeStream, this.tolerance, metabolizer);
                    excludeStream = ToxicityUtilities.createMetabolizedToxicStream(this.useMetabolicParents, metabolizedExcludeFile);
                }
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            catch (MetabolizerException metabolizerException) {
                metabolizerException.printStackTrace();
            }
        }
        ArrayList<Molecule> toxicoPhores = new ArrayList<Molecule>();
        Bag bag = new Bag();
        MoleculeFragmenter fragmenter = new MoleculeFragmenter();
        fragmenter.setCleaveAromaticBonds(this.cleaveAromaticBonds);
        fragmenter.setMaxBondCount(8);
        try {
            String key;
            MolImporter importer = new MolImporter(toxicStream);
            this.processMolecules(importer, bag, fragmenter, COMMAND_INCREASE);
            importer.close();
            if (excludeStream != null) {
                importer = new MolImporter(excludeStream);
                this.processMolecules(importer, bag, fragmenter, COMMAND_REMOVE);
                importer.close();
            }
            Iterator iterator = bag.iterator();
            ArrayList<String> removable = new ArrayList<String>();
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                if (bag.get(key) >= this.minOccurence) continue;
                removable.add(key);
            }
            bag.removeAll(removable);
            iterator = bag.iterator();
            while (iterator.hasNext()) {
                key = (String)iterator.next();
                Molecule molecule = MolImporter.importMol(key);
                molecule.setProperty(TOXIC_PERCENTAGE, bag.getPercentage(key).toString());
                ByteArrayOutputStream parentStream = new ByteArrayOutputStream();
                MolExporter exporter = new MolExporter(parentStream, "mrv");
                Iterator<Molecule> iter = this.parentMap.get(key).iterator();
                while (iter.hasNext()) {
                    exporter.write(iter.next());
                }
                exporter.close();
                molecule.setProperty(TOXIC_PARENTS, parentStream.toString());
                toxicoPhores.add(molecule);
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            bag.clear();
            toxicoPhores.clear();
        }
        return toxicoPhores;
    }

    private void processMolecules(MolImporter importer, Bag bag, MoleculeFragmenter fragmenter, String command) throws IOException {
        Molecule tempMol = null;
        int moleculeCount = 0;
        while ((tempMol = importer.read()) != null) {
            ++moleculeCount;
            fragmenter.setMolecule(tempMol);
            String[] fragments = fragmenter.calculateFragmentsArray();
            for (int i = 0; i < fragments.length; ++i) {
                if (command.equals(COMMAND_INCREASE)) {
                    bag.add(fragments[i]);
                    if (!this.parentMap.containsKey(fragments[i])) {
                        this.parentMap.put(fragments[i], new ArrayList());
                    }
                    this.parentMap.get(fragments[i]).add(tempMol);
                    continue;
                }
                if (!command.equals(COMMAND_REMOVE)) continue;
                bag.remove(fragments[i]);
            }
        }
        if (command.equals(COMMAND_INCREASE)) {
            bag.setMoleculeCount(bag.getMoleculeCount() + moleculeCount);
        }
    }

    public boolean isCleaveAromaticBonds() {
        return this.cleaveAromaticBonds;
    }

    public void setCleaveAromaticBonds(boolean cleaveAromaticBonds) {
        this.cleaveAromaticBonds = cleaveAromaticBonds;
    }

    public int getMinOccurence() {
        return this.minOccurence;
    }

    public void setMinOccurence(int minOccurence) {
        this.minOccurence = minOccurence;
    }

    public String getBiotransformationPath() {
        return this.biotransformationPath;
    }

    public void setBiotransformationPath(String biotransformationPath) {
        this.biotransformationPath = biotransformationPath;
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public void setLevelCount(int levelCount) {
        this.levelCount = levelCount;
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(float tolerance) {
        this.tolerance = tolerance;
    }

    public boolean isUseMetabolicParents() {
        return this.useMetabolicParents;
    }

    public void setUseMetabolicParents(boolean useMetabolicParents) {
        this.useMetabolicParents = useMetabolicParents;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || ToxicophoreGenerator.isSwitchCorrect(args[i])) continue;
            ToxicophoreGenerator.printHelp();
            return;
        }
        InputStream toxicStream = System.in;
        InputStream excludeStream = null;
        OutputStream outputStream = System.out;
        String biotransformationPath = null;
        float tolerance = 0.1f;
        int levelCount = 0;
        boolean cleaveAromaticBonds = false;
        boolean useMetabolicParents = false;
        int minOccurence = 1;
        String outputFormat = SMILES_OUTPUT_FORMAT;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("--help")) {
                ToxicophoreGenerator.printHelp();
                return;
            }
            if (args[i].equals("-f")) {
                outputFormat = args[i + 1].equals("smiles") ? outputFormat : args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-c")) {
                cleaveAromaticBonds = Boolean.valueOf(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-m")) {
                minOccurence = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-E")) {
                try {
                    excludeStream = ToxicophoreGenerator.createMoleculeStream(args[++i]);
                }
                catch (IOException exception) {
                    excludeStream = null;
                }
                continue;
            }
            if (args[i].equals("-o")) {
                try {
                    outputStream = new FileOutputStream(args[++i]);
                }
                catch (IOException exception) {
                    outputStream = System.out;
                }
                continue;
            }
            if (args[i].equals("-M")) {
                biotransformationPath = args[++i];
                continue;
            }
            if (args[i].equals("-n")) {
                levelCount = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-G")) {
                tolerance = Float.valueOf(args[++i]).floatValue();
                continue;
            }
            if (args[i].equals("-p")) {
                useMetabolicParents = true;
                continue;
            }
            try {
                toxicStream = ToxicophoreGenerator.createMoleculeStream(args[i]);
                continue;
            }
            catch (IOException exception) {
                toxicStream = System.in;
            }
        }
        ToxicophoreGenerator generator = new ToxicophoreGenerator();
        generator.setCleaveAromaticBonds(cleaveAromaticBonds);
        generator.setMinOccurence(minOccurence);
        generator.setBiotransformationPath(biotransformationPath);
        generator.setTolerance(tolerance);
        generator.setLevelCount(levelCount);
        generator.setUseMetabolicParents(useMetabolicParents);
        List toxicoPhores = generator.generateToxicophores(toxicStream, excludeStream);
        Iterator iterator = toxicoPhores.iterator();
        try {
            MolExporter exporter = new MolExporter(outputStream, outputFormat);
            while (iterator.hasNext()) {
                Molecule molecule = (Molecule)iterator.next();
                exporter.write(molecule);
            }
            exporter.close();
            ((OutputStream)outputStream).flush();
        }
        catch (IOException exception) {
            // empty catch block
        }
        try {
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream createMoleculeStream(String data) throws IOException {
        File inputFile = new File(data);
        InputStream moleculeStream = inputFile.exists() ? new FileInputStream(inputFile) : new ByteArrayInputStream(data.getBytes());
        return moleculeStream;
    }

    private static boolean isSwitchCorrect(String switchString) {
        return switchString.equals("-o") || switchString.equals("-f") || switchString.equals("-E") || switchString.equals("-c") || switchString.equals("-m") || switchString.equals("-M") || switchString.equals("-n") || switchString.equals("-p") || switchString.equals("-G");
    }

    private static void printHelp() {
        System.out.println("Toxicophore generator");
        System.out.println("Usage:");
        System.out.println("toxicophore [input molecules <smiles/file>] [-M <biotransformationLibraryPath>] [-G <metabolicPathwayTolerance>] [-n <levelCount>] [-f <output format>] [-o <output file>] [-E <exclude molecules>] [-c <true/false>] [-m <minOccurence>]");
    }

    private static class Bag {
        private Map<String, Integer> map = new HashMap<String, Integer>();
        private int moleculeCount = 0;

        private Bag() {
        }

        public int getMoleculeCount() {
            return this.moleculeCount;
        }

        public void setMoleculeCount(int moleculeCount) {
            this.moleculeCount = moleculeCount;
        }

        public void clear() {
            this.map.clear();
        }

        public Integer get(Object key) {
            return this.map.get(key);
        }

        public Float getPercentage(Object key) {
            Integer integer = this.map.get(key);
            return new Float(integer.floatValue() / (float)this.moleculeCount * 100.0f);
        }

        public void add(String key) {
            if (!this.map.containsKey(key)) {
                this.map.put(key, new Integer(1));
            } else {
                Integer integer = this.map.get(key);
                this.map.put(key, new Integer(integer + 1));
            }
        }

        public void remove(Object key) {
            if (this.map.containsKey(key)) {
                this.map.remove(key);
            }
        }

        public void removeAll(Collection collection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
        }

        public Iterator iterator() {
            return this.map.keySet().iterator();
        }
    }
}

