/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.transform;

import chemaxon.marvin.modules.AutoMapper;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReactionPerformer {
    private RxnMolecule schema;
    private Map<MolAtom, Integer> productAtomAtomMap = new HashMap<MolAtom, Integer>();
    private Map<Integer, MolAtom> atomMapProductAtomMap = new HashMap<Integer, MolAtom>();
    private List<Integer> productAtomMaps = new ArrayList<Integer>();
    private AutoMapper mapper = new AutoMapper();
    private Molecule reactant;

    public void setSchema(RxnMolecule schema) throws IllegalArgumentException {
        if (schema == null || schema.getReactantCount() < 1) {
            throw new IllegalArgumentException("Invalid reaction schema!");
        }
        this.schema = schema;
        this.initialize();
    }

    private void initialize() {
        this.mapper.setMappingStyle(2);
        try {
            this.mapper.map(this.schema);
        }
        catch (AutoMapperException e) {
            throw new IllegalArgumentException(e);
        }
        this.reactant = this.schema.getReactant(0);
        Molecule product = this.schema.getProduct(0);
        for (int i = 0; i < product.getAtomCount(); ++i) {
            int atomMap = product.getAtom(i).getAtomMap();
            if (atomMap == 0) continue;
            this.productAtomAtomMap.put(product.getAtom(i), atomMap);
            this.atomMapProductAtomMap.put(atomMap, product.getAtom(i));
            this.productAtomMaps.add(atomMap);
        }
    }

    protected Molecule getReactant() {
        return this.reactant;
    }

    public void performReaction(Molecule target, int[] searchResult) {
        int i;
        ArrayList<Integer> productAtomMaps = new ArrayList<Integer>();
        productAtomMaps.addAll(this.productAtomMaps);
        ArrayList<MolAtom> removableAtoms = new ArrayList<MolAtom>();
        ArrayList<MolBond> removableBonds = new ArrayList<MolBond>();
        HashMap<Integer, MolAtom> atomMapTargetAtomMap = new HashMap<Integer, MolAtom>();
        for (i = 0; i < searchResult.length; ++i) {
            MolAtom reactantAtom = this.reactant.getAtom(i);
            int atomMap = reactantAtom.getAtomMap();
            MolAtom productAtom = this.atomMapProductAtomMap.get(atomMap);
            MolAtom targetAtom = target.getAtom(searchResult[i]);
            if (productAtomMaps.contains(atomMap)) {
                productAtomMaps.remove((Object)atomMap);
                atomMapTargetAtomMap.put(atomMap, targetAtom);
                targetAtom.setAtomMap(atomMap);
                targetAtom.setAtno(productAtom.getAtno());
                targetAtom.setCharge(productAtom.getCharge());
                continue;
            }
            removableAtoms.add(targetAtom);
        }
        for (i = 0; i < target.getBondCount(); ++i) {
            MolBond bond = target.getBond(i);
            MolAtom atom1 = this.atomMapProductAtomMap.get(bond.getAtom1().getAtomMap());
            MolAtom atom2 = this.atomMapProductAtomMap.get(bond.getAtom2().getAtomMap());
            if (atom1 == null || atom2 == null) continue;
            MolBond productBond = atom1.getBondTo(atom2);
            if (productBond != null) {
                bond.setType(productBond.getType());
                continue;
            }
            removableBonds.add(bond);
        }
        for (Integer productAtomMap : productAtomMaps) {
            MolAtom productAtom = this.atomMapProductAtomMap.get(productAtomMap);
            MolAtom targetAtom = new MolAtom(productAtom.getAtno());
            targetAtom.setAtomMap(productAtom.getAtomMap());
            atomMapTargetAtomMap.put(targetAtom.getAtomMap(), targetAtom);
            target.add(targetAtom);
        }
        for (Integer productAtomMap : productAtomMaps) {
            MolAtom productAtom = this.atomMapProductAtomMap.get(productAtomMap);
            for (int i2 = 0; i2 < productAtom.getBondCount(); ++i2) {
                MolBond bond = productAtom.getBond(i2);
                MolAtom atom = bond.getAtom1() == productAtom ? bond.getAtom2() : bond.getAtom1();
                int atomMap = this.productAtomAtomMap.get(atom);
                MolBond newBond = new MolBond((MolAtom)atomMapTargetAtomMap.get(productAtomMap), (MolAtom)atomMapTargetAtomMap.get(atomMap));
                newBond.setType(bond.getType());
                target.add(newBond);
            }
        }
        for (MolBond molBond : removableBonds) {
            target.removeBond(molBond);
        }
        for (MolAtom molAtom : removableAtoms) {
            target.removeAtom(molAtom);
        }
    }
}

