/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.transform;

import chemaxon.formats.MolImporter;
import chemaxon.marvin.modules.SubstructureSearch;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.transform.ReactionPerformer;
import java.io.ByteArrayInputStream;

public class Transformer
extends ReactionPerformer {
    public Molecule transform(Molecule target) throws Exception {
        SubstructureSearch search = new SubstructureSearch();
        search.setQuery(this.getReactant());
        search.setTarget(target);
        boolean found = search.findFirst();
        while (found) {
            int[] result = search.getResult();
            this.performReaction(target, result);
            search.setTarget(target);
            found = search.findNext();
        }
        return target;
    }

    public static void main(String[] args) throws Exception {
        Transformer transformer = new Transformer();
        ByteArrayInputStream stream = new ByteArrayInputStream("[O-:2][N+:1]=O>>[O:2]=[N:1]=O".getBytes());
        MolImporter importer = new MolImporter(stream);
        importer.setQueryMode(true);
        RxnMolecule rxn = RxnMolecule.getReaction(importer.read());
        transformer.setSchema(rxn);
        long time = System.currentTimeMillis();
        for (int i = 0; i < 50000; ++i) {
            transformer.transform(MolImporter.importMol("[O-][N+](=O)c1ccccc1"));
        }
        System.out.println(System.currentTimeMillis() - time);
    }
}

