/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public class BinaryDataUtil {
    public static int getFingerprintInInt(byte[] fingerprint, int position) {
        return BinaryDataUtil.readIntFromByteArray(fingerprint, position * 4);
    }

    public static int get4BytesInInt(byte[] bytes, int position) {
        return BinaryDataUtil.readIntFromByteArray(bytes, position * 4);
    }

    public static int readIntFromByteArray(byte[] bytes, int offset) {
        int result = 0;
        for (int i = offset; i < offset + 4; ++i) {
            int b = i < bytes.length ? bytes[i] & 0xFF : 0;
            result = result << 8 | b;
        }
        return result;
    }

    public static byte[] getIntIn4Bytes(int integer) {
        return BinaryDataUtil.getIntsInBytes(new int[]{integer});
    }

    public static byte[] getFingerprintInBytes(int[] ints) {
        return BinaryDataUtil.getIntsInBytes(ints);
    }

    public static byte[] getIntsInBytes(int[] ints) {
        byte[] bytes = new byte[ints.length << 2];
        int j = 0;
        for (int i = 0; i < ints.length; ++i) {
            int x = ints[i];
            bytes[j++] = (byte)(x >>> 24 & 0xFF);
            bytes[j++] = (byte)(x >>> 16 & 0xFF);
            bytes[j++] = (byte)(x >>> 8 & 0xFF);
            bytes[j++] = (byte)(x & 0xFF);
        }
        return bytes;
    }

    public static int[] getBytesInInts(byte[] bytes) {
        return BinaryDataUtil.getBytesInInts(bytes, 0, (bytes.length & 3) == 0 ? bytes.length >> 2 : (bytes.length >> 2) + 1);
    }

    public static int[] getBytesInInts(byte[] bytes, int position, int size) {
        int[] ints = new int[size];
        int bytePos = position * 4;
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = BinaryDataUtil.readIntFromByteArray(bytes, bytePos);
            bytePos += 4;
        }
        return ints;
    }

    public static int translateIntCountToBitCount(int intCount) {
        return intCount << 5;
    }

    public static void or(byte[] fp, byte[] fp1) {
        for (int i = 0; i < fp.length; ++i) {
            int n = i;
            fp[n] = (byte)(fp[n] | fp1[i]);
        }
    }

    public static void and(byte[] fp, byte[] fp1) {
        for (int i = 0; i < fp.length; ++i) {
            int n = i;
            fp[n] = (byte)(fp[n] & fp1[i]);
        }
    }

    public static int translateBitCountToByteCount(int bitCount) {
        return (bitCount & 7) == 0 ? bitCount >> 3 : (bitCount >> 3) + 1;
    }

    public static int translateBitCountToIntCount(int bitCount) {
        return (bitCount & 0x1F) == 0 ? bitCount >> 5 : (bitCount >> 5) + 1;
    }

    public static byte getByte(int i, int index) {
        return (byte)(i >> (index << 3) & 0xFF);
    }
}

