/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.struc.Molecule;
import java.awt.Image;
import java.awt.image.PixelGrabber;

public class BitmapUtil {
    public static int[] getPixels(Image img, int w, int h) {
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("Error: interrupted waiting for pixels!");
            return null;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("Error: image fetch aborted or errored");
            return null;
        }
        return pixels;
    }

    public static int[] exportMol2bitmap(Molecule m, int w, int h) {
        if (m.getDim() < 2) {
            m.clean(2, null);
        }
        Image img = (Image)m.toObject("image:w" + new Integer(w).toString() + "h" + new Integer(h).toString());
        return BitmapUtil.getPixels(img, w, h);
    }
}

