/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.IntVector;
import chemaxon.jchem.db.DatabaseSearchException;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockingIntArrayQueue {
    private static final Logger logger = Logger.getLogger(BlockingIntArrayQueue.class.getName());
    private static final int INITIAL_CAPACITY = 10240;
    private int nextNotifArraySize = -1;
    private IntVector hitArray = new IntVector(10240);
    private boolean running;
    private Throwable error;
    private volatile boolean canceled;

    public synchronized void start() {
        this.hitArray.clear();
        this.nextNotifArraySize = -1;
        this.running = true;
        this.error = null;
    }

    public synchronized void add(int cdId) {
        this.hitArray.add(cdId);
        if (this.nextNotifArraySize == -1 || this.hitArray.size() == this.nextNotifArraySize) {
            this.notifyAll();
        }
    }

    public int[] getAvailableNewHits(int arraySize) throws DatabaseSearchException, InterruptedException {
        return this.getAvailableNewHitArray(arraySize).toArray();
    }

    public synchronized IntVector getAvailableNewHitArray(int arraySize) throws DatabaseSearchException, InterruptedException {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("arraySize=" + arraySize);
        }
        this.nextNotifArraySize = arraySize;
        while (this.running && this.hitArray.size() < this.nextNotifArraySize) {
            this.wait();
        }
        if (logger.isLoggable(Level.FINER)) {
            if (!this.running) {
                logger.finer("search is stopped");
            }
            logger.finer("hitArray.size=" + this.hitArray.size());
        }
        if (!this.running) {
            if (this.error != null) {
                throw new DatabaseSearchException("Error", this.error);
            }
            if (this.canceled) {
                throw new DatabaseSearchException("Search has been cancelled", new CancellationException("Search has been cancelled"));
            }
        }
        IntVector old = this.hitArray;
        this.hitArray = new IntVector(10240);
        return old;
    }

    public synchronized boolean hasMoreHits() throws InterruptedException {
        this.nextNotifArraySize = -1;
        boolean hasMore = true;
        while (this.hitArray.size() == 0) {
            if (logger.isLoggable(Level.FINER)) {
                if (!this.running) {
                    logger.finer("search is stopped");
                }
                if (this.error != null) {
                    logger.finer("error: " + this.error.getMessage());
                }
                logger.finer("hitArray.size=" + this.hitArray.size());
            }
            if (!this.running || this.error != null) {
                hasMore = false;
                break;
            }
            this.wait();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Returning " + hasMore + "...");
        }
        return hasMore;
    }

    public synchronized int getNextHit() throws InterruptedException {
        if (!this.hasMoreHits()) {
            throw new NoSuchElementException();
        }
        return this.hitArray.remove(0);
    }

    public synchronized int getLastAvailableHit() throws InterruptedException {
        if (!this.hasMoreHits()) {
            throw new NoSuchElementException();
        }
        return this.hitArray.removeLast();
    }

    public synchronized void waitUntilSearchComplete() throws InterruptedException {
        while (this.running) {
            this.wait();
        }
    }

    public synchronized void setError(Throwable e) {
        this.error = e;
    }

    public synchronized void stop() {
        this.running = false;
        this.notifyAll();
    }

    public void cancel() {
        this.canceled = true;
        this.stop();
    }
}

