/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.ArgumentException;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;

public class CLQ {
    boolean[] used;
    String[] args;
    Properties prop;

    public CLQ(String[] args, Properties prop) {
        this.args = args;
        this.prop = prop;
        this.used = new boolean[args.length];
        for (int i = 0; i < this.used.length; ++i) {
            this.used[i] = false;
        }
    }

    public Parameter lookup(String abbr, String name, String propname, int length, boolean required, boolean save) throws ArgumentException {
        return this.lookup(abbr, name, propname, length, required, save, null);
    }

    public Parameter lookup(String abbr, String name, String propname, int length, boolean required, boolean save, String range) throws ArgumentException {
        Parameter hit = null;
        if (abbr != null) {
            try {
                hit = this.lookup(abbr, propname, length, false, save, range);
            }
            catch (Exception exc) {
                throw new ArgumentException("Parameter " + name + " missing.");
            }
        }
        if (name != null) {
            try {
                if (hit == null) {
                    hit = this.lookup(name, propname, length, false, save, range);
                }
            }
            catch (Exception exc) {
                throw new ArgumentException("Parameter " + name + " missing.");
            }
        }
        try {
            if (hit == null && required) {
                hit = this.readProperty(propname, length);
            }
        }
        catch (Exception exc) {
            throw new ArgumentException("Parameter " + name + " missing.");
        }
        return hit;
    }

    public Parameter lookup(String name, String propname, int length, boolean required, boolean save) throws ArgumentException {
        return this.lookup(name, propname, length, required, save, null);
    }

    public Parameter lookup(String name, String propname, int length, boolean required, boolean save, String range) throws ArgumentException {
        int i;
        int pos = -1;
        for (i = 0; i < this.args.length; ++i) {
            if (!name.equals(this.args[i]) || (length = this.check(this.args, i, length, range)) <= 0) continue;
            pos = i;
            break;
        }
        if (pos != -1) {
            for (i = 0; i < length; ++i) {
                this.used[pos + i] = true;
            }
            return new Parameter(CLQ.copy(this.args, pos, length), this.prop, propname, save);
        }
        if (required) {
            throw new ArgumentException("Error reading " + name + ".");
        }
        return null;
    }

    public Parameter lookup(int index, int length, String propname, boolean required, boolean save) throws ArgumentException {
        if (this.check(this.args, index, length)) {
            return new Parameter(CLQ.copy(this.args, index, length), this.prop, propname, save);
        }
        if (this.prop.getProperty(propname) != null) {
            return this.readProperty(propname, length);
        }
        if (required) {
            throw new ArgumentException("Error reading parameter " + index);
        }
        return null;
    }

    public Parameter lookup(String abbr, String name, String propname, boolean required, boolean save) throws ArgumentException {
        int i;
        int index = -1;
        int length = 0;
        for (i = 0; i < this.args.length; ++i) {
            if (index == -1 && (abbr != null && abbr.equals(this.args[i]) || name != null && name.equals(this.args[i]) || (abbr.equals("") || name.equals("")) && !this.used[i])) {
                index = i;
            }
            if (index == -1) continue;
            if (this.used[i]) break;
            ++length;
        }
        if (index != -1) {
            if (this.check(this.args, index, length)) {
                for (i = index; i < index + length; ++i) {
                    this.used[i] = true;
                }
                String[] param = null;
                if (!this.args[index].equals(abbr) && !this.args[index].equals(name)) {
                    param = new String[length + 1];
                    param[0] = "";
                    System.arraycopy(this.args, index, param, 1, length);
                } else {
                    param = CLQ.copy(this.args, index, length);
                }
                return new Parameter(param, this.prop, propname, save);
            }
            if (this.prop != null && this.prop.getProperty(propname) != null) {
                return this.readProperty(propname, length);
            }
            if (required) {
                throw new ArgumentException("Error reading parameter " + index);
            }
            return null;
        }
        if (required) {
            throw new ArgumentException("Parameter " + name + " missing.");
        }
        return null;
    }

    public Parameter lookup(String name, String propname, boolean required, boolean save) throws ArgumentException {
        return this.lookup(null, name, propname, required, save);
    }

    public Parameter readProperty(String name, int length) throws ArgumentException {
        if (this.prop.getProperty(name) == null) {
            throw new ArgumentException("Error reading " + name + " from property file.");
        }
        String[] data = new String[length];
        data[0] = name;
        if (length == 2) {
            data[1] = this.prop.getProperty(name);
        } else if (length > 2) {
            StringTokenizer st = new StringTokenizer(this.prop.getProperty(name));
            if (st.countTokens() != data.length - 1) {
                // empty if block
            }
            for (int i = 1; i < data.length; ++i) {
                if (!st.hasMoreTokens()) continue;
                data[i] = st.nextToken();
            }
        }
        return new Parameter(data, this.prop, name, false);
    }

    protected static String[] cut(String[] args, int pos, int length) {
        String[] param = new String[length];
        System.arraycopy(args, pos, param, 0, length);
        Arrays.fill(args, pos, pos + length, null);
        return param;
    }

    protected static String[] copy(String[] args, int pos, int length) {
        String[] param = new String[length];
        System.arraycopy(args, pos, param, 0, length);
        return param;
    }

    protected boolean check(String[] args, int pos, int length) throws ArgumentException {
        return this.check(args, pos, length, null) > 0;
    }

    /*
     * Unable to fully structure code
     */
    protected int check(String[] args, int pos, int length, String range) throws ArgumentException {
        if (range == null && pos + length > args.length) {
            return -1;
        }
        pu = true;
        end = Math.min(pos + length, args.length);
        i = pos;
        try {
            for (i = pos; i < end && pu; ++i) {
                if (i > pos) {
                    if (range == null || range.indexOf(args[i].toLowerCase()) != -1) {
                        if (args[i].length() > 0 && args[i].charAt(0) == '-' && (args[i].length() == 1 || Character.isLetter(args[i].charAt(1)))) {
                            throw new ArgumentException("Unknown option: " + args[i]);
                        } else {
                            ** GOTO lbl13
                        }
                    }
                    break;
                }
lbl13:
                // 4 sources

                pu = i == pos || this.used[i - 1] == this.used[i] || this.used[i - 1] != false && this.used[i] == false;
            }
        }
        catch (ArgumentException exc) {
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
        return pu != false && this.used[i - 1] == false ? i - pos : -1;
    }

    public String notUsed() {
        for (int i = 0; i < this.used.length; ++i) {
            if (this.used[i]) continue;
            this.used[i] = true;
            return this.args[i];
        }
        return null;
    }

    public static class Parameter {
        String[] data = null;

        protected Parameter(String[] data, Properties prop, String propname, boolean save) {
            this.data = data;
            if (save) {
                String pr = "";
                for (int i = 1; i < data.length; ++i) {
                    pr = pr + data[i] + (i < data.length - 1 ? " " : "");
                }
                prop.setProperty(propname, pr);
            }
        }

        public int size() {
            return this.data.length - 1;
        }

        public String name() {
            return this.data[0];
        }

        public int getInt() throws ArgumentException {
            return this.getInt(0);
        }

        public double getDouble() throws ArgumentException {
            return this.getDouble(0);
        }

        public String getString() throws ArgumentException {
            return this.getString(0);
        }

        public int getInt(int index) throws ArgumentException {
            int i = 0;
            try {
                i = Integer.parseInt(this.data[index + 1]);
            }
            catch (Exception exc) {
                throw new ArgumentException("Error parsing " + this.name());
            }
            return i;
        }

        public double getDouble(int index) throws ArgumentException {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.data[index + 1]);
            }
            catch (Exception exc) {
                throw new ArgumentException("Error parsing " + this.name());
            }
            return d;
        }

        public String getString(int index) throws ArgumentException {
            String s = "";
            try {
                s = this.data[index + 1];
            }
            catch (Exception exc) {
                throw new ArgumentException("Error parsing " + this.name());
            }
            return s;
        }
    }
}

