/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.ExternalFileLoader;
import chemaxon.struc.Molecule;
import chemaxon.util.CLQ;
import chemaxon.util.DotfileUtil;
import chemaxon.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ConfigUtils {
    private static final String fileSep = System.getProperty("file.separator");
    protected static final String lineSep = System.getProperty("line.separator");
    public static final String ITEM_SEPARATOR = "..";
    public static final int ITEM_SEPARATOR_LENGTH = "..".length();
    public static final String IMPORT_EXCEPTION = "IMPORT_EXCEPTION";
    public static final String EXPORT_EXCEPTION = "EXPORT_EXCEPTION";

    public static InputStream openFileFromCodebase(String filename) {
        return ConfigUtils.createStreamForFileInMarvinPackageDir(filename);
    }

    public static String getFilePathFromCodebase(String filename) {
        return ConfigUtils.searchFileInMarvinPackageDir(filename);
    }

    public static String searchFileInMarvinPackageDir(String filename) {
        String path = null;
        if (Environment.APPLET) {
            URL appletCodeBase = Environment.getCodeBase();
            try {
                path = new URL(appletCodeBase, filename.charAt(0) != '/' ? filename : filename.substring(1)).toString();
            }
            catch (IOException ioex) {
                path = null;
            }
        } else {
            ExternalFileLoader extfileloader = new ExternalFileLoader(filename);
            path = extfileloader.getFileOutJar();
        }
        return path;
    }

    public static InputStream createStreamForFileInMarvinPackageDir(String filename) {
        InputStream resource = null;
        if (Environment.APPLET) {
            URL appletCodeBase = Environment.getCodeBase();
            try {
                resource = new URL(appletCodeBase, filename.charAt(0) != '/' ? filename : filename.substring(1)).openStream();
            }
            catch (IOException ioex) {
                resource = null;
            }
        } else {
            ExternalFileLoader extfileloader = new ExternalFileLoader(filename);
            resource = extfileloader.openFileOutJar();
        }
        return resource;
    }

    public static InputStream openFileFromUserHomeDir(String filename) {
        try {
            return DotfileUtil.open(filename);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getFilePathFromUserHomeDir(String filename) {
        String userHomePath;
        try {
            userHomePath = DotfileUtil.getDotFile("").getCanonicalPath();
        }
        catch (IOException e1) {
            return null;
        }
        String path = userHomePath + File.separator + filename;
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getContent(BufferedReader reader) throws IOException {
        StringBuffer content = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            content.append(line);
            content.append("\n");
        }
        reader.close();
        return new String(content);
    }

    public static Molecule getTargetMolecule(String structure) throws IOException {
        return ConfigUtils.getMolecule(structure, null, null, false);
    }

    public static Molecule[] getTargetMolecules(String structure) throws IOException {
        return ConfigUtils.getMolecules(structure, null, null, false);
    }

    public static Molecule getTargetMolecule(String structure, String type, String dir) throws IOException {
        return ConfigUtils.getMolecule(structure, type, dir, false);
    }

    public static Molecule[] getTargetMolecules(String structure, String type, String dir) throws IOException {
        return ConfigUtils.getMolecules(structure, type, dir, false);
    }

    public static Molecule getQueryMolecule(String structure) throws IOException {
        return ConfigUtils.getMolecule(structure, null, null, true);
    }

    public static Molecule[] getQueryMolecules(String structure) throws IOException {
        return ConfigUtils.getMolecules(structure, null, null, true);
    }

    public static Molecule getQueryMolecule(String structure, String type, String dir) throws IOException {
        return ConfigUtils.getMolecule(structure, type, dir, true);
    }

    public static Molecule[] getQueryMolecules(String structure, String type, String dir) throws IOException {
        return ConfigUtils.getMolecules(structure, type, dir, true);
    }

    public static Molecule getMolecule(String structure, String type, String dir, boolean querymode) throws IOException {
        MolImporter molimp = ConfigUtils.getMolImporter(structure, type, dir, querymode);
        Molecule mol = molimp.read();
        molimp.close();
        if (mol == null) {
            throw new IOException("No molecule object is read.");
        }
        return mol;
    }

    public static Molecule[] getMolecules(String structure, String type, String dir, boolean querymode) throws IOException {
        MolImporter molimp = ConfigUtils.getMolImporter(structure, type, dir, querymode);
        ArrayList<Molecule> molarray = new ArrayList<Molecule>();
        Molecule mol = null;
        while ((mol = molimp.read()) != null) {
            molarray.add(mol);
        }
        molimp.close();
        if (molarray.isEmpty()) {
            throw new IOException("No molecule object is read.");
        }
        Molecule[] mols = new Molecule[molarray.size()];
        molarray.toArray(mols);
        return mols;
    }

    public static MolImporter getTargetMolImporter(String structure) throws IOException {
        return ConfigUtils.getMolImporter(structure, null, null, false);
    }

    public static MolImporter getTargetMolImporter(String structure, String type, String dir) throws IOException {
        return ConfigUtils.getMolImporter(structure, type, dir, false);
    }

    public static MolImporter getQueryMolImporter(String structure) throws IOException {
        return ConfigUtils.getMolImporter(structure, null, null, true);
    }

    public static MolImporter getQueryMolImporter(String structure, String type, String dir) throws IOException {
        return ConfigUtils.getMolImporter(structure, type, dir, true);
    }

    public static MolImporter getMolImporter(String structure, String type, String dir, boolean querymode) throws IOException {
        MolImporter molimp = null;
        try {
            if ("string".equalsIgnoreCase(type)) {
                structure = StringUtil.replaceString(structure, "\\n", "\n");
                molimp = new MolImporter(new ByteArrayInputStream(structure.getBytes()));
            } else {
                String path = ConfigUtils.getPath(structure, dir);
                molimp = "path".equalsIgnoreCase(type) ? new MolImporter(path) : (MFileFormatUtil.isURLOrFileName(path) && new File(path).canRead() ? new MolImporter(path) : new MolImporter(new ByteArrayInputStream(structure.getBytes())));
            }
        }
        catch (IOException e) {
            throw new IOException("Could not read file or structure string: " + structure + lineSep + e.getMessage());
        }
        molimp.setQueryMode(querymode);
        return molimp;
    }

    public static MolImporter[] getTargetMolImporters(CLQ clq) throws IOException {
        return ConfigUtils.getTargetMolImporters(clq, null);
    }

    public static MolImporter[] getTargetMolImporters(CLQ clq, List<String> notUsedList) throws IOException {
        if (notUsedList != null) {
            notUsedList.clear();
        }
        ArrayList<MolImporter> inlist = new ArrayList<MolImporter>();
        String in = clq.notUsed();
        do {
            MolImporter importer = in != null ? ConfigUtils.getTargetMolImporter(in) : new MolImporter(System.in);
            inlist.add(importer);
            if (notUsedList == null) continue;
            notUsedList.add(in != null ? in : "System.in");
        } while ((in = clq.notUsed()) != null);
        MolImporter[] ins = new MolImporter[inlist.size()];
        inlist.toArray(ins);
        return ins;
    }

    public static String getMolDir(String structure, String type, String dir) {
        if ("string".equalsIgnoreCase(type)) {
            return dir;
        }
        String path = ConfigUtils.getPath(structure, dir);
        if ("path".equalsIgnoreCase(type)) {
            return new File(path).getParent();
        }
        if (MFileFormatUtil.isURLOrFileName(path) && new File(path).canRead()) {
            return new File(path).getParent();
        }
        return dir;
    }

    public static String getPath(String path, String dir) {
        if (dir == null || new File(path).isAbsolute()) {
            return path;
        }
        return dir + fileSep + path;
    }

    public static boolean isReadErrorMol(Molecule mol) {
        return mol.getProperty(IMPORT_EXCEPTION) != null;
    }

    public static String getReadErrorMessage(Molecule mol) {
        return mol.getProperty(IMPORT_EXCEPTION);
    }

    public static Molecule readMol(MolImporter importer, boolean ignoreError) throws IOException {
        try {
            return importer.read();
        }
        catch (IOException e) {
            if (ignoreError) {
                importer.skipToNext();
                Molecule mol = new Molecule();
                mol.setProperty(IMPORT_EXCEPTION, e.getMessage());
                return mol;
            }
            throw e;
        }
    }

    public static void writeMol(Molecule mol, MolExporter exporter, boolean ignoreError) throws IOException {
        try {
            exporter.write(mol);
        }
        catch (MolExportException e) {
            if (ignoreError) {
                mol = new Molecule();
                mol.setProperty(EXPORT_EXCEPTION, e.getMessage());
                exporter.write(mol);
            }
            throw e;
        }
    }
}

