/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.ErrorHandler;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionHandler
extends ErrorHandler
implements Serializable {
    private PropertyChangeSupport propertySupport;
    private Connection con = null;
    private String url;
    private String driverName;
    private String driver;
    private String loginName;
    private String password;
    private final boolean commitable;
    public static final String DEFAULT_PROPERTY_TABLE = "JChemProperties";
    private String propertyTableName = "JChemProperties";
    private boolean rememberPassword;

    public ConnectionHandler() {
        this(false);
    }

    public ConnectionHandler(boolean isConnectionCommitable) {
        this.commitable = isConnectionCommitable;
        this.propertySupport = new PropertyChangeSupport(this);
    }

    @Deprecated
    public ConnectionHandler(Connection con) {
        this(con, null, false);
    }

    public ConnectionHandler(Connection con, String propertyTableName) {
        this(con, propertyTableName, false);
    }

    public ConnectionHandler(Connection con, String propertyTableName, boolean isConnectionCommitable) {
        this.setConnection(con);
        this.commitable = isConnectionCommitable;
        this.propertyTableName = propertyTableName;
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public ConnectionHandler(ConnectionHandler ch) {
        this(ch, ch.isCommitable());
    }

    public ConnectionHandler(ConnectionHandler ch, boolean isConnectionCommitable) {
        this.url = ch.url;
        this.driver = ch.driver;
        this.loginName = ch.loginName;
        this.password = ch.password;
        this.propertyTableName = ch.propertyTableName;
        this.rememberPassword = ch.rememberPassword;
        this.commitable = isConnectionCommitable;
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public static ConnectionHandler getInstance(int dbType, String host, int port, String database, String username, String password) {
        String cDriver = "";
        String cUrl = "";
        switch (dbType) {
            case 0: {
                if (port < 0) {
                    port = 1521;
                }
                cDriver = "oracle.jdbc.OracleDriver";
                cUrl = "jdbc:oracle:thin:@" + host + ":" + port + ":" + database;
                break;
            }
            case 2: {
                cDriver = "com.mysql.jdbc.Driver";
                cUrl = "jdbc:mysql://" + host + "/" + database;
                break;
            }
            case 3: {
                cDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
                cUrl = "jdbc:odbc:" + database;
                break;
            }
            case 6: {
                if (port < 0) {
                    port = 5432;
                }
                cDriver = "org.postgresql.Driver";
                cUrl = "jdbc:postgresql://" + host + ":" + port + "/" + database;
                break;
            }
            case 5: {
                cDriver = "COM.ibm.db2.jdbc.net.DB2Driver";
                cUrl = "jdbc:db2://" + host + "/" + database;
                break;
            }
            case 4: {
                cDriver = "interbase.interclient.Driver";
                cUrl = "jdbc:interbase://" + host + "/" + database;
                break;
            }
            case 1: {
                if (port < 0) {
                    port = 1433;
                }
                cDriver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                cUrl = "jdbc:sqlserver://" + host + ":" + port + ";databaseName=" + database + ";SelectMethod=cursor";
                break;
            }
            case 8: {
                cDriver = "org.apache.derby.jdbc.EmbeddedDriver";
                cUrl = "jdbc:derby:" + database + ";create=true";
                break;
            }
            default: {
                return null;
            }
        }
        ConnectionHandler ch = new ConnectionHandler();
        ch.setDriver(cDriver);
        ch.setUrl(cUrl);
        ch.setLoginName(username);
        ch.setPassword(password);
        return ch;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPropertyTable() {
        return this.propertyTableName;
    }

    public void setPropertyTable(String propertyTableName) {
        this.propertyTableName = propertyTableName;
    }

    public boolean getRememberPassword() {
        return this.rememberPassword;
    }

    public void setRememberPassword(boolean rememberPassword) {
        boolean oldRememberPassword = this.rememberPassword;
        this.rememberPassword = rememberPassword;
        this.propertySupport.firePropertyChange("rememberPassword", oldRememberPassword, rememberPassword);
    }

    public boolean isConnected() {
        boolean connected = false;
        try {
            if (this.con != null && !this.con.isClosed()) {
                connected = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return connected;
    }

    public void setConnected(boolean connected) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.exception = null;
        if (connected) {
            this.connectToDatabase();
        } else {
            this.disconnect();
        }
    }

    public Connection getConnection() {
        return this.con;
    }

    public final void setConnection(Connection con) {
        this.con = null;
        this.url = null;
        this.driverName = null;
        this.driver = null;
        this.loginName = null;
        this.password = null;
        this.con = con;
    }

    public boolean isCommitable() {
        return this.commitable;
    }

    public void connect() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.connectToDatabase();
    }

    public void connectToDatabase() throws SQLException, ClassNotFoundException {
        Class.forName(this.driver);
        this.con = DriverManager.getConnection(this.url, this.loginName, this.password);
    }

    public void disconnect() throws SQLException {
        this.close();
    }

    public void connect_NE() {
        try {
            this.connect();
        }
        catch (Throwable e) {
            this.exception = e;
            this.con = null;
        }
    }

    public void close() throws SQLException {
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
    }

    public void close_NE() {
        try {
            this.close();
        }
        catch (Throwable e) {
            this.exception = e;
            this.con = null;
        }
    }

    public boolean loadValuesFromProperties(Properties settings) {
        this.driverName = settings.getProperty("connection.jdbcDriverName");
        this.driver = settings.getProperty("connection.jdbcDriver");
        this.url = settings.getProperty("connection.jdbcUrl");
        this.loginName = settings.getProperty("connection.login");
        this.password = settings.getProperty("connection.password");
        this.propertyTableName = settings.getProperty("connection.propertyTable");
        if (this.propertyTableName == null) {
            this.propertyTableName = DEFAULT_PROPERTY_TABLE;
        }
        boolean bl = this.rememberPassword = this.password != null;
        return this.driver != null && this.url != null;
    }

    public void storeValuesToProperties(Properties settings) {
        settings.put("connection.jdbcDriverName", this.driverName);
        settings.put("connection.jdbcDriver", this.driver);
        settings.put("connection.jdbcUrl", this.url);
        settings.put("connection.login", this.loginName);
        settings.put("connection.propertyTable", this.propertyTableName);
        if (this.rememberPassword) {
            settings.put("connection.password", this.password);
        } else {
            settings.remove("connection.password");
        }
    }

    public String toString() {
        return "jdbc driver:" + this.driver + "\n jdbc url: " + this.url + "\nlogin: " + this.loginName + "\n password: * undisclosed ever *\nproperty table name: " + this.propertyTableName + "\n connection is commitable: " + this.isCommitable();
    }
}

