/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.jchem.db.FieldInfo;
import chemaxon.jchem.db.TableInfo;
import chemaxon.util.ConnectionHandler;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;

public class DatabaseTools {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConnectionAlive(Connection con) {
        try {
            String s = "SELECT 1";
            Statement stmt = con.createStatement();
            try {
                stmt.executeQuery(s);
            }
            finally {
                stmt.close();
            }
            return true;
        }
        catch (SQLException e) {
            System.err.println("Connection is dead.");
            return false;
        }
    }

    public static ArrayList getFieldNames(ConnectionHandler ch, String tableName, ArrayList types) throws SQLException {
        if (types == null) {
            types = new ArrayList<String>();
        }
        TableInfo tableFields = TableInfo.getTableInfo(ch, null, tableName);
        Enumeration<FieldInfo> fields = tableFields.elements();
        ArrayList<String> tableFieldList = new ArrayList<String>();
        while (fields.hasMoreElements()) {
            FieldInfo fi = fields.nextElement();
            tableFieldList.add(fi.getName());
            types.add(fi.getTypeName());
        }
        return tableFieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getFieldTypes(ConnectionHandler ch, String tableName) throws SQLException {
        int[] types;
        Connection con = ch.getConnection();
        Statement stmt = con.createStatement();
        try {
            StringBuffer sql = new StringBuffer("SELECT ");
            ArrayList fieldList = DatabaseTools.getFieldNames(ch, tableName, new ArrayList());
            for (int x = 0; x < fieldList.size(); ++x) {
                if (x != 0) {
                    sql.append(",");
                }
                sql.append(fieldList.get(x));
            }
            sql.append(" FROM " + tableName + " WHERE 1=2");
            ResultSet rs = stmt.executeQuery(sql.toString());
            try {
                ResultSetMetaData md = rs.getMetaData();
                int colnum = md.getColumnCount();
                types = new int[colnum];
                for (int x = 0; x < colnum; ++x) {
                    types[x] = md.getColumnType(x + 1);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            stmt.close();
        }
        return types;
    }

    public static boolean isTextType(int type) {
        return type == 1 || type == 12 || type == -1;
    }

    public static boolean isIntType(int type) {
        return type == -6 || type == 5 || type == 4 || type == -5;
    }

    public static boolean isRealType(int type) {
        return type == 8 || type == 7 || type == 6 || type == 3 || type == 2;
    }

    public static byte[] readBytes(ResultSet rs, int idx) throws SQLException {
        return DatabaseTools.readBytes(rs, idx, null);
    }

    public static byte[] readBytes(ResultSet rs, String columnName) throws SQLException {
        return DatabaseTools.readBytes(rs, 0, columnName);
    }

    private static byte[] readBytes(ResultSet rs, int idx, String columnName) throws SQLException {
        byte[] bytes = null;
        Object result = DatabaseTools.readBytesOrString(rs, idx, columnName);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            try {
                bytes = ((String)result).getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            bytes = (byte[])result;
        }
        return bytes;
    }

    public static String readString(ResultSet rs, int idx) throws SQLException {
        if (idx < 1) {
            throw new IllegalArgumentException("Column index must be 1 or higher (\"" + idx + "\")");
        }
        Object result = DatabaseTools.readBytesOrString(rs, idx, null);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        try {
            return new String((byte[])result, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object readBytesOrString(ResultSet rs, int idx, String columnName) throws SQLException {
        Object o = null;
        o = idx > 0 ? rs.getObject(idx) : rs.getObject(columnName);
        if (o == null) {
            return null;
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            return blob.getBytes(1L, (int)blob.length());
        }
        if (o instanceof Clob) {
            Clob clob = (Clob)o;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (o instanceof byte[]) {
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        String fName = null;
        fName = idx > 0 ? rs.getMetaData().getColumnName(idx) : columnName;
        throw new SQLException("Cannot handle type in field \"" + fName + "\": " + o.getClass().getName());
    }
}

