/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class DesEncrypter {
    private Cipher ecipher;
    private Cipher dcipher;
    private byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    private int iterationCount = 19;

    private DesEncrypter(String passPhrase) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), this.salt, this.iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
        }
        catch (InvalidKeySpecException e) {
        }
        catch (NoSuchPaddingException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
    }

    private Cipher getEncrypter() {
        return this.ecipher;
    }

    private Cipher getDecrypter() {
        return this.dcipher;
    }

    public static OutputStream encrypt(OutputStream out, String passPhrase) {
        DesEncrypter de = new DesEncrypter(passPhrase);
        return new CipherOutputStream(out, de.getEncrypter());
    }

    public static InputStream decrypt(InputStream in, String passPhrase) {
        DesEncrypter de = new DesEncrypter(passPhrase);
        return new CipherInputStream(in, de.getDecrypter());
    }

    public static void encrypt(InputStream in, OutputStream out, String passPhrase) {
        byte[] buf = new byte[1024];
        DesEncrypter de = new DesEncrypter(passPhrase);
        try {
            out = new CipherOutputStream(out, de.getEncrypter());
            int numRead = 0;
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void decrypt(InputStream in, OutputStream out, String passPhrase) {
        byte[] buf = new byte[1024];
        DesEncrypter de = new DesEncrypter(passPhrase);
        try {
            in = new CipherInputStream(in, de.getDecrypter());
            int numRead = 0;
            while ((numRead = in.read(buf)) >= 0) {
                out.write(buf, 0, numRead);
            }
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.out.println("Usage: java DesEncrypter <e|d> <passphrase> <inputfile> <outputfile>");
        }
        FileInputStream in = new FileInputStream(args[2]);
        FileOutputStream out = new FileOutputStream(args[3]);
        if (args[0].equals("e")) {
            DesEncrypter.encrypt(in, out, args[1]);
        } else if (args[0].equals("d")) {
            DesEncrypter.decrypt(in, out, args[1]);
        } else {
            System.out.println("Unknown option: " + args[0]);
        }
        in.close();
        out.close();
    }
}

