/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.ArgumentException;
import chemaxon.util.CLQ;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.DotfileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class Diff {
    static final String lineSep = System.getProperty("line.separator");
    static final String homeDir = System.getProperty("user.home");
    static final String configFile = new File(DotfileUtil.getDotDir(), ".jchem").getAbsolutePath();
    private static final String helptext = "Diff, (C) 2002-2012 ChemAxon Ltd." + lineSep + "Extracting different molecules of two molecular libraries." + lineSep + "Usage:" + lineSep + "  diff [options]" + lineSep + "" + lineSep + "" + "General options: " + lineSep + "  -h  --help                    this help message" + lineSep + "  -d  --driver <JDBC driver>    JDBC driver" + lineSep + "  -u  --dburl <url>             URL of database" + lineSep + "  -l  --login <login>           login name" + lineSep + "  -p  --password <password>     password" + lineSep + "  -s  --saveconf                save settings into" + lineSep + "\"" + configFile + "\"" + lineSep + "" + lineSep + "Input options (default: standard input):" + lineSep + "  -i  --input <path1> <path2>   input file to compare (text file input)" + lineSep + "  -q  --query <sql1> <sql2>     SQL query strings for reading input " + lineSep + "                                (database input)" + lineSep + "Combined input (table vs. file comparison):" + lineSep + "  -i <path> -q <sql>" + lineSep + "" + lineSep + "" + "Output options (default: standard output):" + lineSep + "  -o  --output <filepath>       output file path (SDF file output)" + lineSep + "  -a  --statement <sql>         SQL statement for inserting results" + lineSep + "                                (database output)" + lineSep + "" + lineSep + "" + "Execution mode" + lineSep + "" + "  -m  --matching             export matching pairs" + lineSep + "                             (otherwise different ones)" + lineSep;
    private boolean exportMatchingPairs = false;
    String[] inputSQL = new String[2];
    InputStream[] inputStream = new InputStream[2];
    String outputTableName = null;
    OutputStream outputStream = null;
    ConnectionHandler conh = null;
    boolean[] dbInput = new boolean[2];
    boolean dbOutput = false;
    ResultSet rs = null;
    MolImporter[] molImporter = new MolImporter[2];

    public void setExportMatchingPairs(boolean exportMatchingPairs) {
        this.exportMatchingPairs = exportMatchingPairs;
    }

    static ConnectionHandler openConn(CLQ clq) throws ArgumentException, SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ConnectionHandler conh = Diff.getConnectionHandler(clq);
        conh.connect();
        return conh;
    }

    public void setInput1(ConnectionHandler conh, String querySQL) throws SQLException {
        this.conh = conh;
        this.inputStream[0] = null;
        this.inputSQL[0] = querySQL;
        this.dbInput[0] = true;
    }

    public void setInput2(ConnectionHandler conh, String querySQL) throws SQLException {
        this.conh = conh;
        this.inputStream[1] = null;
        this.inputSQL[1] = querySQL;
        this.dbInput[1] = true;
    }

    public void setInput1(String fileName) throws FileNotFoundException {
        this.inputStream[0] = new FileInputStream(fileName);
        this.inputSQL[0] = null;
        this.dbInput[0] = false;
    }

    public void setInput2(String fileName) throws FileNotFoundException {
        this.inputStream[1] = new FileInputStream(fileName);
        this.inputSQL[1] = null;
        this.dbInput[1] = false;
    }

    public void setOutput(OutputStream os) {
        this.outputStream = os;
        this.dbOutput = false;
    }

    private static ConnectionHandler getConnectionHandler(CLQ clq) throws ArgumentException {
        CLQ.Parameter driver = clq.lookup("-d", "--driver", "connection.jdbcDriver", 2, true, true);
        CLQ.Parameter url = clq.lookup("-u", "--dburl", "connection.jdbcUrl", 2, true, true);
        CLQ.Parameter login = clq.lookup("-l", "--login", "connection.login", 2, true, true);
        CLQ.Parameter pwd = clq.lookup("-p", "--password", "connection.password", 2, true, true);
        CLQ.Parameter prop = clq.lookup("-P", "--proptable", "connection.propertyTable", 2, true, true);
        ConnectionHandler conh = new ConnectionHandler();
        conh.setUrl(url.getString());
        conh.setDriver(driver.getString());
        conh.setLoginName(login.getString());
        conh.setPassword(pwd.getString());
        String propTable = prop.getString();
        if (propTable == null) {
            propTable = "JChemProperties";
        }
        conh.setPropertyTable(propTable);
        return conh;
    }

    private Molecule getNextMolecule(int set) {
        try {
            RgMolecule mol;
            if (this.dbInput[set]) {
                if (this.rs == null) {
                    Statement stmt = this.conh.getConnection().createStatement();
                    this.rs = stmt.executeQuery(this.inputSQL[set]);
                }
                if (!this.rs.next()) {
                    return null;
                }
                Molecule mol2 = null;
                byte[] data = (byte[])this.rs.getObject(1);
                mol2 = MolImporter.importMol(data);
                return mol2;
            }
            if (this.molImporter[set] == null) {
                BufferedInputStream bis = new BufferedInputStream(this.inputStream[set]);
                MolInputStream mis = new MolInputStream(bis);
                MolImporter molImporter1 = new MolImporter(mis);
            }
            if (this.molImporter[set].read(mol = new RgMolecule())) {
                return mol;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void run() throws Exception {
        Molecule query = this.getNextMolecule(0);
        if (query == null && this.outputStream != null) {
            this.outputStream.close();
            return;
        }
        if (this.dbInput[1]) {
            boolean found;
            JChemSearch searcher = new JChemSearch();
            searcher.setConnectionHandler(this.conh);
            searcher.setQueryStructure(query.toFormat("mol"));
            searcher.setRunMode(0);
            JChemSearchOptions jso = new JChemSearchOptions(5);
            jso.setMaxResultCount(1);
            searcher.run();
            boolean bl = found = searcher.getResultCount() > 1;
            if (found == this.exportMatchingPairs) {
                // empty if block
            }
        }
    }

    private static void main(String[] args) {
        ConnectionHandler conh = null;
        long startTime = System.currentTimeMillis();
        Object verbose = null;
        Properties p = new Properties();
        Diff diff = new Diff();
        SettingsHandler settingsHandler = null;
        try {
            settingsHandler = new SettingsHandler();
            p = settingsHandler.getSettings();
        }
        catch (IOException exc) {
            // empty catch block
        }
        CLQ clq = new CLQ(args, p);
        try {
            String s;
            if (clq.lookup("-h", "--help", "", 1, false, false) != null) {
                System.out.println(helptext);
                return;
            }
            CLQ.Parameter inputfiles = clq.lookup("-i", "--input", "", 2, false, false);
            CLQ.Parameter inputqueries = clq.lookup("-q", "--query", "", 2, false, false);
            if (inputfiles != null && inputqueries != null) {
                conh = Diff.openConn(clq);
                diff.setInput1(conh, inputqueries.getString(0));
                diff.setInput2(inputfiles.getString(0));
            } else {
                inputfiles = clq.lookup("-i", "--input", "", 3, false, false);
                inputqueries = clq.lookup("-q", "--query", "", 3, false, false);
                if (inputfiles == null && inputqueries == null) {
                    throw new ArgumentException("Input not defined");
                }
                if (inputfiles != null && inputqueries != null) {
                    throw new ArgumentException("Ambiguous input");
                }
                if (inputfiles != null) {
                    diff.setInput1(inputfiles.getString(0));
                    diff.setInput2(inputfiles.getString(1));
                } else if (inputqueries != null) {
                    conh = Diff.openConn(clq);
                    diff.setInput1(conh, inputqueries.getString(0));
                    diff.setInput2(conh, inputqueries.getString(1));
                }
            }
            CLQ.Parameter genid = clq.lookup("-m", "--matching", "", 1, false, false);
            CLQ.Parameter outputfile = clq.lookup("-o", "--output", "", 2, false, false);
            CLQ.Parameter outputtable = clq.lookup("-o", "--output", "", 2, false, false);
            if (outputfile == null && outputtable == null) {
                diff.setOutput(System.out);
            } else {
                if (outputfile != null && outputtable != null) {
                    throw new ArgumentException("Ambiguous output");
                }
                if (outputfile != null) {
                    diff.setOutput(new FileOutputStream(outputfile.getString()));
                } else if (outputtable != null && conh == null) {
                    conh = Diff.openConn(clq);
                }
            }
            CLQ.Parameter store = clq.lookup("-s", "--saveconf", "", 1, false, false);
            if (store != null) {
                settingsHandler.save(p);
            }
            if ((s = clq.notUsed()) != null) {
                throw new ArgumentException("Unknown or unnecessary parameter: " + s);
            }
            diff.run();
        }
        catch (Throwable thr) {
            if (thr.getMessage() != null) {
                System.err.println("Error: " + thr.getMessage());
                if (verbose != null) {
                    thr.printStackTrace();
                }
            } else {
                System.err.println("Unknown error");
                thr.printStackTrace();
            }
            System.exit(1);
        }
    }
}

