/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class DotfileUtil {
    private static String dotDirName = "chemaxon";

    public static File getDotDir() {
        String sep = System.getProperty("file.separator");
        String home = System.getProperty("user.home");
        String dir = sep.equals("/") ? "." + dotDirName : dotDirName;
        return DotfileUtil.getFile(new File(home), dir);
    }

    public static File getDotFile(String relpath) {
        return DotfileUtil.getFile(DotfileUtil.getDotDir(), relpath);
    }

    public static File getDotFileWithEnsuredPath(String relpath) throws IOException {
        File f = DotfileUtil.getFile(DotfileUtil.getDotDir(), relpath);
        DotfileUtil.ensureParentExists(f);
        return f;
    }

    public static OutputStream create(String f) throws IOException {
        File file = new File(DotfileUtil.getDotDir(), f);
        DotfileUtil.ensureParentExists(file);
        return new FileOutputStream(file);
    }

    public static InputStream open(String f) throws IOException {
        File file = new File(DotfileUtil.getDotDir(), f);
        return new FileInputStream(file);
    }

    public static long lastModified(String f) {
        File file = new File(DotfileUtil.getDotDir(), f);
        return file.lastModified();
    }

    public static String getDotDirName() {
        return dotDirName;
    }

    public static void setDotDirName(String d) {
        dotDirName = d;
    }

    private static File getFile(File f, String relpath) {
        StringTokenizer st = new StringTokenizer(relpath, "/");
        while (st.hasMoreTokens()) {
            f = new File(f, st.nextToken());
        }
        return f;
    }

    private static void ensureParentExists(File f) throws IOException {
        String p = f.getParent();
        if (p == null) {
            throw new IOException("Cannot create parent directory");
        }
        f = new File(p);
        boolean success = false;
        try {
            if (f.isDirectory()) {
                return;
            }
            if (f.exists()) {
                throw new IOException("Parent is not a directory");
            }
            success = f.mkdir();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        if (!success) {
            DotfileUtil.ensureParentExists(f);
            if (!f.mkdir()) {
                throw new IOException("Cannot create parent directory");
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(DotfileUtil.getDotDir().getAbsolutePath());
    }
}

