/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public final class FloatIntQuickSort {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    float[] fa;
    int[] ia;
    int order;

    public FloatIntQuickSort(int order, float[] fa, int[] ia) {
        this.order = order;
        this.fa = fa;
        this.ia = ia;
    }

    public void qsort(int left, int right) {
        this.sort1(left, right);
        if (this.order == 2) {
            int lower = left;
            for (int upper = right; lower < upper; ++lower, --upper) {
                this.swap(lower, upper);
            }
        }
    }

    private void sort1(int low, int high) {
        if (high - low < 7) {
            for (int i = low; i <= high; ++i) {
                for (int j = i; j > low && !FloatIntQuickSort.compare(this.fa[j - 1], this.ia[j - 1], this.fa[j], this.ia[j]); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = (low + high) / 2;
        float v = this.fa[m];
        int v_i = this.ia[m];
        int i = low;
        int j = high;
        while (i <= j) {
            while (FloatIntQuickSort.compare(this.fa[i], this.ia[i], v, v_i)) {
                ++i;
            }
            while (FloatIntQuickSort.compare(v, v_i, this.fa[j], this.ia[j])) {
                --j;
            }
            if (i > j) continue;
            this.swap(i++, j--);
        }
        if (low < j) {
            this.sort1(low, j);
        }
        if (i < high) {
            this.sort1(i, high);
        }
    }

    private static final boolean compare(float f1, int i1, float f2, int i2) {
        return f1 < f2 || f1 == f2 && i1 < i2;
    }

    private void swap(int i1, int i2) {
        float ftmp = this.fa[i1];
        this.fa[i1] = this.fa[i2];
        this.fa[i2] = ftmp;
        int itmp = this.ia[i1];
        this.ia[i1] = this.ia[i2];
        this.ia[i2] = itmp;
    }
}

