/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.util.StringUtil;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class HTMLTools {
    private HTMLTools() {
    }

    public static String insertStringBeforeLineEnds(String input, String insertion) {
        String value = StringUtil.convertToUNIXStyle(input);
        value = StringUtil.replaceString(value, "\n", insertion + "\n");
        return value;
    }

    public static String convertForJavaScript(String input) {
        String value = StringUtil.convertToUNIXStyle(input);
        value = StringUtil.replaceString(value, "\\", "\\\\");
        value = StringUtil.replaceString(value, "\n", "\\n");
        value = StringUtil.replaceString(value, "\"", "\\\"");
        value = StringUtil.replaceString(value, "'", "\\'");
        return value;
    }

    public static String convertForAppletParameter(String input) {
        String value = StringUtil.convertToUNIXStyle(input);
        value = StringUtil.replaceString(value, "\n", "\\\n");
        return value;
    }

    private static String sqlExceptionToString(SQLException e) {
        StringBuffer msg = new StringBuffer("<p><font size=\"+1\">SQL error</font>\n");
        while (e != null) {
            String s = e.getMessage();
            msg.append("<p>SQLState: " + e.getSQLState() + "<br>\n");
            msg.append("Message:  <font color=\"red\">" + s + "</font><br>\n");
            msg.append("Vendor:   " + e.getErrorCode() + "<br>\n");
            e = e.getNextException();
        }
        return msg.toString();
    }

    public static String exceptionToString(Throwable e) {
        StringBuffer sb = new StringBuffer();
        try {
            throw e;
        }
        catch (SQLException sqlex) {
            sb.append(HTMLTools.sqlExceptionToString(sqlex));
        }
        catch (Throwable ex) {
            sb.append("<p><font size=\"+1\">Error:</font>\n<p><font color=\"red\">" + ex.getMessage() + "</font>");
        }
        sb.append("\n<p>");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        e.printStackTrace(new PrintWriter(os));
        String s = ((Object)os).toString();
        sb.append(HTMLTools.insertStringBeforeLineEnds(s, "<br>"));
        return sb.toString();
    }

    public static String stringToPage(String text) {
        return "<html><body bgcolor=\"white\">" + text + "</body></html>";
    }

    public static String exceptionToPage(Throwable e) {
        return HTMLTools.stringToPage(HTMLTools.exceptionToString(e));
    }

    public static String getHTMLColorString(Color color) {
        if (color == null) {
            return null;
        }
        int c = color.getRed();
        c *= 256;
        c += color.getGreen();
        c *= 256;
        String s = Integer.toHexString(c += color.getBlue());
        while (s.length() < 6) {
            s = "0" + s;
        }
        return "#" + s;
    }

    public static Color getColor(String s) {
        s = s.trim();
        if ((s = s.toLowerCase()).length() < 3) {
            return null;
        }
        if (s.charAt(0) == '#') {
            if (s.length() != 7) {
                return null;
            }
            int code = 0;
            try {
                code = Integer.parseInt(s.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
            return new Color(code);
        }
        if (s.equals("black")) {
            return new Color(0);
        }
        if (s.equals("white")) {
            return new Color(0xFFFFFF);
        }
        if (s.equals("red")) {
            return new Color(0xFF0000);
        }
        if (s.equals("yellow")) {
            return new Color(0xFFFF00);
        }
        if (s.equals("lime")) {
            return new Color(65280);
        }
        if (s.equals("aqua")) {
            return new Color(65535);
        }
        if (s.equals("blue")) {
            return new Color(255);
        }
        if (s.equals("fuchsia")) {
            return new Color(0xFF00FF);
        }
        if (s.equals("gray")) {
            return new Color(0x808080);
        }
        if (s.equals("silver")) {
            return new Color(0xC0C0C0);
        }
        if (s.equals("maroon")) {
            return new Color(0x800000);
        }
        if (s.equals("olive")) {
            return new Color(0x808000);
        }
        if (s.equals("green")) {
            return new Color(32768);
        }
        if (s.equals("teal")) {
            return new Color(32896);
        }
        if (s.equals("navy")) {
            return new Color(128);
        }
        if (s.equals("purple")) {
            return new Color(0x800080);
        }
        if (s.equals("cyan")) {
            return Color.cyan;
        }
        if (s.equals("darkGray")) {
            return Color.darkGray;
        }
        if (s.equals("lightGray")) {
            return Color.lightGray;
        }
        if (s.equals("magenta")) {
            return Color.magenta;
        }
        if (s.equals("orange")) {
            return Color.orange;
        }
        if (s.equals("pink")) {
            return Color.pink;
        }
        if (s.equals("brown")) {
            return new Color(6042391);
        }
        if (s.equals("darkgreen")) {
            return new Color(25600);
        }
        return null;
    }
}

