/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ColorParser;
import chemaxon.util.CxOptions;
import java.awt.Color;

public class HitColoringAndAlignmentOptions
implements Cloneable {
    public static final int ALIGNMENT_OFF = 0;
    public static final int ALIGNMENT_ROTATE = 1;
    public static final int ALIGNMENT_PARTIAL_CLEAN = 2;
    public static final int ORIGINAL_MARKUSH = 0;
    public static final int MARKUSH_REDUCTION = 1;
    public static final int MARKUSH_REDUCTION_HGEXPANSION = 2;
    public boolean coloring = false;
    public boolean enumerateMarkush = false;
    public int markushDisplayMode = 0;
    public int alignmentMode = 0;
    public Color hitColor = Color.blue;
    public Color hitHomologyColor = Color.green;
    public Color nonHitColor = Color.black;
    public Color nonHitColor3D = Color.gray;
    public static final int SIMILARITY_OFF = 1;
    public static final int DISSIMILARITY = 2;
    public static final int SIMILARITY = 3;
    public int similarityScoreDisplay = 3;
    private boolean queryDisplay = false;
    private boolean removeUnusedDefinitions = true;
    public static final String QUERY_LABEL = "Query";
    public static final String TARGET_LABEL = "Target";
    public static final String SIMILARITY_LABEL = "Score";
    private boolean displayLabelsAndBoxes = false;

    public boolean isQueryDisplay() {
        return this.queryDisplay;
    }

    public void setQueryDisplay(boolean value) {
        this.queryDisplay = value;
    }

    public boolean isRemoveUnusedDefitions() {
        return this.removeUnusedDefinitions;
    }

    public void setRemoveUnusedDefinitions(boolean value) {
        this.removeUnusedDefinitions = value;
    }

    public boolean isDisplayLabelsAndBoxes() {
        return this.displayLabelsAndBoxes;
    }

    public void setHitHomologyColor(Color hitHomologyColor) {
        this.hitHomologyColor = hitHomologyColor;
    }

    public Color getHitHomologyColor() {
        return this.hitHomologyColor;
    }

    public void setDisplayLabelsAndBoxes(boolean value) {
        this.displayLabelsAndBoxes = value;
    }

    public static void setOptions(HitColoringAndAlignmentOptions hcaaOptions, String hitColorAndAlignOptionList) throws Exception {
        CxOptions jcOptions = new CxOptions(hitColorAndAlignOptionList);
        hcaaOptions.markushDisplayMode = jcOptions.getBoolValue("enumerateMarkush", false) ? 1 : 0;
        hcaaOptions.alignmentMode = 0;
        String alignModString = jcOptions.getStringValue("alignmentMode");
        if (alignModString != null && !alignModString.equalsIgnoreCase("off")) {
            if (alignModString.equalsIgnoreCase("rotate")) {
                hcaaOptions.alignmentMode = 1;
            } else if (alignModString.equalsIgnoreCase("partialClean")) {
                hcaaOptions.alignmentMode = 2;
            } else {
                throw new IllegalArgumentException("Invalid option for aligmentMode: " + alignModString);
            }
        }
        hcaaOptions.similarityScoreDisplay = 3;
        String simModString = jcOptions.getStringValue("similarity");
        if (simModString != null) {
            if (simModString.equalsIgnoreCase("off")) {
                hcaaOptions.similarityScoreDisplay = 1;
            } else if (simModString.equalsIgnoreCase("dissimilarity")) {
                hcaaOptions.similarityScoreDisplay = 2;
            } else if (!simModString.equalsIgnoreCase("similarity")) {
                throw new IllegalArgumentException("Invalid option for similarity: " + simModString);
            }
        }
        hcaaOptions.coloring = jcOptions.getBoolValue("coloring", false);
        hcaaOptions.hitColor = HitColoringAndAlignmentOptions.parseColor(jcOptions, "hitColor", hcaaOptions.hitColor);
        hcaaOptions.nonHitColor = HitColoringAndAlignmentOptions.parseColor(jcOptions, "nonHitColor", hcaaOptions.nonHitColor);
        hcaaOptions.nonHitColor3D = HitColoringAndAlignmentOptions.parseColor(jcOptions, "nonHitColor3D", hcaaOptions.nonHitColor3D);
        hcaaOptions.setHitHomologyColor(HitColoringAndAlignmentOptions.parseColor(jcOptions, "hitHomologyColor", hcaaOptions.hitHomologyColor));
        hcaaOptions.setQueryDisplay(jcOptions.getBoolValue("queryDisplay", false));
        hcaaOptions.setRemoveUnusedDefinitions(jcOptions.getBoolValue("removeUnusedDef", false));
        hcaaOptions.setRemoveUnusedDefinitions(jcOptions.getBoolValue("displayLabelsAndBoxes", false));
    }

    private static Color parseColor(CxOptions jcOptions, String coloringType, Color dfltValue) {
        Color c = dfltValue;
        String cstr = jcOptions.getStringValue(coloringType);
        if (cstr != null) {
            c = ColorParser.parseColor(cstr);
        }
        return c;
    }

    public Object clone() {
        HitColoringAndAlignmentOptions clone = new HitColoringAndAlignmentOptions();
        clone.alignmentMode = this.alignmentMode;
        clone.coloring = this.coloring;
        clone.enumerateMarkush = this.enumerateMarkush;
        clone.hitColor = this.hitColor;
        clone.hitHomologyColor = this.hitHomologyColor;
        clone.markushDisplayMode = this.markushDisplayMode;
        clone.nonHitColor = this.nonHitColor;
        clone.nonHitColor3D = this.nonHitColor3D;
        clone.similarityScoreDisplay = this.similarityScoreDisplay;
        clone.queryDisplay = this.queryDisplay;
        clone.removeUnusedDefinitions = this.removeUnusedDefinitions;
        clone.displayLabelsAndBoxes = this.displayLabelsAndBoxes;
        return clone;
    }
}

