/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import chemaxon.common.util.ArrayTools;
import chemaxon.common.util.IntVector;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyConversionUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.util.ArrayList;

class HomologyExpansionUtil {
    private HomologyExpansionUtil() {
    }

    static int[] expand(Molecule mol, Molecule query, int[] hit) {
        for (int i = mol.getAtomCount() - 1; i >= 0; --i) {
            int[] qHgInd;
            MolAtom hgAtom = mol.getAtom(i);
            if (!HomologyConstants.isHandledHomology(hgAtom.getAliasstr()) || (qHgInd = HomologyExpansionUtil.getAtomsMatchingOnHG(hit, i)).length == 0) continue;
            ArrayList<MolAtom> targetOuterAtoms = new ArrayList<MolAtom>();
            ArrayList<MolAtom> defBorderAtoms = new ArrayList<MolAtom>();
            Molecule hgDef = HomologyExpansionUtil.getHomologyPart(query, mol, qHgInd, targetOuterAtoms, defBorderAtoms, hit);
            HomologyExpansionUtil.addMissingAttachments(hgAtom, hgDef, targetOuterAtoms, defBorderAtoms);
            mol.fuse(hgDef);
            for (int l = 0; l < targetOuterAtoms.size(); ++l) {
                MolBond bond = hgAtom.getBondTo(targetOuterAtoms.get(l));
                mol.add(bond.cloneBond(targetOuterAtoms.get(l), defBorderAtoms.get(l)));
            }
            mol.removeAtom(hgAtom);
            HomologyExpansionUtil.updateHitIndexes(hit, mol, qHgInd, i);
        }
        return hit;
    }

    private static void addMissingAttachments(MolAtom hgAtom, Molecule hgDef, ArrayList<MolAtom> targetOuterAtoms, ArrayList<MolAtom> defBorderAtoms) {
        int neededAttachNum;
        int fixAttachNum = defBorderAtoms.size();
        if (fixAttachNum == (neededAttachNum = hgAtom.getBondCount())) {
            return;
        }
        for (int i = 0; i < fixAttachNum; ++i) {
            defBorderAtoms.get(i).addRgroupAttachmentPoint(i + 1, 1);
        }
        HomologyConversionUtil.addRandomAttachmentPoints(hgDef, neededAttachNum, hgAtom.getAliasstr(), fixAttachNum);
        MolAtom[] attachAtoms = MolImportUtil.getAtomsWithAttachments(hgDef);
        defBorderAtoms.clear();
        for (MolAtom atom : attachAtoms) {
            if (atom == null) continue;
            defBorderAtoms.add(atom);
            MolImportUtil.clearAttachments(atom);
        }
        int needed = defBorderAtoms.size();
        for (int i = targetOuterAtoms.size(); i < needed; ++i) {
            boolean found = false;
            int n = hgAtom.getBondCount();
            for (int j = 0; j < n && !found; ++j) {
                MolAtom ligand = hgAtom.getLigand(j);
                if (targetOuterAtoms.contains(ligand)) continue;
                targetOuterAtoms.add(ligand);
            }
        }
    }

    private static void updateHitIndexes(int[] hit, Molecule mol, int[] qHgInd, int hgInd) {
        for (int i = 0; i < hit.length; ++i) {
            if (hit[i] <= hgInd) continue;
            int n = i;
            hit[n] = hit[n] - 1;
        }
        int targetAtNum = mol.getAtomCount();
        for (int i = 0; i < qHgInd.length; ++i) {
            hit[qHgInd[i]] = targetAtNum - qHgInd.length + i;
        }
    }

    private static Molecule getHomologyPart(Molecule query, Molecule target, int[] qHgInd, ArrayList<MolAtom> targetOuterAtoms, ArrayList<MolAtom> defBorderAtoms, int[] hit) {
        Molecule res = new Molecule();
        qHgInd = HomologyExpansionUtil.throwOutGroupHitIndexes(qHgInd, query);
        if (query instanceof RgMolecule) {
            ((RgMolecule)query).getRoot().clonecopy(qHgInd, res);
        } else {
            query.clonecopy(qHgInd, res);
        }
        for (int i = 0; i < qHgInd.length; ++i) {
            MolAtom atom = query.getAtom(qHgInd[i]);
            int n = atom.getBondCount();
            for (int j = 0; j < n; ++j) {
                int othersHit;
                MolAtom other = atom.getLigand(j);
                int otherInd = query.indexOf(other);
                if (ArrayTools.foundInArray(qHgInd, otherInd) || (othersHit = hit[otherInd]) < 0) continue;
                targetOuterAtoms.add(target.getAtom(othersHit));
                defBorderAtoms.add(res.getAtom(i));
            }
        }
        return res;
    }

    private static int[] throwOutGroupHitIndexes(int[] qHgInd, Molecule query) {
        int atomCount = query.getAtomCount();
        IntVector res = new IntVector();
        for (int elem : qHgInd) {
            if (elem >= atomCount) continue;
            res.add(elem);
        }
        return res.toArray();
    }

    private static int[] getAtomsMatchingOnHG(int[] hit, int hgInd) {
        IntVector atomV = new IntVector();
        for (int i = 0; i < hit.length; ++i) {
            if (hit[i] != hgInd) continue;
            atomV.add(i);
        }
        return atomV.toArray();
    }
}

