/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

import java.io.Serializable;
import java.util.Arrays;

public final class IntArray
implements Cloneable,
Serializable {
    private int[][] elementData = new int[0][];
    private int blockCount = 0;
    private int currentCapacity = 0;
    private int[] firstElements = null;
    private int elementCount = 0;
    public static final int DEFAULT_BLOCK_SIZE = 16384;
    private int blockSize = 16384;

    public IntArray() {
        this(16384);
    }

    public IntArray(int blockSize) {
        this.blockSize = blockSize;
    }

    public void copyInto(int[] array) {
        int i = this.elementCount;
        while (i-- > 0) {
            array[i] = this.elementData[i / this.blockSize][i % this.blockSize];
        }
    }

    public int[] toArray() {
        int[] anArray = new int[this.elementCount];
        this.copyInto(anArray);
        return anArray;
    }

    public void setSize(int newSize) {
        this.ensureCapacity(newSize);
        this.elementCount = newSize;
    }

    public int capacity() {
        return this.currentCapacity;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean contains(int elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }

    public int indexOfWithBinarySearch(int num) {
        if (this.firstElements == null) {
            throw new IllegalStateException("Cannot perform binary search on a non-sorted array");
        }
        int blockIndex = Arrays.binarySearch(this.firstElements, num);
        if (blockIndex < 0 && (blockIndex = -blockIndex - 2) < 0) {
            return -1;
        }
        int high = blockIndex == this.blockCount - 1 ? this.elementCount % this.blockSize : this.blockSize - 1;
        return blockIndex * this.blockSize + IntArray.binarySearch(this.elementData[blockIndex], num, high);
    }

    private static int binarySearch(int[] a, int key, int high) {
        int low = 0;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public int indexOf(int value, int index) {
        int p = 0;
        for (int x = 0; x < this.blockCount; ++x) {
            int[] block = this.elementData[x];
            for (int y = 0; y < this.blockSize; ++y) {
                if (block[y] == value) {
                    return x * this.blockSize + y;
                }
                if (++p < this.elementCount) continue;
                return -1;
            }
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        return this.lastIndexOf(value, this.elementCount - 1);
    }

    public int lastIndexOf(int elem, int index) {
        for (int i = index; i >= 0; --i) {
            if (elem != this.elementData[i / this.blockSize][i % this.blockSize]) continue;
            return i;
        }
        return -1;
    }

    public int get(int index) {
        if (index < 0 || index >= this.elementCount) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + ". Element count: " + this.elementCount);
        }
        return this.elementData[index / this.blockSize][index % this.blockSize];
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException("Invalid index: " + index + ". Element count: " + this.elementCount);
        }
        this.setElement(index, value);
    }

    public void setWithExpansion(int index, int value) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index: " + index);
        }
        if (index >= this.elementCount) {
            this.setSize(index + 1);
        }
        this.setElement(index, value);
    }

    private void setElement(int index, int value) {
        this.firstElements = null;
        int block = index / this.blockSize;
        int pos = index % this.blockSize;
        this.elementData[block][pos] = value;
    }

    public void add(int value) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount / this.blockSize][this.elementCount % this.blockSize] = value;
        ++this.elementCount;
        this.firstElements = null;
    }

    public void clear() {
        this.elementCount = 0;
    }

    public boolean addAll(IntArray other) {
        if (other == null || other.size() == 0) {
            return false;
        }
        this.ensureCapacity(this.elementCount + other.elementCount);
        for (int i = 0; i < other.elementCount; ++i) {
            this.add(other.elementData[i / this.blockSize][i % this.blockSize]);
        }
        return true;
    }

    public void fill(int value) {
        for (int x = 0; x < this.elementCount; ++x) {
            this.elementData[x / this.blockSize][x % this.blockSize] = value;
        }
    }

    public void sort() {
        if (this.elementCount > 1) {
            this.qsort(0, this.elementCount - 1);
        }
        this.firstElements = new int[this.blockCount];
        for (int x = 0; x < this.blockCount; ++x) {
            this.firstElements[x] = this.elementData[x][0];
        }
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity <= this.currentCapacity) {
            return;
        }
        int oldElementDataLength = this.elementData.length;
        this.blockCount = minCapacity / this.blockSize;
        if (minCapacity % this.blockSize > 0) {
            ++this.blockCount;
        }
        if (this.blockCount > this.elementData.length) {
            int[][] newData = new int[this.blockCount * 3 / 2 + 1][];
            System.arraycopy(this.elementData, 0, newData, 0, this.elementData.length);
            this.elementData = newData;
        }
        for (int x = oldElementDataLength; x < this.elementData.length; ++x) {
            this.elementData[x] = new int[this.blockSize];
        }
        this.currentCapacity = this.blockCount * this.blockSize;
    }

    private void qsort(int left, int right) {
        this.sort1(left, right - left + 1);
    }

    private void sort1(int off, int len) {
        int c;
        int a;
        int loBlock = off / this.blockSize;
        int hi = off + len - 1;
        int hiBlock = hi / this.blockSize;
        if (loBlock == hiBlock) {
            int loPos = off % this.blockSize;
            int hiPos = hi % this.blockSize;
            int[] block = this.elementData[loBlock];
            Arrays.sort(block, loPos, hiPos + 1);
            return;
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compare(j - 1, j); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        int v = this.elementData[m / this.blockSize][m % this.blockSize];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int cValue;
            int bValue;
            if (b <= c && (bValue = this.elementData[b / this.blockSize][b % this.blockSize]) <= v) {
                if (bValue == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (cValue = this.elementData[c / this.blockSize][c % this.blockSize]) >= v) {
                if (cValue == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1(n - s, s);
        }
    }

    private int med3(int a, int b, int c) {
        int aValue = this.elementData[a / this.blockSize][a % this.blockSize];
        int bValue = this.elementData[b / this.blockSize][b % this.blockSize];
        int cValue = this.elementData[c / this.blockSize][c % this.blockSize];
        return aValue < bValue ? (bValue < cValue ? b : (aValue < cValue ? c : a)) : (bValue > cValue ? b : (aValue > cValue ? c : a));
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private boolean compare(int i1, int i2) {
        return this.elementData[i1 / this.blockSize][i1 % this.blockSize] > this.elementData[i2 / this.blockSize][i2 % this.blockSize];
    }

    private void swap(int i1, int i2) {
        int[] block1 = this.elementData[i1 / this.blockSize];
        int offset1 = i1 % this.blockSize;
        int[] block2 = this.elementData[i2 / this.blockSize];
        int offset2 = i2 % this.blockSize;
        int tmp = block1[offset1];
        block1[offset1] = block2[offset2];
        block2[offset2] = tmp;
    }

    public static void main(String[] args) {
        int x;
        IntArray iv = new IntArray();
        int count = 4000000;
        for (x = 0; x < count; ++x) {
            iv.add(x);
        }
        System.err.println("---------");
        iv.sort();
        System.err.println("---------");
        for (x = 0; x < count; ++x) {
            if (iv.indexOfWithBinarySearch(x) == x) continue;
            System.err.println("Binary search error !!! " + x);
            break;
        }
    }
}

