/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.util;

public final class IntIntQuickSort {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    int[] ia1;
    int[] ia2;
    int order;

    public IntIntQuickSort(int order, int[] ia1, int[] ia2) {
        this.order = order;
        this.ia1 = ia1;
        this.ia2 = ia2;
    }

    public void qsort(int left, int right) {
        this.sort1(left, right - left + 1);
    }

    private void sort1(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compare(j - 1, j); --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        int v = this.ia1[m];
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && this.ia1[b] <= v) {
                if (this.ia1[b] == v) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && this.ia1[c] >= v) {
                if (this.ia1[c] == v) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1(n - s, s);
        }
    }

    private int med3(int a, int b, int c) {
        return this.ia1[a] < this.ia1[b] ? (this.ia1[b] < this.ia1[c] ? b : (this.ia1[a] < this.ia1[c] ? c : a)) : (this.ia1[b] > this.ia1[c] ? b : (this.ia1[a] > this.ia1[c] ? c : a));
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private boolean compare(int i1, int i2) {
        return this.order == 1 ? this.ia1[i1] > this.ia1[i2] : this.ia1[i1] < this.ia1[i2];
    }

    private void swap(int i1, int i2) {
        int tmp = this.ia1[i1];
        this.ia1[i1] = this.ia1[i2];
        this.ia1[i2] = tmp;
        tmp = this.ia2[i1];
        this.ia2[i1] = this.ia2[i2];
        this.ia2[i2] = tmp;
    }
}

